/***************************************************************************
                         group.cpp  -  description                              
                            -------------------                                         
   begin                : Sat Nov 6 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "group.h"

Group::Group() : Entity( 0 ), entity()
{
   drawable = false;
}

Group::~Group()
{}

void Group::addEntity( Entity *e )
{
   entity.append( e );
}

void Group::removeEntity( Entity *e )
{
   entity.removeRef( e );
}

void Group::move( float x, float y, float z )
{
   Entity * e;

   for ( e = entity.first(); e != 0; e = entity.next() )
      e->move( x, y, z );

}

void Group::rotate( float amount, float x, float y, float z, float px, float py, float pz )
{
   Entity * e;

   for ( e = entity.first(); e != 0; e = entity.next() )
      e->rotate( amount, x, y, z, px, py, pz );

}

void Group::scale( float x, float y, float z, float px, float py, float pz )
{
   Entity * e;

   for ( e = entity.first(); e != 0; e = entity.next() )
      e->scale( x, y, z, px, py, pz );

}

