/***************************************************************************
                         cube.cpp  -  description                              
                            -------------------                                         
   begin                : Wed Aug 4 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cube.h"
#include "vertex.h"
#include "face.h"
#include "edge.h"


/* Just some temporary IData structures for testing...
 */

class TestData1 : public IData
{
   public:
      TestData1() : IData( "TestData1" ) { my_string = "Here is my data\nHear me roar!\n"; };

      string toString() { return my_string; };

      void init( string s ) { my_string = s; };

      IData * clone() { return new TestData1(); };

      string my_string;

      static int TYPE;
};

class TestData2 : public IData
{
   public:
      TestData2() : IData( "GameData" ) { my_string = "j=1\ni=2\nname=smurf\ntest=off\njames=1\nnetwork = off\n"; };

      string toString() { return my_string; };

      void init( string s ) { my_string = s; };

      IData * clone() { return new TestData2(); };

      string my_string;

      static int TYPE;
};

int TestData2::TYPE = IData::registerData( new TestData2() );
int TestData1::TYPE = IData::registerData( new TestData1() );


Cube::Cube( float x, float y, float z, int w, int h, int d )
      : Mesh( x, y, z )
{
   //construct the front first

   w++;
   h++;
   d++;

   //set up the vertices;
   Vertex *front[ w ][ h ];
   Vertex *back[ w ][ h ];
   Vertex *left[ d ][ h ];
   Vertex *right[ d ][ h ];
   Vertex *top[ w ][ d ];
   Vertex *bottom[ w ][ d ];

   //top;
   for ( int i = 0; i < w; i++ )
   {
      for ( int j = 0; j < h; j++ )
      {
         Vertex *v = createVertex( i, j, d - 1 );
         front[ i ][ j ] = v;
      }
   }

   //back;
   for ( int i = 0; i < w; i++ )
   {
      for ( int j = 0; j < h; j++ )
      {
         Vertex *v = createVertex( i, j, 0 );
         back[ i ][ j ] = v;
      }
   }

   //left
   for ( int j = 0; j < h; j++ )
   {
      left[ 0 ][ j ] = back[ 0 ][ j ];
      left[ d - 1 ][ j ] = front[ 0 ][ j ];
   }

   for ( int i = 1; i < d - 1; i++ )
   {
      for ( int j = 0; j < h; j++ )
      {
         Vertex *v = createVertex( 0, j, i );
         left[ i ][ j ] = v;
      }
   }

   //Right
   for ( int j = 0; j < h; j++ )
   {
      right[ 0 ][ j ] = back[ w - 1 ][ j ];
      right[ d - 1 ][ j ] = front[ w - 1 ][ j ];
   }

   for ( int i = 1; i < d - 1; i++ )
   {
      for ( int j = 0; j < h; j++ )
      {
         Vertex *v = createVertex( w - 1, j, i );
         right[ i ][ j ] = v;
      }
   }

   //top
   for ( int j = 0; j < d; j++ )
   {
      top[ 0 ][ j ] = left[ j ][ h - 1 ];
      top[ w - 1 ][ j ] = right[ j ][ h - 1 ];
   }

   for ( int i = 0; i < w; i++ )
   {
      top[ i ][ 0 ] = back[ i ][ h - 1 ];
      top[ i ][ d - 1 ] = front[ i ][ h - 1 ];
   }


   for ( int i = 1; i < w - 1; i++ )
   {
      for ( int j = 1; j < d - 1; j++ )
      {
         Vertex *v = createVertex( i, h - 1, j );
         top[ i ][ j ] = v;
      }
   }

   //bottom
   for ( int j = 0; j < d; j++ )
   {
      bottom[ 0 ][ j ] = left[ j ][ 0 ];
      bottom[ w - 1 ][ j ] = right[ j ][ 0 ];
   }

   for ( int i = 0; i < w; i++ )
   {
      bottom[ i ][ 0 ] = back[ i ][ 0 ];
      bottom[ i ][ d - 1 ] = front[ i ][ 0 ];
   }

   for ( int i = 1; i < w - 1; i++ )
   {
      for ( int j = 1; j < d - 1; j++ )
      {
         Vertex *v = createVertex( i, 0, j );
         bottom[ i ][ j ] = v;
      }
   }

   //setup the quad faces;
   //front
   for ( int i = 0; i < w - 1; i++ )
   {
      for ( int j = 0; j < h - 1; j++ )
      {
         createFace( front[ i ][ j ] ->getParentIndex(), front[ i + 1 ][ j ] ->getParentIndex(),
                     front[ i + 1 ][ j + 1 ] ->getParentIndex(), front[ i ][ j + 1 ] ->getParentIndex() );
      }
   }

   //back
   for ( int i = 0; i < w - 1; i++ )
   {
      for ( int j = 0; j < h - 1; j++ )
      {
         createFace( back[ i + 1 ][ j ] ->getParentIndex(), back[ i ][ j ] ->getParentIndex(),
                     back[ i ][ j + 1 ] ->getParentIndex(), back[ i + 1 ][ j + 1 ] ->getParentIndex() );
      }
   }

   //left
   for ( int i = 0; i < d - 1; i++ )
   {
      for ( int j = 0; j < h - 1; j++ )
      {
         createFace( left[ i ][ j ] ->getParentIndex(), left[ i + 1 ][ j ] ->getParentIndex(),
                     left[ i + 1 ][ j + 1 ] ->getParentIndex(), left[ i ][ j + 1 ] ->getParentIndex() );
      }
   }

   //right
   for ( int i = 0; i < d - 1; i++ )
   {
      for ( int j = 0; j < h - 1; j++ )
      {
         createFace( right[ i + 1 ][ j ] ->getParentIndex(), right[ i ][ j ] ->getParentIndex(),
                     right[ i ][ j + 1 ] ->getParentIndex(), right[ i + 1 ][ j + 1 ] ->getParentIndex() );
      }
   }

   //top
   for ( int i = 0; i < w - 1; i++ )
   {
      for ( int j = 0; j < d - 1; j++ )
      {
         createFace( top[ i + 1 ][ j ] ->getParentIndex(), top[ i ][ j ] ->getParentIndex(),
                     top[ i ][ j + 1 ] ->getParentIndex(), top[ i + 1 ][ j + 1 ] ->getParentIndex() );
      }
   }

   //bottom
   for ( int i = 0; i < w - 1; i++ )
   {
      for ( int j = 0; j < d - 1; j++ )
      {
         createFace( bottom[ i ][ j ] ->getParentIndex(), bottom[ i + 1 ][ j ] ->getParentIndex(),
                     bottom[ i + 1 ][ j + 1 ] ->getParentIndex(), bottom[ i ][ j + 1 ] ->getParentIndex() );
      }
   }

   for ( int i = 0; i < ( int ) verts.size(); i++ )
      verts[ i ] ->move( -( float ) ( w - 1 ) / 2, -( float ) ( h - 1 ) / 2, -( float ) ( d - 1 ) / 2 );


   normalize();

   IData *d = new TestData1();

   putData( d -> getTag(), d );

   d = new TestData2();

   putData( d -> getTag(), d );

}

Cube::~Cube()
{}














