/***************************************************************************
                          animationctrl.h  -  description                              
                             -------------------                                         
    begin                : Thu Sep 30 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ANIMATIONCTRL_H
#define ANIMATIONCTRL_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qgroupbox.h>
#include <qslider.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qvalidator.h>
//Generated area. DO NOT EDIT!!!(end)


class BaseController;

#include <qdialog.h>

/**
  *@author Jon Anderson
  */

class AnimationCtrl : public QDialog  {
   Q_OBJECT
public: 
	AnimationCtrl(QWidget *parent=0, const char *name=0);
	~AnimationCtrl();

public slots:
	/**Play all animations starting with the current time */
	void play();
	/**Stop the animations */
	void stop();
	/**Rewind to the first frame */
	void first();
	/**Fast forward to the last frame */
	void last();
	/**Catches the slider bar and sets the frame time */
	void slide(int);
	/**Saves the current state of entities as a keyframe */
	void saveKeyframe();
	/**Deletes the current keyframe */
	void deleteKeyframe();
	
protected: 
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QGroupBox *grpAnimation;
	QSlider *sldrFrame;
	QLabel *lblMaxLabel;
	QPushButton *btnPlay;
	QPushButton *btnStop;
	QLabel *lblMaxFrame;
	QPushButton *btnLast;
	QPushButton *btnSave;
	QPushButton *btnDelete;
	QLineEdit *fldKeyNumber;
	QLabel *lblKeyName;
	QPushButton *btnFirst;
	QLabel *lblCurrentlbl;
	QLabel *lblCurrentFrame;
	//Generated area. DO NOT EDIT!!!(end)

private:
	int max_frame;
	int current_frame;
	BaseController *timer;
};

#endif


