/***************************************************************************
                          scalecommand.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "scalecommand.h"

ScaleCommand::ScaleCommand(Transformable *_e, Vector4 &s, Vector4 &_pt):PropertyCommand(_e),
amount(s),
oldamount(1/s.x,1/s.y, 1/s.z, 1), pt(_pt)
{												
}
ScaleCommand::~ScaleCommand()
{
	
}
/** Scale the entity to the new size. */
bool ScaleCommand::execute()
{
	if( e == 0) {
		cerr << "Action nolonger doable..."<<endl;
		return false;
	}		
	e->scale(amount, pt);
	return true;
}
/** Undo the scale action. */
bool ScaleCommand::undo()
{
	if( e == 0) {
		cerr << "Action nolonger undoable..."<<endl;
		return false;
	}		
	
	e->scale(oldamount, pt);
	return true;
}
