/***************************************************************************
                          propertycommand.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PROPERTYCOMMAND_H
#define PROPERTYCOMMAND_H

#include "entitycommand.h"
#include <string>

class Transformable;

/** All entities have a list of properties that can be manipulate by using
  * string key/value commands.  A Property command uses this to change an Entity
  * Property.
  *@author Jon Anderson
  */

class PropertyCommand : public EntityCommand  {
public: 
	PropertyCommand(Transformable *, string s="", string p="");
	virtual ~PropertyCommand();
  /** Changes an entities property... */
  virtual bool execute();
  /** Undo changes an entities property back
to it's original state. */
  virtual bool undo();

public: // Public attributes
  /** The old value of the property. */
  string oldValue;
  /** The property to be modified. */
  string strProperty;
  /** The new value of the property. */
  string newValue;

};

#endif
