/***************************************************************************
                          movecommand.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "movecommand.h"

MoveCommand::MoveCommand(Transformable *_e, Vector4 &s):PropertyCommand(_e), amount(s), oldAmount()
{
	oldAmount.assign(-s.x, -s.y, -s.z, 1);
	
}
MoveCommand::~MoveCommand()
{
	
}
/** Move the entity to the new location. */
bool MoveCommand::execute()
{
	if( e == 0) {
		cerr << "Action nolonger doable..."<<endl;
		return false;
	}		

	e->move(amount);
	return true;
	
}
/** Move the entity to the old location. */
bool MoveCommand::undo()
{
	if( e == 0) {
		cerr << "Action nolonger undoable..."<<endl;
		return false;
	}		
	e->move(-amount.x, -amount.y, -amount.z);
	return true;
}
