/***************************************************************************
                          command.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COMMAND_H
#define COMMAND_H


/**This is the abstract class for all commands.  Commands are
encapsulations of all actions available to the user.  Encapsulation
makes it very easy implement alternative interfaces, as 
well as undo/redo, and scripting.
  *@author Jon Anderson
  */

class Command  {
public: 
	Command();
	virtual ~Command();
  /** Undo's this command */
  virtual bool undo(){return true;};
  /** Executes the this command */
  virtual bool execute(){return true;};

  bool save();
};

#endif
