#!/usr/bin/python

"""
An example usage of the OpenDis Framework
A part of the Inguma Project

The following example compares 2 databases to look for differences between different versions.

Copyright (c) 2007 Joxean Koret
"""

import os
import sys
import pickle
import asmclasses

def compareLines(fixedProc, procOrig, fOrig, fFixed):
    
    i = -1
    for objLine in fixedProc.lines:
        i += 1

        if objLine.code.split(" ")[0] != procOrig.lines[i].code.split(" ")[0]:
            writeProcedureToFile(fOrig, procOrig)
            writeProcedureToFile(fFixed, fixedProc)

def asmdiff(orig, fixed):
    magic = "- Analyzing binaries ... -"

    print "-"*len(magic)
    print magic
    print "-"*len(magic)
    print

    rodataOrig, objOrig, rodataFixed, objFixed = getDatabases(orig, fixed)

    if len(objOrig) != len(objFixed):
        print "[+] Different number of functions"
    else:
        print "[+] The number of functions is equal"

    for procOrig in objOrig:
        fixedProc = searchProc(objFixed, procOrig.name)
        
        if fixedProc:
            print "[+] Function %s exists in both versions" % fixedProc.name
        
        if len(fixedProc.lines) != len(procOrig.lines):
            print "  --> Function %s has different number of lines" % fixedProc.name
            
            i = -1
            for line in procOrig.lines:
                i += 1
                
                if len(fixedProc.lines) >= i:
                    if line.code != fixedProc.lines[i].code:
                        if line.description:
                            print "\t> %s; %s" % (fixedProc.lines[i].code, fixedProc.lines[i].description)
                            print "\t< %s; %s" % (line.code, line.description)
                            print "\t-"
                        else:
                            print "\t> %s" % fixedProc.lines[i].code
                            print "\t< %s" % line.code
                            print "\t-"
        else:
            compareLines(fixedProc, procOrig)

    print

def log(buf):
    sys.stderr.write(buf + "\n")

def getDatabases(orig, fixed):
    
    # Read the first object database
    f = file(orig, "r")
    rodataOrig, objOrig = pickle.load(f)
    f.close()

    # Read the second object database
    f = file(fixed, "r")
    rodataFixed, objFixed = pickle.load(f)
    f.close()

    return rodataOrig, objOrig, rodataFixed, objFixed

def generatediff(orig, fixed, program):

    rodataOrig, objOrig, rodataFixed, objFixed = getDatabases(orig, fixed)

    if len(objOrig) != len(objFixed):
        log("Different number of functions")

    fOrig  = file(orig + ".asm", "w")
    fFixed = file(fixed + ".asm", "w")
    """
    for procOrig in objOrig:
        procFixed = searchProc(objFixed, procOrig.name)
        
        if not procFixed:
            continue
        
        if len(procFixed.lines) != len(procOrig.lines):
            log("Function %s differs" % procFixed.name)

            writeProcedureToFile(fOrig, procOrig)
            writeProcedureToFile(fFixed, procFixed)
        else:
            compareLines(procFixed, procOrig, fOrig, fFixed)
    """

    if len(objOrig) != len(objFixed):
        for procFixed in objFixed:
            procOrig = searchProc(objOrig, procFixed.name)
            
            if not procOrig:
                log("Function %s ONLY exists in fixed version" % procFixed.name)
            
            if len(procFixed.lines) != len(procOrig.lines):
                log("  --> Function %s has different number of lines" % procFixed.name)
    
                writeProcedureToFile(fOrig, procOrig)
                writeProcedureToFile(fFixed, procFixed)

    print
    os.system("%s %s.asm %s.asm" % (program, orig, fixed))

def writeProcedureToFile(f, proc):
    f.write("PROCEDURE %s\n" % proc.name)
    for line in proc.lines:
        if line.code == "nop": # Assume we're in x86
            continue
        if line.description:
            data = "\t%s; %s" % (line.code, line.description)
        else:
            data= "\t%s" % line.code

        f.write(data + "\n")
    f.write("END PROCEDURE %s\n\n" % proc.name)

def cleanCode(base):
    data = base.split(" ")
    
    for x in data:
        tmp = x.split(",")
        for arg in tmp:
            if arg.find("$0x") == 0 and len(arg) > 6:
                base = base.replace(arg, arg[0:len(arg)-2] + "XX")

    return base

def searchProc(obj, name):
    for x in obj:
        if x.name == name:
            return x

def usage():
    print "Usage:", sys.argv[0], " <database 1> <database 2> [program to show differences]"
    print 
    print "Example:"
    print sys.argv[0], "test1.db fixed.db kompare"

def main():
    if len(sys.argv) < 3:
        usage()
        sys.exit(0)
    else:
        if len(sys.argv) == 4:
            generatediff(sys.argv[1], sys.argv[2], sys.argv[3])
        else:
            asmdiff(sys.argv[1], sys.argv[2])

if __name__ == "__main__":
    main()
