#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <jpeglib.h>
#include "common.h"

int Set_Default_Args(struct ArgStruct *Args) {
  char *tmp ;
  char buffer[256] ;
  
  Args->Infile = NULL ;
  Args->Outfile = NULL ;

  Args->Use3D = 1 ;
  Args->Colors[0] = WHITE ;
  Args->Colors[1] = WHITE ;
  Args->Colors[2] = WHITE ;
  Args->Colors[3] = BLACK ;
  Args->Colors[4] = BLACK ;
  Args->Colors[5] = BLACK ;
  Args->UseColors = 0 ;

  Args->Previewfile = malloc(strlen("")+1) ;
  strcpy (Args->Previewfile, "") ;

  Args->UpperString = malloc(strlen("")+1) ;
  strcpy (Args->UpperString, "") ;
  Args->UpperFont = malloc(strlen("")+1) ;
  strcpy (Args->UpperFont, "") ;
  Args->UStringExec = 0 ;

  Args->LowerString = malloc(strlen("")+1) ;
  strcpy (Args->LowerString, "") ;
  Args->LowerFont = malloc(strlen("")+1) ;
  strcpy (Args->LowerFont, "") ;
  Args->LStringExec = 0 ;

  Args->Rotate = 0 ;
  Args->ShadeRate = 8 ;
  Args->Quality = 75 ;
  
  Args->Host = malloc(strlen("")+1) ;
  strcpy (Args->Host, "") ;
  Args->Path = malloc(strlen("")+1) ;
  strcpy (Args->Path, "") ;
  Args->Upload = malloc(strlen("")+1) ;
  strcpy (Args->Upload, "") ;
  Args->Login = malloc(strlen("")+1) ;
  strcpy (Args->Login, "") ;
  Args->Passwd = malloc(strlen("")+1) ;
  strcpy (Args->Passwd, "") ;
  
  tmp = getenv("HOME");
  
  if (!tmp) {
    fprintf(stderr, "stamp: Cannot find your home directory!") ;
    exit(ERR_NOHOMEDIR) ;
  }
  
  strncpy(buffer, tmp, 230) ;
  buffer[230] = '\0' ;
  strcat(buffer, "/.stamprc") ;
  
  Args->RCFile = malloc(strlen(buffer)+1) ;
  strcpy(Args->RCFile, buffer) ;
  
  return (0) ;
}

int Check_Args(struct ArgStruct *Args) {
  if (((Args->Colors[0] < 0) || (Args->Colors[0] > 255)) ||
      ((Args->Colors[1] < 0) || (Args->Colors[1] > 255)) ||
      ((Args->Colors[2] < 0) || (Args->Colors[2] > 255)) ||
      ((Args->Colors[3] < 0) || (Args->Colors[3] > 255)) ||
      ((Args->Colors[4] < 0) || (Args->Colors[4] > 255)) ||
      ((Args->Colors[5] < 0) || (Args->Colors[5] > 255))) {
    fprintf(stderr, "stamp: Invalid color component (greater than 255 or less than 0).\n") ;
    exit(ERR_BADCOLORS) ;
  }
  
  if ((Args->ShadeRate < 0) || (Args->ShadeRate > 255)) {
    fprintf(stderr, "stamp: Invalid shade rate (greater than 255 or less than 0).\n") ;
    exit(ERR_BADSHADE) ;
  }
  
  if ((Args->Quality < 0) || (Args->Quality > 100)) {
    fprintf(stderr, "stamp: Invalid JPEG quality (greater than 100 or less than 0).\n") ;
    exit(ERR_BADQUALITY) ;
  }
  
  if ((!(strcmp(Args->UpperFont,""))) &&
      ((strcmp(Args->UpperString,"")))) {
    fprintf(stderr, "stamp: You must specify a font to use for the upper string.\n") ;
  exit(ERR_NOUFONT) ;
  }

if ((!(strcmp(Args->LowerFont,""))) &&
    ((strcmp(Args->LowerString,"")))) {
     fprintf(stderr, "stamp: You must specify a font to use for the lower string.\n") ;
    exit(ERR_NOLFONT) ;
  }

  if ((!(strcmp(Args->Infile,""))) ||
      (!(strcmp(Args->Outfile,"")))) {
    fprintf(stderr, "stamp: You must specify both an input and output JPEG image.\n") ;
    exit(ERR_MISSIOFILE) ;
  }

  return(0) ;
}

void RC_load(struct ArgStruct *Args) {
  char line[256] ;
  char value[256] ;
  char variable[256] ;
  char *tmp ;
  FILE *RC_file;

  RC_file = fopen(Args->RCFile, "rw") ;

  if (RC_file == NULL) {
    return;
  }

  while (!feof(RC_file)) {
    fgets(line, 255, RC_file) ;
    if ((tmp = strchr(line, '#')) != NULL){
      *tmp = '\0';
    }
    
    sscanf(line, "%s %[^\n]", variable, value);

    if (strcmp(variable, "") || strcmp(value, "")) {
      if (!strcmp(variable, "upperstring")) {
	Args->UpperString = malloc(strlen(value)+1) ;
	strcpy(Args->UpperString, value) ;
	
      } else if (!strcmp(variable, "lowerstring")) {
	Args->LowerString = malloc(strlen(value)+1) ;
	strcpy(Args->LowerString, value) ;
	
      } else if (!strcmp(variable, "upperfont")) {
	Args->UpperFont = malloc(strlen(value)+1) ;
	strcpy(Args->UpperFont, value) ;
	
      } else if (!strcmp(variable, "lowerfont")) {
	Args->LowerFont = malloc(strlen(value)+1) ;
	strcpy(Args->LowerFont, value) ;
	
      } else if (!strcmp(variable, "infile")) {
	Args->Infile = malloc(strlen(value)+1) ;
	strcpy(Args->Infile, value) ;
	
      } else if (!strcmp(variable, "outfile")) {
	Args->Outfile = malloc(strlen(value)+1) ;
	strcpy(Args->Outfile, value) ;
	
      } else if (!strcmp(variable, "previewfile")) {
	Args->Previewfile = malloc(strlen(value)+1) ;
	strcpy(Args->Previewfile, value) ;

      } else if (!strcmp(variable, "ftphost")) {
	Args->Host = malloc(strlen(value)+1) ;
	strcpy(Args->Host, value) ;
	
      } else if (!strcmp(variable, "ftppath")) {
	Args->Path = malloc(strlen(value)+1) ;
	strcpy(Args->Path, value) ;

      } else if (!strcmp(variable, "ftpupload")) {
	Args->Upload = malloc(strlen(value)+1) ;
	strcpy(Args->Upload, value) ;
	
      } else if (!strcmp(variable, "ftplogin")) {
	Args->Login = malloc(strlen(value)+1) ;
	strcpy(Args->Login, value) ;
	
      } else if (!strcmp(variable, "ftppasswd")) {
	Args->Passwd = malloc(strlen(value)+1) ;
	strcpy(Args->Passwd, value) ;
      }
      
      else if (!strcmp(variable, "ustringexec"))
	Args->UStringExec = atoi(value) ;
      
      else if (!strcmp(variable, "lstringexec"))
	Args->LStringExec = atoi(value) ;
      
      else if (!strcmp(variable, "shaderate"))
	Args->ShadeRate = atoi(value) ;
      
      else if (!strcmp(variable, "quality"))
	Args->Quality = atoi(value) ;
      
      else if (!strcmp(variable, "rotate"))
	Args->Rotate = atoi(value) ;
      
      else if (!strcmp(variable, "use3d"))
	Args->Use3D = atoi(value) ;

      else if (!strcmp(variable, "usecolors")) {
	Args->UseColors = atoi(value) ;
      }
      else if (!strcmp(variable, "redfore")) {
	Args->Colors[0] = atoi(value) ;
      }
      else if (!strcmp(variable, "greenfore")) {
	Args->Colors[1] = atoi(value) ;
      }
      else if (!strcmp(variable, "bluefore")) {
	Args->Colors[2] = atoi(value) ;
      }
      else if (!strcmp(variable, "redback")) {
	Args->Colors[3] = atoi(value) ;
      }
      else if (!strcmp(variable, "greenback")) {
	Args->Colors[4] = atoi(value) ;
      }
      else if (!strcmp(variable, "blueback")) {
	Args->Colors[5] = atoi(value) ;
      }
      else
	fprintf(stderr, "stamp: Invalid stamprc option: %s\n", variable) ;
    }
  }
  fclose(RC_file);
}

void RC_save(struct ArgStruct *Args) {
  FILE *RC_file;

  RC_file =   RC_file = fopen(Args->RCFile, "w+") ;

  if (RC_file == NULL) {
    fprintf(stderr, "rcfile.c: Uh oh - file is null! - rcfile = %s\n", Args->RCFile);
    return;
  }

  if (strcmp(Args->UpperString, ""))
    fprintf(RC_file, "%s\t%s\n", "upperstring", Args->UpperString) ;
  if (strcmp(Args->LowerString, ""))
    fprintf(RC_file, "%s\t%s\n", "lowerstring", Args->LowerString) ;
  if (strcmp(Args->UpperFont, ""))
    fprintf(RC_file, "%s\t%s\n", "upperfont", Args->UpperFont) ;
  if (strcmp(Args->LowerFont, ""))
    fprintf(RC_file, "%s\t%s\n", "lowerfont", Args->LowerFont) ;
  if (strcmp(Args->Infile, ""))
    fprintf(RC_file, "%s\t%s\n", "infile", Args->Infile) ;
  if (strcmp(Args->Outfile, ""))
    fprintf(RC_file, "%s\t%s\n", "outfile", Args->Outfile) ;
  if (strcmp(Args->Host, ""))
    fprintf(RC_file, "%s\t%s\n", "ftphost", Args->Host) ;
  if (strcmp(Args->Path, ""))
    fprintf(RC_file, "%s\t%s\n", "ftppath", Args->Path) ;
  if (strcmp(Args->Upload, ""))
    fprintf(RC_file, "%s\t%s\n", "ftpupload", Args->Upload) ;
  if (strcmp(Args->Login, "")) 
    fprintf(RC_file, "%s\t%s\n", "ftplogin", Args->Login) ;
  if (strcmp(Args->Passwd, ""))
    fprintf(RC_file, "%s\t%s\n", "ftppasswd", Args->Passwd) ;

  fprintf(RC_file, "%s\t%d\n", "ustringexec", Args->UStringExec) ;
  fprintf(RC_file, "%s\t%d\n", "lstringexec", Args->LStringExec) ;
  fprintf(RC_file, "%s\t%d\n", "shaderate", Args->ShadeRate) ;
  fprintf(RC_file, "%s\t%d\n", "quality", Args->Quality) ;
  fprintf(RC_file, "%s\t%d\n", "rotate", Args->Rotate) ;
  fprintf(RC_file, "%s\t%d\n", "use3d", Args->Use3D) ;
  fprintf(RC_file, "%s\t%d\n", "usecolors", Args->UseColors);
  fprintf(RC_file, "%s\t%d\n", "redfore", Args->Colors[0]) ;
  fprintf(RC_file, "%s\t%d\n", "greenfore", Args->Colors[1]) ;
  fprintf(RC_file, "%s\t%d\n", "bluefore", Args->Colors[2]) ;
  fprintf(RC_file, "%s\t%d\n", "redback", Args->Colors[3]) ;
  fprintf(RC_file, "%s\t%d\n", "greenback", Args->Colors[4]) ;
  fprintf(RC_file, "%s\t%d\n", "blueback", Args->Colors[5]) ;
  
  if (strcmp(Args->Previewfile, ""))
    fprintf(RC_file, "%s\t%s\n", "previewfile", Args->Previewfile) ;
  fclose(RC_file);
}





