/* Helper Functions for GTK Stamp Config! 
   Eric Werner - 19 FEB 1999 
   ebw@city-net.com
*/
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "gstamp.h"

extern char *stamperror[] ;


void set_status(UI_Struct *ui, char *str){
  gtk_label_set(GTK_LABEL(ui->Status), str);
  gtk_widget_hide(ui->Status);
  gtk_widget_show(ui->Status);
}

/* this forks and runs stamp_main and potentially Transfer_File.  It forks so that
   the ui is kept active */
int gstmp_stampit(UI_Struct *ui, struct ArgStruct *args, int send){
  int stamp_return;
  int pid;
  int *shm;
  int shmid;
  char tmpstr[1024];

  if (ui->GSTMP_STAMPING) {
    return 0;
  }

  shmid = create_shm();
  
  if (shmid == -1) {
    message_set_text(ui, "Error Creating Shared Memory.\n Contact Authors.");    
    message_show(ui);
    return 0;
  }
  
  shm = (int *) shmat(shmid, 0, 0);
  shm[0] = -1;

  pid = fork();

  if (pid){
    /* then we're the parent */
    ui->GSTMP_STAMPING = 1;
    gtk_pixmap_set ((GtkPixmap *)ui->stamp_pix, ui->yes_stamp, ui->yes_stamp_mask);
    gtk_widget_hide(ui->stamp_pix);
    gtk_widget_show(ui->stamp_pix);
    strcpy(tmpstr, "Stamping...");
    set_status(ui, tmpstr);
    while ((shm[0]) == -1) {
      if (gtk_events_pending()){
	gtk_main_iteration();
      }
    }
    stamp_return = shm[0];
    gtk_pixmap_set ((GtkPixmap *)ui->stamp_pix, ui->no_stamp, ui->no_stamp_mask);
    gtk_widget_hide(ui->stamp_pix);
    gtk_widget_show(ui->stamp_pix);
    if (send && !stamp_return) {
      shm[0] = -1;
      gtk_pixmap_set ((GtkPixmap *)ui->transfer_pix, ui->yes_transfer, ui->yes_transfer_mask);
      gtk_widget_hide(ui->transfer_pix);
      gtk_widget_show(ui->transfer_pix);
      strcpy(tmpstr, "Sending to ");
      strcat(tmpstr, ui->args->Host);
      strcat(tmpstr, "...");
      set_status(ui, tmpstr);
      while ((shm[0]) == -1) {
	if (gtk_events_pending()){
	  gtk_main_iteration();
	}
      }
      gtk_pixmap_set ((GtkPixmap *)ui->transfer_pix, ui->no_transfer, ui->no_transfer_mask);
      gtk_widget_hide(ui->transfer_pix);
      gtk_widget_show(ui->transfer_pix);
      stamp_return = shm[0];
    }
    set_status(ui, "Idle");
    shmdt(shm);
    ui->GSTMP_STAMPING = 0;
  } 

  /* BEGIN CHILD PROCESS */
  else { 
    stamp_return = stamp_main(args);
    shm[0] = stamp_return;
    if (send && !stamp_return) {
      while(shm[0] != -1){ usleep(1); };
      stamp_return = Transfer_File(args) ;
    }
    shm[0] = stamp_return;
    shmdt(shm);
    _exit(0);
  }
  /* END CHILD PROCESS */

  if (remove_shm(shmid) == -1){
    message_set_text(ui, "Error Removing Shared Memory.\n Contact Authors.");    
    message_show(ui);
    return 0;
  }
  return stamp_return;
}

/* create shared memory segment */
int create_shm(){
  key_t key;
  char *shm;
  int shmid;

  key = ftok(".", 'h');
  if (key == -1) {
    return -1;
  }
  shmid = shmget(key,0,0);
  shmctl(shmid, 0, IPC_RMID);
  shmid = shmget(key, 2 * sizeof(int), 0700 | IPC_CREAT | IPC_EXCL);
    return shmid;
}

int remove_shm(int shmid){
  if (shmctl(shmid, 0, IPC_RMID) == -1) {
    return -1;
  }
  return 0;
}

/* this actually displays a jpeg in the preview window */
void display_jpeg(gchar *filename, UI_Struct *ui){
  GdkColorContext *gcc;
  guint32 pixel;
  struct ImageStruct *jpg;
  struct ScanLine *scanline;
  int x, y,i;
  guint32 red, green, blue;
  gint bgcolor_red, bgcolor_green, bgcolor_blue;
  gint bits_red, bits_green, bits_blue;
  gint mask_red, mask_green, mask_blue;
  guint32 bgcolor;
  
  jpg = g_malloc ( sizeof(struct ImageStruct) );
  bzero(jpg, sizeof(struct ImageStruct));
  
  gtk_widget_realize(ui->preview->window);

  if (jpg==NULL){
    message_set_text(ui, "Could not allocate memory for jpg!");
    message_show(ui);
    return;
  }

  JPG_Load(filename, jpg);
  
  /* make a gcc if we dont have one, and set it. */
  if (!ui->preview->gcc) {
    gcc = ui->preview->gcc = 
      gdk_color_context_new(
			    gdk_window_get_visual(ui->preview->window->window),
			    gdk_window_get_colormap(ui->preview->window->window));
  } else {
    gcc = ui->preview->gcc;
  }
  
  /* if there was an image, kill it */
  if (ui->preview->gdk_image){
    gdk_image_destroy(ui->preview->gdk_image);
  }
  
  /* now make our gdk image */
  ui->preview->gdk_image = 
    gdk_image_new(GDK_IMAGE_NORMAL, 
		  gdk_window_get_visual(ui->preview->window->window),
		  jpg->image_width,
		  jpg->image_height);
  
  /* if there's not a gtk_image, make one. */
  if (!ui->preview->gtk_image){
    ui->preview->gtk_image = gtk_image_new (ui->preview->gdk_image, (GdkBitmap *)NULL); 
    gtk_container_add (GTK_CONTAINER (ui->preview->vbox), ui->preview->gtk_image);
    gtk_widget_show (ui->preview->gtk_image);
  } 
  
  /* set the image in the gtk_image */
  gtk_image_set (GTK_IMAGE(ui->preview->gtk_image), ui->preview->gdk_image, (GdkBitmap *)NULL);   

  /* set the window size */
  gtk_widget_set_usize (ui->preview->window, jpg->image_width+5, jpg->image_height+5);
  
  /* do some magic with the bits to fit them into out colormap */
  bits_red = gcc->bits.red + gcc->bits.green + gcc->bits.blue - 8; 
  bits_green = gcc->bits.green + gcc->bits.blue - 8;
  bits_blue = 8 - gcc->bits.blue;
  
  mask_red = ((1 << gcc->bits.red) - 1) << (gcc->bits.green + gcc->bits.blue);
  mask_green = ((1 << gcc->bits.green) - 1) << gcc->bits.blue;
  mask_blue = ((1 << gcc->bits.blue) - 1);
  
  /* loop thru the jpeg */
  scanline = jpg->FirstLine;
  for (y = 0; y< jpg->image_height; y++){ 
    for (x = 0; x< jpg->image_width; x++){
      
      red = scanline->line[x * BYTES_PER_PIXEL + 0];
      green = scanline->line[x * BYTES_PER_PIXEL + 1];
      blue = scanline->line[x * BYTES_PER_PIXEL + 2];
      
      pixel = (red << bits_red) & mask_red;
      pixel |= (green << bits_green) & mask_green;
      pixel |= (blue >> bits_blue); 
      
      gdk_image_put_pixel(ui->preview->gdk_image, x, y, pixel);
    }
    scanline = scanline->next;
  }
  
  JPG_Free(jpg);
  gtk_widget_show(ui->preview->window);
}

/* this runs stamp and then calls show_jpeg */
void Preview(UI_Struct *ui){
  
  /* these are to hold the original values in the Args structure */
  char *outfile;
  char *infile;
  char tmpoutfile[255];
  int pid;  /* our pid */
  int stamp_return;  /* return value for the call to stamp */
  struct ArgStruct *a;
  
  /* save what is originally in the stamp args struct */
  a = ui->args;
  
  /* put what we have into the stamp args struct */
  ui_to_args(ui, a);
  
  /* save that which we must temporarily change for our preview */
  infile = a->Infile;
  outfile = a->Outfile;

  /* make a unique rcfile in tmp */
  pid = getpid();
  
  /* make a unique outputfile in /tmp */
  sprintf(tmpoutfile, "/tmp/stamp.%d.jpg", pid);
  a->Outfile = tmpoutfile;

  /* set the infile  */
  a->Infile = a->Previewfile;
 
  /* run stamp on the image.
     this should eventually be a call to the stamp_main */

  stamp_return = gstmp_stampit(ui, a, 0);

  /* put the rc structure back to the way is 'twas */
  a->Infile = infile;
  a->Outfile = outfile;
  
  if (stamp_return) {
    message_set_text(ui, stamperror[stamp_return]);    
    message_show(ui);
  } else {
    /* now we actually display the damn jpeg */
    display_jpeg(tmpoutfile, ui);
  }
  /* get rid of our mess in /tmp */
  remove(tmpoutfile);  
}


/* Funtion to copy strings and handle memory allocation. 
   Goofy - yes, but makes the code look a bit nicer
*/
void Nice_String_Copy(char **s1, char *s2){
  if (!s2) {
    if (!*s1) {
      return;
    } else {
      free(*s1);
      s1 = NULL;
      return;
    }
  } else {
    if (*s1) {
      free (*s1);
    }
    *s1 = (char *)g_malloc (sizeof (char) * strlen(s2) + 1);
    if(*s1) {
      strcpy (*s1, s2);
    } else {
    }
  }
}


/* Fills up the Stamp Args Structure using the information contained in the GUI. */
gint ui_to_args(UI_Struct *ui, struct ArgStruct *a){
  GtkStyle *style;
   
  bzero((void *)a, sizeof(struct ArgStruct));
  
  Nice_String_Copy(&a->RCFile, (char *)ui->RCFile);
  Nice_String_Copy(&a->Previewfile, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Previewfile)));
  Nice_String_Copy(&a->Infile, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Infile)));
  Nice_String_Copy(&a->Outfile, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Outfile)));
  Nice_String_Copy(&a->UpperString, (char *)gtk_entry_get_text (GTK_ENTRY(ui->UpperString)));
  Nice_String_Copy(&a->LowerString, (char *)gtk_entry_get_text (GTK_ENTRY(ui->LowerString)));
  Nice_String_Copy(&a->UpperFont, (char *)gtk_entry_get_text (GTK_ENTRY(ui->UpperFont)));
  Nice_String_Copy(&a->LowerFont, (char *)gtk_entry_get_text (GTK_ENTRY(ui->LowerFont)));

  a->UStringExec = (int)GTK_TOGGLE_BUTTON(ui->UStringExec)->active ;
  a->LStringExec = (int)GTK_TOGGLE_BUTTON(ui->LStringExec)->active ;
  a->Use3D = (int)GTK_TOGGLE_BUTTON(ui->Use3D)->active ;
  a->Rotate = (int)GTK_TOGGLE_BUTTON(ui->Rotate)->active ;

  a->UseColors = (int)GTK_TOGGLE_BUTTON(ui->UseColors)->active;

  a->ShadeRate = (int)gtk_range_get_adjustment(GTK_RANGE(ui->ShadeRate))->value;
  a->Quality = (int)gtk_range_get_adjustment(GTK_RANGE(ui->Quality))->value;

  /* FTP Related */
  Nice_String_Copy(&a->Host, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Host)));
  Nice_String_Copy(&a->Path, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Path)));
  Nice_String_Copy(&a->Upload, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Upload)));
  Nice_String_Copy(&a->Login, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Login)));
  Nice_String_Copy(&a->Passwd, (char *)gtk_entry_get_text (GTK_ENTRY(ui->Passwd)));
  

  /* the colors stored in the styles are from 0..65535, and we need them to
     be from 0..255, so we have to mult by a constant */
  /* please note that anything to do with colors in this program is completely insane. */
  style = gtk_widget_get_style(ui->ColorButton1);
  a->Colors[0] = (int) (style->bg[GTK_STATE_NORMAL].red * (255.0/65535.0) );
  a->Colors[1] = (int) (style->bg[GTK_STATE_NORMAL].green * (255.0/65535.0) );
  a->Colors[2] = (int) (style->bg[GTK_STATE_NORMAL].blue * (255.0/65535.0) );

  style = gtk_widget_get_style(ui->ColorButton2);
  a->Colors[3] = (int) (style->bg[GTK_STATE_NORMAL].red * (255.0/65535.0) );
  a->Colors[4] = (int) (style->bg[GTK_STATE_NORMAL].green * (255.0/65535.0) );
  a->Colors[5] = (int) (style->bg[GTK_STATE_NORMAL].blue * (255.0/65535.0) );

  return 1;
}


/* converts a NULL string to a "" string, because gtk doesnt like
   when you set things inside widgets to NULL */
gchar *check_str(char *s){
  return (gchar *)((s==NULL)?"":s);
}

/* Fills up the GUI structure using info contained in the Stamp Args Structure */
gint args_to_ui(struct ArgStruct *a, UI_Struct *ui) {
 
  gdouble colors[3];
  ui->args = a;
  
  Nice_String_Copy(&ui->RCFile, a->RCFile);

  gtk_entry_set_text (GTK_ENTRY(ui->Previewfile), check_str(a->Previewfile));
  gtk_entry_set_text (GTK_ENTRY(ui->Infile), check_str(a->Infile));
  gtk_entry_set_text (GTK_ENTRY(ui->Outfile), check_str(a->Outfile));
  gtk_entry_set_text (GTK_ENTRY(ui->UpperString), check_str(a->UpperString));
  gtk_entry_set_text (GTK_ENTRY(ui->LowerString), check_str(a->LowerString));
  gtk_entry_set_text (GTK_ENTRY(ui->UpperFont), check_str(a->UpperFont));
  gtk_entry_set_text (GTK_ENTRY(ui->LowerFont), check_str(a->LowerFont));
  

  GTK_TOGGLE_BUTTON(ui->UStringExec)->active = a->UStringExec;
  GTK_TOGGLE_BUTTON(ui->LStringExec)->active = a->LStringExec;
  GTK_TOGGLE_BUTTON(ui->Use3D)->active       = a->Use3D;
  GTK_TOGGLE_BUTTON(ui->Rotate)->active      = a->Rotate;
  

  colors[0] = ((gdouble)a->Colors[0])/255.0;
  colors[1] = ((gdouble)a->Colors[1])/255.0;
  colors[2] = ((gdouble)a->Colors[2])/255.0;
  set_color(ui->ColorButton1, colors);


  colors[0] = ((gdouble)a->Colors[3])/255.0;
  colors[1] = ((gdouble)a->Colors[4])/255.0;
  colors[2] = ((gdouble)a->Colors[5])/255.0;
  set_color(ui->ColorButton2, colors);
  

  GTK_TOGGLE_BUTTON(ui->UseColors)->active = a->UseColors;
  gtk_range_get_adjustment(GTK_RANGE(ui->ShadeRate))->value = a->ShadeRate;
  gtk_range_get_adjustment(GTK_RANGE(ui->Quality))->value = a->Quality ;
  
  /* FTP Related */
  
  gtk_entry_set_text (GTK_ENTRY(ui->Host), check_str(a->Host));
  gtk_entry_set_text (GTK_ENTRY(ui->Path), check_str(a->Path));
  gtk_entry_set_text (GTK_ENTRY(ui->Upload), check_str(a->Upload));
  gtk_entry_set_text (GTK_ENTRY(ui->Login), check_str(a->Login));
  gtk_entry_set_text (GTK_ENTRY(ui->Passwd), check_str(a->Passwd));
  
  return 1;
}



/* This is called by the save button callback and sets things 
   up from the gui end to write the config file */
void write_config_file(char *filename, UI_Struct *ui){
  if(ui->RCFile) { free (ui->RCFile); }
  ui->RCFile = (char *)g_malloc ( sizeof(char) * strlen(filename) + 1);
  strcpy(ui->RCFile, filename);
  ui_to_args(ui, ui->args);
  RC_save(ui->args);
} 

/* shows the Yes/No Dialog */
void yes_no_show(UI_Struct *ui) {
  gtk_widget_show (ui->yesno->window);
  gtk_grab_add(ui->yesno->window);
}

/* sets the yes/no title */
void yes_no_set_title(UI_Struct *ui, gchar *title){
  gtk_window_set_title (GTK_WINDOW(ui->yesno->window), title);
}

/* sets the yes/no question */
void yes_no_set_question(UI_Struct *ui, gchar *question){
  gtk_label_set (GTK_LABEL(ui->yesno->label), question);
}

/* initializes our yes/no dialog */
void make_yes_no_dialog(UI_Struct *ui) {
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *table;
  GtkWidget *label;
  Yes_No_Dialog *yn;
  
  yn = (Yes_No_Dialog *)g_malloc(sizeof(Yes_No_Dialog));
  
  window = gtk_window_new(GTK_WINDOW_DIALOG);
  yn->window = window;
  gtk_window_position (GTK_WINDOW(yn->window), GTK_WIN_POS_CENTER);
  
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (yes_no_delete_event), ui);
  gtk_container_border_width (GTK_CONTAINER (window), 20);

  table = gtk_table_new (3, 2, TRUE);
  gtk_container_add (GTK_CONTAINER (window), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 2 ); 
  button = gtk_button_new_with_label ("Yes");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (yes_no_yes_sel), ui);
  gtk_table_attach_defaults (GTK_TABLE(table), button, 0, 1, 1, 2);
  gtk_widget_show (button);
  button = gtk_button_new_with_label ("No");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (yes_no_no_sel), ui);
  gtk_table_attach_defaults (GTK_TABLE(table), button, 1, 2, 1, 2);
  gtk_widget_show (button);
  button = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (yes_no_cancel_sel), ui);
  gtk_table_attach_defaults (GTK_TABLE(table), button, 2, 3, 1, 2);
  gtk_widget_show (button);
  label = gtk_label_new ("");
  yn->label = label;
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,2,0,1);

  gtk_widget_show(label);
  gtk_widget_show (table);

  ui->yesno = yn;
}

/* This builds and initilizes the File Dialog, and adds it into the ui structure */
void make_file_dialog(UI_Struct *ui){
  GtkWidget *filew;

  ui->GSTMP_FILE_VISIBLE = FALSE;
  ui->GSTMP_FILE_BUTTON = 0;

  filew = gtk_file_selection_new ("File selection");
  gtk_signal_connect (GTK_OBJECT (filew), "destroy",
		      (GtkSignalFunc) file_delete_event, ui);
  gtk_signal_connect (GTK_OBJECT (filew), "delete_event",
		      (GtkSignalFunc) file_delete_event, ui);
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, ui );
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
		      "clicked", (GtkSignalFunc) file_cancel_sel, ui);
  ui->filew = filew;
}

/* this changes the color of a widget */
/* the color is an array of doubles from 0..1 and they are R G B */
void set_color(GtkWidget *w, gdouble color[])
{

  /* this is insane - ebw */

  GdkColor gdk_color;
  GdkColormap *colormap;
  GtkStyle *fgstyle;
  
  /* get the current colormap of the widget so we can add in the new
     color and it will be displayed properly */
  colormap = gtk_widget_get_colormap (w);
  
  /* the Gtk color selector uses RGB from 0..1 as doubles,
     the GdkColor object uses RGB from 0..65535, so we have to convert */
  gdk_color.red = (guint16)(color[0]*65535.0);
  gdk_color.green = (guint16)(color[1]*65535.0);
  gdk_color.blue = (guint16)(color[2]*65535.0);

  /* not really sure what this does, but i know we need it. */
  gdk_color.pixel = (gulong)(gdk_color.red*65536 + gdk_color.green*256 + gdk_color.blue);
  
  /* Allocate color */
  gdk_color_alloc (colormap, &gdk_color);
  
  /* Set window background color */
  fgstyle = gtk_style_new();

  /* this sets the color for EVERY STATE which may not be what you want
     if you're reusing this, but it's what i need for my color picker
     buttons */
  fgstyle->bg[GTK_STATE_NORMAL] = gdk_color;
  fgstyle->bg[GTK_STATE_ACTIVE] = gdk_color;
  fgstyle->bg[GTK_STATE_PRELIGHT] = gdk_color;
  fgstyle->bg[GTK_STATE_SELECTED] = gdk_color;
  fgstyle->bg[GTK_STATE_INSENSITIVE] = gdk_color;
  
  /* add the new style (with the new color we made) into the widget */
  gtk_widget_set_style(w, fgstyle);

  /* dunno if we need this or not. */
  gtk_widget_show(w);
}


/* this builds the Color Selection Dialog and adds it into the ui */
void make_colorsel_dialog(UI_Struct *ui){
  
  ui->GSTMP_COLOR_VISIBLE = FALSE;
  ui->GSTMP_CURRENT_COLOR_BUTTON = 0;

  ui->ColorSel = gtk_color_selection_dialog_new("Select a Color");
  gtk_color_selection_set_update_policy(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(ui->ColorSel)->colorsel), 
					GTK_UPDATE_CONTINUOUS);

  gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (ui->ColorSel)->ok_button),
		      "clicked", (GtkSignalFunc) color_changed, ui );

  gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (ui->ColorSel)->cancel_button),
		      "clicked", (GtkSignalFunc) color_cancel_sel, ui );

  gtk_signal_connect (
		      GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (ui->ColorSel)->colorsel),
		      "color_changed",
		      GTK_SIGNAL_FUNC(color_selection_changed), ui->ColorSel );
  
  gtk_signal_connect (
		      GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (ui->ColorSel)),
		      "delete_event",
		      GTK_SIGNAL_FUNC (color_delete_event), ui);

  gtk_widget_hide (GTK_WIDGET(GTK_COLOR_SELECTION_DIALOG(ui->ColorSel)->help_button));
}
	   
/* this builds the Image Preview Dialog and adds it into the ui */	   
void make_preview_dialog(UI_Struct *ui){

  GtkWidget *window;
  GtkStyle *style;
  GtkWidget *gtk_image;
  GdkImage *gdk_image;
  GdkColorContext *gcc;

  ui->preview = (Gstmp_Preview *)g_malloc(sizeof (Gstmp_Preview));
  ui->preview->window = window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_container_border_width (GTK_CONTAINER (window), 20);
  gtk_window_set_title (GTK_WINDOW(window), "Stamp! Preview");

  ui->preview->vbox = gtk_vbox_new(FALSE, 5);
  gtk_widget_show (ui->preview->vbox);
  
  gtk_container_add (GTK_CONTAINER (window), ui->preview->vbox);
  
  style = ui->preview->style = gtk_widget_get_style(window);
  
  ui->preview->gdk_image = NULL;
  ui->preview->gtk_image = NULL;
  ui->preview->gcc = NULL;
  
  
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (preview_delete_event), ui);
    

}

void make_message_dialog(UI_Struct *ui){
  Message_Dialog *m;
  GtkWidget *window;
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *vbox;
  GtkWidget *hbox;
  
  m = g_malloc(sizeof(Message_Dialog));
  ui->message = m;
  
  window = gtk_window_new(GTK_WINDOW_DIALOG);
  m->window = window;
  gtk_window_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (message_delete_event), ui);
  gtk_container_border_width (GTK_CONTAINER (window), 20);
  
  vbox = gtk_vbox_new(TRUE, 5);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  
  label = gtk_label_new("");
  m->label = label;
  gtk_box_pack_start_defaults(GTK_BOX(vbox), label);
  gtk_widget_show (label);
  
  hbox = gtk_hbox_new(FALSE, 5);
  gtk_widget_show (hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 5);
  
  button = gtk_button_new_with_label ("Ok");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (message_ok_sel), ui);
  gtk_widget_set_usize (button, 50, 0);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 5);
  gtk_widget_show (button);
  m->button = button;
}

void message_set_text(UI_Struct *ui, gchar *t) { 
  gtk_label_set (GTK_LABEL(ui->message->label), t);
}
void message_show(UI_Struct *ui) {
  gtk_widget_show(GTK_WIDGET(ui->message->window));
  gtk_grab_add(GTK_WIDGET(ui->message->window));
}









