#ifndef _COMMON_H_
#define _COMMON_H_
#include <jpeglib.h>
#include <setjmp.h>

#define BYTES_PER_PIXEL 3

#define DHEIGHT 16
#define DWIDTH 8

#define BLACK 0
#define WHITE 255

#define ERR_INFILE     1
#define ERR_OUTFILE    2
#define ERR_NOHOMEDIR  3
#define ERR_BADCOLORS  4
#define ERR_BADSHADE   5
#define ERR_BADQUALITY 6 
#define ERR_NOUFONT    7
#define ERR_NOLFONT    8
#define ERR_MISSIOFILE 9
#define ERR_NOTCOLORJPG 10
#define ERR_BADEXEC 11
#define ERR_UTOOBIG 12
#define ERR_LTOOBIG 13
#define ERR_BADUFONT 14
#define ERR_BADLFONT 15
#define ERR_FTPCONNECT 16
#define ERR_FTPLOGIN 17
#define ERR_FTPCHDIR 18
#define ERR_FTPPUT 19
#define ERR_FTPREN 20
#define ERR_JPEGLIB 21

struct stamp_jpeg_error_mgr {
  struct jpeg_error_mgr pub;    /* "public" fields */
  
  jmp_buf setjmp_buffer;        /* for return to caller */
};

typedef struct stamp_jpeg_error_mgr * stamp_jpeg_error_ptr;

struct ScanLine {
  struct ScanLine *next ;
  JSAMPLE *line ;
} ;

struct ImageStruct {
  int image_width ;
  int image_height ;
  struct ScanLine *FirstLine ;
  struct ScanLine *LastLine ;
  
  struct ScanLine *OldFirstLine ;
  struct ScanLine *OldLastLine ;
} ;

struct ArgStruct {
  char *Previewfile ;
  char *RCFile ;
  char *Infile ;
  char *Outfile ;
  char *UpperString ;
  char *LowerString ;
  char *UpperFont ;
  char *LowerFont ;
  int UStringExec ;
  int LStringExec ;
  int UseFTP ;
  int Use3D ;
  int Rotate ;
  int Colors[6] ;
  int UseColors ;
  int ShadeRate ;
  int Quality ;
  /* FTP Related */
  char *Host ;
  char *Path ;
  char *Upload ;
  char *Login ;
  char *Passwd ;
} ;

int JPG_Load(char *, struct ImageStruct *) ;
int JPG_Save(char *, struct ImageStruct *, struct ArgStruct *) ;
void JPG_Free(struct ImageStruct *Image) ;
int stamp_main(struct ArgStruct *Args) ;
int Transfer_File(struct ArgStruct *Args) ;
#endif











