/* gstamp
   GTK+ config file for Stamp!
   Eric Werner 
   ebw@city-net.com
   Copyright Eric Werner 1999
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include "gstamp.h"


int Parse_GStamp_Args(int argc, char **argv, struct ArgStruct *Args) {
  extern int optind ;
  extern char *optarg ;
  extern int opterr ;
  int c ;
  
  while (1) {
    int option_index = 0 ;
    static struct option long_options[] =
    {
      {"help", 0, 0, 'h'},
      {"version", 0, 0, 'v'},
      {"rcfile", 1, 0, 'r'},
      {0, 0, 0, 0}
    };
    
    c = getopt_long (argc, argv, "hvr:", long_options, &option_index);
    
    if (c == -1){
      break;
    }
    switch (c) {
      
    case 'v':
      fprintf(stderr, "\nGTK Stamp %s\n", VERSION) ;
      fprintf(stderr, "Copyright (C) 1999 Patrick Keane, Joshua Kirby, Eric Werner\n") ;
      fprintf(stderr, "This Program comes with NO WARRANTY.  You may redistribute\n");
      fprintf(stderr, "copies of this program under the terms of the GNU General\n");
      fprintf(stderr, "Public License.  For more information about these\n") ;
      fprintf(stderr, "matters, see the file named COPYING.\n\n") ;
      exit(0) ;
      break ;
    case 'r':
      g_free(Args->RCFile);
      Args->RCFile = (char *)malloc(strlen(optarg) + 1) ;
      strcpy(Args->RCFile, optarg) ; 
      break ;
      
    default:
      fprintf(stderr, "\n") ;
      fprintf(stderr, "Usage:\n") ;
      fprintf(stderr, "  gstamp <options>\n") ;
      fprintf(stderr, "  -r [file],      --rcfile       Use [file] for stamprc information\n") ;
      fprintf(stderr, "  -v,             --version      Show version information\n") ;
      fprintf(stderr, "  -h,             --help         This help message\n") ;
      fprintf(stderr, "\n") ;
      exit(0);
    }
  }
  return 1;
}      
      

int main (int argc, char *argv[]) {
  struct ArgStruct *Args;
  UI_Struct *UI;

  gtk_init (&argc, &argv);

  Args = g_malloc (sizeof (struct ArgStruct));
  bzero(Args, sizeof(struct ArgStruct));
  Set_Default_Args(Args);
  Parse_GStamp_Args(argc,argv,Args);
  
  RC_load(Args);
  UI = make_ui(Args);

  gtk_main ();

  return 0;
}

      
      
      
      
      









