""" CSV export module

    begin                : 2003-01-26 09:03:06 rnc
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: dbExportCSV.py,v 1.20 2004/02/28 13:08:01 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.20 $"

import traceback

class dbExportDSV:
    def __init__(self,db,opts,batch):
        self.curdb = db
        self.opts = opts
        if self.opts["outdir"][-1] != '/': self.opts["outdir"] = self.opts["outdir"]+'/'
        try:
            self.outmeta = open(opts["outdir"]+"metadata.csv","w")
        except:
            traceback.print_exc()
            print "Error opening output file for writing"
        self.batch = batch

    def do(self):
        """# export only metadata """
        imglist = []
        ln = "Path,"
        for fld in self.curdb.metafields:
            ln = ln+fld+','
        self.outmeta.write(ln[:-1]+"\n")
        self.curdb.crawlBatchContentsForImg(self.batch,imglist)
        for id in imglist:
            line = "\""+ self.curdb.img[id][0] +"\","
            mt = self.curdb.meta[id]
            for fld in self.curdb.metafields:
                if mt.has_key(fld):
                    line = line+'\"'+str(mt[fld])+"\""
                line = line+','
            self.outmeta.write(line[:-1]+"\n") # -1 to remove trailing ,
        print "Closing"
        self.outmeta.close()
        return "Data succesfully exported:\n%s." %(self.opts["outdir"]+"metadata.csv")

class dbImportDSV:
    def __init__(self,db,wnd):
        self.wnd = wnd
    def previewFile(self,lines = 0):
        """ return lines lines of data. if lines is zero, return all data found on file
        return is a list of lists. First list are the headers.
        """
        tbl = []
        data = ""
        delimiter = str(self.wnd.datadedit.text())
        qualifier = str(self.wnd.textqedit.text())
        try:
            fname = str(self.wnd.pathedit.text())
            file = open(fname,"r")
            if not lines:
                data = file.read()
            else:
                for i in range(11):
                    try:
                        data = data+file.readline()
                    except:
                        pass
            import DSV
            rdata = DSV.organizeIntoLines(data, textQualifier = qualifier)
            tbl= DSV.importDSV(rdata, delimiter = delimiter, textQualifier = qualifier)
        except:
            traceback.print_exc()
            return None
        return tbl
