/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifndef __LE_H__
#define __LE_H__

#include "SunIM.h"
#include "koinput.h"

/* record the status of Auxiliary window */
typedef struct {
  int	x;
  int	y;
  char	on;		/* On or Off status of Auxiliary Window */
  char	junjabanja;		/* JunJa/BanJa Status */
  char	punct;		/* Punctuation Status	*/ 
  int	engine_id;	/* Current Input Method ID */
}   TPaletteAuxStatus;

typedef struct {
  int	x;
  int	y;
  int	keyboard_id;    /* Virtual Keyboard ID */
  char	key_status;
}   TKeyboardAuxStatus;

typedef struct {
  char 	on;
  char	lookup_id;    /* Lookup Table ID */
}   TLookupAuxStatus;

typedef struct {
  char 	on;
}   TSelectAuxStatus;

typedef struct {
  char 	on;
}   TOptionAuxStatus;

typedef enum {
  UNKNOWN_IMP,
  IIIMP,
  XIMP,
  XIMCP
}   TIMProtocolType;

typedef enum {
  UNKNOWN_CLIENT,
  JAVA_CLIENT,
  X11_CLIENT
}   TClientType;

/* data per desktop */
typedef struct {
  iml_session_t 	*current_session;
  iml_session_t 	*root_session;
  CARD8 		selectaux_started;
  CARD8 		optionaux_started;
  CARD8 		keyboardaux_started;
  CARD8 		lookupaux_started;
  CARD8 		actionaux_started;
  CARD8 		paletteaux_started;
  CARD8 		paletteaux_first_trigger_on;
  CARD8 		paletteaux_ready;
  CARD8 		aux_locale_id;
  CARD8		bSentKeymapToAux[MAX_ENGINE_NUM];
  IMEArgList	ime_args[MAX_ENGINE_NUM];
  UserPreference	user_pref;
} MyDataPerDesktop;

/* data per session */

typedef struct _SessionCoreStruct SessionCoreStruct;
struct _SessionCoreStruct{
  IMEBufferMethods ime_methods_table;
  IMEBuffer 		  ime_buffer;
};
typedef struct {
  TPaletteAuxStatus  	paletteaux_status;
  TKeyboardAuxStatus  	keyboardaux_status;
  TLookupAuxStatus  	lookupaux_status;
  TSelectAuxStatus  	selectaux_status;
  TOptionAuxStatus  	optionaux_status;
  TIMProtocolType		protocol_type;
  TClientType				client_type;
  int                     input_mode;
  SessionCoreStruct 	session_core;
  IMEEngine *p_engine;
} MyDataPerSession;

#endif /* __LE_H__ */
