/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>
#include <IMProtocolStruct.h>

/*
  table_prv.h is meant to be included only by this file
  Maybe I don't need to have separate header later...
*/

#define TABLE_PRIVATE_DEFINED
#include "table_prv.h"
#include "hangul.h"

UTFCHAR
hangul_combining_chosung_to_compatibility_jamo (UTFCHAR ch)
{
  if (ch < 0x1100 || ch > 0x1112)
    return 0;
  else
    return _combining_chosung_to_compatibility_chosung[ch - 0x1100];
}

UTFCHAR
hangul_combining_jungsung_to_compatibility_moeum (UTFCHAR ch)
{
  if (ch < 0x1161 || ch > 0x1175)
    return 0;
  else
    return _combining_jungsung_to_compatibility_moeum[ch - 0x1161];
}

UTFCHAR
hangul_combining_jongsung_to_compatibility_jaeum (UTFCHAR ch)     
{
  if (ch < 0x11a8 || ch > 0x11c2)
    return 0;
  else
    return _combining_jongsung_to_compatibility_jaeum[ch - 0x11a8];
}

UTFCHAR
hangul_combining_chosung_to_combining_jongsung (UTFCHAR cchosung)
{
  /*
    cchosung : compatibility jamo chosung
    cjongsung: compatibility jamo jongsung
   */
  UTFCHAR cjongsung;

  if (cchosung < 0x1100 || cchosung > 0x1112)
    cjongsung = 0;
  else
    cjongsung =
      _combining_chosung_to_combining_jongsung[cchosung - 0x1100];

  return cjongsung;
}

UTFCHAR
hangul_combining_jongsung_to_combining_chosung (UTFCHAR jongsung)
{
#if 0
  static UTFCHAR table[] = {
    0x1100, 0x1101, 0x1109, 0x1102,
    0x110c, 0x1112, 0x1103, 0x1105,
    0x1100, 0x1106, 0x1107, 0x1109,
    0x1110, 0x1111, 0x1112, 0x1106,
    0x1107, 0x1109, 0x1109, 0x110a,
    0x110b, 0x110c, 0x110e, 0x110f,
    0x1110, 0x1111, 0x1112 
  };
#endif
  
  if (jongsung < 0x11a8 || jongsung > 0x11c2)
    return 0;
  else
    return _combining_jongsung_to_combining_chosung[jongsung - 0x11a8];
}
#if 0
void
hangul_jongseong_decompose (UTFCHAR ch,
			    UTFCHAR* return_jongsung, UTFCHAR* return_chosung)
{
  if (ch >= 0x11a8 && ch <= 0x11c2) {
    *return_jongsung = _combining_coupled_jongsung_decompose[ch - 0x11a8][0];
    *return_chosung  = _combining_coupled_jongsung_decompose[ch - 0x11a8][1];
  } else {
    *return_jongsung = 0;
    *return_chosung = 0;
  }
}

UTFCHAR
hangul_jamo_to_syllable (UTFCHAR chosung, UTFCHAR jungsung, UTFCHAR jongsung)
{
  static UTFCHAR base_hangul	  = 0xac00;
  static UTFCHAR base_chosung  = 0x1100;
  static UTFCHAR base_jungsung = 0x1161;
  static UTFCHAR base_jongsung = 0x11a7;
  static int njungsung = 21;
  static int njongsung = 28;
  UTFCHAR ch;

  if (jongsung == 0)
    jongsung = JONGSEONG_FILLER;

  if (chosung  < 0x1100 || chosung  > 0x1112)
    return 0;
  if (jungsung < 0x1161 || jungsung > 0x1175)
    return 0;
  if (jongsung < 0x11a7 || jongsung > 0x11c2)
    return 0;

  chosung  -= base_chosung;
  jungsung -= base_jungsung;
  jongsung -= base_jongsung;

  ch = ((chosung * njungsung) + jungsung) * njongsung + jongsung
    + base_hangul;
  return ch;
}
#endif
