#ifndef _ENCODE_H_
#define _ENCODE_H_
enum encode_id_list {
	ENCODE_ERROR = -1,
	ENCODE_GB2312 = 0,
	ENCODE_GBK,
	ENCODE_GB18030,
	ENCODE_BIG5,
	ENCODE_EUC_TW,
	ENCODE_BIG5HK,
	ENCODE_EUC_TH,
	ENCODE_EUC_KO,
	ENCODE_UTF8,
	ENCODES_NUM
};

enum lang_group_list {
	LANG_ERROR = -1,
	LANG_ZH_CN = 0,
	LANG_ZH_TW,
	LANG_ZH_HK,
	LANG_TH_TH,
	LANG_KO_KR,
	LANGS_NUM,
};

extern char *get_langname_from_langid(int langid);
extern char *get_langname_from_locale(char *locale);
extern char *get_langname_from_encodeid(int encodeid);
extern int get_langid_from_locale(char *locale);
extern int get_langid_from_localeid(int localeid);
extern int get_encodeid_from_name(char *name);
extern int get_encodeid_from_locale(char *locale);
extern char *get_name_from_encodeid(int encode_id);
extern char *get_default_locale_from_locale(char *locale);
extern int  get_char_len_by_encodeid(int encode_id, unsigned char *ch_ptr);
extern int is_valid_code(int encode_id, unsigned char *int_code, int code_len);

extern int Convert_Native_To_UTF8(int encode_id, char *from_buf, size_t from_left,
			   char **to_buf, size_t * to_left);
extern int Convert_UTF8_To_Native(int encode_id, char *from_buf, size_t from_left,
			   char **to_buf, size_t * to_left);
extern int Convert_Native_To_UTF16(int encode_id, char *from_buf, size_t from_left,
			   char **to_buf, size_t *to_left);
extern int Convert_UTF16_To_Native(int encode_id, char *from_buf, size_t from_left,
			   char **to_buf, size_t * to_left);

#endif /* _ENCODE_H_ */

