/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/* 
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */
#include <stdio.h>

#include "hzinput.h"
#include "codetable.h"
#include "zhuyin_im.h"
#include "zhuyin_data.h"

int  zhuyin_SetOptions(IMECore, char *);
int  zhuyin_SetValues(IMECore, IMEArgList, int);
int  zhuyin_Init(IMECore);
int  zhuyin_Open(IMECore, IMEBuffer);
int  zhuyin_Filter(IMECore, IMEKey, IMEArgList, IMEBuffer);
void zhuyin_Close(IMECore);

#ifdef	WIN32
#define EXPORT extern __declspec(dllexport)
EXPORT
#endif

/* IF Method */
IMEMethodsRec ime_methods = {
	zhuyin_SetOptions,
	zhuyin_SetValues,
	zhuyin_Init,
	zhuyin_Open,
	zhuyin_Filter,
	zhuyin_Close,
	NULL,
	NULL,
	NULL
};

/* Set options for codetable input method. */
int zhuyin_SetOptions(IMECore core, char *options)
{
	return (0);
}

int zhuyin_SetValues(IMECore core, IMEArgList arglist, int option_value)
{
	int i;
	static char arg_keymaps[256];
	char *arg_name;
	TZhuyinData *pZhuyinData;

	DEBUG_printf("zhuyin_SetValues === \n");
	if (arglist == NULL) return(-1);

	arglist->args_num = ZHUYIN_ARGS_NUM;

	arg_name = NULL;
	pZhuyinData = (TZhuyinData *)(core->envinfo.data_ptr);
	if (pZhuyinData->pZhuyinKeymapList && pZhuyinData->pZhuyinKeymapList->nNum_Keymaps > 0){
		strcpy(arg_keymaps, zhuyin_args_name_TW[KEYMAP_MODE_ID]);
		for (i=0; i<pZhuyinData->pZhuyinKeymapList->nNum_Keymaps; i++) {
			strcat(arg_keymaps, " ; ");
			strcat(arg_keymaps, pZhuyinData->pZhuyinKeymapList->pKeymaps[i]->pName);
		}
		arg_name = arg_keymaps;
	}
	i = KEYMAP_MODE_ID;
	arglist->args[i].name = arg_name;
	arglist->args[i].value = 0;
	arglist->args[i].type = 6;

	i = AUTOSELECT_MODE_ID;
	arglist->args[i].name = zhuyin_args_name_TW[i];
	arglist->args[i].value = 1;
	arglist->args[i].type = 1;

	if (option_value != -1) {
		int cur_bit_pos, cur_bit_len, mask, j;

		cur_bit_pos = 0;
		for (i = 0; i < arglist->args_num; i++) {
			if (arglist->args[i].name == NULL)
				continue;

			cur_bit_len = arglist->args[i].type;
			mask = 0;
			for (j=0; j<cur_bit_len; j++)
				mask |= (1<<j);

			arglist->args[i].value = (option_value >> cur_bit_pos) & mask;
			cur_bit_pos += cur_bit_len;
		}
	}

	return(0);
}

/* return the Chinese name and encode status and status of codetable IME */
int zhuyin_Init(IMECore core)
{
	int  		ret;
	char 		file_name[256];
	TZhuyinData     *pZhuyinData;

	DEBUG_printf("zhuyin_Init ====\n");

	/* read table from file to memory buffer  */
	pZhuyinData = (TZhuyinData *)calloc(1, sizeof(TZhuyinData));
	if (pZhuyinData == NULL)
		return(-1);

	sprintf(file_name, "/usr/lib/im/locale/%s/common/zhuyin.cfg", core->envinfo.lang_name);
	ret = ZhuyinData_Init(file_name, pZhuyinData);
	if (ret == ZHUYIN_ERROR) {
		ZhuyinData_Free(pZhuyinData);
		return (-1);
	}

	/* Return Information that needed by Input Method Manager */
	/* Such as Encode, Cname, Status */
	core->baseinfo.status = ENGINE_NOT_INITIATED;
	core->baseinfo.cname = (char *)strdup(pZhuyinData->pCodetableHeader->Cname);
	core->baseinfo.encode_id = pZhuyinData->pCodetableHeader->Encode;
	
	core->envinfo.data_ptr = (char *)pZhuyinData;

	return(0);
}


/* Load the codetable file int memory */
int zhuyin_Open(IMECore core, IMEBuffer ime_buffer)
{
	int		ret;

	TZhuyinData     *pZhuyinData;

	DEBUG_printf("zhuyin_Open ==== \n");

	ime_buffer->encode = 0;
	ime_buffer->return_status = 0;
	ime_buffer->preedit_len = 0;
	ime_buffer->commit_len  = 0;
	ime_buffer->lookup_num  = 0;
	ime_buffer->inputkey_len  = 0;
	ime_buffer->cur_lookup_pos = 0;

	if (core->baseinfo.status == ENGINE_NOT_INSTALLED)
        	return(-1);

	if (core->baseinfo.status == ENGINE_INITIATED)
		return 0;

	/* if IME engine is not initiated, would malloc dictionary buffer */

	core->baseinfo.status == ENGINE_NOT_INSTALLED;

	pZhuyinData = (TZhuyinData *)(core->envinfo.data_ptr);
	ret = ZhuyinData_Open(pZhuyinData);
	if (ret == ZHUYIN_ERROR) {
        	return(-1);
	}

	core->baseinfo.status = ENGINE_INITIATED;

	return(0);
}

/* close IME, and free codetable pointers */
void zhuyin_Close(IMECore core)
{
	TZhuyinData     *pZhuyinData;

	DEBUG_printf("zhuyin_Close ==== \n");

	pZhuyinData = (TZhuyinData *)(core->envinfo.data_ptr);
	ZhuyinData_Free(pZhuyinData);
	free((char *)pZhuyinData);

	if (core->baseinfo.cname)
		free((char *)core->baseinfo.cname);
}

/* process key input event */
/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int  zhuyin_Filter(IMECore core, IMEKey  key_event, IMEArgList ime_args, IMEBuffer ime_buffer)
{
	int 		ret;
	CodeTableStruct *ctHeader;
	TZhuyinData     *pZhuyinData;

	DEBUG_printf("zhuyin_Filter ==== \n");

	if (core->baseinfo.status != ENGINE_INITIATED)
		return(IME_NOT_USED_KEY);
		
	pZhuyinData = (TZhuyinData *)(core->envinfo.data_ptr);

	/* if no user defined arguments, set with default arguments */
	pZhuyinData->nCurrentKeymapID = 0;

	/* ctHeader's argument setting are always coveried by user defined data */
	ctHeader = pZhuyinData->pCodetableHeader;
	ctHeader->Output_Encode = core->envinfo.output_encode_id;
	ctHeader->nKeyByKeyMode = 0;
	ctHeader->nHelpInfoMode = 0;
	ctHeader->nAutoSelectMode = 1;
	ctHeader->nKeyPromptMode = 1;

	if (ime_args != NULL) {
		/* if has user defined arguments, set with user defined arguments */
		pZhuyinData->nCurrentKeymapID = ime_args->args[KEYMAP_MODE_ID].value;
		ctHeader->nAutoSelectMode = ime_args->args[AUTOSELECT_MODE_ID].value;
	}
		
	ret = zhuyin_filter(pZhuyinData, key_event, ime_buffer);
	return(ret);
}

