/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef	XAUX_EXT_COMMON_H
#define	XAUX_EXT_COMMON_H

#pragma ident	"$Id$"

typedef enum aux_ext_data_type_enum {
	AUX_EXT_DATA_NONE = 0,
	AUX_EXT_DATA_START = 1,
	AUX_EXT_DATA_DRAW = 2,
	AUX_EXT_DATA_DONE = 3,
	AUX_EXT_DATA_SETVALUE = 4
} aux_ext_data_type_t;

typedef struct aux_ext_string_struct {
	int		length;
	unsigned char *	ptr;
} aux_ext_string_t;

typedef struct aux_ext_data_struct {
	aux_ext_data_type_t	type;
	int		im;
	int		ic;
	int		aux_index;
	int		aux_name_length;
	unsigned char *	aux_name;
	int		integer_count;
	int *		integer_list;
	int		string_count;
	aux_ext_string_t *	string_list;
	unsigned char *	string_ptr;
	Window		clientwin;
	Window		focuswin;
	XPoint		point;
} aux_ext_data_t;

typedef void *	xaux_ext_handle_t;

typedef Bool (*xaux_ext_cb_evhandler_t)(
	xaux_ext_handle_t,		/* handle */
	Window,				/* window */
	XEvent *,			/* event */
	void *				/* so's data */
);

typedef Bool (*xaux_ext_cb_addevhandler_t)(
	xaux_ext_handle_t,		/* handle */
	long,				/* event mask */
	Bool,				/* nonmaskable */
	xaux_ext_cb_evhandler_t,	/* handler */
	void *,				/* so's data */
	void *				/* ext's data */
);

typedef Bool (*xaux_ext_cb_rmevhandler_t)(
	xaux_ext_handle_t,		/* handle */
	long,				/* event mask */
	Bool,				/* nonmaskable */
	xaux_ext_cb_evhandler_t,	/* handler */
	void *,				/* so's data */
	void *				/* ext's data */
);

typedef Bool (*xaux_ext_cb_start_t)(
	xaux_ext_handle_t,
	aux_ext_data_t *,
	void *
);

typedef Bool (*xaux_ext_cb_draw_t)(
	xaux_ext_handle_t,
	aux_ext_data_t *,
	void *
);

typedef Bool (*xaux_ext_cb_done_t)(
	xaux_ext_handle_t,
	aux_ext_data_t *,
	void *
);

typedef struct xaux_ext_methods_struct {
	xaux_ext_handle_t	(*open)(const char *, Display *, Window, ...);
	void	(*close)(xaux_ext_handle_t);
	Bool	(*registercb_start)(
		xaux_ext_handle_t, xaux_ext_cb_start_t, void *);
	Bool	(*registercb_draw)(
		xaux_ext_handle_t, xaux_ext_cb_draw_t, void *);
	Bool	(*registercb_done)(
		xaux_ext_handle_t, xaux_ext_cb_done_t, void *);
	Bool	(*call_setvalue)(
		xaux_ext_handle_t, aux_ext_data_t *);
	Bool	(*registercb_addevhandler)(
		xaux_ext_handle_t, xaux_ext_cb_addevhandler_t, void *);
	Bool	(*registercb_rmevhandler)(
		xaux_ext_handle_t, xaux_ext_cb_rmevhandler_t, void *);
	Bool	(*set)(xaux_ext_handle_t, ...);
	Bool	(*get)(xaux_ext_handle_t, ...);
} xaux_ext_methods_t;

typedef void *	xaux_ext_hdlrmng_handle_t;

typedef struct xaux_ext_hdlrmng_methods_struct {
	xaux_ext_hdlrmng_handle_t	(*open)(void);
	Bool	(*add)(xaux_ext_hdlrmng_handle_t, xaux_ext_cb_evhandler_t,
			void *, long, Bool, long *, Bool *, long *, Bool *);
	Bool	(*remove)(xaux_ext_hdlrmng_handle_t, xaux_ext_cb_evhandler_t,
			void *, long, Bool, long *, Bool *, long *, Bool *);
	Bool	(*filter)(xaux_ext_hdlrmng_handle_t,
			xaux_ext_handle_t, XEvent *);
	void	(*close)(xaux_ext_hdlrmng_handle_t);
} xaux_ext_hdlrmng_methods_t;

#endif	/* !XAUX_EXT_COMMON_H */
