/* $Id: perror.c,v 1.1.1.1 2002/08/31 04:18:02 himi Exp $ */


#include <stdio.h>
#if defined(HAVE_DGETTEXT) && defined(HAVE_LIBINTL_H)
#include <libintl.h>
#endif /* HAVE_DGETTEXT && HAVE_LIBINTL_H */

#include <iiimp.h>


#if defined(HAVE_DGETTEXT)
#define IIIMF_MESSAGE_DOMAIN	"libiiimf"
#endif /* HAVE_DGETTEXT */


static const char *
status_string(IIIMF_status status)
{
    switch (status) {
    case IIIMF_STATUS_FAIL:
	return "fail";
    case IIIMF_STATUS_SUCCESS:
	return "success";

    case IIIMF_STATUS_MALLOC:
	return "memory allocation error";
    case IIIMF_STATUS_ARGUMENT:
	return "argument error";

    case IIIMF_STATUS_CONFIG:
	return "configuration error";
    case IIIMF_STATUS_ROLE:
	return "role violation";

    case IIIMF_STATUS_OPCODE:
	return "invalid opcode";
    case IIIMF_STATUS_SEQUENCE_REQUEST:
	return "sequence: request error";
    case IIIMF_STATUS_SEQUENCE_REPLY:
	return "sequence: reply error";
    case IIIMF_STATUS_SEQUENCE_ROLE:
	return "sequence: role error";
    case IIIMF_STATUS_SEQUENCE_STATE:
	return "sequence: state error";
    case IIIMF_STATUS_SEQUENCE_NEST:
	return "sequence: message nesting level exeeds the limit";

    case IIIMF_STATUS_IM_INVALID:
	return "invalid IM";

    case IIIMF_STATUS_STREAM:
	return "stream error";
    case IIIMF_STATUS_STREAM_SEND:
	return "stream send error";
    case IIIMF_STATUS_STREAM_RECEIVE:
	return "stream receive error";
    case IIIMF_STATUS_PACKET:
	return "packet error";
    case IIIMF_STATUS_INVALID_ID:
	return "invalid ID";
    case IIIMF_STATUS_TIMEOUT:
	return "timeout";

    default:
	return "unknown";
    }
}


void
iiimf_perror(IIIMF_status status, const char * str)
{
    const char *	p;
#if defined(HAVE_DGETTEXT) && defined(IIIMF_MESSAGE_DIRNAME)
    char *		dirname;
#endif /* HAVE_DGETTEXT && IIIMF_MESSAGE_DIRNAME */

    p = status_string(status);

#if defined(HAVE_DGETTEXT)
#if defined(IIIMF_MESSAGE_DIRNAME)
    dirname = bindtextdomain(IIIMF_MESSAGE_DOMAIN, NULL);
    bindtextdomain(IIIMF_MESSAGE_DOMAIN, IIIMF_MESSAGE_DIRNAME);
#endif /* IIIMF_MESSAGE_DOMAIN */
    p = dgettext(IIIMF_MESSAGE_DOMAIN, p);
#endif /* HAVE_DGETTEXT */

    if ((NULL == str) || ('\0' == *str)) {
	(void)fprintf(stderr, "%s\n", p);
    } else {
	(void)fprintf(stderr, "%s: %s\n", str, p);
    }

#if defined(HAVE_DGETTEXT) && defined(IIIMF_MESSAGE_DIRNAME)
    if (NULL != dirname) {
	bindtextdomain(IIIMF_MESSAGE_DOMAIN, dirname);
    }
#endif /* HAVE_DGETTEXT && IIIMF_MESSAGE_DOMAIN */

    return;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
