#include <stdio.h>
#include <stdlib.h>
#include <iiimcf.h>
#include "common.h"

IIIMCF_context context;

static void
create_context()
{
    IIIMF_status st;

    st = iiimcf_create_context(handle, IIIMCF_ATTR_NULL, &context);
    if (st != IIIMF_STATUS_SUCCESS) test_iiimf_error(st);
}

static void
destroy_context(
    IIIMCF_context c
)
{
    IIIMF_status st;

    st = iiimcf_destroy_context(c);
    if (st != IIIMF_STATUS_SUCCESS) test_iiimf_error(st);
}

static char attr_teststr[] = "teststr";

static void
set_context_attr(
    IIIMCF_context c
)
{
    IIIMCF_attr attr;

    check(iiimcf_context_get_attr(c, &attr));
    check(iiimcf_attr_put_integer_value(attr, IIIMCF_ATTR_PRIVATE_START + 1,
					10));
    check(iiimcf_attr_put_ptr_value(attr, IIIMCF_ATTR_PRIVATE_START + 2,
				    set_context_attr));
    check(iiimcf_attr_put_string_value(attr, IIIMCF_ATTR_PRIVATE_START + 3,
				       attr_teststr));
}

static void
check_context_attr(
    IIIMCF_context c
)
{
    IIIMCF_attr attr;
    int i;
    void *p;
    const char* str;

    check(iiimcf_context_get_attr(c, &attr));
    check(iiimcf_attr_get_integer_value(attr, IIIMCF_ATTR_PRIVATE_START + 1, &i));
    test_assert(i == 10);
    check(iiimcf_attr_get_ptr_value(attr, IIIMCF_ATTR_PRIVATE_START + 2, &p));
    test_assert(p == set_context_attr);
    check(iiimcf_attr_get_string_value(attr, IIIMCF_ATTR_PRIVATE_START + 3, &str));
    test_assert(str == attr_teststr);
}

int
main(
    int argc,
    char **argv
)
{
    test_init();
    test_show_version_info(handle);
    test_show_input_methods();
    test_show_objects();
    create_context();
    set_context_attr(context);
    check_context_attr(context);

    test_seticfocus(context);
    test_unseticfocus(context);
    check(iiimcf_reset_context(context));
    test_seticfocus(context);
    test_unseticfocus(context);

    destroy_context(context);
    test_uninit();

    return 0;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
