/*
  status.c
*/

#include <stdlib.h>
#include "iiimcfint.h"

IIIMF_status
iiimcf_toggle_status(
    IIIMCF_context_rec *pc,
    int flag
)
{
    if (flag && !IIIMCF_IS_ENABLED(pc, IIIMCF_CONTEXT_STATUS_ENABLED)) {
	IIIMCF_SET_STATE(pc, IIIMCF_CONTEXT_STATUS_ENABLED);
	IIIMCF_SET_STATE_CHANGE(pc, IIIMCF_STATE_STATUS_CHANGED);
	return iiimcf_store_simple_event(pc, IIIMCF_EVENT_TYPE_UI_STATUS_START);
    } else if (!flag && IIIMCF_IS_ENABLED(pc, IIIMCF_CONTEXT_STATUS_ENABLED)) {
	IIIMCF_RESET_STATE(pc, IIIMCF_CONTEXT_STATUS_ENABLED);
	IIIMCF_SET_STATE_CHANGE(pc, IIIMCF_STATE_STATUS_CHANGED);
	return iiimcf_store_simple_event(pc, IIIMCF_EVENT_TYPE_UI_STATUS_DONE);
    }

    return IIIMF_STATUS_SUCCESS;
}

IIIMF_status
iiimcf_update_status(
    IIIMCF_context_rec *pc,
    IIIMP_message *pmes
)
{
    IIIMF_status st;
    IIIMP_contents *pcon = pmes->v.status_draw.status;
    ASSERT(pmes->opcode == IM_STATUS_DRAW);

    st = iiimcf_convert_iiimp_contents_to_text(pcon, &pc->status_text);
    if (st != IIIMF_STATUS_SUCCESS) return st;

    /* 
       Strictly speaking, we should not enable status here.
       However, ATOK/X never send IM_STATUS_START, we cannot
       help enabling status text by IM_STATUS_DRAW as well...
     */
    if (!IIIMCF_IS_ENABLED(pc, IIIMCF_CONTEXT_STATUS_ENABLED)) {
	st = iiimcf_toggle_status(pc, 1);
	if (st != IIIMF_STATUS_SUCCESS) return st;
    }

    IIIMCF_SET_STATE_CHANGE(pc, IIIMCF_STATE_STATUS_CHANGED);

    return iiimcf_store_simple_event(pc, IIIMCF_EVENT_TYPE_UI_STATUS_CHANGE);
}

IIIMF_status
iiimcf_get_status_text(
    IIIMCF_context context,
    IIIMCF_text *ptext
)
{
    IIIMCF_context_rec *pc = (IIIMCF_context_rec*) context;

    if (IIIMCF_IS_IC_INVALID(pc)) return IIIMF_STATUS_IC_INVALID;
    if ((!IIIMCF_IS_ENABLED(pc, IIIMCF_CONTEXT_STATUS_ENABLED))
	|| (!IIIMCF_IS_VALID_TEXT(&pc->status_text)))
	return IIIMF_STATUS_NO_STATUS_TEXT;
    
    *ptext = &pc->status_text;

    return IIIMF_STATUS_SUCCESS;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
