/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "virtual_keyboard.h"

int
main (int argc, char *argv[])
{
  KeyboardLayout **keyboards;
  int n_count;
  GtkWidget *main_window;
  GtkWidget *kbd;
  
  Keyboards_Init (&n_count, &keyboards);
  
  gtk_init (&argc, &argv);
  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  g_printf ("%d layouts available...\n", n_count);
  kbd = virtual_keyboard_new_with_keyboard_layout (n_count, keyboards);
  virtual_keyboard_set_keyboard_layout (VIRTUAL_KEYBOARD (kbd), 1);
  gtk_container_add (GTK_CONTAINER (main_window), kbd);

  gtk_widget_show (kbd);
  /*
  gtk_widget_show (main_window);
  */
  

  gtk_main ();
  return 0;
}


