#include <stdio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

static GdkColor           _normal_bg;
static GdkColor           _normal_text;
static GdkColor           _active_bg;
static GdkColor           _active_text;
 
static GdkDisplay        *_current_display             = 0;
static GdkScreen         *_current_screen              = 0;

static GtkWidget         *_lookup_table_window         = 0;
static GtkWidget         *_lookup_table_up_button      = 0;
static GtkWidget         *_lookup_table_down_button    = 0;
static GtkWidget         *_lookup_table_left_button    = 0;
static GtkWidget         *_lookup_table_right_button   = 0;
static GtkWidget         *_lookup_table_items[10]      = { 0 };

int main(int argc, char **argv)
{
    PangoFontDescription *font_desc = 0;
    GtkWidget *input_window_vbox;
    GtkWidget *_lookup_table_parent;

    int _lookup_table_vertical = 1;
    int i;

    gtk_init (&argc, &argv);

    // Read configurations.
    gdk_color_parse ("gray92",     &_normal_bg);
    gdk_color_parse ("black",      &_normal_text);
    gdk_color_parse ("light blue", &_active_bg);
    gdk_color_parse ("black",      &_active_text);

    _current_display = gdk_display_get_default ();
    _current_screen  = gdk_display_get_default_screen (_current_display);
  
    font_desc = pango_font_description_from_string ("default");                                                                                                     
    //Create lookup table window
    {
        GtkWidget *vbox;
        GtkWidget *hbox;
        GtkWidget *frame;
        GtkWidget *image;
        GtkWidget *separator;
        GtkRequisition size;

        _lookup_table_window = gtk_window_new (GTK_WINDOW_POPUP);
        gtk_widget_modify_bg (_lookup_table_window, GTK_STATE_NORMAL, &_normal_bg);
        gtk_window_set_policy (GTK_WINDOW (_lookup_table_window), TRUE, TRUE, FALSE);
        gtk_window_set_resizable (GTK_WINDOW (_lookup_table_window), FALSE);
        gtk_widget_add_events (_lookup_table_window,GDK_BUTTON_PRESS_MASK);
        gtk_widget_add_events (_lookup_table_window,GDK_BUTTON_RELEASE_MASK);
        gtk_widget_add_events (_lookup_table_window,GDK_POINTER_MOTION_MASK);
/*
        g_signal_connect (G_OBJECT (_lookup_table_window), "button-press-event",
                          G_CALLBACK (ui_lookup_table_window_click_cb),
                          GINT_TO_POINTER (0));
        g_signal_connect (G_OBJECT (_lookup_table_window), "button-release-event",
                          G_CALLBACK (ui_lookup_table_window_click_cb),
                          GINT_TO_POINTER (1));
*/
        gtk_container_set_border_width (GTK_CONTAINER (_lookup_table_window), 0);

        frame = gtk_frame_new (0);
        gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_OUT);
        gtk_container_add (GTK_CONTAINER (_lookup_table_window), frame);
	_lookup_table_parent = frame;

        //Vertical lookup table
        if (_lookup_table_vertical) {
            vbox = gtk_vbox_new (FALSE, 0);
            gtk_container_add (GTK_CONTAINER (_lookup_table_parent), vbox);

            //New table items
            for (i=0; i<10; ++i) {
                _lookup_table_items [i] = gtk_label_new ("Item         ");
                if (font_desc)
                    gtk_widget_modify_font (_lookup_table_items [i], font_desc);

                gtk_widget_modify_base (_lookup_table_items [i], GTK_STATE_NORMAL, &_normal_bg);
                gtk_widget_modify_base (_lookup_table_items [i], GTK_STATE_ACTIVE, &_active_bg);
                gtk_widget_modify_text (_lookup_table_items [i], GTK_STATE_NORMAL, &_normal_text);
                gtk_widget_modify_text (_lookup_table_items [i], GTK_STATE_ACTIVE, &_active_text);
/*
                g_signal_connect (G_OBJECT (_lookup_table_items [i]), "button-press-event",
                                  G_CALLBACK (ui_lookup_table_vertical_click_cb),
                                  GINT_TO_POINTER (i));
*/
                gtk_box_pack_start (GTK_BOX (vbox), _lookup_table_items [i], TRUE, TRUE, 0);
            }

            separator = gtk_hseparator_new ();
            gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, FALSE, 0);

            hbox = gtk_hbox_new (FALSE, 0);
            gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

            //New down button
            image = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_IN);
            _lookup_table_down_button = gtk_button_new ();
            gtk_container_add (GTK_CONTAINER (_lookup_table_down_button), image);
            gtk_box_pack_end (GTK_BOX (hbox), _lookup_table_down_button, FALSE, FALSE, 0);
/*
            g_signal_connect (G_OBJECT (_lookup_table_down_button), "clicked",
                                G_CALLBACK (ui_lookup_table_down_button_click_cb),
                                image);
*/

            //New UP button
            image = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_IN);
            _lookup_table_up_button = gtk_button_new ();
            gtk_container_add (GTK_CONTAINER (_lookup_table_up_button), image);
            gtk_box_pack_end (GTK_BOX (hbox), _lookup_table_up_button, FALSE, FALSE, 0);
/*
            g_signal_connect (G_OBJECT (_lookup_table_down_button), "clicked",
                                G_CALLBACK (ui_lookup_table_down_button_click_cb),
                                image);
*/

        } else {
            hbox = gtk_hbox_new (FALSE, 0);
            gtk_container_add (GTK_CONTAINER (_lookup_table_parent), hbox);

            _lookup_table_items [0] = gtk_label_new ("Item1 Item2 Item3 Item4 Item5 Item6   ");
            if (font_desc)
                gtk_widget_modify_font (_lookup_table_items [0], font_desc);
            gtk_widget_modify_base (_lookup_table_items [0], GTK_STATE_NORMAL, &_normal_bg);
            gtk_widget_modify_base (_lookup_table_items [0], GTK_STATE_ACTIVE, &_active_bg);
            gtk_widget_modify_text (_lookup_table_items [0], GTK_STATE_NORMAL, &_normal_text);
            gtk_widget_modify_text (_lookup_table_items [0], GTK_STATE_ACTIVE, &_active_text);
/*
            g_signal_connect (G_OBJECT (_lookup_table_items [0]), "move_cursor",
                            G_CALLBACK (ui_lookup_table_horizontal_click_cb),
                            0);
*/
            gtk_box_pack_start (GTK_BOX (hbox), _lookup_table_items [0], TRUE, TRUE, 0);

            separator = gtk_vseparator_new ();
            gtk_box_pack_start (GTK_BOX (hbox), separator, FALSE, FALSE, 0);

            //New left button
            image = gtk_arrow_new(GTK_ARROW_LEFT, GTK_SHADOW_IN);
            gtk_widget_size_request (image, &size);
            _lookup_table_up_button = gtk_button_new ();
            gtk_widget_set_size_request (_lookup_table_up_button, size.width + 4, size.height + 4);
            gtk_container_add (GTK_CONTAINER (_lookup_table_up_button), image);

            gtk_box_pack_start (GTK_BOX (hbox), _lookup_table_up_button, FALSE, FALSE, 0);
/*
            g_signal_connect (G_OBJECT (_lookup_table_up_button), "clicked",
                                G_CALLBACK (ui_lookup_table_up_button_click_cb),
                                image);
*/

            //New right button
            image = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_IN);
            gtk_widget_size_request (image, &size);
            _lookup_table_down_button = gtk_button_new ();
            gtk_widget_set_size_request (_lookup_table_down_button, size.width + 4, size.height + 4);
            gtk_container_add (GTK_CONTAINER (_lookup_table_down_button), image);

            gtk_box_pack_start (GTK_BOX (hbox), _lookup_table_down_button, FALSE, FALSE, 0);

/*
            g_signal_connect (G_OBJECT (_lookup_table_down_button), "clicked",
                                G_CALLBACK (ui_lookup_table_down_button_click_cb),
                                image);
*/
        }

        gtk_button_set_relief (GTK_BUTTON (_lookup_table_up_button), GTK_RELIEF_NONE);
        gtk_widget_modify_bg (_lookup_table_up_button, GTK_STATE_ACTIVE, &_normal_bg);
        gtk_widget_modify_bg (_lookup_table_up_button, GTK_STATE_INSENSITIVE, &_normal_bg);
        gtk_widget_modify_bg (_lookup_table_up_button, GTK_STATE_PRELIGHT, &_normal_bg);

        gtk_button_set_relief (GTK_BUTTON (_lookup_table_down_button), GTK_RELIEF_NONE);
        gtk_widget_modify_bg (_lookup_table_down_button, GTK_STATE_ACTIVE, &_normal_bg);
        gtk_widget_modify_bg (_lookup_table_down_button, GTK_STATE_INSENSITIVE, &_normal_bg);
        gtk_widget_modify_bg (_lookup_table_down_button, GTK_STATE_PRELIGHT, &_normal_bg);

        gtk_window_move (GTK_WINDOW (_lookup_table_window), 200, 200);

        gtk_widget_show_all (_lookup_table_window);
    }

    gtk_main();

    return FALSE;
}
