/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include  <stdio.h>
#include  <string.h>
#include  <strings.h>
#include  <stdlib.h>
#include  <assert.h>
#include  "GeneType.h"
#include  "PyStatic.h"
#include  "PyBig5.h"

extern  CHAR   szLocale[10];
VOID    WarpByte(VOID* pv, JINT n);

CHAR* SHENGMUSTR[26] =
{
   /* Total 26*/
    "a",  "b",  "c",  "ch", "d",  
    "e",  "f",  "g",  "h",  "j",  
    "k",  "l",  "m",  "n",  "o",  
    "p",  "q",  "r",  "s",  "sh", 
    "t",  "w",  "x",  "y",  "z",  
    "zh"
};


/************************
    a    e    m    n    o
    0   80  191  211  237
    1   81  192  212  238
************************/
JINT INDEXSMTOYINJIE[27] = 
{
/*  "a",  "b",  "c",  "ch",  "d", */
      0,    5,   21,    38,   57,
      
/*  "e",  "f",  "g",   "h",  "j", */
     80,   84,   94,   113,  132,

/*  "k",  "l",  "m",   "n",  "o", */
    146,  165,  191,   211,  237,

/*  "p",  "q",  "r",   "s",  "sh", */
    239,  256, 	270,   285,  301,

/*  "t",  "w",  "x",   "y",  "z", */
    320,  340, 	349,   363,  378,

/*  "zh" */
    395,  415
};


/*
**  i ==> ch,   u ==> sh,   v ==> zh
*/
JINT INDEXMAGIC[26] = 
{ 
  /* a   b   c   d   e   f   g   h   i   j   k   l   m */
     0,  1,  2,  4,  5,  6,  7,  8,  3,  9, 10, 11, 12,
     
  /* n   o   p   q   r   s   t   u   v   w   x   y   z */
    13, 14, 15, 16, 17, 18, 20, 19, 25, 21, 22, 23, 24
};

/*************   ZiRanMa ShuangPin Keyboard Layout    ************
      NOTES:  No "er" in this ZRM KeyLayout, ASSUME it's R
                 ch [i]     sh [u]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   iao  uang e    en   eng  ang  i    an   ao   ai   ian
                 iang               
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  in   o    un   iu   uan  iong ue   u    v    ua   ie   uai  ei
       uo             er   ong            ui   ia        ing
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

************** Shuang Pin Keyboard Layout In CStar2.97************
                   ch [u]     sh [i]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ia   uan  ao   e    an   ang  iang i    ian  iao  in   ie
       ua                            uang
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  iu   o    ou   er   en   ai   eng  u    v    ei   uai  iong un
       uo        ing                      ui        ue   ong
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

**********  Intelligent ABC ShuangPin Keyboard Layout   **********
            ch [E] sh [V] zh[A] 0 or ' [Zero ShengMu]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   in   ua   e    en   eng  ang  i    an   ao   ai   ue
            uai  ia                                           ui
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  un   o    uan  ei   iu   ong  uang u    v    ian  ie   ing  iao
       uo             er   iong iang                
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

*****************************************************************/

CHAR* YUNMUSTR[37] =
{
  /*  0  */
    "",
  /********* Standard YunMu(33) **********/
  /*  1       2       3       4       5      6       7       8       9      0a   */
    "a",    "ai",   "an",   "ang",  "ao",   "e",    "ei",   "en",   "eng",  "er", 

  /* 0b      0c      0d      0e      0f      10      11      12      13      14  */
    "i",    "ia",   "ian",  "iang", "iao",  "ie",   "in",   "ing",  "iong", "iu",

  /* 15      16      17      18      19      1a      1b      1c      1d      1e  */
    "o",    "ong",  "ou",   "u",    "v",    "ua",   "uai",  "uan",  "uang", "ue",

  /* 1f      20      21  */
    "ui",   "un",   "uo",

  /******** Additional ShengMu(3) **********/
  /* 22      23      24  */
    "ch",   "sh",   "zh"
};

JINT KEYLAYMODE[3][27] = {
    /* ShuangPin Keyboard Layout of ZiRanMa 6.2 */
    /*  A         B         C         D         E  */
    0x000001, 0x000017, 0x00000F, 0x001D0E, 0x000006,
    /*  F         G         H         I         J  */
    0x000008, 0x000009, 0x000004, 0x22000B, 0x000003,
    /*  K         L         M         N         O  */
    0x000005, 0x000002, 0x00000D, 0x000011, 0x002115,
    /*  P         Q         R         S         T  */
    0x000020, 0x000014, 0x000A1C, 0x001316, 0x00001E,
    /*  U         V         W         X         Y  */
    0x230018, 0x241F19, 0x001A0C, 0x000010, 0x001B12,
    /*  Z  */
    0x000007, 0x000000,

    /* ShuangPin Keyboard Layout of Chinese Star2.97 */
    /*  A         B         C         D         E  */
    0x000001, 0x001A0C, 0x00001C, 0x000005, 0x000006,
    /*  F         G         H         I         J  */
    0x000003, 0x000004, 0x001D0E, 0x23000B, 0x00000D,
    /*  K         L         M         N         O  */
    0x00000F, 0x000011, 0x000010, 0x000014, 0x002115,
    /*  P         Q         R         S         T  */
    0x000017, 0x00120A, 0x000008, 0x000002, 0x000009,
    /*  U         V         W         X         Y  */
    0x220018, 0x241F19, 0x000007, 0x001E1B, 0x001613,
    /*  Z  */
    0x000020, 0x000000,

    /* ShuangPin Keyboard Layout of Intelligent ABC */
    /*  A         B         C         D         E  */
    0x000001, 0x000017, 0x00111B, 0x001A0C, 0x000006,
    /*  F         G         H         I         J  */
    0x000008, 0x000009, 0x000004, 0x23000B, 0x000003,
    /*  K         L         M         N         O  */
    0x000005, 0x000002, 0x001E1F, 0x000020, 0x002115,
    /*  P         Q         R         S         T  */
    0x00001C, 0x000007, 0x00140A, 0x001613, 0x001D0E,
    /*  U         V         W         X         Y  */
    0x220018, 0x240019, 0x00000D, 0x000010, 0x000012,
    /*  Z  */
    0x00000F, 0x000000
};

CHAR* YINJIESTR[NUM_YINJIE + 1] = 
{
    "a",      "ai",     "an",     "ang",    "ao",      
    "ba",     "bai",    "ban",    "bang",   "bao",     
    "bei",    "ben",    "beng",   "bi",     "bian",    
    "biao",   "bie",    "bin",    "bing",   "bo",      
    "bu",     "ca",     "cai",    "can",    "cang",    
    "cao",    "ce",     "cei",    "cen",    "ceng",    
    "cha",    "chai",   "chan",   "chang",  "chao",    
    "che",    "chen",   "cheng",  "chi",    "chong",   
    "chou",   "chu",    "chua",   "chuai",  "chuan",   
    "chuang", "chui",   "chun",   "chuo",   "ci",      
    "cong",   "cou",    "cu",     "cuan",   "cui",     
    "cun",    "cuo",    "da",     "dai",    "dan",     
    "dang",   "dao",    "de",     "dei",    "den",     
    "deng",   "di",     "dia",    "dian",   "diao",    
    "die",    "ding",   "diu",    "dong",   "dou",     
    "du",     "duan",   "dui",    "dun",    "duo",     
    "e",      "en",     "eng",    "er",     "fa",      
    "fan",    "fang",   "fei",    "fen",    "feng",    
    "fiao",   "fo",     "fou",    "fu",     "ga",      
    "gai",    "gan",    "gang",   "gao",    "ge",      
    "gei",    "gen",    "geng",   "gong",   "gou",     
    "gu",     "gua",    "guai",   "guan",   "guang",   
    "gui",    "gun",    "guo",    "ha",     "hai",     
    "han",    "hang",   "hao",    "he",     "hei",     
    "hen",    "heng",   "hong",   "hou",    "hu",      
    "hua",    "huai",   "huan",   "huang",  "hui",     
    "hun",    "huo",    "ji",     "jia",    "jian",    
    "jiang",  "jiao",   "jie",    "jin",    "jing",    
    "jiong",  "jiu",    "ju",     "juan",   "jue",     
    "jun",    "ka",     "kai",    "kan",    "kang",    
    "kao",    "ke",     "kei",    "ken",    "keng",    
    "kong",   "kou",    "ku",     "kua",    "kuai",    
    "kuan",   "kuang",  "kui",    "kun",    "kuo",     
    "la",     "lai",    "lan",    "lang",   "lao",     
    "le",     "lei",    "leng",   "li",     "lia",     
    "lian",   "liang",  "liao",   "lie",    "lin",     
    "ling",   "liu",    "lo",     "long",   "lou",     
    "lu",     "lv",     "luan",   "lue",    "lun",     
    "luo",    "m",      "ma",     "mai",    "man",     
    "mang",   "mao",    "me",     "mei",    "men",     
    "meng",   "mi",     "mian",   "miao",   "mie",     
    "min",    "ming",   "miu",    "mo",     "mou",     
    "mu",     "n",      "na",     "nai",    "nan",     
    "nang",   "nao",    "ne",     "nei",    "nen",     
    "neng",   "ni",     "nian",   "niang",  "niao",    
    "nie",    "nin",    "ning",   "niu",    "nong",    
    "nou",    "nu",     "nv",     "nuan",   "nue",     
    "nun",    "nuo",    "o",      "ou",     "pa",      
    "pai",    "pan",    "pang",   "pao",    "pei",     
    "pen",    "peng",   "pi",     "pian",   "piao",    
    "pie",    "pin",    "ping",   "po",     "pou",     
    "pu",     "qi",     "qia",    "qian",   "qiang",   
    "qiao",   "qie",    "qin",    "qing",   "qiong",   
    "qiu",    "qu",     "quan",   "que",    "qun",     
    "ran",    "rang",   "rao",    "re",     "ren",     
    "reng",   "ri",     "rong",   "rou",    "ru",      
    "rua",    "ruan",   "rui",    "run",    "ruo",     
    "sa",     "sai",    "san",    "sang",   "sao",     
    "se",     "sen",    "seng",   "sha",    "shai",    
    "shan",   "shang",  "shao",   "she",    "shei",    
    "shen",   "sheng",  "shi",    "shou",   "shu",     
    "shua",   "shuai",  "shuan",  "shuang", "shui",    
    "shun",   "shuo",   "si",     "song",   "sou",     
    "su",     "suan",   "sui",    "sun",    "suo",     
    "ta",     "tai",    "tan",    "tang",   "tao",     
    "te",     "tei",    "teng",   "ti",     "tian",    
    "tiao",   "tie",    "ting",   "tong",   "tou",     
    "tu",     "tuan",   "tui",    "tun",    "tuo",     
    "wa",     "wai",    "wan",    "wang",   "wei",     
    "wen",    "weng",   "wo",     "wu",     "xi",      
    "xia",    "xian",   "xiang",  "xiao",   "xie",     
    "xin",    "xing",   "xiong",  "xiu",    "xu",      
    "xuan",   "xue",    "xun",    "ya",     "yan",     
    "yang",   "yao",    "ye",     "yi",     "yin",     
    "ying",   "yo",     "yong",   "you",    "yu",      
    "yuan",   "yue",    "yun",    "za",     "zai",     
    "zan",    "zang",   "zao",    "ze",     "zei",     
    "zen",    "zeng",   "zha",    "zhai",   "zhan",    
    "zhang",  "zhao",   "zhe",    "zhei",   "zhen",    
    "zheng",  "zhi",    "zhong",  "zhou",   "zhu",     
    "zhua",   "zhuai",  "zhuan",  "zhuang", "zhui",    
    "zhun",   "zhuo",   "zi",     "zong",   "zou",     
    "zu",     "zuan",   "zui",    "zun",    "zuo", ""
};

/*
**  "CH SH ZH"in the following table was adjusted.
*/
CHAR* YINJIESTR_CSZ[NUM_YINJIE + 1] = 
{
    "a",      "ai",     "an",     "ang",    "ao",      
    "ba",     "bai",    "ban",    "bang",   "bao",     
    "bei",    "ben",    "beng",   "bi",     "bian",    
    "biao",   "bie",    "bin",    "bing",   "bo",      
    "bu",     "ca",     "cai",    "can",    "cang",    
    "cao",    "ce",     "cei",    "cen",    "ceng",    
    "ci",     "cong",   "cou",    "cu",     "cuan",    
    "cui",    "cun",    "cuo",    "cha",    "chai",    
    "chan",   "chang",  "chao",   "che",    "chen",    
    "cheng",  "chi",    "chong",  "chou",   "chu",     
    "chua",   "chuai",  "chuan",  "chuang", "chui",    
    "chun",   "chuo",   "da",     "dai",    "dan",     
    "dang",   "dao",    "de",     "dei",    "den",     
    "deng",   "di",     "dia",    "dian",   "diao",    
    "die",    "ding",   "diu",    "dong",   "dou",     
    "du",     "duan",   "dui",    "dun",    "duo",     
    "e",      "en",     "eng",    "er",     "fa",      
    "fan",    "fang",   "fei",    "fen",    "feng",    
    "fiao",   "fo",     "fou",    "fu",     "ga",      
    "gai",    "gan",    "gang",   "gao",    "ge",      
    "gei",    "gen",    "geng",   "gong",   "gou",     
    "gu",     "gua",    "guai",   "guan",   "guang",   
    "gui",    "gun",    "guo",    "ha",     "hai",     
    "han",    "hang",   "hao",    "he",     "hei",     
    "hen",    "heng",   "hong",   "hou",    "hu",      
    "hua",    "huai",   "huan",   "huang",  "hui",     
    "hun",    "huo",    "ji",     "jia",    "jian",    
    "jiang",  "jiao",   "jie",    "jin",    "jing",    
    "jiong",  "jiu",    "ju",     "juan",   "jue",     
    "jun",    "ka",     "kai",    "kan",    "kang",    
    "kao",    "ke",     "kei",    "ken",    "keng",    
    "kong",   "kou",    "ku",     "kua",    "kuai",    
    "kuan",   "kuang",  "kui",    "kun",    "kuo",     
    "la",     "lai",    "lan",    "lang",   "lao",     
    "le",     "lei",    "leng",   "li",     "lia",     
    "lian",   "liang",  "liao",   "lie",    "lin",     
    "ling",   "liu",    "lo",     "long",   "lou",     
    "lu",     "lv",     "luan",   "lue",    "lun",     
    "luo",    "m",      "ma",     "mai",    "man",     
    "mang",   "mao",    "me",     "mei",    "men",     
    "meng",   "mi",     "mian",   "miao",   "mie",     
    "min",    "ming",   "miu",    "mo",     "mou",     
    "mu",     "n",      "na",     "nai",    "nan",     
    "nang",   "nao",    "ne",     "nei",    "nen",     
    "neng",   "ni",     "nian",   "niang",  "niao",    
    "nie",    "nin",    "ning",   "niu",    "nong",    
    "nou",    "nu",     "nv",     "nuan",   "nue",     
    "nun",    "nuo",    "o",      "ou",     "pa",      
    "pai",    "pan",    "pang",   "pao",    "pei",     
    "pen",    "peng",   "pi",     "pian",   "piao",    
    "pie",    "pin",    "ping",   "po",     "pou",     
    "pu",     "qi",     "qia",    "qian",   "qiang",   
    "qiao",   "qie",    "qin",    "qing",   "qiong",   
    "qiu",    "qu",     "quan",   "que",    "qun",     
    "ran",    "rang",   "rao",    "re",     "ren",     
    "reng",   "ri",     "rong",   "rou",    "ru",      
    "rua",    "ruan",   "rui",    "run",    "ruo",     
    "sa",     "sai",    "san",    "sang",   "sao",     
    "se",     "sen",    "seng",   "si",     "song",    
    "sou",    "su",     "suan",   "sui",    "sun",     
    "suo",    "sha",    "shai",   "shan",   "shang",   
    "shao",   "she",    "shei",   "shen",   "sheng",   
    "shi",    "shou",   "shu",    "shua",   "shuai",   
    "shuan",  "shuang", "shui",   "shun",   "shuo",    
    "ta",     "tai",    "tan",    "tang",   "tao",     
    "te",     "tei",    "teng",   "ti",     "tian",    
    "tiao",   "tie",    "ting",   "tong",   "tou",     
    "tu",     "tuan",   "tui",    "tun",    "tuo",     
    "wa",     "wai",    "wan",    "wang",   "wei",     
    "wen",    "weng",   "wo",     "wu",     "xi",      
    "xia",    "xian",   "xiang",  "xiao",   "xie",     
    "xin",    "xing",   "xiong",  "xiu",    "xu",      
    "xuan",   "xue",    "xun",    "ya",     "yan",     
    "yang",   "yao",    "ye",     "yi",     "yin",     
    "ying",   "yo",     "yong",   "you",    "yu",      
    "yuan",   "yue",    "yun",    "za",     "zai",     
    "zan",    "zang",   "zao",    "ze",     "zei",     
    "zen",    "zeng",   "zi",     "zong",   "zou",     
    "zu",     "zuan",   "zui",    "zun",    "zuo",     
    "zha",    "zhai",   "zhan",   "zhang",  "zhao",    
    "zhe",    "zhei",   "zhen",   "zheng",  "zhi",     
    "zhong",  "zhou",   "zhu",    "zhua",   "zhuai",   
    "zhuan",  "zhuang", "zhui",   "zhun",   "zhuo", "" 
};

/*
UCHAR HIFREQHANZI[26][14] = {
    "ڦwRתD",
    "äⳡг",
    "qĤ~s",
    "XtB",
    "aojh",
    "ӤGc",
    "oD϶O",
    "ӤuLUӰ",
    "Mٷ|Xθ",
    "δNNڥ[",
    "i}ŤfJ",
    "FzqOQ",
    "CSW̪",
    "~AAk",
    "ڰ³x",
    "~ưt}L",
    "_BϥeD",
    "HpJM{",
    "ҤT|ⴵHq",
    "OϤWQͮ",
    "LoѦPSx",
    "ڵL~",
    "VǷstʫH",
    "@nHP",
    "b`lۦA̧@",
    "o̵ۤإD"
};
*/

/* HUr: e᧡ipr, bɧ@PIŸ */
UCHAR NONLINKHZ[2 * NUM_NONLINKHZ + 2] = 
    "OF]ӧAڥLPoNM";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/* HUr: uiPep, iPp. */
UCHAR PRELINKHZ[2 * NUM_PRELINKHZ + 2] = 
    "̩ʭlWU~ƪ̮a~ɤ";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/* HUr: uiPp, iPep. */
UCHAR SUFLINKHZ[2 * NUM_SUFLINKHZ + 2] = 
    "boq쨺ĦUCY`ѦpHQϧBNi|Ӧܳ";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/*
** bUdCiku.dat, r]ANONLINKHZMUDSINGLEHZⶵ, 
** UDSINGLEHZqPRELINKHZMSUFLINKHZ`X!!DnOƵ, sM
*/

/****************   ZiRanMa ShuangPin Keyboard Layout    ***************
                NOTES:  No "er" in this Keyboard Layout

                 ch [i]     sh [u]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   iao  uang e    en   eng  ang  i    an   ao   ai   ian
                 iang           ng    
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  in   o    un   iu   uan  iong ue   u    v    ua   ie   uai  ei
       uo                  ong            ui   ia        ing
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

:;     ===> G F
'"     ===> 
,.     ===> A C
[{     ===>   m   PageUp 
]}     ===>   n   PageDown
"'     ===>          ²X
/      ===> B
\      ===> θqƦr

DzY~ acӰlPnֲyc zr   S  嶳 oo
***********************************************************************/
 
JINT    GbkHz2244ToYj(JINT nHzcode);
JINT    GbkHz2244ToYjSM(JINT nHzcode);
JINT    GetDyzInfo(JINT nHzcode, JINT* pnDyzYjCode);
JINT    EncodeDyzTo2244(JINT nHzcode, JINT nYjcode);
JINT    FastMatchYinJieStr(CHAR* szPystr);
UCHAR*  RecovDyz2244(UCHAR *szDyz2244);
JWORD   RecovDyzWord2244(JWORD wDyz2244);
JWORD*  RecovDyzNWord2244(JWORD* pwDyz2244, JINT nMaxLen);

CHAR    LastChar (JINT nYinjieCode);
CHAR    FirstChar(JINT nYinjieCode);
JINT    ValidButLastChar (JINT nYinjieCode);
JINT    ValidButFirstChar(JINT nYinjieCode);
JINT    ValidAddChar(CHAR ch, JINT nYinjieCode);

VOID    UnifOrgSpStr(CHAR* pszOrgSp, CHAR* pszUnifSp);
JINT    Sp2QpStr(CHAR* pszOrgSp, CHAR* pszUnifSp, CHAR* pszQp, JINT nKeyLayMode);

JINT    Sp2QpStr_Better(CHAR* pszOrgSp, CHAR* pszQp, JINT nKeyLayMode, JINT nSpCaretPos, JINT* pnQpCaretPos);
JINT    IsValidSpSuite(CHAR chSM, CHAR chYM, JINT nKeyLayMode);

JINT    TypeOfSpChar(CHAR *pszOrgSp, JINT nPos, JINT nKeyLayMode);
JINT    IsLower(CHAR ch);
JINT    IsUpper(CHAR ch);
CHAR    Lower(CHAR ch);
CHAR    Upper(CHAR ch);


/*
**  nHzcode range: [0xB0A1 ~ 0xF7FE] || [0x2001 ~ 0x2000 + TOTAL_DYZYINJIE]
**  [0x2001 ~ 0x2000 + TOTAL_DYZYINJIE] contains 580 DuoYinZi.
**  Lookup table BIG5HZCODETOYJ[] and DYZCODETOYJ[] to return
**  a integer Yinjie code 0~414.
*/
JINT GbkHz2244ToYj(JINT nHzcode)
{
	JINT    hi, low;
	JINT    res;
	JINT    t1, t2, t3, t4;

	hi = (nHzcode >> 8) & 0x00FF;
	low = nHzcode & 0x00FF;
	t1 = t2 = t3 = t4 = 0;
	res = 0xFFFF;

	if ((hi >= 0xA4) && (hi <= 0xC6) && (low >= 0x40) && (low <= 0xFE))
	{
	    	if(low >= 0xA1) low -= 0x22;
		t1 = (hi - 0xA4) * 157 + (low - 0x40) + 1;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;
			
		if (t2 > t3)
			res = (int)( (BIG5HZCODETOYJ[t2] >> (32 - t4)) & 0x01FF ) + 
			      (int)( (BIG5HZCODETOYJ[t3] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (int)( BIG5HZCODETOYJ[t2] >> (32 - t4) ) & 0x01FF;
	}

	else if ((hi >= 0xC9) && (hi <= 0xF9) && (low >= 0x40) && (low <= 0xFE))
	{
	    	if(low >= 0xA1) low -= 0x22;
	        t1 = (hi - 0xC9) * 157 + 5408 + (low - 0x40) + 1;
                t2 = (t1 * 9 - 1) / 32;
                t3 = ((t1 - 1) * 9 - 1) / 32;
                t4 = (t1 * 9) % 32;

                if (t2 > t3)
                        res = (int)( (BIG5HZCODETOYJ[t2] >> (32 - t4)) & 0x01FF ) +
                              (int)( (BIG5HZCODETOYJ[t3] << t4) & 0x01FF );
                else if (t2 == t3)
                        res = (int)( BIG5HZCODETOYJ[t2] >> (32 - t4) ) & 0x01FF;
        }
	else if ((nHzcode >= 0x2001) && (nHzcode <= 0x2000 + TOTAL_DYZYINJIE))
	{
		t1 = nHzcode - 0x2001;
		res = (JINT) DYZYJCODE[t1];
/*
		t1 = nHzcode - 0x2000;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;
			
		if (t2 > t3)
			res = (int)( (DYZCODETOYJ[t2] >> (32 - t4)) & 0x01FF ) + 
			      (int)( (DYZCODETOYJ[t3] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (int)( DYZCODETOYJ[t2] >> (32 - t4) ) & 0x01FF;
*/
	}
	else res = 0xFFFF;
	return (res);
}

/*
**  nHzcode range: [0xB0A1 ~ 0xF7FE] || [0x2001 ~ 0x2000 + TOTAL_DYZYINJIE]
**  [0x2001 ~ 0x2000 + TOTAL_DYZYINJIE] contains 580 DuoYinZi.
**
**  Return ShengMu YinjieCode(450~475) of this Hanzi. If unNormal, return 0xFFFF
*/
JINT GbkHz2244ToYjSM(JINT nHzcode)
{
	JINT    nTmpRes;
	JINT    nRet;
	
	nTmpRes = GbkHz2244ToYj(nHzcode);

	if (nTmpRes != 0xFFFF)
	{
		if ((nTmpRes >= 38) && (nTmpRes < 57 ))        /* "ch" */
			nRet =  3 + 450;
		else if ((nTmpRes >= 301) && (nTmpRes < 320))  /* "sh" */
			nRet = 19 + 450;
		else if ((nTmpRes >= 395) && (nTmpRes < 415))  /* "zh" */
			nRet = 25 + 450;
		else
			nRet = INDEXMAGIC[(JINT)(YINJIESTR_CSZ[nTmpRes][0] - 'a')] + 450;
			
		return nRet;
	}

	return 0xFFFF;
}


/*
**  Lookup the DYZLIST[428] to see if this nHzcode is a DuoYinZi.
**  index of DYZLIST by High Byte is placed in INDEXOFDYZLIST
**  return: JINT           number of DuoYin, for example: 1, 2, 3  else, 0
**          pnDyzYjCode    yinjiecode include yinjie code
**
*/
JINT GetDyzInfo(JINT nHzcode, JINT* pnDyzYjCode)
{
	JINT    nHiHzPos, nLowHz;
	JINT    i, j;
	
	nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xA4;
	nLowHz   = nHzcode & 0x00FF;
	
	j = 0;
/*
	if ((nHiHzPos < 0) || (nHiHzPos > (0xF7 - 0xB0)))
		return j;
*/

	for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++)
	{
		if( (DYZLIST[i] & 0x00FF) == nLowHz )
		{
			pnDyzYjCode[j] = DYZYJCODE[i];
			j++;
		}
	}
	return j;
}


/*
**  nHzcode is Normal Hanzi Code defined in GB or GBK.
**  If nHzcode indicates a DYZ, return 0x2001 ~ (TOTAL_DYZYINJIE - 1 + 0x2001) [0x2001 + 0x2000 + TOTAL_DYZYINJIE]
**  Else, return 0xFFFF.
*/
JINT EncodeDyzTo2244(JINT nHzcode, JINT nYjcode)
{
	JINT    nHiHzPos, nLowHz;
	JINT    i;
	
	nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xA4;
	if (nHiHzPos < 0) return 0xFFFF;

/*
	if ((nHiHzPos < 0) || (nHiHzPos > (0xF7 - 0xB0)))
		return 0xFFFF;
*/

	nLowHz = nHzcode & 0x00FF;
	
	for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++)
	{
		if ( ((DYZLIST[i] & 0x00FF) == nLowHz) && (DYZYJCODE[i] == nYjcode) )
			return (i + 0x2001);
	}
	
	return 0xFFFF;
}


/*
**  Lookup the equal string of szPystr in YINJIESTR_CSZ[415].
**  if successfully, return 0~414; otherwise, return -1
*/
JINT FastMatchYinJieStr(CHAR* szPystr)
{
	JINT    i, j, nLen;
	CHAR    chFirst;
	JINT    nFromYJStr, nToYJStr, nShengmuIndex;	
	
	i = 0;
	nLen = (JINT)strlen(szPystr);
	
	j = 0;
	if (nLen > 0)
	{
		chFirst    = szPystr[0];
		nFromYJStr = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] ];
		nToYJStr   = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] + 1];
		nShengmuIndex = INDEXMAGIC[(JINT)(chFirst - 'a')];
		
		if ((chFirst == 'c') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[3];
			nToYJStr   = INDEXSMTOYINJIE[4];
			nShengmuIndex = 3;
		}
		else if ((chFirst == 's') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[19];
			nToYJStr   = INDEXSMTOYINJIE[20];
			nShengmuIndex = 19;
		}
		else if ((chFirst == 'z') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[25];
			nToYJStr   = INDEXSMTOYINJIE[26];
			nShengmuIndex = 25;
		}

		i = nFromYJStr;
		do {
			j = strcmp (YINJIESTR_CSZ[i], szPystr);
			i++;
		} while ((i < nToYJStr) && (j != 0));
	}
	
	if (j == 0)
		return (i - 1);
	else
		return (-1);
}


/*
**  nYinjieCode Valid from 0 to 414. Return the last
**  character of this YinJie String.
*/
CHAR LastChar(JINT nYinjieCode)
{
	CHAR   res = ' ';		/* SPACE */
	JINT   i = 0;
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		while (YINJIESTR_CSZ[nYinjieCode][i] != '\0')
			i++;
		res = YINJIESTR_CSZ[nYinjieCode][i-1];
	}
	return res;
}


/*
**  nYinjieCode Valid from 0 to 414
*/
CHAR FirstChar(JINT nYinjieCode)
{
	CHAR   res = ' ';		/* SPACE */
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
		res = YINJIESTR_CSZ[nYinjieCode][0];
	return res;
}


/*
**  Valid but the end CHARacter?
**  return 0~414 if valid, else return 0xFFFF
*/
JINT ValidButLastChar(JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i+1])
		{
			szStr[i] = YINJIESTR_CSZ[nYinjieCode][i];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	return 0xFFFF;
}


/*
** Valid add a new CHARacter before it?
** return 0~414 if valid, else return 0xFFFF
*/
JINT ValidAddChar(CHAR ch, JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';

	szStr[0] = ch;
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i])
		{
			szStr[i + 1] = YINJIESTR_CSZ[nYinjieCode][i];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	
	return 0xFFFF;
}


/*
**  Valid but first CHARacter ?
**  return 0~414 if valid, else return 0xFFFF
*/
JINT ValidButFirstChar(JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i+1])
		{
			szStr[i] = YINJIESTR_CSZ[nYinjieCode][i+1];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	
	return 0xFFFF;
}


/*
**  Recover these Hanzi String which encode by GBK&Dyz2244 to normal GBK.
**  Length of returned string is determined by the length of szDyz2244
**
**  This function must be rewritten to process failure of malloc()!!!
*/
UCHAR* RecovDyz2244(UCHAR *szDyz2244)
{
	JINT    i, j, nLen, nHlfLen;
	JINT    nDyzCode, nNormCode;
	static  UCHAR*  szNorm = NULL; 
   
	nLen = strlen((CHAR*)szDyz2244);
	nHlfLen = nLen / 2;

	if(szNorm != NULL)
		free(szNorm);

	szNorm = (UCHAR*)malloc(nLen + MALIGN);
	if (szNorm == NULL)
	{
		fprintf(stderr, "Failed to alloc Memory in function RecovDyz2244()\n");
		return (szNorm);
	}
	memset(szNorm, '\0', (nLen + MALIGN));
	
	j = 0;
	for (i = 0; i < nHlfLen; i++)
	{
		if (nArch == TRUE)
			WarpByte( (VOID*)((JINT*)(szDyz2244 + 2*i)), 2);

		nDyzCode = szDyz2244[(2 * i) + 1] + ((JINT)szDyz2244[2 * i] << 8);

		if ((nDyzCode >= 0x2001) && (nDyzCode <= 0x2000 + TOTAL_DYZYINJIE))
		{
			nNormCode         = DYZLIST[nDyzCode - 0x2001];
			if (nArch == TRUE)
			{
				szNorm[2 * i + 1]     = (UCHAR)((nNormCode & 0xFF00) >> 8);
				szNorm[2 * i] = (UCHAR)(nNormCode & 0x00FF);
			}
			else {
				szNorm[2 * i]     = (UCHAR)((nNormCode & 0xFF00) >> 8);
				szNorm[2 * i + 1] = (UCHAR)(nNormCode & 0x00FF);
			}
		}
		else
		{
			if (nArch == TRUE)
				WarpByte( (VOID*)((JINT*)(szDyz2244 + 2*i)), 2);
			szNorm[2 * i]      = szDyz2244[2 * i];
			szNorm[2 * i + 1]  = szDyz2244[2 * i + 1];
		}
	}
	
	return (szNorm);
}


/*
**  Convert a DyzJword to a GBK Code.
*/
JWORD RecovDyzWord2244(JWORD wDyz2244)
{
	JWORD    wRet;
	
	wRet = wDyz2244;

	if ((wDyz2244 >= 0x2001) && (wDyz2244 <= 0x2000 + TOTAL_DYZYINJIE))
		wRet  = (JWORD)DYZLIST[wDyz2244 - 0x2001];
	
	return wRet;
}


/*
**  Convert a DyzJword String to a GBK-encoded String.
*/
JWORD* RecovDyzNWord2244(JWORD* pwDyz2244, JINT nMaxLen)
{
	static JWORD*  pwRet = NULL;
	JINT    i;

	free (pwRet);
	pwRet = (JWORD*)malloc((nMaxLen + MALIGN) * sizeof(JWORD));
	if (pwRet == NULL)
	{
		fprintf(stderr, "Failed in malloc() of RecovDyzNWord2244().\n");
		return pwRet;
	}
	memset(pwRet, '\0', sizeof(JWORD) * (nMaxLen + MALIGN));

	for (i = 0; (i < nMaxLen) && (pwDyz2244[i] != 0x0000); i++)
	{
		if ((pwDyz2244[i] >= 0x2001) && (pwDyz2244[i] <= 0x2000 + TOTAL_DYZYINJIE))
			pwRet[i]  = (JWORD)DYZLIST[pwDyz2244[i] - 0x2001];
		else
			pwRet[i]  = pwDyz2244[i];
	}

	return pwRet;
}


/*
**  EXAMPLE: (KEYLAYMODE_ZRM)
**  zhong hua ren min gong he guo   ru guo mei you tian shang de yu shui a hai tang hua er
**  vs hw rf mn gs he go            ru go mz yb tm uh de yu uv aa hl th hw er
**  v'h'r'm'g'h'g'                  r'g'm'y't'u'd'y'u'a'h't'h'e
**
**  Uniformed: Means contain only [a~z] and ['], [A~Z] was converted to be [a'~z']
**
**************   ZiRanMa ShuangPin Keyboard Layout    ************
      NOTES:  No "er" in this ZRM KeyLayout, ASSUME it's R
                 ch [i]     sh [u]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   iao  uang e    en   eng  ang  i    an   ao   ai   ian
                 iang               
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  in   o    un   iu   uan  iong ue   u    v    ua   ie   uai  ei
       uo             er   ong            ui   ia        ing
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
**
*/
JINT Sp2QpStr(CHAR* pszOrgSp, CHAR* pszUnifSp, CHAR* pszQp, JINT nKeyLayMode)
{
	JINT    nLen, i, j, k, m, nRes;
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nfStartSM, nfStartYM;
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;

#ifdef _DEBUG
	if ((nKeyLayMode < 0) || (nKeyLayMode >= 3))
	{
		fprintf (stderr, "Error nKeyLayMode [%d] in Sp2QpStr().\n", nKeyLayMode);
		return FALSE;
	}
#endif

	UnifOrgSpStr(pszOrgSp, pszUnifSp);

	memset (szYjTmp1, '\0', 10);
	memset (szYjTmp2, '\0', 10);
	nfStartSM = TRUE;
	nfStartYM = FALSE;
	i = j = 0;
	nLen = strlen(pszUnifSp);

	for (i = 0; i < nLen; )
	{
		if (pszUnifSp[i] == '\'')
		{
			pszQp[j++] = '\'';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
		}
		else if (nfStartSM == TRUE)
		{
			/* To "ch" "sh" "zh" */
			if ((pszUnifSp[i] == 'i') || (pszUnifSp[i] == 'u') || (pszUnifSp[i] == 'v'))
			{
				nKeyLaySM   = KEYLAYMODE[nKeyLayMode][pszUnifSp[i] - 'a'] >> 16;
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
				pszQp[j++]  = szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
				szYjTmp1[2] = szYjTmp2[2] = '\0';
				m = 2;    /* length of ShengMu */
			}
			else
			{
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = pszUnifSp[i];
				szYjTmp1[1] = szYjTmp2[1] = '\0';
				m = 1;    /* length of ShengMu */
			}
			i++;
			nfStartSM  = FALSE;
			nfStartYM  = TRUE;
		}
		else if (nfStartYM == TRUE)
		{
			nKeyLayYM1 = KEYLAYMODE[nKeyLayMode][pszUnifSp[i] - 'a'] & 0x0000FF;
			nKeyLayYM2 = (KEYLAYMODE[nKeyLayMode][pszUnifSp[i] - 'a'] & 0x00FF00) >> 8;

			/* ShengMu just before it is [aeo] */
			if ((pszUnifSp[i - 1] == 'a') || (pszUnifSp[i - 1] == 'e') || (pszUnifSp[i - 1] == 'o'))
				szYjTmp1[0]  = szYjTmp2[0] = '\0';

			strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
			nRes = FastMatchYinJieStr(szYjTmp1);
			if ((nRes >= 0) && (nRes < NUM_YINJIE))
			{
				for (k = m; szYjTmp1[k] != '\0'; k++)
					pszQp[j++] = szYjTmp1[k];
				i++;
			}

			if ((nRes == -1) && (nKeyLayYM2 != 0))
			{
				strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
				nRes = FastMatchYinJieStr(szYjTmp2);
				if ((nRes >= 0) && (nRes < NUM_YINJIE))
				{
					for (k = m; szYjTmp2[k] != '\0'; k++)
						pszQp[j++] = szYjTmp2[k];
					i++;
				}
			}

			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			memset (szYjTmp1, '\0', 10);
			memset (szYjTmp2, '\0', 10);
		}
	}

	pszQp[j] = '\0';
	return TRUE;
}


/*
**  Convert pszOrgSp to pszUnifSp.
*/
VOID UnifOrgSpStr(CHAR* pszOrgSp, CHAR* pszUnifSp)
{
	JINT    nLen, i, j;

	nLen = strlen(pszOrgSp);

	i = j = 0;
	for (i = 0; i < nLen; i++)
	{
		if ((pszOrgSp[i] >= 'A') && (pszOrgSp[i] <= 'Z'))
		{
			pszUnifSp[j++] = pszOrgSp[i] + 'a' - 'A';
			pszUnifSp[j++] = '\'';
		}
		else if (pszOrgSp[i] == '\'')
		{
			if ((j > 0) && (pszUnifSp[j - 1] != '\''))
				pszUnifSp[j++] = '\'';
		}
		else if ((pszOrgSp[i] >= 'a') && (pszOrgSp[i] <= 'z'))
			pszUnifSp[j++] = pszOrgSp[i];
		else
		{
#ifdef _DEBUG
			fprintf (stderr, "Error in UnifOrgSpStr(): Unexpected char: [%d]%c\n", i, pszOrgSp[i]);
#endif
		}
	}

	pszUnifSp[j] = '\0';
}


/*
**  Additional [aoe] process added!!    Scott Ma  98-03-07
**
**  [#] and [$]-support is added!
**  THERE are TWO conditions: I.   There is [$] in ShuangPin String already.
**                            II.  Add automatically [#] to QuanPin String.
**  For Example, OrgSp is [ruguo], should be converted to [ru#gu#o] instead of [ruguo]
**                            III. There is not connected ['][#][$].
**
**  Requirement of pszOrgSp:  contains only [a] ~ [z], ['] & [$]  MXL 98-03-13
**
**  Normal nSpCaretPos is between [0, strlen(pszOrgSp)]
**  IF nSpCaretPos = [0 ~ (strlen(pszOrgSp) - 1)],   *pnQpCaretPos = strlen(pszQp);
**  ELSE if nSpCaretPos = strlen(pszOrgSp), After for( ; ; ) reclycle, *pnQpCaretPos = strlen(pszQp);
*/
JINT Sp2QpStr_Better(CHAR* pszOrgSp, CHAR* pszQp, JINT nKeyLayMode, JINT nSpCaretPos, JINT* pnQpCaretPos)
{
	JINT    nLen, i, j, k, m, nRes;
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nfStartSM, nfStartYM;
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;
	
#ifdef _DEBUG
	if ((nKeyLayMode < 0) || (nKeyLayMode >= 3))
	{
		fprintf (stderr, "Error nKeyLayMode [%d] in Sp2QpStr().\n", nKeyLayMode);
		return FALSE;
	}
#endif

	memset (szYjTmp1, '\0', 10);
	memset (szYjTmp2, '\0', 10);
	nfStartSM = TRUE;
	nfStartYM = FALSE;
	i = j = 0;
	nLen = strlen(pszOrgSp);

	for (i = 0; i < nLen; )
	{
		/* Cacluates Caret Position */
		if ( nSpCaretPos == i)
			*pnQpCaretPos = strlen (pszQp);
		
		if (pszOrgSp[i] == '\'')
		{
			if (!((j > 0) && (pszQp[j - 1] == '\'')))
				pszQp[j++] = '\'';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '$')
		{
			if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '$'))
				pszQp[j++] = '$';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '#')
		{
			if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '$') && (pszQp[j - 1] != '#'))
				pszQp[j++] = '#';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
			
			continue;
		}

		/* For a UpperCase [A], it was treated as ShengMu and was replaced with [#a#] */
		if (nfStartSM == TRUE)
		{
			if (IsUpper(pszOrgSp[i]))
			{
				if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '$') && (pszQp[j - 1] != '#'))
					pszQp[j++] = '#';
			}
			
			/* To "ch" "sh" "zh" */
			if ((Lower(pszOrgSp[i]) == 'i') || (Lower(pszOrgSp[i]) == 'u') || (Lower(pszOrgSp[i]) == 'v'))
			{
				nKeyLaySM   = KEYLAYMODE[nKeyLayMode][Lower(pszOrgSp[i]) - 'a'] >> 16;
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
				pszQp[j++]  = szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
				szYjTmp1[2] = szYjTmp2[2] = '\0';
				m = 2;    /* length of ShengMu */
			}
			else
			{
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = Lower(pszOrgSp[i]);
				szYjTmp1[1] = szYjTmp2[1] = '\0';
				m = 1;    /* length of ShengMu */
			}
			
			if (IsUpper(pszOrgSp[i]))
			{
				pszQp[j++] = '#';          /* Add a [#] ??? MXL ????? Necessary!! Indeed!!! */
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
			}
			else
			{
				nfStartSM  = FALSE;
				nfStartYM  = TRUE;
			}
			i++;

		}
		else if (nfStartYM == TRUE)
		{
			/* If it is in Upper Case, treat it as ShengMu */
			if (IsUpper(pszOrgSp[i]))
			{
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
				continue;
			}
			
			nKeyLayYM1 = KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x0000FF;
			nKeyLayYM2 = (KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x00FF00) >> 8;

			/* ShengMu just before it is [aeo] */
			if ((pszOrgSp[i - 1] == 'a') || (pszOrgSp[i - 1] == 'e') || (pszOrgSp[i - 1] == 'o'))
				szYjTmp1[0]  = szYjTmp2[0] = '\0';
				
			/* To Process 'aa' 'ee' 'oo' ......????? */

			strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
			nRes = FastMatchYinJieStr(szYjTmp1);
			if ((nRes >= 0) && (nRes < NUM_YINJIE))
			{
				for (k = m; szYjTmp1[k] != '\0'; k++)
					pszQp[j++] = szYjTmp1[k];
				i++;
			}

			if ((nRes == -1) && (nKeyLayYM2 != 0))
			{
				strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
				nRes = FastMatchYinJieStr(szYjTmp2);
				if ((nRes >= 0) && (nRes < NUM_YINJIE))
				{
					for (k = m; szYjTmp2[k] != '\0'; k++)
						pszQp[j++] = szYjTmp2[k];
					i++;
				}
			}
			
			if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '#'))
				pszQp[j++] = '#';

			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			memset (szYjTmp1, '\0', 10);
			memset (szYjTmp2, '\0', 10);
		}
	}
	
	if ((j > 0) && (pszQp[j - 1] == 0x23))           /* [#] */
		pszQp[j - 1] = '\0';
	
	if (nLen == nSpCaretPos)
		*pnQpCaretPos = strlen (pszQp);

	pszQp[j] = '\0';
	
	return TRUE;
}


/*
**  To avoid any affection of LC_CTYPE, rewrite the following functions myself.
*/
CHAR Upper(CHAR ch)
{
	if ((ch >= 'a') && (ch <= 'z'))
		return (CHAR)(ch + 'A' - 'a');
		
	return (ch);
}

CHAR Lower(CHAR ch)
{
	if ((ch >= 'A') && (ch <= 'Z'))
		return (CHAR)(ch + 'a' - 'A');
		
	return (ch);
}

JINT IsUpper(CHAR ch)
{
	if ((ch >= 'A') && (ch <= 'Z'))
		return TRUE;
		
	return FALSE;
}

JINT IsLower(CHAR ch)
{
	if ((ch >= 'a') && (ch <= 'z'))
		return TRUE;
		
	return FALSE;
}

/*
**  Get the type of a specified character in a given ShuangPin String.
**  nPos specifies the position of a char, which is between [0 ~ strlen(pszOrgSp)).
**
**  #define SPYJ_SHENGMU     1
**  #define SPYJ_YUNMU       2
**  #define SPYJ_QUOTE       3
**  #define SPYJ_NUMSIGN     4
**  #define SPYJ_DOLLAR      5
**  #define SPYJ_INVALID     8
*/
JINT TypeOfSpChar(CHAR *pszOrgSp, JINT nPos, JINT nKeyLayMode)
{
	JINT    nLen, i, j, k, m, nRes;
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nfStartSM, nfStartYM;
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;
	
	memset (szYjTmp1, '\0', 10);
	memset (szYjTmp2, '\0', 10);
	nfStartSM = TRUE;
	nfStartYM = FALSE;
	i = j = 0;
	
	nLen = strlen(pszOrgSp);

	if ((nPos < 0) || (nPos >= nLen))
		return SPYJ_INVALID;
		
	/* Valid nPos is  [0 ~ (nLen - 1)] */
	for (i = 0; i <= nPos; )
	{
		if (pszOrgSp[i] == '\'')
		{
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;

			if (nPos == i)
				return SPYJ_QUOTE;
			else
				i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '#')
		{
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;

			if (nPos == i)
				return SPYJ_NUMSIGN;
			else
				i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '$')
		{
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;

			if (nPos == i)
				return SPYJ_DOLLAR;
			else
				i++;
			
			continue;
		}

		/* For a UpperCase [A], it was treated as ShengMu and was replaced with ['a'] */
		if (nfStartSM == TRUE)
		{
			/* To "ch" "sh" "zh" */
			if ((Lower(pszOrgSp[i]) == 'i') || (Lower(pszOrgSp[i]) == 'u') || (Lower(pszOrgSp[i]) == 'v'))
			{
				nKeyLaySM   = KEYLAYMODE[nKeyLayMode][Lower(pszOrgSp[i]) - 'a'] >> 16;
				szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
				szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
				szYjTmp1[2] = szYjTmp2[2] = '\0';
				m = 2;    /* length of ShengMu */
			}
			else
			{
				szYjTmp1[0] = szYjTmp2[0] = Lower(pszOrgSp[i]);
				szYjTmp1[1] = szYjTmp2[1] = '\0';
				m = 1;    /* length of ShengMu */
			}
			
			if (IsUpper(pszOrgSp[i]))
			{
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
			}
			else
			{
				nfStartSM  = FALSE;
				nfStartYM  = TRUE;
			}

			if (nPos == i)
				return SPYJ_SHENGMU;
			
			i++;

		}
		else if (nfStartYM == TRUE)
		{
			/* If it is in Upper Case, treat it as ShengMu */
			if (IsUpper(pszOrgSp[i]))
			{
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
				continue;
			}
			
			nKeyLayYM1 = KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x0000FF;
			nKeyLayYM2 = (KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x00FF00) >> 8;

			/* ShengMu just before it is [aeo] */
			if ((pszOrgSp[i - 1] == 'a') || (pszOrgSp[i - 1] == 'e') || (pszOrgSp[i - 1] == 'o'))
				szYjTmp1[0]  = szYjTmp2[0] = '\0';

			strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
			nRes = FastMatchYinJieStr(szYjTmp1);
			if ((nRes >= 0) && (nRes < NUM_YINJIE))
			{
				if (nPos == i)
					return SPYJ_YUNMU;
				i++;
			}

			if ((nRes == -1) && (nKeyLayYM2 != 0))
			{
				strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
				nRes = FastMatchYinJieStr(szYjTmp2);
				if ((nRes >= 0) && (nRes < NUM_YINJIE))
				{
					if (nPos == i)
						return SPYJ_YUNMU;
					i++;
				}
			}

			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			memset (szYjTmp1, '\0', 10);
			memset (szYjTmp2, '\0', 10);
		}
	}
	
	return SPYJ_INVALID;
}


/*
**  Return TRUE or FALSE to indicates whether this chSM and chYM
**  is a valid composition under given nKeyLayMode.
*/

/*  Following Yinjie has no Chinese in GB2312 Area. - Scott Ma 98-05-13
    [   cei]   0      27
    [  chua]   0      50
    [   den]   0      64
    [   eng]   0      82
    [  fiao]   0      90
    [   kei]   0     152
    [   nun]   0     235
    [   rua]   0     285
************************************/
JINT IsValidSpSuite(CHAR chSM, CHAR chYM, JINT nKeyLayMode)
{
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;
	JINT    i, m, nRes;
	JINT    nNullYj[8] = {27, 50, 64, 82, 90, 152, 235, 285};

	assert(((chSM >= 'a') && (chSM <= 'z')) || ((chSM >= 'A') && (chSM <= 'Z')));
	assert(((chYM >= 'a') && (chYM <= 'z')) || ((chYM >= 'A') && (chYM <= 'Z')));

	if ((Lower(chSM) == 'i') || (Lower(chSM) == 'u') || (Lower(chSM) == 'v'))
	{
		nKeyLaySM   = KEYLAYMODE[nKeyLayMode][Lower(chSM) - 'a'] >> 16;
		szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
		szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
		szYjTmp1[2] = szYjTmp2[2] = '\0';
		m = 2;    /* length of ShengMu */
	}
	else
	{
		szYjTmp1[0] = szYjTmp2[0] = Lower(chSM);
		szYjTmp1[1] = szYjTmp2[1] = '\0';
		m = 1;    /* length of ShengMu */
	}

	nKeyLayYM1  =  KEYLAYMODE[nKeyLayMode][Lower(chYM) - 'a'] & 0x0000FF;
	nKeyLayYM2  = (KEYLAYMODE[nKeyLayMode][Lower(chYM) - 'a'] & 0x00FF00) >> 8;

	/* ShengMu just before it is [aeo] */
	if ((chSM == 'a') || (chSM == 'e') || (chSM == 'o'))
		szYjTmp1[0]  = szYjTmp2[0] = '\0';

	strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
	nRes = FastMatchYinJieStr(szYjTmp1);

	/* Process for Null Yinjie in "zh" locale. Scott Ma 98-05-13 */
#ifndef _DRAW_IM_WIN_H
	if ( (strstr(szLocale, "GBK") == NULL) && 
	     (strstr(szLocale, "UTF-8") == NULL)
	   )
	{
		for (i = 0; i < 8; i++)
		{
			if (nRes == nNullYj[i])
			{
				nRes = -1;
				break;
			}
		}
	}
#endif

	if ((nRes >= 0) && (nRes < NUM_YINJIE))
		return TRUE;

	if ((nRes == -1) && (nKeyLayYM2 != 0))
	{
		strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
		nRes = FastMatchYinJieStr(szYjTmp2);

		/* Process for Null Yinjie in "zh" locale. Scott Ma 98-05-13 */
#ifndef _DRAW_IM_WIN_H
		if ( (strstr(szLocale, "GBK") == NULL) &&
		     (strstr(szLocale, "UTF-8") == NULL)
	  	   )
		{
			for (i = 0; i < 8; i++)
			{
				if (nRes == nNullYj[i])
				{
					nRes = -1;
					break;
				}
			}
		}
#endif

		if ((nRes >= 0) && (nRes < NUM_YINJIE))
			return TRUE;
	}
	
	return FALSE;
}

