/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


/* TabBook widget private definitions */

#ifndef _XcgTabBookP_h
#define _XcgTabBookP_h

#include "TabBook.h"
#include <X11/ConstrainP.h>

#ifdef MOTIF
#include <Xm/XmP.h>
# if XmVersion >= 1002	/* If motif version >= 1.2 */
#   include <Xm/ManagerP.h>
# endif
#include <Xm/BulletinBP.h>
#include <Xm/PrimitiveP.h>   
#endif

#define XtInheritLayout ((Boolean (*)())_XtInherit)

typedef struct {
  int dummy;
} TabBookClassPart;


typedef struct _TabBookClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
#ifdef MOTIF
    XmManagerClassPart  manager_class;
    XmBulletinBoardClassPart    bulletin_class;
#endif
    TabBookClassPart tabBook_class;
} TabBookClassRec;

extern TabBookClassRec tabBookClassRec;

typedef struct _TabBookPart 
{
	int y_margin ;	/* reserved margin around each pushbutton ... */
	int x_margin ;	/* Used to draw Tab around it */
	int x_spacing;	/* x space between each button */
	int x_angle;	/* space on the right to draw andled line */
	int border;	/* border around entire TabBook */
	Dimension button_bot;	/* largest button goes this far */
	Dimension cur_width;
	Dimension cur_height;
	Boolean layout_completed;	/* layout was done at least once */
	Boolean managed_before;		/* manged was done at least once */
	Boolean auto_manage;	/* manager children are automatically mapped when appropriate */
	Widget active_tab;	/* the current page's tab Button */
	Widget active_manager;	/* the current page's manager widget */
	int active_page;	/* 1,2,.. */
	int total_buttons;
	int total_managers;
	int old_active_page;	/* 1,2,.. 0 means none, i.e. init */
	GC drawBackground_GC ;	/* the drawing area background */
	Pixel drawBackground_color;	/* ... and its color */
	GC drawForeground_GC ;	/* the drawing area foreground */
	Pixel drawForeground_color;	/* ... and its color */
	GC bot_shadow_GC;	/* for drawing lines, bottom shadow */
	Pixel bot_shadow_color;	/* ... and its color  */
	GC top_shadow_GC;	/* for drawing lines, top shadow */
	Pixel top_shadow_color;	/* ... and its color  */
	XtCallbackList newPageCallback;
	Widget clip;		/* clip the manager children */
} TabBookPart;

typedef struct _TabBookRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
#ifdef MOTIF
    XmManagerPart  manager;
    XmBulletinBoardPart	bulletin_board;
#endif
    TabBookPart	tabBook;
} TabBookRec;


typedef struct _TabBookConstraintPart 
{
	int resize_child;	/* constraint resources */
	int anchor_child;
} TabBookConstraintPart;


typedef struct _TabBookConstraintRec {
    TabBookConstraintPart	tabBook;
} TabBookConstraintRec, *TabBookConstraints;


#endif /* _XcgTabBookP_h */
