/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _compoundstring_hh
#define _compoundstring_hh

#define native /**/

#ifdef WIN32
#include <stdlib.h>
#endif

class CompoundString {
 public:
  CompoundString();
  ~CompoundString();
  CompoundString(const CompoundString& a);
  CompoundString(const int);
  CompoundString(const int, int);
  operator char*() const {return pBuffer;}
  int operator!=(const CompoundString&) const;
  int compare(const CompoundString&, int) const;
  int compare(const CompoundString&) const;
  int search(CompoundString&) const;	// return -1 if no matched pattern

  unsigned char* toUchar() const {return (unsigned char*)pBuffer;}

  native CompoundString(const char[]);
  native CompoundString(const wchar_t[]);
  native CompoundString& operator=(const CompoundString& a);
  native CompoundString& operator=(const char * s);
  native CompoundString& operator=(const unsigned char * s);
  native CompoundString  operator+(const CompoundString&) const;
  native CompoundString& operator+=(const CompoundString&);
  native CompoundString& operator-=(const CompoundString&);
  native int operator==(const CompoundString&) const;
  native int compare(const char[], int) const;
  native int compare(const char[]) const;
  native int search(const char[]) const; // return -1 if no matched pattern
  native unsigned int length() const;
 private:
  char *pBuffer;
};

#endif
