/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package com.sun.iiim.sample.lwe;

import java.util.Hashtable;
import java.util.Locale;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.text.AttributedString;
import java.text.AttributedCharacterIterator;
import com.sun.iiim.*;

class LWE1 extends LWE {

    private Hashtable firstTable;

    private static final String ISO8859_1 =
	"x!\u00a1" +
	"/c\u00a2" +
	"l-\u00a3" +
	"ox\u00a4" +
	"y=\u00a5" +
	"|-\u00a6" +
	"ss\u00a7" +
	"co\u00a9" +
	"ro\u00ae" +
	"x?\u00bf" +
	"34\u00be";

    private String[] sampleCandidate = {
	"\u00a1",
	"\u00a2",
	"\u00a3",
	"\u00a4",
	"\u00a5",
	"\u00a6",
	"\u00a7",
	"\u00a8",
	"\u00a9",
	"\u00aa",
	"\u00ab",
	"\u00ac",
	"\u00ad",
	"\u00ae",
	"\u00af",
    };
    
    public LWE1() {

	firstTable = new Hashtable();
	
	for (int i = 0; i < ISO8859_1.length(); i += 3) {
	    Character c1 = new Character(ISO8859_1.charAt(i));
	    Hashtable secondTable;
	    if (firstTable.containsKey(c1)) {
		secondTable = (Hashtable)firstTable.get(c1);
	    } else {
		secondTable = new Hashtable();
		firstTable.put(c1, secondTable);
	    }
	    Character c2 = new Character(ISO8859_1.charAt(i + 1));
	    Character c3 = new Character(ISO8859_1.charAt(i + 2));
	    secondTable.put(c2, c3);
	}
    }

    public void dispatchEvent(IIIMEvent e) {

	AWTEvent aev = e.getAWTEvent();
	if (aev == null)
	    return;

	if (aev instanceof KeyEvent) {
	    processKeyEvent(e);
	}
    }

    public String getName() {
	return "Sample LWE1";
    }

    private boolean beingProcess = false;
    private Character first, second, result;
    private boolean haveFirst = false;

    private void processKeyEvent(IIIMEvent e) {

	KeyEvent kev = (KeyEvent)e.getAWTEvent();
	int id = kev.getID();

	if (!beingProcess && id == KeyEvent.KEY_PRESSED &&
	    kev.getKeyCode() == KeyEvent.VK_COMPOSE) {
	    e.consume();
	    beingProcess = true;
	    // fire IIIMStatuEvent
	    AttributedString aString = new AttributedString("COMPOSE");
	    AttributedCharacterIterator iterator = aString.getIterator();
	    dispatchStatusEvent(new IIIMStatusEvent(IIIMStatusEvent.DRAW, iterator));
	    return;
	}

	//
	// Normal mode
	//
	if (!beingProcess) {
	    return;
	}

	//
	// Being process 
	//
	e.consume();

	//
	// only KEY_TYPED event will produce something
	// during processing
	//
	if (id == KeyEvent.KEY_RELEASED || id == KeyEvent.KEY_PRESSED) {
	    return;
	}

	if (haveFirst) {
	    Hashtable secondTable = (Hashtable)firstTable.get(first);

	    beingProcess = false;
	    haveFirst = false;

	    if (secondTable == null) {
		// reset compose
		return;
	    }
	    
	    second = new Character(kev.getKeyChar());
	    result = (Character)secondTable.get(second);

	    if (result == null) {
		// do nothing
		return;
	    }

	    // fire IIIMCommittedString
	    dispatchCommittedEvent
		(new IIIMCommittedEvent(String.valueOf(result.charValue())));
	    return;
	}

	first = new Character(kev.getKeyChar());
	haveFirst = true;
    }

    public Locale[] getSupportLocales() {
	return new Locale[] {Locale.JAPAN};
    }
}

class LWE2 extends LWE {

    private Hashtable firstTable1, firstTable2;

    private static final String HIRAGANA1 =
	"a\u3042" +
	"i\u3044" +
	"u\u3046" +
	"e\u3048" +
	"o\u304a";

    private static final String HIRAGANA2 =
	"ka\u304b" + "ki\u304d" + "ku\u304f" + "ke\u3051" + "ko\u3053" +
	"sa\u3055" + "si\u3057" + "su\u3059" + "se\u305b" + "so\u305d" +
	"ta\u305f" + "ti\u3061" + "tu\u3064" + "te\u3066" + "to\u3068" +
	"na\u306a" + "ni\u306b" + "nu\u306c" + "ne\u306d" + "no\u306e" +
	"ma\u307e" + "mi\u307f" + "mu\u3080" + "me\u3081" + "mo\u3082" +
	"ha\u306f" + "hi\u3072" + "fu\u3075" + "he\u3078" + "ho\u307b" +
	"ya\u3084" + "yu\u3086" + "yo\u3088" + "wa\u308f";

    public LWE2() {

	firstTable1 = new Hashtable();
	firstTable2 = new Hashtable();

	for (int i = 0; i < HIRAGANA1.length(); i += 2) {
	    Character c1 = new Character(HIRAGANA1.charAt(i));
	    Character c2 = new Character(HIRAGANA1.charAt(i + 1));
	    firstTable1.put(c1, c2);
	}

	for (int i = 0; i < HIRAGANA2.length(); i += 3) {
	    Character c1 = new Character(HIRAGANA2.charAt(i));
	    Hashtable secondTable;
	    if (firstTable2.containsKey(c1)) {
		secondTable = (Hashtable)firstTable2.get(c1);
	    } else {
		secondTable = new Hashtable();
		firstTable2.put(c1, secondTable);
	    }
	    Character c2 = new Character(HIRAGANA2.charAt(i + 1));
	    Character c3 = new Character(HIRAGANA2.charAt(i + 2));
	    secondTable.put(c2, c3);
	}
    }

    public void dispatchEvent(IIIMEvent e) {

	AWTEvent aev = e.getAWTEvent();
	if (aev == null)
	    return;

	if (aev instanceof KeyEvent) {
	    processKeyEvent(e);
	}
    }

    public String getName() {
	return "Sanple LWE2";
    }

    private boolean beingProcess = false;
    private Character first, second, result;
    private boolean haveFirst = false;

    private boolean triggerConsume = false;

    private void processKeyEvent(IIIMEvent e) {

	KeyEvent kev = (KeyEvent)e.getAWTEvent();
	int id = kev.getID();

	if (!beingProcess && id == KeyEvent.KEY_PRESSED &&
	    kev.getKeyCode() == KeyEvent.VK_SPACE &&
	    kev.isControlDown()) {
	    e.consume();
	    triggerConsume = true;
	    beingProcess = true;
	    // fire IIIMStatusEvent
	    return;
	}

	if (triggerConsume && id == KeyEvent.KEY_TYPED) {
	    triggerConsume = false;
	    e.consume();
	    return;
	}

	//
	// Conversion off
	//
	if (!beingProcess) {
	    return;
	}
	
	//
	// Being process
	//
	e.consume();

	//
	// Check Conversion off
	//
	if (id == KeyEvent.KEY_PRESSED &&
	    kev.getKeyCode() == KeyEvent.VK_SPACE &&
	    kev.isControlDown()) {
	    beingProcess = false;
	    e.consume();
	    triggerConsume = true;
	    // fire IIIMStatusEvent / IIIMPreeditEvetn / IIIMCommittedEvent
	    return;
	}
	
	//
	// only KEY_TYPED event will produce something
	// during processing.
	//
	if (id == KeyEvent.KEY_RELEASED || id == KeyEvent.KEY_PRESSED) {
	    return;
	}

	if (haveFirst) {
	    Hashtable secondTable = (Hashtable)firstTable2.get(first);

	    haveFirst = false;

	    if (secondTable == null) {
		// reset preedit
		return;
	    }

	    second = new Character(kev.getKeyChar());
	    result = (Character)secondTable.get(second);

	    if (result == null) {
		// reset preedit
		return;
	    }

	    // fire IIIMPreeditString
	    dispatchCommittedEvent(new IIIMCommittedEvent(String.valueOf
							  (result.charValue())));
	    return;
	}
	
	//
	// check firstTabel1
	//
	first = new Character(kev.getKeyChar());
	result = (Character)firstTable1.get(first);

	if (result != null) {
	    // fire IIIPreeditEvent
	    dispatchCommittedEvent(new IIIMCommittedEvent(String.valueOf
							  (result.charValue())));
	    return;
	}

	haveFirst = true;
    }

    public Locale[] getSupportLocales() {
	return new Locale[] {Locale.JAPAN};
    }
}
