/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- SimpleSvgImage.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of itnautilus --no_desktop
s
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "SimpleSvgImage.h"

SimpleSvgImage::SimpleSvgImage(AbstractContainer * c, AbstractIcon * iParent,
                             AbstractConfig * con, AbstractIconConfig * iConfig)
                                : XIdeskImage(c, iParent, con, iConfig)
{
    XDesktopContainer * xContainer =
        dynamic_cast<XDesktopContainer *>(container);
}

SimpleSvgImage::~SimpleSvgImage()
{
}

void SimpleSvgImage::configure()
{
    XIdeskImage::configure();

    DesktopIconConfig * dIcon = dynamic_cast<DesktopIconConfig *>(iconConfig);
    width = dIcon->getWidth();
    height = dIcon->getHeight();
}

void SimpleSvgImage::createPicture()
{
    string filename = iconConfig->getPictureFilename();
    
    if( !loadSvg( filename ) == true )
        cout << "Can't load SVG file: " << filename << " bailing\n";
}

bool SimpleSvgImage::loadSvg(const string & filename)
{
    GError * gErr;
    //vectorPixbuf = rsvg_pixbuf_from_file_at_zoom_with_max((char *)filename.c_str(),0,0, width,height,&gErr);
    
    vectorPixbuf = rsvg_pixbuf_from_file_at_size((char *)filename.c_str(),
                                                 width, height, &gErr);

    
    if (!vectorPixbuf)
    {   
        cout << "librsvg error: "<< gErr->message << endl;
        return false;
    }

    hasAlpha = gdk_pixbuf_get_has_alpha(vectorPixbuf);
    /*
    rgb = (unsigned char *)malloc( width * height * 3 );
    alpha = (unsigned char *)malloc( width * height );
    alpha2 = (unsigned char *)malloc( width * height );
    */
    rgb = new unsigned char[width * height * 3];
    alpha = new unsigned char[width * height];
    alpha2 = new unsigned char[width * height];

    unsigned char r, g, b, a;
    unsigned char * pixbufRgb = gdk_pixbuf_get_pixels(vectorPixbuf);
    unsigned char * rgbPtr = rgb;
    unsigned char * aPtr = alpha;
    unsigned char * aPtr2 = alpha2;
    
    for(int y = 0; y < height; y++)
    {
        for (int x = 0; x < width; x++)
        {
            r = *pixbufRgb++;
            g = *pixbufRgb++;
            b = *pixbufRgb++;
            a = *pixbufRgb++;

            *rgbPtr++ = r;
            *rgbPtr++ = g;
            *rgbPtr++ = b;
            
            // Transparency matrix.
            if( ( a - transparency ) < 0 )
            {
                *aPtr++ = 0;
                *aPtr2++ = a;
            }
            else 
            {
                *aPtr++ = a - transparency;
                *aPtr2++ = a;
            }
        }

    }

}


/******************************************************************************\
 *              SimpleSvgImageShadow -- class implementation                  *
\******************************************************************************/

#include "XIconWithShadow.h"
SimpleSvgImageShadow::SimpleSvgImageShadow(AbstractContainer * c,
                                           AbstractIcon * iParent,
                                           AbstractConfig * con,
                                           AbstractIconConfig * iConfig)
                                            : XIdeskImage(c, iParent, con,
                                                          iConfig),
                                              SimpleSvgImage(c, iParent, con,
                                                             iConfig),
                                              XShadowImage(c, iParent, con,
                                                           iConfig)
{
}

void SimpleSvgImageShadow::configure()
{
    SimpleSvgImage::configure();
    XShadowImage::configure();
}

void SimpleSvgImageShadow::refreshIcon()
{
    XShadowImage::refreshIcon();
    //SimpleSvgImage::refreshIcon(); calls repaint but resets new x and y values
    repaint();
}
