#ifndef ICECAST_TIMER_H
#define ICECAST_TIMER_H

void *startup_timer_thread(void *arg);
void *startup_heartbeat_thread(void *arg);
void *startup_udp_info_thread (void *arg);
void *startup_relay_connector_thread(void *arg);
void status_write(server_info_t *info);
void get_hourly_stats(statistics_t *stat);
void write_hourly_stats(statistics_t *stat);
void update_daily_statistics(statistics_t *stat);
void get_daily_stats(statistics_t *stat);
void update_total_statistics(statistics_t *stat);
void write_daily_stats(statistics_t *stat);
void zero_stats(statistics_t *stat);
void get_current_stats(statistics_t *stat);
void get_current_stats_proc (statistics_t *stat, int lock);
void get_running_stats(statistics_t *stat);
void get_running_stats_proc (statistics_t *stat, int lock);
void get_running_stats_nl (statistics_t *stat);
void add_stats(statistics_t *target, statistics_t *source, unsigned long int factor);
void *startup_relay_connector_thread(void *arg);
int udp_update_metainfo (SOCKET s, connection_t *sourcecon, connection_t *clicon);
void timer_update_stats_files (time_t stime);
void timer_handle_directory_servers (time_t stime);
void timer_handle_status_lines (time_t stime);
void timer_handle_transfer_statistics (time_t stime, time_t *trottime, time_t *justone, statistics_t *trotstat);
void timer_kick_abandoned_relays (time_t stime);
#endif

