/*
 * FILE : swig_wrap.c
 *
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 *
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 *
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : TCL 8.0 */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
#define SWIGTCL8
/*
 * $Header: /b2/dmb/SWIG/SWIG1.0b3/swig_lib/tcl/RCS/swigtcl.cfg,v 1.1 1996/05/22 19:47:45 beazley Exp $
 *
 * swigtcl.cfg
 *
 * This file is modified from a platform independent file provided
 * by Sun.   With any luck this will allow SWIG generated wrapper
 * files to work on Unix, Windows, and Macintosh.
 *
 * Revision History
 * $Log: swigtcl.cfg,v $
 * Revision 1.1  1996/05/22 19:47:45  beazley
 * Initial revision
 *
 *
 * -- Dave Beazley, May 2, 1996.
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
    return TRUE;
}
#endif

/**************************************************************************
 * $Header:$
 *
 * tcl8ptr.swg
 *
 * This file provides type-checked pointer support to Tcl 8.0.
 * Pointers are installed as new kinds of Tcl 8.0 objects consisting
 * of the following structure
 *
 * typedef struct {
 *         char     *name;            Name of the datatype
 *         void     *value;           Value of the pointer
 * } Tcl_SwigPtr;
 *
 * While we still need to perform string comparisons on the
 * type-name, this function no longer needs to convert pointer
 * values to hex so it should be a little faster.
 *
 * New Tcl datatypes are defined by the following data structure.
 *
 * typedef struct Tcl_ObjType {
 *              char *name;
 *              Tcl_FreeInternalRepProc *freeIntRepProc;
 *              Tcl_DupInternalRepProc *dupIntRepProc;
 *              Tcl_UpdateStringProc *updateStringProc;
 *              Tcl_SetFromAnyProc *setFromAnyProc;
 *             } Tcl_ObjType;
 *
 * Functions for manipulating SWIG pointers in wrapper code are:
 *
 *     void *SWIG_SetPointerObj(objPtr, ptr, type)
 *     char *SWIG_GetPointerFromObj(objPtr, *ptr, type)
 *
 **********************************************************************/

#ifdef SWIG_GLOBAL
#include <tcl.h>
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Array containing start locations (for searching) */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}


/*---------------------------------------------------------------------
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *))
 *
 * Register a new type-mapping with the type-checking system.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(origtype);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(newtype);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}


/*---------------------------------------------------------------------
 * void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *ptr, char *type)
 *
 * Sets a Tcl object to a pointer value.
 *           ptr = void pointer value
 *           type = string representing type
 *
 *---------------------------------------------------------------------*/



/* This is for backwards compatibility */



/*---------------------------------------------------------------------
 * char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *type)
 *
 * Attempts to extract a pointer value from our pointer type.
 * Upon failure, returns a string corresponding to the actual datatype.
 * Upon success, returns NULL and sets the pointer value in ptr.
 *---------------------------------------------------------------------*/



/*---------------------------------------------------------------------
 * void SWIG_RegisterType()
 *
 * Registers our new datatype with an interpreter.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterType( void ) {
  /* Does nothing at the moment */
}
#define SWIG_init    Ibis_Init
#define SWIG_name    "ibis"
#define SWIG_prefix  ""
#define SWIG_namespace ""

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int,Ibis_Init)(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif

#undef panic

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include <opensm/osm_log.h>
#include <complib/cl_qmap.h>
#include <complib/cl_map.h>
#include <complib/cl_debug.h>
#include "ibis.h"
#include "ibcr.h"
#include "ibpm.h"
#include "ibvs.h"
#include "ibbbm.h"
#include "ibsac.h"
#include "ibsm.h"
#include "ibcc.h"

END_C_DECLS

#ifndef PRIx64
#if __WORDSIZE == 64
#define __PRI64_PREFIX	"l"
#else
#define __PRI64_PREFIX	"L"
#endif

#define PRId64		__PRI64_PREFIX"d"
#define PRIo64		__PRI64_PREFIX"o"
#define PRIu64		__PRI64_PREFIX"u"
#define PRIx64		__PRI64_PREFIX"x"
#endif

/**********************************************************************
 **********************************************************************/
boolean_t
ibisp_is_debug(void)
{
#if defined( _DEBUG_ )
  return TRUE;
#else
  return FALSE;
#endif /* defined( _DEBUG_ ) */
}


#define new_uint64_t uint64_t

#define uint8_array_t uint8_t

#define uint16_array_t uint16_t

#define uint32_array_t uint32_t

#define uint64_array_t uint64_t

#define ib_net16_array_t ib_net16_t

#define ib_net32_array_t ib_net32_t

#define ib_net64_array_t ib_net64_t


  static char ibis_tcl_error_msg[1024];
  static int  ibis_tcl_error;

  void ibis_set_tcl_error(char *err) {
    if (strlen(err) < 1024)
      strcpy(ibis_tcl_error_msg, err);
    else
      strncpy(ibis_tcl_error_msg, err, 1024);
    ibis_tcl_error = 1;
  }


#include <complib/cl_qmap.h>
#include <complib/cl_passivelock.h>
#include <complib/cl_debug.h>
#include <iba/ib_types.h>
#include <opensm/osm_madw.h>
#include <opensm/osm_log.h>
#include <opensm/osm_mad_pool.h>
#include <opensm/osm_msgdef.h>
#include "ibcr.h"


static ibcr_t *p_ibcr_global;

/*
   this function returns the string corresponding to the
   read cpu data
*/
char *
ibcr_get_cr_str(
  boolean_t is_multi,
  uint8_t num,
  ib_cr_space_t *p_cr_mads
  )
{
  char *p_res_str = 0;
  char buff[512];
  static int i, extra;

  if (p_cr_mads) {
    for (i=0;i<num;i++) {
      if (p_cr_mads[i].mad_header.method != VENDOR_GET_RESP) {
        if (is_multi) {
          sprintf(buff,"TARGET_ERROR : Fail to obtain CR mad response");
        } else {
          sprintf(buff,"ERROR : Fail to obtain CR mad response");
        }
      } else if (ibis_get_mad_status((ib_mad_t*)&p_cr_mads[i]) != 0) {
        if (is_multi) {
          sprintf(buff,"TARGET_ERROR : Got remote error:0x%x",
                  ibis_get_mad_status((ib_mad_t*)&p_cr_mads[i]));
        } else {
          sprintf(buff,"ERROR : Got remote error:0x%x",
                  ibis_get_mad_status((ib_mad_t*)&p_cr_mads[i]));
        }
      } else {
        sprintf(buff, "{vendor_key 0x%016" PRIx64 "} {data 0x%x}",
                cl_ntoh64(p_cr_mads[i].vendor_key),
                cl_ntoh32(p_cr_mads[i].data[0]));
      }

      if (is_multi) extra = 3; else extra = 0;

      if (p_res_str) {
        p_res_str =
          (char *)realloc(p_res_str,strlen(p_res_str)+strlen(buff) + 1+ extra);
      } else {
        p_res_str = (char *)malloc(strlen(buff) + 1+ extra);
        p_res_str[0] = '\0';
      }

      /* need an extra list wrap */
      if (is_multi) {
        strcat(p_res_str,"{");
        strcat(p_res_str, buff);
        strcat(p_res_str,"} ");
      } else {
        strcat(p_res_str, buff);
      }
    }
  }
  return(p_res_str);
}

int
ibcr_destroy_global(void)
{
	ibcr_destroy(p_ibcr_global);
	return (0);
}

int
ibcr_num_of_multi_max(void)
{
	return (IBCR_MULTI_MAX);
}

int
ibcr_read_global(
  uint16_t lid,
  uint32_t address,
  char **pp_new_cr_str)
{
	ib_api_status_t status;
   ib_cr_space_t   cr_space_mads_arr[1];

	status = ibcr_read(p_ibcr_global,lid,address,cr_space_mads_arr);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to read CR space");
   } else {
     *pp_new_cr_str = ibcr_get_cr_str(FALSE, 1, cr_space_mads_arr);
   }

	return(status);
}

int
ibcr_write_global(
  uint16_t lid,
  uint32_t data,
  uint32_t address)
{

	ib_api_status_t status;

	status = ibcr_write(p_ibcr_global,lid,data,address);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to write CR space");
   }
	return(status);
}

int
ibcr_multi_read_global(
  uint8_t num,
  uint16_t lid_list[],
  uint32_t address,
  char **pp_new_cr_str)
{
	ib_api_status_t status;
   ib_cr_space_t   cr_space_mads_arr[IBCR_MULTI_MAX];

	status =
     ibcr_multi_read(p_ibcr_global,num,lid_list,address,cr_space_mads_arr);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to read all targets CR space");
   } else {
     *pp_new_cr_str = ibcr_get_cr_str(TRUE, num, cr_space_mads_arr);
   }
	return(status);
}

int
ibcr_multi_write_global(
  uint8_t num,
  uint16_t lid_list[],
  uint32_t data,
  uint32_t address)
{

	ib_api_status_t status;

	status = ibcr_multi_write(p_ibcr_global,num,lid_list,data,address);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to write all targets CR space");
   }
	return(status);
}


#define uint16_cr_arr_t uint16_t

#include <complib/cl_qmap.h>
#include <complib/cl_passivelock.h>
#include <complib/cl_debug.h>
#include <iba/ib_types.h>
#include <opensm/osm_madw.h>
#include <opensm/osm_log.h>
#include <opensm/osm_mad_pool.h>
#include <opensm/osm_msgdef.h>
#include <inttypes.h>
#include "ibpm.h"


static ibpm_t *p_ibpm_global;

int
ibpm_num_of_multi_max(void)
{
	return (IBPM_MULTI_MAX);
}

/*
   this function returns the string corresponding to the
   port counters.
*/
char *
ibpm_get_port_counters_str(
  uint8_t num,
  ib_pm_port_counter_t *p_counters)
{
  char *p_res_str = 0;
  char buff[1024];
  static int i;

  buff[0] = '\0';
  for (i=0;i<num;i++) {
    /* format the string */
    if (p_counters[i].mad_header.method == VENDOR_GET_RESP) {
      sprintf(buff,"{{port_select %u } {counter_select %u } {symbol_error_counter %u } {link_error_recovery_counter %u } {link_down_counter %u } {port_rcv_errors %u } {port_rcv_remote_physical_errors %u } {port_rcv_switch_relay_errors %u } {port_xmit_discard %u } {port_xmit_constraint_errors %u } {port_rcv_constraint_errors %u } {local_link_integrity_errors %u } {excesive_buffer_errors %u } {vl15_dropped %u } {port_xmit_data %u } {port_rcv_data %u } {port_xmit_pkts %u } {port_rcv_pkts %u }} ",
              p_counters[i].port_select,
              cl_ntoh16(p_counters[i].counter_select),
              cl_ntoh16(p_counters[i].symbol_error_counter),
              p_counters[i].link_error_recovery_counter,
              p_counters[i].link_down_counter,
              cl_ntoh16(p_counters[i].port_rcv_errors),
              cl_ntoh16(p_counters[i].port_rcv_remote_physical_errors),
              cl_ntoh16(p_counters[i].port_rcv_switch_relay_errors),
              cl_ntoh16(p_counters[i].port_xmit_discard),
              p_counters[i].port_xmit_constraint_errors,
              p_counters[i].port_rcv_constraint_errors,
              (p_counters[i].lli_errors_exc_buf_errors & 0xf0) >> 4,
              (p_counters[i].lli_errors_exc_buf_errors & 0x0f),
              cl_ntoh16(p_counters[i].vl15_dropped),
              cl_ntoh32(p_counters[i].port_xmit_data),
              cl_ntoh32(p_counters[i].port_rcv_data),
              cl_ntoh32(p_counters[i].port_xmit_pkts),
              cl_ntoh32(p_counters[i].port_rcv_pkts));
    } else {
      sprintf(buff,"{TARGET_ERROR : Fail to obtain port counters} ");
    }

    if (p_res_str) {
      p_res_str = (char *)realloc(p_res_str,strlen(p_res_str)+strlen(buff) + 1);
    } else {
      p_res_str = (char *)malloc(strlen(buff) + 1);
      p_res_str[0] = '\0';
    }
    strcat(p_res_str, buff);
  }
  return(p_res_str);
}

/*
   this function returns the string corresponding to the
   extended port counters.
*/
char *
ibpm_get_port_counters_extended_str(
  uint8_t num,
  ib_pm_port_counter_extended_t *p_counters)
{
  char *p_res_str = 0;
  char buff[1024];
  static int i;

  buff[0] = '\0';
  for (i=0;i<num;i++) {
    /* format the string */
    if (p_counters[i].mad_header.method == VENDOR_GET_RESP) {
      sprintf(buff,"{{port_select %u} {counter_select %u} {port_xmit_data %"PRIu64"} {port_rcv_data %"PRIu64"} {port_xmit_pkts %"PRIu64"} {port_rcv_pkts %"PRIu64"} {port_ucast_xmit_pkts %"PRIu64"} {port_ucast_rcv_pkts %"PRIu64"} {port_mcast_xmit_pkts %"PRIu64"} {port_mcast_rcv_pkts %"PRIu64"} } ",
              p_counters[i].port_select,
              cl_ntoh16(p_counters[i].counter_select),
              cl_ntoh64(p_counters[i].port_xmit_data),
              cl_ntoh64(p_counters[i].port_rcv_data),
              cl_ntoh64(p_counters[i].port_xmit_pkts),
              cl_ntoh64(p_counters[i].port_rcv_pkts),
              cl_ntoh64(p_counters[i].port_ucast_xmit_pkts),
              cl_ntoh64(p_counters[i].port_ucast_rcv_pkts),
              cl_ntoh64(p_counters[i].port_mcast_xmit_pkts),
              cl_ntoh64(p_counters[i].port_mcast_rcv_pkts)
              );
    } else {
      sprintf(buff,"{TARGET_ERROR : Fail to obtain port counters} ");
    }

    if (p_res_str) {
      p_res_str = (char *)realloc(p_res_str,strlen(p_res_str)+strlen(buff) + 1);
    } else {
      p_res_str = (char *)malloc(strlen(buff) + 1);
      p_res_str[0] = '\0';
    }
    strcat(p_res_str, buff);
  }
  return(p_res_str);
}

int
ibpm_get_counters_global(
  uint16_t lid,
  uint8_t port_select,
  char **pp_new_counters_str)
{
  int status;
  ib_pm_port_counter_t single_counters_set;
  *pp_new_counters_str = NULL;
  status = (int) ibpm_get_counters(p_ibpm_global,lid,port_select,&single_counters_set);
  if (status) {
    ibis_set_tcl_error("ERROR : Fail to obtain port counters");
  } else {
    *pp_new_counters_str = ibpm_get_port_counters_str(1, &single_counters_set);
  }
  return(status);
}

int
ibpm_get_multi_counters_global(
   uint8_t num,
   uint16_t lid_list[],
   uint8_t port_select_list[],
   char **pp_new_counters_str)
{
  int status;
  ib_pm_port_counter_t *p_multi_counters_set;
  p_multi_counters_set = (ib_pm_port_counter_t *)malloc(sizeof(ib_pm_port_counter_t)*num);
  *pp_new_counters_str = NULL;

  status = (int) ibpm_get_multi_counters(
    p_ibpm_global,num,lid_list,port_select_list,p_multi_counters_set);
  if (status) {
    ibis_set_tcl_error("ERROR : Fail to obtain multiple port counters");
  } else {
    *pp_new_counters_str = ibpm_get_port_counters_str(num, p_multi_counters_set);
  }
  free(p_multi_counters_set);
  return(status);
}

int
ibpm_get_multi_counters_extended_global(
   uint8_t num,
   uint16_t lid_list[],
   uint8_t port_select_list[],
   char **pp_new_counters_str)
{
  int status;
  ib_pm_port_counter_extended_t *p_multi_counters_set;
  p_multi_counters_set =
    (ib_pm_port_counter_extended_t *)malloc(sizeof(ib_pm_port_counter_t)*num);
  *pp_new_counters_str = NULL;

  status = (int) ibpm_get_multi_counters_extended(
    p_ibpm_global,num,lid_list,port_select_list,p_multi_counters_set);
  if (status) {
    ibis_set_tcl_error("ERROR : Fail to obtain multiple port counters");
  } else {
    *pp_new_counters_str = ibpm_get_port_counters_extended_str(num, p_multi_counters_set);
  }
  free(p_multi_counters_set);
  return(status);
}

int
ibpm_clr_all_counters_global(
  uint16_t lid,
  uint8_t port_select)
{
  int status;
  status = (int) ibpm_clr_all_counters(p_ibpm_global,lid,port_select);
  if (status) {
    ibis_set_tcl_error("ERROR : Fail to clear port counters");
  }
  return(status);
}

int
ibpm_clr_all_multi_counters_global(
  uint8_t num,
  uint16_t lid_list[],
  uint8_t port_select_list[])
{
  int status;
  status = (int) ibpm_clr_all_multi_counters(p_ibpm_global,num,lid_list,port_select_list);

  if (status) {
    ibis_set_tcl_error("ERROR : Fail to clear multiple port counters");
  }
  return(status);
}


#define  uint16_pm_arr_t  uint16_t

#define  uint8_pm_arr_t  uint8_t

#include <complib/cl_qmap.h>
#include <complib/cl_passivelock.h>
#include <complib/cl_debug.h>
#include <iba/ib_types.h>
#include <opensm/osm_madw.h>
#include <opensm/osm_log.h>
#include <opensm/osm_mad_pool.h>
#include <opensm/osm_msgdef.h>
#include "ibvs.h"


static ibvs_t *p_ibvs_global;

int
ibvs_num_of_multi_max(void)
{
	return (IBVS_MULTI_MAX);
}

/*
   this function returns the string corresponding to the
   read cpu data
*/
char *
ibvs_get_vs_str(
  boolean_t is_multi,
  boolean_t is_read,
  uint8_t num,
  uint8_t size,
  uint8_t first_data_idx,
  ib_vs_t *p_vs_mads
  )
{
  char *p_res_str = 0;
  char buff[1024];
  int i,j, extra;

  if (p_vs_mads) {
    for (i=0;i<num;i++) {
      boolean_t space_in_resp = TRUE;

      if (p_vs_mads[i].mad_header.method != VENDOR_GET_RESP) {
        sprintf(buff,"TARGET_ERROR : Failed to obtain VS mad response");
      } else if (ibis_get_mad_status((ib_mad_t*)&p_vs_mads[i]) != 0) {
        sprintf(buff,"TARGET_ERROR : Got remote error:0x%x",
                ibis_get_mad_status((ib_mad_t*)&p_vs_mads[i]));
      } else if (is_read) {
        sprintf(buff, "{vendor_key 0x%016" PRIx64 "} ",
                cl_ntoh64(p_vs_mads[i].vendor_key));
        for (j=0; j < size; j++) {
          sprintf(buff,"%s {data%u 0x%x} ",
                  buff, j, cl_ntoh32(p_vs_mads[i].data[j+first_data_idx]));
        }
      } else {
	  // Write response - no data
	  // Note: The trailing space here is important !
	  sprintf(buff, "ACK ");
	  space_in_resp = 0;
      }

      if (is_multi && space_in_resp)
	extra = 3;
      else
	extra = 0;

      if (p_res_str) {
        p_res_str =
          (char *)realloc(p_res_str,strlen(p_res_str)+strlen(buff) + 1+ extra);
      } else {
        p_res_str = (char *)malloc(strlen(buff) + 1+ extra);
        p_res_str[0] = '\0';
      }

      /* need an extra list wrap */
      if (is_multi && space_in_resp) {
	  strcat(p_res_str,"{");
	  strcat(p_res_str, buff);
	  strcat(p_res_str,"} ");
      } else {
        strcat(p_res_str, buff);
      }
    }
  }
  return(p_res_str);
}

int
ibvs_cpu_read_global(
  uint16_t lid,
  uint8_t size,
  uint8_t cpu_traget_size,
  uint32_t address,
  char **pp_new_cpu_str)
{
	ib_api_status_t status;
   ib_vs_t         vs_mads[1];

	status =
     ibvs_cpu_read(p_ibvs_global,lid,size,cpu_traget_size,address,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to obtain port counters");
   } else {
     *pp_new_cpu_str =
       ibvs_get_vs_str(FALSE, TRUE, 1, IBVS_DATA_MAX, VS_CPU_DATA_OFFSET, vs_mads);
   }

   return(status);
}

int
ibvs_cpu_write_global(
  uint16_t lid,
  uint8_t size,
  uint8_t cpu_traget_size,
  uint32_t data[],
  uint32_t address)
{

	ib_api_status_t status;

	status =
     ibvs_cpu_write(p_ibvs_global,lid,size,cpu_traget_size,data,address);
   if (status)
     ibis_set_tcl_error("ERROR : Fail to clear port counters");
   return(status);
}

int
ibvs_i2c_read_global(
  uint16_t lid,
  uint8_t port_num,
  uint8_t device_id,
  uint8_t size,
  uint32_t address,
  char **pp_new_i2c_str)
{
	ib_api_status_t status;
   ib_vs_t         vs_mads[1];

	status =
     ibvs_i2c_read(
       p_ibvs_global,lid,port_num,size,device_id,address,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to obtain port counters");
   } else {
     *pp_new_i2c_str =
       ibvs_get_vs_str(FALSE, TRUE, 1, size / 4, VS_I2C_DATA_OFFSET, vs_mads);
   }

	return(status);
}

int
ibvs_multi_i2c_read_global(
  uint8_t num,
  uint16_t lid_list[],
  uint8_t port_num,
  uint8_t device_id,
  uint8_t size,
  uint32_t address,
  char **pp_new_i2c_str)
{
    ib_api_status_t status;
    ib_vs_t         vs_mads[IBVS_MULTI_MAX];

    status =
	ibvs_multi_i2c_read(p_ibvs_global,num,lid_list,port_num,size,device_id,address,vs_mads);
    if (status) {
	ibis_set_tcl_error("ERROR : Failed reading multiple i2c");
    } else {
	*pp_new_i2c_str =
	    ibvs_get_vs_str(TRUE, TRUE, num, size / 4, VS_I2C_DATA_OFFSET, vs_mads);
    }

    return(status);
}

int
ibvs_multi_i2c_write_global(
  uint8_t num,
  uint16_t lid_list[],
  uint8_t port_num,
  uint8_t device_id,
  uint8_t size,
  uint32_t address,
  uint32_t data[],
  char **pp_new_i2c_str)
{

    ib_api_status_t status;
    ib_vs_t         vs_mads[IBVS_MULTI_MAX];

    status =
	ibvs_multi_i2c_write(p_ibvs_global,num,lid_list,port_num,size,device_id,data,address,vs_mads);

    if (status) {
	ibis_set_tcl_error("ERROR : Failed writing multiple i2c");
    } else {
	*pp_new_i2c_str =
	    ibvs_get_vs_str(TRUE, FALSE, num, size / 4, VS_I2C_DATA_OFFSET, vs_mads);
    }

    return(status);
}

int
ibvs_i2c_write_global(
  uint16_t lid,
  uint8_t port_num,
  uint8_t device_id,
  uint8_t size,
  uint32_t address,
  uint32_t data[])
{

    ib_api_status_t status;

    status = ibvs_i2c_write(p_ibvs_global,lid,port_num,size,device_id,data,address);
    if (status)
	ibis_set_tcl_error("ERROR : Fail to write i2c");
    return(status);
}

int
ibvs_gpio_read_global(
  IN uint16_t lid,
  OUT	char **pp_new_gpio_str)
{
	ib_api_status_t status;
   ib_vs_t         vs_mads[1];

	status = ibvs_gpio_read(p_ibvs_global,lid,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to read gpio");
   } else {
     *pp_new_gpio_str =
       ibvs_get_vs_str(TRUE, TRUE, 1, IBVS_DATA_MAX, VS_GPIO_DATA_OFFSET, vs_mads);
   }
	return(status);
}

int
ibvs_gpio_write_global(
  IN uint16_t lid,
  IN uint64_t gpio_mask,
  IN uint64_t gpio_data)
{
	ib_api_status_t status;

	status = ibvs_gpio_write(p_ibvs_global,lid,gpio_mask,gpio_data );
   if (status)
     ibis_set_tcl_error("ERROR : Fail to write gpio");
	return(status);
}

int
ibvs_multi_sw_reset_global(
  uint8_t num,
  uint16_t lid_list[])
{
	ib_api_status_t status;

	status = ibvs_multi_sw_reset(p_ibvs_global,num,lid_list);
   if (status)
     ibis_set_tcl_error("ERROR : Fail to reset");

	return(status);
}

int
ibvs_multi_flash_open_global(
  uint8_t num,
  uint16_t lid_list[],
  uint32_t last,
  uint8_t size,
  uint32_t address,
  uint32_t data[],
  char **pp_new_flash_str)
{
	ib_api_status_t status;
	ib_vs_t vs_mads[IBVS_MULTI_MAX];

	status =
     ibvs_multi_flash_open(
       p_ibvs_global,num,lid_list,last,size,data,address,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to open flash");
   } else {
     *pp_new_flash_str =
       ibvs_get_vs_str(TRUE, TRUE, num, 4, VS_FLASH_DATA_OFFSET, vs_mads);
   }

	return(status);
}

int
ibvs_multi_flash_close_global(
  uint8_t num,
  uint16_t lid_list[],
  uint32_t force,
  char **pp_new_flash_str)
{
	ib_api_status_t status;
 	ib_vs_t vs_mads[IBVS_MULTI_MAX];

	status =
     ibvs_multi_flash_close(
       p_ibvs_global,num,lid_list,force,vs_mads);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to close flash");
   } else {
     *pp_new_flash_str =
       ibvs_get_vs_str(TRUE, TRUE, num, 4, VS_FLASH_DATA_OFFSET, vs_mads);
   }

	return(status);
}

int
ibvs_multi_flash_set_bank_global(
  uint8_t num,
  uint16_t lid_list[],
  uint32_t address,
  char **pp_new_flash_str)
{
	ib_api_status_t status;
 	ib_vs_t vs_mads[IBVS_MULTI_MAX];

	status =
     ibvs_multi_flash_set_bank(
       p_ibvs_global, num, lid_list, address, vs_mads);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to set flash bank");
   } else {
     *pp_new_flash_str =
       ibvs_get_vs_str(TRUE, TRUE, num, 4, VS_FLASH_DATA_OFFSET, vs_mads);
   }

	return(status);
}

int
ibvs_multi_flash_erase_global(
  uint8_t num,
  uint16_t lid_list[],
  uint32_t address,
  char **pp_new_flash_str)
{
	ib_api_status_t status;
 	ib_vs_t vs_mads[IBVS_MULTI_MAX];

	status =
     ibvs_multi_flash_erase(
       p_ibvs_global, num, lid_list, address, vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to erase flash sector");
   } else {
     *pp_new_flash_str =
       ibvs_get_vs_str(TRUE, TRUE, num, 4, VS_FLASH_DATA_OFFSET, vs_mads);
   }

	return(status);
}

int
ibvs_multi_flash_read_global(
  uint8_t num,
  uint16_t lid_list[],
  uint8_t size,
  uint32_t address,
  char **pp_new_flash_str)
{
	ib_api_status_t status;
 	ib_vs_t vs_mads[IBVS_MULTI_MAX];

	status =
     ibvs_multi_flash_read(
       p_ibvs_global, num, lid_list, size, address, vs_mads);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to read flash");
   } else {
     *pp_new_flash_str =
       ibvs_get_vs_str(TRUE, TRUE, num, size / 4, VS_FLASH_DATA_OFFSET, vs_mads);
   }

	return(status);
}

int
ibvs_multi_flash_write_global(
  uint8_t num,
  uint16_t lid_list[],
  uint8_t size,
  uint32_t address,
  uint32_t data[])
{
	ib_api_status_t status;

	status =
     ibvs_multi_flash_write(
       p_ibvs_global, num, lid_list, size, data, address);

   if (status) {
     ibis_set_tcl_error("ERROR : Fail to write flash");
   }
	return(status);
}

int
ibvs_mirror_read_global(
  IN uint16_t lid,
  OUT	char **pp_new_mirror_str)
{
   ib_api_status_t status;
   ib_vs_t         vs_mads[1];

   status = ibvs_mirror_read(p_ibvs_global,lid,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to read mirror");
   } else {
     *pp_new_mirror_str =
       ibvs_get_vs_str(FALSE, TRUE, 1, IBVS_DATA_MAX, VS_MIRROR_DATA_OFFSET, vs_mads);
   }
	return(status);
}

int
ibvs_mirror_write_global(
  IN uint16_t lid,
  IN uint32_t rx_mirror,
  IN uint32_t tx_mirror)
{
   ib_api_status_t status;

   status = ibvs_mirror_write(p_ibvs_global,lid,rx_mirror,tx_mirror );
   if (status)
     ibis_set_tcl_error("ERROR : Fail to write mirror");
	return(status);
}

int
ibvs_plft_map_get_global(
  IN uint16_t lid,
  IN uint8_t upper_ports,
  OUT	char **pp_new_plft_map_str)
{
   ib_api_status_t status;
   ib_vs_t         vs_mads[1];
	char *          buff;
	ib_vs_plft_map_t *p_map = (ib_vs_plft_map_t *)&vs_mads[0];

   status = ibvs_plft_map_get(p_ibvs_global,lid,upper_ports,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to get private LFT map");
		*pp_new_plft_map_str = NULL;
   } else {
		buff = (char *)malloc(1024);
		*pp_new_plft_map_str = buff;
		sprintf(buff,
				  "{ib_port0 0x%x} "
				  "{shared_plft_port0 0x%x} "
				  "{size0 0x%x} "
				  "{ib_port1 0x%x} "
				  "{shared_plft_port1 0x%x} "
				  "{size1 0x%x} "
				  "{ib_port2 0x%x} "
				  "{shared_plft_port2 0x%x} "
				  "{size2 0x%x} "
				  "{ib_port3 0x%x} "
				  "{shared_plft_port3 0x%x} "
				  "{size3 0x%x} "
				  "{ib_port4 0x%x} "
				  "{shared_plft_port4 0x%x} "
				  "{size4 0x%x} "
				  "{ib_port5 0x%x} "
				  "{shared_plft_port5 0x%x} "
				  "{size5 0x%x} "
				  "{ib_port6 0x%x} "
				  "{shared_plft_port6 0x%x} "
				  "{size6 0x%x} "
				  "{ib_port7 0x%x} "
				  "{shared_plft_port7 0x%x} "
				  "{reserved7 0x%x} "
				  "{size7 0x%x} "
				  "{ib_port8 0x%x} "
				  "{shared_plft_port8 0x%x} "
				  "{size8 0x%x} "
				  "{ib_port9 0x%x} "
				  "{shared_plft_port9 0x%x} "
				  "{reserved9 0x%x} "
				  "{size9 0x%x} "
				  "{ib_port10 0x%x} "
				  "{shared_plft_port10 0x%x} "
				  "{size10 0x%x} "
				  "{ib_port11 0x%x} "
				  "{shared_plft_port11 0x%x} "
				  "{size11 0x%x} "
				  "{ib_port12 0x%x} "
				  "{shared_plft_port12 0x%x} "
				  "{size12 0x%x}",
				  p_map->ib_port0,
				  p_map->shared_plft_port0,
				  p_map->size0,
				  p_map->ib_port1,
				  p_map->shared_plft_port1,
				  p_map->size1,
				  p_map->ib_port2,
				  p_map->shared_plft_port2,
				  p_map->size2,
				  p_map->ib_port3,
				  p_map->shared_plft_port3,
				  p_map->size3,
				  p_map->ib_port4,
				  p_map->shared_plft_port4,
				  p_map->size4,
				  p_map->ib_port5,
				  p_map->shared_plft_port5,
				  p_map->size5,
				  p_map->ib_port6,
				  p_map->shared_plft_port6,
				  p_map->size6,
				  p_map->ib_port7,
				  p_map->shared_plft_port7,
				  p_map->reserved7,
				  p_map->size7,
				  p_map->ib_port8,
				  p_map->shared_plft_port8,
				  p_map->size8,
				  p_map->ib_port9,
				  p_map->shared_plft_port9,
				  p_map->reserved9,
				  p_map->size9,
				  p_map->ib_port10,
				  p_map->shared_plft_port10,
				  p_map->size10,
				  p_map->ib_port11,
				  p_map->shared_plft_port11,
				  p_map->size11,
				  p_map->ib_port12,
				  p_map->shared_plft_port12,
				  p_map->size12
				  );
   }
	return(status);
}

int
ibvs_general_info_get_global(
  IN uint16_t lid,
  OUT	char **pp_gen_info_str)
{
   ib_api_status_t status;
   ib_vs_t         vs_mads[1];
	char *          buff;
	char            psid[17];
	ib_vs_gen_info_t *p_info = (ib_vs_gen_info_t *)&vs_mads[0];
   status = ibvs_general_info_get(p_ibvs_global,lid,vs_mads);
   if (status) {
     ibis_set_tcl_error("ERROR : Fail to get general info");
		*pp_gen_info_str = 0;
   } else {
		buff = (char *)malloc(1024);
		*pp_gen_info_str = buff;
		strncpy(psid, (char *)p_info->fw_psid, 16);
		psid[16] = '\0';
		sprintf(buff,
				  "{hw_rev 0x%x} "
				  "{hw_devid 0x%x} "
				  "{hw_uptime 0x%x} "
				  "{fw_major 0x%x} "
				  "{fw_minor 0x%x} "
				  "{fw_sub_minor 0x%x} "
				  "{fw_build_id 0x%x} "
				  "{fw_month 0x%x} "
				  "{fw_day 0x%x} "
				  "{fw_year 0x%x} "
				  "{fw_hour 0x%x} "
				  "{fw_psid \"%s\"} "
				  "{fw_ini_ver 0x%x} "
				  "{sw_major 0x%x} "
				  "{sw_minor 0x%x} "
				  "{sw_sub_minor 0x%x}",
				  cl_ntoh16(p_info->hw_rev),
				  cl_ntoh16(p_info->hw_devid),
				  cl_ntoh32(p_info->hw_uptime),
				  p_info->fw_major,
				  p_info->fw_minor,
				  p_info->fw_sub_minor,
				  cl_ntoh32(p_info->fw_build_id),
				  p_info->fw_month,
				  p_info->fw_day,
				  cl_ntoh16(p_info->fw_year),
				  cl_ntoh16(p_info->fw_hour),
				  psid,
				  cl_ntoh32(p_info->fw_ini_ver),
				  p_info->sw_major,
				  p_info->sw_minor,
				  p_info->sw_sub_minor);
   }
	return(status);
}


#define uint16_vs_arr_t uint16_t

#define uint32_vs_data_arr_t uint32_t

#include <complib/cl_qmap.h>
#include <complib/cl_passivelock.h>
#include <complib/cl_debug.h>
#include <iba/ib_types.h>
#include <opensm/osm_madw.h>
#include <opensm/osm_log.h>
#include <opensm/osm_mad_pool.h>
#include <opensm/osm_msgdef.h>
#include "ibbbm.h"


static ibbbm_t *p_ibbbm_global;

int
ibbbm_read_vpd_global(
  uint16_t lid,
  uint8_t vpd_device_selector,
  uint16_t bytes_num,
  uint16_t offset,
  ib_bbm_vpd_t *p_bbm_vpd_mad)
{
	ib_api_status_t status;

	status = ibbbm_read_vpd(p_ibbbm_global,lid,vpd_device_selector,bytes_num,offset,p_bbm_vpd_mad);
	;
	ibis_set_tcl_error("-E- Failed to read VPD");

	return(status);
}

int
ibbbm_write_vpd_global(
  uint16_t lid,
  uint8_t vpd_device_selector,
  uint16_t bytes_num,
  uint16_t offset,
  uint8_t *p_data)
{

	ib_api_status_t status;

	status = ibbbm_write_vpd(p_ibbbm_global,lid,vpd_device_selector,bytes_num,offset,p_data);
	;
	ibis_set_tcl_error("-E- Failed to write VPD");
	return(status);
}

int
ibbbm_read_vsd_vpd_global(
  uint16_t lid,
  ib_bbm_vsd_vpd_t *p_bbm_vsd_vpd_mad)
{
	ib_api_status_t status;
	ib_bbm_vpd_t *p_bbm_vpd_mad;

	p_bbm_vpd_mad = (ib_bbm_vpd_t *)p_bbm_vsd_vpd_mad;

	status = ibbbm_read_vpd(p_ibbbm_global,lid,IBBBM_VSD_VPD_DEV_SEL,IBBBM_VSD_VPD_SIZE,IBBBM_VSD_VPD_OFFSET,p_bbm_vpd_mad);
	;
	ibis_set_tcl_error("-E- Failed to read VSD VPD");
   return(status);
}

int
ibbbm_read_bsn_vpd_global(
  uint16_t lid,
  ib_bbm_bsn_vpd_t *p_bbm_bsn_vpd_mad)
{
	ib_api_status_t status;
	ib_bbm_vpd_t *p_bbm_vpd_mad;

	p_bbm_vpd_mad = (ib_bbm_vpd_t *)p_bbm_bsn_vpd_mad;

	status = ibbbm_read_vpd(p_ibbbm_global,lid,IBBBM_BSN_VPD_DEV_SEL,IBBBM_BSN_VPD_SIZE,IBBBM_BSN_VPD_OFFSET,p_bbm_vpd_mad);
	;
	ibis_set_tcl_error("-E- Failed to read BSN");

	return(status);
}

int
ibbbm_read_mod_vpd_global(
  uint16_t lid,
  ib_bbm_mod_vpd_t *p_bbm_mod_vpd_mad)
{
	ib_api_status_t status;
	ib_bbm_vpd_t *p_bbm_vpd_mad;

	p_bbm_vpd_mad = (ib_bbm_vpd_t *)p_bbm_mod_vpd_mad;

	status = ibbbm_read_vpd(p_ibbbm_global,lid,IBBBM_MOD_VPD_DEV_SEL,IBBBM_MOD_VPD_SIZE,IBBBM_MOD_VPD_OFFSET,p_bbm_vpd_mad);
	;
	ibis_set_tcl_error("-E- Failed to read Module VPD");

	return(status);
}

int
ibbbm_read_cha_vpd_global(
  uint16_t lid,
  ib_bbm_cha_vpd_t *p_bbm_cha_vpd_mad)
{
	ib_api_status_t status;
	ib_bbm_vpd_t *p_bbm_vpd_mad;

	p_bbm_vpd_mad = (ib_bbm_vpd_t *)p_bbm_cha_vpd_mad;

	status = ibbbm_read_vpd(p_ibbbm_global,lid,IBBBM_CHA_VPD_DEV_SEL,IBBBM_CHA_VPD_SIZE,IBBBM_CHA_VPD_OFFSET,p_bbm_vpd_mad);
	;
   ibis_set_tcl_error("-E- Failed to read Chassis VPD");
	return(status);
}


int
ibbbm_read_fw_ver_vpd_global(
  uint16_t lid,
  ib_bbm_fw_ver_vpd_t *p_bbm_fw_ver_vpd_mad)
{
	ib_api_status_t status;
	ib_bbm_vpd_t *p_bbm_vpd_mad;

	p_bbm_vpd_mad = (ib_bbm_vpd_t *)p_bbm_fw_ver_vpd_mad;

	status = ibbbm_read_vpd(p_ibbbm_global,lid,IBBBM_FW_VER_VPD_DEV_SEL,IBBBM_FW_VER_VPD_SIZE,IBBBM_FW_VER_VPD_OFFSET,p_bbm_vpd_mad);
	;

   ibis_set_tcl_error("-E- Failed to read FW Version.");

	return(status);
}


#include "stdio.h"
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <iba/ib_types.h>
#include <complib/cl_types.h>
#include <complib/cl_qmap.h>
#include <complib/cl_map.h>
#include <complib/cl_debug.h>
#include "ibis_api.h"
#ifdef OSM_BUILD_OPENIB
#include <vendor/osm_vendor_sa_api.h>
#else
#include <opensm/osm_vendor_sa_api.h>
#endif
#include "ibsac.h"

  /*
     TODO:  Add the following queries
     ClassPortInfo
     InformInfo
     SLtoVLMappingTableRecord
     VLArbitrationTableRecord
     ServiceRecord
     P_KeyTableRecord

     Not supported by OpenSM:
     Notice
     MulticastForwardingTableRecord
     GUIDInfoRecord
     InformInfoRecord

     Later:
     MultiPathRecord
  */

  /* we probably want to use our own naming for classes */
  typedef ib_node_record_t         sacNodeRec;
  typedef ib_node_info_t           sacNodeInfo;
  typedef ib_portinfo_record_t     sacPortRec;
  typedef ib_port_info_t           sacPortInfo;
  typedef ib_sminfo_record_t       sacSmRec;
  typedef ib_sm_info_t             sacSmInfo;
  typedef ib_switch_info_record_t  sacSwRec;
  typedef ib_switch_info_t         sacSwInfo;
  typedef ib_link_record_t         sacLinkRec;
  typedef ib_path_rec_t            sacPathRec;
  typedef ib_lft_record_t          sacLFTRec;
  typedef ib_member_rec_t          sacMCMRec;
  typedef ib_class_port_info_t     sacClassPortInfo;
  typedef ib_inform_info_t         sacInformInfo;
  typedef ib_service_record_t      sacServiceRec;
  typedef ib_slvl_table_t          sacSlVlTbl;
  typedef ib_slvl_table_record_t   sacSlVlRec;
  typedef ib_vl_arb_table_record_t sacVlArbRec;
  typedef ib_pkey_table_t          sacPKeyTbl;
  typedef ib_pkey_table_record_t   sacPKeyRec;
  typedef uint8_t                  ib_lft_t;


#include "swig_extended_obj.c"

  /* Pre allocated Query Objects */
  ib_node_record_t        ibsac_node_rec;
  ib_portinfo_record_t    ibsac_portinfo_rec;
  ib_sminfo_record_t      ibsac_sminfo_rec;
  ib_switch_info_record_t ibsac_swinfo_rec;
  ib_link_record_t        ibsac_link_rec; // no sub type
  ib_path_rec_t           ibsac_path_rec; // no sub type
  ib_lft_record_t         ibsac_lft_rec; // no sub type
  ib_member_rec_t         ibsac_mcm_rec; // no sub type

  ib_class_port_info_t    ibsac_class_port_info; // no sub type
  ib_inform_info_t        ibsac_inform_info; // no sub type
  ib_service_record_t     ibsac_svc_rec;  // no sub type
  ib_slvl_table_record_t  ibsac_slvl_rec; // ib_slvl_table_t
  ib_vl_arb_table_record_t ibsac_vlarb_rec; // ib_vl_arb_table_t
  ib_pkey_table_record_t  ibsac_pkey_rec; // ib_pkey_table_t

  /* Query Functions for each record */
  /* These are TCL specific thus are here */

  char *ibsacNodeRecordQuery(
	 ib_node_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_node_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_NODE_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_node_record_t *)malloc(sizeof(ib_node_record_t));

		/* copy into it */
		*p_rec = *(osmv_get_query_node_rec( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("nr",p_rec);
		SWIG_AltMnglRegObj("ni",&(p_rec->node_info));

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "nr", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacPortInfoRecordQuery(
	 ib_portinfo_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_portinfo_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_PORTINFO_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_portinfo_record_t *)malloc(sizeof(ib_portinfo_record_t));

		/* copy into it */
		*p_rec = *(osmv_get_query_portinfo_rec( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("pir",p_rec);
		SWIG_AltMnglRegObj("pi",&(p_rec->port_info));

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "pir", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacSMInfoRecordQuery(
	 ib_sminfo_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_sminfo_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_SMINFO_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_sminfo_record_t *)malloc(sizeof(ib_sminfo_record_t));

		/* copy into it */
		*p_rec = *((ib_sminfo_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("smir",p_rec);
		SWIG_AltMnglRegObj("smi",&(p_rec->sm_info));

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "smir", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacSwitchInfoRecordQuery(
	 ib_switch_info_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_switch_info_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, CL_NTOH16(0x0014), self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_switch_info_record_t *)malloc(sizeof(ib_switch_info_record_t));

		/* copy into it */
		*p_rec = *((ib_switch_info_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("swir",p_rec);
		SWIG_AltMnglRegObj("swi",&(p_rec->switch_info));

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "swir", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacPathRecordQuery(
	 ib_path_rec_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_path_rec_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_PATH_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_path_rec_t *)malloc(sizeof(ib_path_rec_t));

		/* copy into it */
		*p_rec = *((ib_path_rec_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("path",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "path", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacLinkRecordQuery(
	 ib_link_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_link_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_LINK_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_link_record_t *)malloc(sizeof(ib_link_record_t));

		/* copy into it */
		*p_rec = *((ib_link_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("link",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "link", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacLFTRecordQuery(
	 ib_lft_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_lft_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_LFT_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_lft_record_t *)malloc(sizeof(ib_lft_record_t));

		/* copy into it */
		*p_rec = *((ib_lft_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("lft",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "lft", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacMCMemberRecordQuery(
	 ib_member_rec_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_member_rec_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_MCMEMBER_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_member_rec_t *)malloc(sizeof(ib_member_rec_t));

		/* copy into it */
		*p_rec = *((ib_member_rec_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("mcm",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "mcm", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacClassPortInfoQuery(
	 ib_class_port_info_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_class_port_info_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_CLASS_PORT_INFO, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_class_port_info_t *)malloc(sizeof(ib_class_port_info_t));

		/* copy into it */
		*p_rec = *((ib_class_port_info_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("cpi",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "cpi", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacInformInfoQuery(
	 ib_inform_info_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_inform_info_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj,  IB_MAD_ATTR_INFORM_INFO, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_inform_info_t *)malloc(sizeof(ib_inform_info_t));

		/* copy into it */
		*p_rec = *((ib_inform_info_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("info",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "info", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }


  char *ibsacServiceRecordQuery(
	 ib_service_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_service_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj,  IB_MAD_ATTR_SERVICE_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_service_record_t *)malloc(sizeof(ib_service_record_t));

		/* copy into it */
		*p_rec = *((ib_service_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("svc",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "svc", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacSl2VlRecordQuery(
	 ib_slvl_table_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_slvl_table_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_SLVL_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_slvl_table_record_t *)malloc(sizeof(ib_slvl_table_record_t));

		/* copy into it */
		*p_rec = *((ib_slvl_table_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("slvr",p_rec);
		SWIG_AltMnglRegObj("slvt",&(p_rec->slvl_tbl));

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "slvr", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacVlArbRecordQuery(
	 ib_vl_arb_table_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_vl_arb_table_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_VLARB_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_vl_arb_table_record_t *)malloc(sizeof(ib_vl_arb_table_record_t));

		/* copy into it */
		*p_rec = *((ib_vl_arb_table_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("vlarb",p_rec);

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "vlarb", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

  char *ibsacPKeyRecordQuery(
	 ib_pkey_table_record_t *self,
	 uint64_t comp_mask,
	 uint8_t method) {
	 ib_pkey_table_record_t *p_rec;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_recs = 0;
	 osm_madw_t *p_result_madw;
	 char *p_res_str = NULL, *tmp;
	 Tcl_Obj *p_tclObj;
	 int nameLength;

	 status = ibsac_query(
		&IbisObj, IB_MAD_ATTR_PKEY_TBL_RECORD, self, comp_mask, method,
		&num_recs, &p_result_madw
		);

	 for( i = 0; i < num_recs; i++ )
	 {
		/* we need to create a new node info and copy */
		p_rec = (ib_pkey_table_record_t *)malloc(sizeof(ib_pkey_table_record_t));

		/* copy into it */
		*p_rec = *((ib_pkey_table_record_t*)osmv_get_query_result( p_result_madw, i ));

		/* register it as a new object */
		SWIG_AltMnglRegObj("pkr",p_rec);
		SWIG_AltMnglRegObj("pkt",&(p_rec->pkey_tbl));

		p_tclObj = Tcl_NewObj();

		/* get the assigned name */
		if (SWIG_AltMnglGetObjNameByPtr(p_tclObj, "pkr", p_rec)) {
		  printf("-E- Fail to get name of object %p\n", p_rec);
		} else {
		  tmp = Tcl_GetStringFromObj(p_tclObj, &nameLength);

		  /* enlarge the result string length */
		  if (p_res_str)
			 p_res_str = (char *)realloc(p_res_str, strlen(p_res_str) + nameLength + 2);
		  else {
			 p_res_str = (char *)malloc(nameLength + 2);
			 p_res_str[0] = '\0';
		  }

		  strcat(p_res_str, tmp);
		  strcat(p_res_str, " ");
		}
		Tcl_DecrRefCount(p_tclObj);
	 }

	 if( p_result_madw != NULL )
		osm_mad_pool_put( &IbisObj.mad_pool, p_result_madw );

	 return(p_res_str);
  }

static int  _wrap_const_IB_NR_COMPMASK_LID = 0x1;
static int  _wrap_const_IB_NR_COMPMASK_RESERVED1 = 0x2;
static int  _wrap_const_IB_NR_COMPMASK_BASEVERSION = 0x4;
static int  _wrap_const_IB_NR_COMPMASK_CLASSVERSION = 0x8;
static int  _wrap_const_IB_NR_COMPMASK_NODETYPE = 0x10;
static int  _wrap_const_IB_NR_COMPMASK_NUMPORTS = 0x20;
static int  _wrap_const_IB_NR_COMPMASK_SYSIMAGEGUID = 0x40;
static int  _wrap_const_IB_NR_COMPMASK_NODEGUID = 0x80;
static int  _wrap_const_IB_NR_COMPMASK_PORTGUID = 0x100;
static int  _wrap_const_IB_NR_COMPMASK_PARTCAP = 0x200;
static int  _wrap_const_IB_NR_COMPMASK_DEVID = 0x400;
static int  _wrap_const_IB_NR_COMPMASK_REV = 0x800;
static int  _wrap_const_IB_NR_COMPMASK_PORTNUM = 0x1000;
static int  _wrap_const_IB_NR_COMPMASK_VENDID = 0x2000;
static int  _wrap_const_IB_NR_COMPMASK_NODEDESC = 0x4000;
static char * _wrap_const_IB_PIR_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_PIR_COMPMASK_PORTNUM = "0x2";
static char * _wrap_const_IB_PIR_COMPMASK_RESV1 = "0x4";
static char * _wrap_const_IB_PIR_COMPMASK_MKEY = "0x8";
static int  _wrap_const_IB_PIR_COMPMASK_GIDPRE = 0x10;
static int  _wrap_const_IB_PIR_COMPMASK_BASELID = 0x20;
static int  _wrap_const_IB_PIR_COMPMASK_SMLID = 0x40;
static int  _wrap_const_IB_PIR_COMPMASK_CAPMASK = 0x80;
static int  _wrap_const_IB_PIR_COMPMASK_DIAGCODE = 0x100;
static int  _wrap_const_IB_PIR_COMPMASK_MKEYLEASEPRD = 0x200;
static int  _wrap_const_IB_PIR_COMPMASK_LOCALPORTNUM = 0x400;
static int  _wrap_const_IB_PIR_COMPMASK_LNKWIDTHSUPPORT = 0x800;
static int  _wrap_const_IB_PIR_COMPMASK_LNKWIDTHACTIVE = 0x1000;
static int  _wrap_const_IB_PIR_COMPMASK_LINKWIDTHENABLED = 0x2000;
static int  _wrap_const_IB_PIR_COMPMASK_LNKSPEEDSUPPORT = 0x4000;
static int  _wrap_const_IB_PIR_COMPMASK_PORTSTATE = 0x10000;
static int  _wrap_const_IB_PIR_COMPMASK_PORTPHYSTATE = 0x20000;
static int  _wrap_const_IB_PIR_COMPMASK_LINKDWNDFLTSTATE = 0x40000;
static int  _wrap_const_IB_PIR_COMPMASK_MKEYPROTBITS = 0x80000;
static int  _wrap_const_IB_PIR_COMPMASK_LMC = 0x100000;
static int  _wrap_const_IB_PIR_COMPMASK_LINKSPEEDACTIVE = 0x200000;
static int  _wrap_const_IB_PIR_COMPMASK_LINKSPEEDENABLE = 0x400000;
static int  _wrap_const_IB_PIR_COMPMASK_NEIGHBORMTU = 0x800000;
static int  _wrap_const_IB_PIR_COMPMASK_MASTERSMSL = 0x1000000;
static int  _wrap_const_IB_PIR_COMPMASK_VLCAP = 0x2000000;
static int  _wrap_const_IB_PIR_COMPMASK_INITTYPE = 0x4000000;
static int  _wrap_const_IB_PIR_COMPMASK_VLHIGHLIMIT = 0x8000000;
static int  _wrap_const_IB_PIR_COMPMASK_VLARBHIGHCAP = 0x10000000;
static int  _wrap_const_IB_PIR_COMPMASK_VLARBLOWCAP = 0x20000000;
static int  _wrap_const_IB_PIR_COMPMASK_INITTYPEREPLY = 0x40000000;
static int  _wrap_const_IB_PIR_COMPMASK_MTUCAP = 0x80000000;
static char * _wrap_const_IB_PIR_COMPMASK_VLSTALLCNT = "0x100000000";
static char * _wrap_const_IB_PIR_COMPMASK_HOQLIFE = "0x200000000";
static char * _wrap_const_IB_PIR_COMPMASK_OPVLS = "0x400000000";
static char * _wrap_const_IB_PIR_COMPMASK_PARENFIN = "0x800000000";
static char * _wrap_const_IB_PIR_COMPMASK_PARENFOUT = "0x1000000000";
static char * _wrap_const_IB_PIR_COMPMASK_FILTERRAWIN = "0x2000000000";
static char * _wrap_const_IB_PIR_COMPMASK_FILTERRAWOUT = "0x4000000000";
static char * _wrap_const_IB_PIR_COMPMASK_MKEYVIO = "0x8000000000";
static char * _wrap_const_IB_PIR_COMPMASK_PKEYVIO = "0x10000000000";
static char * _wrap_const_IB_PIR_COMPMASK_QKEYVIO = "0x20000000000";
static char * _wrap_const_IB_PIR_COMPMASK_GUIDCAP = "0x40000000000";
static char * _wrap_const_IB_PIR_COMPMASK_RESV2 = "0x80000000000";
static char * _wrap_const_IB_PIR_COMPMASK_SUBNTO = "0x100000000000";
static char * _wrap_const_IB_PIR_COMPMASK_RESV3 = "0x200000000000";
static char * _wrap_const_IB_PIR_COMPMASK_RESPTIME = "0x400000000000";
static char * _wrap_const_IB_PIR_COMPMASK_LOCALPHYERR = "0x800000000000";
static char * _wrap_const_IB_PIR_COMPMASK_OVERRUNERR = "0x1000000000000";
static char * _wrap_const_IB_SMR_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_SMR_COMPMASK_GUID = "0x2";
static char * _wrap_const_IB_SMR_COMPMASK_SM_KEY = "0x4";
static char * _wrap_const_IB_SMR_COMPMASK_ACT_COUNT = "0x8";
static int  _wrap_const_IB_SMR_COMPMASK_STATE = 0x10;
static int  _wrap_const_IB_SMR_COMPMASK_PRI = 0x20;
static char * _wrap_const_IB_SWR_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_SWR_COMPMASK_LIN_CAP = "0x2";
static char * _wrap_const_IB_SWR_COMPMASK_RAND_CAP = "0x4";
static char * _wrap_const_IB_SWR_COMPMASK_MCAST_CAP = "0x8";
static char * _wrap_const_IB_SWR_COMPMASK_LIN_TOP = "0x10";
static char * _wrap_const_IB_SWR_COMPMASK_DEF_PORT = "0x20";
static char * _wrap_const_IB_SWR_COMPMASK_DEF_MCAST_PRI = "0x40";
static char * _wrap_const_IB_SWR_COMPMASK_DEF_MCAST_NOT = "0x80";
static char * _wrap_const_IB_SWR_COMPMASK_STATE = "0x100";
static char * _wrap_const_IB_SWR_COMPMASK_LIFE = "0x200";
static char * _wrap_const_IB_SWR_COMPMASK_LMC = "0x400";
static char * _wrap_const_IB_SWR_COMPMASK_ENFORCE_CAP = "0x800";
static char * _wrap_const_IB_SWR_COMPMASK_FLAGS = "0x1000";
static int  _wrap_const_IB_LR_COMPMASK_FROM_LID = 0x1;
static int  _wrap_const_IB_LR_COMPMASK_FROM_PORT = 0x2;
static int  _wrap_const_IB_LR_COMPMASK_TO_PORT = 0x4;
static int  _wrap_const_IB_LR_COMPMASK_TO_LID = 0x8;
static int  _wrap_const_IB_PR_COMPMASK_DGID = 0x4;
static int  _wrap_const_IB_PR_COMPMASK_SGID = 0x8;
static int  _wrap_const_IB_PR_COMPMASK_DLID = 0x10;
static int  _wrap_const_IB_PR_COMPMASK_SLID = 0x20;
static int  _wrap_const_IB_PR_COMPMASK_RAWTRAFIC = 0x40;
static int  _wrap_const_IB_PR_COMPMASK_RESV0 = 0x80;
static int  _wrap_const_IB_PR_COMPMASK_FLOWLABEL = 0x100;
static int  _wrap_const_IB_PR_COMPMASK_HOPLIMIT = 0x200;
static int  _wrap_const_IB_PR_COMPMASK_TCLASS = 0x400;
static int  _wrap_const_IB_PR_COMPMASK_REVERSIBLE = 0x800;
static int  _wrap_const_IB_PR_COMPMASK_NUMBPATH = 0x1000;
static int  _wrap_const_IB_PR_COMPMASK_PKEY = 0x2000;
static int  _wrap_const_IB_PR_COMPMASK_RESV1 = 0x4000;
static int  _wrap_const_IB_PR_COMPMASK_SL = 0x8000;
static int  _wrap_const_IB_PR_COMPMASK_MTUSELEC = 0x10000;
static int  _wrap_const_IB_PR_COMPMASK_MTU = 0x20000;
static int  _wrap_const_IB_PR_COMPMASK_RATESELEC = 0x40000;
static int  _wrap_const_IB_PR_COMPMASK_RATE = 0x80000;
static int  _wrap_const_IB_PR_COMPMASK_PKTLIFETIMESELEC = 0x100000;
static int  _wrap_const_IB_PR_COMPMASK_PFTLIFETIME = 0x200000;
static char * _wrap_const_IB_LFT_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_LFT_COMPMASK_BLOCK = "0x2";
static char * _wrap_const_IB_MCR_COMPMASK_GID = "0x1";
static char * _wrap_const_IB_MCR_COMPMASK_MGID = "0x1";
static char * _wrap_const_IB_MCR_COMPMASK_PORT_GID = "0x2";
static char * _wrap_const_IB_MCR_COMPMASK_QKEY = "0x4";
static char * _wrap_const_IB_MCR_COMPMASK_MLID = "0x8";
static char * _wrap_const_IB_MCR_COMPMASK_MTU_SEL = "0x10";
static char * _wrap_const_IB_MCR_COMPMASK_MTU = "0x20";
static char * _wrap_const_IB_MCR_COMPMASK_TCLASS = "0x40";
static char * _wrap_const_IB_MCR_COMPMASK_PKEY = "0x80";
static char * _wrap_const_IB_MCR_COMPMASK_RATE_SEL = "0x100";
static char * _wrap_const_IB_MCR_COMPMASK_RATE = "0x200";
static char * _wrap_const_IB_MCR_COMPMASK_LIFE_SEL = "0x400";
static char * _wrap_const_IB_MCR_COMPMASK_LIFE = "0x800";
static char * _wrap_const_IB_MCR_COMPMASK_SL = "0x1000";
static char * _wrap_const_IB_MCR_COMPMASK_FLOW = "0x2000";
static char * _wrap_const_IB_MCR_COMPMASK_HOP = "0x4000";
static char * _wrap_const_IB_MCR_COMPMASK_SCOPE = "0x8000";
static char * _wrap_const_IB_MCR_COMPMASK_JOIN_STATE = "0x10000";
static char * _wrap_const_IB_MCR_COMPMASK_PROXY = "0x20000";

typedef union {
	 struct _sac_inform_generic
	 {
		ib_net16_t		trap_num;
		ib_net32_t		qpn_resp_time_val;
      uint8_t        reserved2;
		uint8_t			node_type_msb;
		ib_net16_t		node_type_lsb;
	 } generic;

	 struct _sac_inform_vend
	 {
		ib_net16_t		dev_id;
		ib_net32_t		qpn_resp_time_val;
      uint8_t        reserved2;
		uint8_t			vendor_id_msb;
		ib_net16_t		vendor_id_lsb;
	 } vend;

  } sacInformInfo_g_or_v;


typedef struct {
		ib_net16_t		trap_num;
		ib_net32_t		qpn_resp_time_val;
      uint8_t        reserved2;
		uint8_t			node_type_msb;
		ib_net16_t		node_type_lsb;
	 } sacInformInfo_g_or_v_generic;


typedef struct {
		ib_net16_t		dev_id;
		ib_net32_t		qpn_resp_time_val;
      uint8_t        reserved2;
		uint8_t			vendor_id_msb;
		ib_net16_t		vendor_id_lsb;
	 } sacInformInfo_g_or_v_vend;

static char * _wrap_const_IB_SR_COMPMASK_SID = "0x1";
static char * _wrap_const_IB_SR_COMPMASK_SGID = "0x1";
static char * _wrap_const_IB_SR_COMPMASK_SPKEY = "0x2";
static char * _wrap_const_IB_SR_COMPMASK_RES1 = "0x4";
static char * _wrap_const_IB_SR_COMPMASK_SLEASE = "0x8";
static char * _wrap_const_IB_SR_COMPMASK_SKEY = "0x10";
static char * _wrap_const_IB_SR_COMPMASK_SNAME = "0x20";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_0 = "0x40";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_1 = "0x80";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_2 = "0x100";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_3 = "0x200";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_4 = "0x400";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_5 = "0x800";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_6 = "0x1000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_7 = "0x2000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_8 = "0x4000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_9 = "0x8000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_10 = "0x10000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_11 = "0x20000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_12 = "0x40000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_13 = "0x80000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_14 = "0x100000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA8_15 = "0x200000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_0 = "0x400000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_1 = "0x800000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_2 = "0x1000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_3 = "0x2000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_4 = "0x4000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_5 = "0x8000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_6 = "0x10000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA16_7 = "0x20000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA32_0 = "0x40000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA32_1 = "0x80000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA32_2 = "0x100000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA32_3 = "0x200000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA64_0 = "0x400000000";
static char * _wrap_const_IB_SR_COMPMASK_SDATA64_1 = "0x800000000";
static char * _wrap_const_IB_SLVL_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_SLVL_COMPMASK_IN_PORT = "0x2";
static char * _wrap_const_IB_SLVL_COMPMASK_OUT_PORT = "0x4";
static char * _wrap_const_IB_VLA_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_VLA_COMPMASK_OUT_PORT = "0x2";
static char * _wrap_const_IB_VLA_COMPMASK_BLOCK = "0x4";

#define sac_vl_arb_tbl_t ib_vl_arb_table_t
static char * _wrap_const_IB_PKEY_COMPMASK_LID = "0x1";
static char * _wrap_const_IB_PKEY_COMPMASK_BLOCK = "0x2";
static char * _wrap_const_IB_PKEY_COMPMASK_PORT = "0x4";

#include "stdio.h"
#include <errno.h>
#include <stdlib.h>
#include <getopt.h>
#include <iba/ib_types.h>
#include <complib/cl_types.h>
#include <complib/cl_qmap.h>
#include <complib/cl_map.h>
#include <complib/cl_debug.h>
#include "ibis_api.h"

  /* the global pointer to this SM mads manager */
  static ibsm_t *gp_ibsm;

  /* the data section within a LFT mad */
  typedef struct _ibsm_lft_block {
    uint8_t lft[64];
  } ibsm_lft_block_t;

  /* the data section within a MFT mad */
  typedef struct _ibsm_mft_block {
    uint16_t mft[32];
  } ibsm_mft_block_t;

  /* we probably want to use our own naming for classes */
  typedef ib_node_info_t        smNodeInfo;
  typedef ib_port_info_t        smPortInfo;
  typedef ib_switch_info_t      smSwInfo;
  typedef ibsm_lft_block_t      smLftBlock;
  typedef ibsm_mft_block_t      smMftBlock;
  typedef ib_guid_info_t        smGuidInfo;
  typedef ib_pkey_table_t       smPkeyTable;
  typedef ib_slvl_table_t       smSlVlTable;
  typedef ib_vl_arb_table_t     smVlArbTable;
  typedef ib_node_desc_t        smNodeDesc;
  typedef ib_sm_info_t          smSMInfo;
  typedef ib_mad_notice_attr_t  smNotice;

  /* these are the globals to be used for set/get */
  ib_node_info_t          ibsm_node_info_obj;
  ib_port_info_t          ibsm_port_info_obj;
  ib_switch_info_t        ibsm_switch_info_obj;
  ibsm_lft_block_t        ibsm_lft_block_obj;
  ibsm_mft_block_t        ibsm_mft_block_obj;
  ib_guid_info_t          ibsm_guid_info_obj;
  ib_pkey_table_t         ibsm_pkey_table_obj;
  ib_slvl_table_t         ibsm_slvl_table_obj;
  ib_vl_arb_table_t       ibsm_vl_arb_table_obj;
  ib_node_desc_t          ibsm_node_desc_obj;
  ib_sm_info_t            ibsm_sm_info_obj;
  ib_mad_notice_attr_t    ibsm_notice_obj;

  /* TODO - define a Vendor Specific CR Read/Write attributes to use VL15 */


  int smMftGetAttrMod( uint16_t startLid, uint8_t startPort, uint32_t *p_attrMod )
    {
      if (startLid % 32)
      {
        printf("Error: Given startLid must be a multiply of 32: %u\n", startLid);
        return TCL_ERROR;
      }
      if (startPort % 16)
      {
        printf("Error: Given startPort must be a multiply of 16: %u\n", startPort);
        return TCL_ERROR;
      }

      /*
         always true due to the uint8_t
         if (startPort > 255)
         {
         printf("Error: Given startPort is out of range: %u > 255\n", startPort);
         return TCL_ERROR;
         }
      */
      *p_attrMod = ((startLid - 0xc000) / 32) + ((startPort / 16) << 28);
      return TCL_OK;
    }

  typedef uint8_t ibsm_node_desc_str_t;

typedef union {
	 struct _sm_notice_generic
	 {
		uint8_t		prod_type_msb;
		ib_net16_t	prod_type_lsb;
		ib_net16_t	trap_num;
	 }	generic;

	 struct _sm_notice_vend
	 {
		uint8_t		vend_id_msb;
		ib_net16_t	vend_id_lsb;
		ib_net16_t	dev_id;
	 } vend;
  } smNotice_g_or_v;


typedef union {
    struct _sm_raw_data
    {
      uint8_array_t	details[54];
    } raw_data;

    struct _sm_ntc_64_67
    {
      uint8_array_t  res[6];
      ib_gid_t   gid;	// the Node or Multicast Group that came in/out
    } ntc_64_67;

    struct _sm_ntc_128 {
      ib_net16_t sw_lid; // the sw lid of which link state changed
    } ntc_128;

    struct _sm_ntc_129_131 {
      ib_net16_t    pad;
      ib_net16_t    lid;		// lid and port number of the violation
      uint8_t       port_num;
    } ntc_129_131;

    struct _sm_ntc_144 {
      ib_net16_t    pad1;
      ib_net16_t    lid;		// lid where capability mask changed
      ib_net16_t    pad2;
      ib_net32_t    new_cap_mask; // new capability mask
    } ntc_144;

    struct _sm_ntc_145 {
      ib_net16_t    pad1;
      ib_net16_t    lid;		// lid where sys guid changed
      ib_net16_t    pad2;
      ib_net64_t    new_sys_guid; // new system image guid
    } ntc_145;

    struct _sm_ntc_256 {
      ib_net16_t    pad1;
      ib_net16_t    lid;
      ib_net16_t    pad2;
      uint8_t       method;
      uint8_t       pad3;
      ib_net16_t    attr_id;
      ib_net32_t    attr_mod;
      ib_net64_t    mkey;
      uint8_t       dr_slid;
      uint8_t       dr_trunc_hop;
      uint8_array_t dr_rtn_path[30];
    } ntc_256;

    struct _sm_ntc_257_258 // violation of p/q_key // 49
    {
      ib_net16_t    pad1;
      ib_net16_t    lid1;
      ib_net16_t    lid2;
      ib_net32_t    key;
      uint8_t       sl;
      ib_net32_t    qp1;
      ib_net32_t    qp2;
      ib_gid_t      gid1;
      ib_gid_t      gid2;
    } ntc_257_258;

    struct _sm_ntc_259 // p/q_key violation with sw info 53
    {
      ib_net16_t    data_valid;
      ib_net16_t    lid1;
      ib_net16_t    lid2;
      ib_net32_t    key;
      uint8_t       sl;
      ib_net32_t    qp1;
      uint8_t       qp2_msb;
      ib_net16_t    qp2_lsb;
      ib_gid_t      gid1;
      ib_gid_t      gid2;
      ib_net16_t    sw_lid;
      uint8_t       port_no;
    } ntc_259;

  } smNotice_data_details;


typedef struct {
		uint8_t		prod_type_msb;
		ib_net16_t	prod_type_lsb;
		ib_net16_t	trap_num;
	 } smNotice_g_or_v_generic;


typedef struct {
		uint8_t		vend_id_msb;
		ib_net16_t	vend_id_lsb;
		ib_net16_t	dev_id;
	 } smNotice_g_or_v_vend;


typedef struct {
      uint8_array_t	details[54];
    } smNotice_data_details_raw_data;


typedef struct {
      uint8_array_t  res[6];
      ib_gid_t   gid;	// the Node or Multicast Group that came in/out
    } smNotice_data_details_ntc_64_67;


typedef struct {
      ib_net16_t sw_lid; // the sw lid of which link state changed
    } smNotice_data_details_ntc_128;


typedef struct {
      ib_net16_t    pad;
      ib_net16_t    lid;		// lid and port number of the violation
      uint8_t       port_num;
    } smNotice_data_details_ntc_129_131;


typedef struct {
      ib_net16_t    pad1;
      ib_net16_t    lid;		// lid where capability mask changed
      ib_net16_t    pad2;
      ib_net32_t    new_cap_mask; // new capability mask
    } smNotice_data_details_ntc_144;


typedef struct {
      ib_net16_t    pad1;
      ib_net16_t    lid;		// lid where sys guid changed
      ib_net16_t    pad2;
      ib_net64_t    new_sys_guid; // new system image guid
    } smNotice_data_details_ntc_145;


typedef struct {
      ib_net16_t    pad1;
      ib_net16_t    lid;
      ib_net16_t    pad2;
      uint8_t       method;
      uint8_t       pad3;
      ib_net16_t    attr_id;
      ib_net32_t    attr_mod;
      ib_net64_t    mkey;
      uint8_t       dr_slid;
      uint8_t       dr_trunc_hop;
      uint8_array_t dr_rtn_path[30];
    } smNotice_data_details_ntc_256;


typedef struct {
      ib_net16_t    pad1;
      ib_net16_t    lid1;
      ib_net16_t    lid2;
      ib_net32_t    key;
      uint8_t       sl;
      ib_net32_t    qp1;
      ib_net32_t    qp2;
      ib_gid_t      gid1;
      ib_gid_t      gid2;
    } smNotice_data_details_ntc_257_258;


typedef struct {
      ib_net16_t    data_valid;
      ib_net16_t    lid1;
      ib_net16_t    lid2;
      ib_net32_t    key;
      uint8_t       sl;
      ib_net32_t    qp1;
      uint8_t       qp2_msb;
      ib_net16_t    qp2_lsb;
      ib_gid_t      gid1;
      ib_gid_t      gid2;
      ib_net16_t    sw_lid;
      uint8_t       port_no;
    } smNotice_data_details_ntc_259;


#include "stdio.h"
#include <errno.h>
#include <stdlib.h>
#include <getopt.h>
#include <iba/ib_types.h>
#include <complib/cl_types.h>
#include <complib/cl_qmap.h>
#include <complib/cl_map.h>
#include <complib/cl_debug.h>
#include "ibis_api.h"

	/* the global pointer to this CC mads manager */
	static ibcc_t *gp_ibcc;

	/* we probably want to use our own naming for classes */
	typedef ib_class_port_info_t       ccClassPortInfo;
	typedef ibcc_notice_attr_t         ccNotice;
	typedef ib_cong_info_t             ccCongestionInfo;
	typedef ib_cong_key_info_t         ccCongestionKeyInfo;
	typedef ibcc_ca_cong_log_t         ccCACongestionLog;
	typedef ibcc_sw_cong_log_t         ccSWCongestionLog;
	typedef ib_sw_cong_setting_t       ccSWCongestionSetting;
	typedef ib_sw_port_cong_setting_t  ccSWPortCongestionSetting;
	typedef ib_ca_cong_setting_t       ccCACongestionSetting;
	typedef ib_cc_tbl_t                ccTable;
	typedef ib_time_stamp_t            ccTimeStamp;

	/* these are the global objects to be used
	   for set/get (one for each attribute) */
	ib_class_port_info_t               ibcc_class_port_info_obj;
	ibcc_notice_attr_t                 ibcc_notice_obj;
	ib_cong_info_t                     ibcc_cong_info_obj;
	ib_cong_key_info_t                 ibcc_cong_key_info_obj;
	ibcc_ca_cong_log_t                 ibcc_ca_cong_log_obj;
	ibcc_sw_cong_log_t                 ibcc_sw_cong_log_obj;
	ib_sw_cong_setting_t               ibcc_sw_cong_setting_obj;
	ib_sw_port_cong_setting_t          ibcc_sw_port_cong_setting_obj;
	ib_ca_cong_setting_t               ibcc_ca_cong_setting_obj;
	ib_cc_tbl_t                        ibcc_table_obj;
	ib_time_stamp_t                    ibcc_time_stamp_obj;


  /* globals */
  ibis_t    IbisObj;
  static ibis_opt_t  *ibis_opt_p;
  ibis_opt_t IbisOpts;

  /* initialize the ibis object - is not done during init so we
     can play with the options ... */
  int ibis_ui_init(void)
  {
    ib_api_status_t status;
#ifdef OSM_BUILD_OPENIB
    complib_init();
#endif

	 status = ibis_init( &IbisOpts, IbisOpts.log_flags );
	 if( status != IB_SUCCESS ) {
		printf("-E- Error from ibis_init: %s.\n",
				 ib_get_err_str( status ));
		ibis_destroy();
		exit(1);
	 }

    status = ibcr_init(p_ibcr_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- fail to init ibcr_init.\n");
      ibcr_destroy( p_ibcr_global );
      exit(1);
    }

    status = ibpm_init(p_ibpm_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- fail to init ibpm_init.\n");
      ibpm_destroy( p_ibpm_global );
      exit(1);
    }

    status = ibvs_init(p_ibvs_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to init ibvs_init.\n");
      ibvs_destroy( p_ibvs_global );
      exit(1);
    }

    status = ibbbm_init(p_ibbbm_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to init ibbbm_init.\n");
      ibbbm_destroy( p_ibbbm_global );
      exit(1);
    }

    status = ibsm_init(gp_ibsm);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to init ibsm_init.\n");
      ibsm_destroy( gp_ibsm );
      exit(1);
    }

    status = ibcc_init(gp_ibcc);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to init ibcc_init.\n");
      ibcc_destroy( gp_ibcc );
      exit(1);
    }

    return 0;
  }

  /* destroy the osm object and close the complib.
     This function is called from by the Tcl_CreateExitHandler - meaning
     it will be called when calling 'exit' in the osm shell. */
  void
    ibis_exit( ClientData clientData ) {
    ibcr_destroy(p_ibcr_global);
    ibpm_destroy(p_ibpm_global);
    ibvs_destroy(p_ibvs_global);
    ibbbm_destroy(p_ibbbm_global);
    ibsm_destroy(gp_ibsm);
    ibcc_destroy(gp_ibcc);

    ibis_destroy();
    usleep(100);
    complib_exit();
  }

  int ibis_ui_destroy(void)
  {
    ibis_exit(NULL);
    return TCL_OK;
  }


  /* simply return the active port guid ibis is binded to */
  uint64_t ibis_get_port(void)
  {
    return (IbisObj.port_guid);
  }

  /* set the port we bind to and initialize sub packages */
  int ibis_set_port(uint64_t port_guid)
  {
    ib_api_status_t status;

    if (! IbisObj.initialized) {
      ibis_set_tcl_error("ibis was not initialized! Please use ibis_init before any call to ibis_*");
      ibis_tcl_error = 1;
      return 1;
    }

    IbisObj.port_guid = port_guid;

    status = ibcr_bind(p_ibcr_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to ibcr_bind.\n");
      ibcr_destroy( p_ibcr_global );
      exit(1);
    }

    status = ibpm_bind(p_ibpm_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to ibpm_bind.\n");
      ibpm_destroy( p_ibpm_global );
      exit(1);
    }

    status = ibvs_bind(p_ibvs_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to ibvs_bind.\n");
      ibvs_destroy( p_ibvs_global );
      exit(1);
    }

    status = ibbbm_bind(p_ibbbm_global);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to ibbbm_bind.\n");
      ibbbm_destroy( p_ibbbm_global );
      exit(1);
    }

    status = ibsm_bind(gp_ibsm);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to ibsm_bind.\n");
      ibsm_destroy( gp_ibsm );
      exit(1);
    }

    status = ibcc_bind(gp_ibcc);
    if( status != IB_SUCCESS )
    {
      printf("-E- Fail to ibcc_bind.\n");
      ibcc_destroy( gp_ibcc );
      exit(1);
    }

    if (ibsac_bind(&IbisObj))
    {
      printf("-E- Fail to ibsac_bind.\n");
      exit(1);
    }

    return 0;
  }

  int ibis_set_verbosity(int level) {
    if (IbisObj.initialized)
      osm_log_set_level( &(IbisObj.log), level );
    else
      IbisOpts.log_flags = level;

	 return TCL_OK;
  }

  int ibis_puts( osm_log_level_t verbosity, char *msg) {
	 osm_log(&(IbisObj.log), verbosity, msg );
	 return TCL_OK;
  }

  int ibis_set_transaction_timeout( uint32_t timeout_ms ) {
	 osm_log(&(IbisObj.log),
				OSM_LOG_VERBOSE,
				" Setting timeout to:%u[msec]\n", timeout_ms);
	 IbisOpts.transaction_timeout = timeout_ms;
	 return TCL_OK;
  }

  /* return the list of port guids and their status etc */
  static int ibis_get_local_ports_info (ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj * tcl_result;
	 ibis_t *p_ibis = &IbisObj;
	 uint32_t i;
	 ib_api_status_t status;
	 uint32_t num_ports = GUID_ARRAY_SIZE;
	 ib_port_attr_t attr_array[GUID_ARRAY_SIZE];
	 static char res[128];
	 Tcl_Obj *p_obj;

    if (!IbisObj.initialized)
    {
      Tcl_SetStringObj(
        Tcl_GetObjResult(interp),
        "ibis was not yet initialized. please use ibis_init before.", -1);
      return TCL_ERROR;
    }

	 /* command options */
    tcl_result = Tcl_GetObjResult(interp);

    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_get_local_ports_info ",-1);
        return TCL_ERROR;
    }

	 /*
		Call the transport layer for a list of local port
		GUID values.
	 */
    status = osm_vendor_get_all_port_attr(
      p_ibis->p_vendor,
      attr_array,
      &num_ports );
    if( status != IB_SUCCESS )
    {
      sprintf(ibis_tcl_error_msg,"-E- fail status:%x\n", status);
      ibis_tcl_error = 1;
      return( TCL_ERROR );
    }

	 /*
		 Go over all ports and build the return  value
	 */
	 for( i = 0; i < num_ports; i++ )
    {

      // start with 1 on host channel adapters.
      sprintf(res, "0x%016" PRIx64 " 0x%04X %s %u",
              cl_ntoh64( attr_array[i].port_guid ),
              attr_array[i].lid,
              ib_get_port_state_str( attr_array[i].link_state ),
              attr_array[i].port_num
              );

      p_obj = Tcl_NewStringObj(res, strlen(res));
      Tcl_ListObjAppendElement(interp, tcl_result, p_obj);
    }

    return TCL_OK;
  }

static int  _wrap_const_IBIS_LOG_NONE = 0x00;
static int  _wrap_const_IBIS_LOG_ERROR = 0x01;
static int  _wrap_const_IBIS_LOG_INFO = 0x02;
static int  _wrap_const_IBIS_LOG_VERBOSE = 0x04;
static int  _wrap_const_IBIS_LOG_DEBUG = 0x08;
static int  _wrap_const_IBIS_LOG_FUNCS = 0x10;
static int  _wrap_const_IBIS_LOG_FRAMES = 0x20;
extern char * ibisSourceVersion;


/* A TCL_AppInit() function that lets you build a new copy
 * of tclsh.
 *
 * The macro SWIG_init contains the name of the initialization
 * function in the wrapper file.
 */

#ifndef SWIG_RcFileName
char *SWIG_RcFileName = "~/.myapprc";
#endif


#ifdef MAC_TCL
extern int		MacintoshInit _ANSI_ARGS_((void));
#endif

int Tcl_AppInit(Tcl_Interp *interp){

  if (Tcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  /* Now initialize our functions */

  if (SWIG_init(interp) == TCL_ERROR)
    return TCL_ERROR;
#if TCL_MAJOR_VERSION > 7 || TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION >= 5
   Tcl_SetVar(interp,"tcl_rcFileName",SWIG_RcFileName,TCL_GLOBAL_ONLY);
#else
   tcl_RcFileName = SWIG_RcFileName;
#endif
#ifdef SWIG_RcRsrcName
  Tcl_SetVar(interp,"tcl_rcRsrcName",SWIG_RcRsrcName,TCL_GLOBAL);
#endif

  return TCL_OK;
}

#if TCL_MAJOR_VERSION > 7 || TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION >= 4
int main(int argc, char **argv) {
#ifdef MAC_TCL
    char *newArgv[2];

    if (MacintoshInit()  != TCL_OK) {
	Tcl_Exit(1);
    }

    argc = 1;
    newArgv[0] = "tclsh";
    newArgv[1] = NULL;
    argv = newArgv;
#endif

  Tcl_Main(argc, argv, Tcl_AppInit);
  return(0);

}
#else
extern int main();
#endif

static int _wrap_crDestroy(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. crDestroy ",-1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibcr_destroy_global();
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_crMultiMaxGet(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. crMultiMaxGet ",-1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibcr_num_of_multi_max();
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_crRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint32_t * _arg1;
    char ** _arg2;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint32_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg2 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. crRead lid address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibcr_read_global(*_arg0,*_arg1,_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg2,strlen(*_arg2));
  if (*_arg2) free(*_arg2);
}
    return TCL_OK;
}
static int _wrap_crWrite(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint32_t * _arg1;
    uint32_t * _arg2;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint32_t  temp0;
    uint32_t  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. crWrite lid data address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibcr_write_global(*_arg0,*_arg1,*_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_crReadMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_cr_arr_t * _arg1;
    uint32_t * _arg2;
    char ** _arg3;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBCR_MULTI_MAX];
    uint32_t  temp1;

    clientData = clientData; objv = objv;
{
  _arg3 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. crReadMulti num lid_list address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);


    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBCR_MULTI_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp0[i] = strtoul(str, NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg1 = temp0;
    free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibcr_multi_read_global(*_arg0,_arg1,*_arg2,_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg3,strlen(*_arg3));
  if (*_arg3) free(*_arg3);
}
    return TCL_OK;
}
static int _wrap_crWriteMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_cr_arr_t * _arg1;
    uint32_t * _arg2;
    uint32_t * _arg3;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBCR_MULTI_MAX];
    uint32_t  temp1;
    uint32_t  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. crWriteMulti num lid_list data address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);


    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBCR_MULTI_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp0[i] = strtoul(str, NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg1 = temp0;
    free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibcr_multi_write_global(*_arg0,_arg1,*_arg2,*_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_pmMultiMaxGet(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. pmMultiMaxGet ",-1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibpm_num_of_multi_max();
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_pmGetPortCounters(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    char ** _arg2;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg2 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. pmGetPortCounters lid port_select ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibpm_get_counters_global(*_arg0,*_arg1,_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg2,strlen(*_arg2));
  if (*_arg2) free(*_arg2);
}
    return TCL_OK;
}
static int _wrap_pmGetPortCountersMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_pm_arr_t * _arg1;
    uint8_pm_arr_t * _arg2;
    char ** _arg3;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBPM_MULTI_MAX];
    uint8_t  temp1[IBPM_MULTI_MAX];

    clientData = clientData; objv = objv;
{
  _arg3 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. pmGetPortCountersMulti num lid_list port_select_list ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);

    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBPM_MULTI_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp0[i] = atoi(str);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg1 = temp0;
    free(loc_buf);
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[3],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBPM_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp1[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }

  _arg2 = temp1;
  free(loc_buf);

}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibpm_get_multi_counters_global(*_arg0,_arg1,_arg2,_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg3,strlen(*_arg3));
  if (*_arg3) free(*_arg3);
}
    return TCL_OK;
}
static int _wrap_pmGetExtPortCountersMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_pm_arr_t * _arg1;
    uint8_pm_arr_t * _arg2;
    char ** _arg3;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBPM_MULTI_MAX];
    uint8_t  temp1[IBPM_MULTI_MAX];

    clientData = clientData; objv = objv;
{
  _arg3 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. pmGetExtPortCountersMulti num lid_list port_select_list ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);

    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBPM_MULTI_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp0[i] = atoi(str);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg1 = temp0;
    free(loc_buf);
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[3],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBPM_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp1[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }

  _arg2 = temp1;
  free(loc_buf);

}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibpm_get_multi_counters_extended_global(*_arg0,_arg1,_arg2,_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg3,strlen(*_arg3));
  if (*_arg3) free(*_arg3);
}
    return TCL_OK;
}
static int _wrap_pmClrAllCounters(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. pmClrAllCounters lid port_select ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibpm_clr_all_counters_global(*_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_pmClrAllCountersMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_pm_arr_t * _arg1;
    uint8_pm_arr_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBPM_MULTI_MAX];
    uint8_t  temp1[IBPM_MULTI_MAX];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. pmClrAllCountersMulti num lid_list port_select_list ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);

    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBPM_MULTI_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp0[i] = atoi(str);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg1 = temp0;
    free(loc_buf);
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[3],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBPM_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp1[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }

  _arg2 = temp1;
  free(loc_buf);

}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibpm_clr_all_multi_counters_global(*_arg0,_arg1,_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsMultiMaxGet(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsMultiMaxGet ",-1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_num_of_multi_max();
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsCpuRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    uint32_t * _arg3;
    char ** _arg4;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;
    uint8_t  temp1;
    uint32_t  temp2;

    clientData = clientData; objv = objv;
{
  _arg4 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsCpuRead lid size cpu_traget_size address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_cpu_read_global(*_arg0,*_arg1,*_arg2,*_arg3,_arg4);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg4,strlen(*_arg4));
  if (*_arg4) free(*_arg4);
}
    return TCL_OK;
}
static int _wrap_vsCpuWrite(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    uint32_vs_data_arr_t * _arg3;
    uint32_t * _arg4;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;
    uint8_t  temp1;
    uint32_t  temp2[IBVS_DATA_MAX];
    uint32_t  temp3;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsCpuWrite lid size cpu_traget_size data address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[4],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);
    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBVS_DATA_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp2[i] = (uint32_t)strtoll(str, (char **)NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg3 = temp2;
    free(loc_buf);
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_cpu_write_global(*_arg0,*_arg1,*_arg2,_arg3,*_arg4);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsI2cRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    uint8_t * _arg3;
    uint32_t * _arg4;
    char ** _arg5;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;
    uint8_t  temp1;
    uint8_t  temp2;
    uint32_t  temp3;

    clientData = clientData; objv = objv;
{
  _arg5 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsI2cRead lid port_num device_id size address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_i2c_read_global(*_arg0,*_arg1,*_arg2,*_arg3,*_arg4,_arg5);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg5,strlen(*_arg5));
  if (*_arg5) free(*_arg5);
}
    return TCL_OK;
}
static int _wrap_vsI2cWrite(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    uint8_t * _arg3;
    uint32_t * _arg4;
    uint32_vs_data_arr_t * _arg5;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;
    uint8_t  temp1;
    uint8_t  temp2;
    uint32_t  temp3;
    uint32_t  temp4[IBVS_DATA_MAX];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 7) || (objc > 7)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsI2cWrite lid port_num device_id size address data ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[6],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);
    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBVS_DATA_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp4[i] = (uint32_t)strtoll(str, (char **)NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg5 = temp4;
    free(loc_buf);
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_i2c_write_global(*_arg0,*_arg1,*_arg2,*_arg3,*_arg4,_arg5);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsI2cReadMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint8_t * _arg2;
    uint8_t * _arg3;
    uint8_t * _arg4;
    uint32_t * _arg5;
    char ** _arg6;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint8_t  temp1;
    uint8_t  temp2;
    uint8_t  temp3;
    uint32_t  temp4;

    clientData = clientData; objv = objv;
{
  _arg6 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 7) || (objc > 7)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsI2cReadMulti num lid_list port_num device_id size address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
  temp4 = strtoul(Tcl_GetStringFromObj(objv[6],NULL), NULL, 0);
  _arg5 = &temp4;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_i2c_read_global(*_arg0,_arg1,*_arg2,*_arg3,*_arg4,*_arg5,_arg6);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg6,strlen(*_arg6));
  if (*_arg6) free(*_arg6);
}
    return TCL_OK;
}
static int _wrap_vsI2cWriteMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint8_t * _arg2;
    uint8_t * _arg3;
    uint8_t * _arg4;
    uint32_t * _arg5;
    uint32_vs_data_arr_t * _arg6;
    char ** _arg7;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint8_t  temp1;
    uint8_t  temp2;
    uint8_t  temp3;
    uint32_t  temp4;
    uint32_t  temp5[IBVS_DATA_MAX];

    clientData = clientData; objv = objv;
{
  _arg7 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 8) || (objc > 8)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsI2cWriteMulti num lid_list port_num device_id size address data ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
  temp4 = strtoul(Tcl_GetStringFromObj(objv[6],NULL), NULL, 0);
  _arg5 = &temp4;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[7],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);
    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBVS_DATA_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp5[i] = (uint32_t)strtoll(str, (char **)NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg6 = temp5;
    free(loc_buf);
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_i2c_write_global(*_arg0,_arg1,*_arg2,*_arg3,*_arg4,*_arg5,_arg6,_arg7);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg7,strlen(*_arg7));
  if (*_arg7) free(*_arg7);
}
    return TCL_OK;
}
static int _wrap_vsGpioRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    char ** _arg1;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;

    clientData = clientData; objv = objv;
{
  _arg1 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsGpioRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_gpio_read_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg1,strlen(*_arg1));
  if (*_arg1) free(*_arg1);
}
    return TCL_OK;
}
static int _wrap_vsGpioWrite(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint64_t * _arg1;
    uint64_t * _arg2;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint64_t  temp0;
    uint64_t  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsGpioWrite lid gpio_mask gpio_data ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp0;
}
{
  temp1 = strtoull(Tcl_GetStringFromObj(objv[3],NULL), NULL,16);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_gpio_write_global(*_arg0,*_arg1,*_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsSWReset(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsSWReset num lid_list ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_sw_reset_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsFlashStartMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint32_t * _arg2;
    uint8_t * _arg3;
    uint32_t * _arg4;
    uint32_vs_data_arr_t * _arg5;
    char ** _arg6;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint32_t  temp1;
    uint8_t  temp2;
    uint32_t  temp3;
    uint32_t  temp4[IBVS_DATA_MAX];

    clientData = clientData; objv = objv;
{
  _arg6 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 7) || (objc > 7)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsFlashStartMulti num lid_list last size address data ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[6],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);
    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBVS_DATA_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp4[i] = (uint32_t)strtoll(str, (char **)NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg5 = temp4;
    free(loc_buf);
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_flash_open_global(*_arg0,_arg1,*_arg2,*_arg3,*_arg4,_arg5,_arg6);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg6,strlen(*_arg6));
  if (*_arg6) free(*_arg6);
}
    return TCL_OK;
}
static int _wrap_vsFlashStopMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint32_t * _arg2;
    char ** _arg3;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint32_t  temp1;

    clientData = clientData; objv = objv;
{
  _arg3 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsFlashStopMulti num lid_list force ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_flash_close_global(*_arg0,_arg1,*_arg2,_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg3,strlen(*_arg3));
  if (*_arg3) free(*_arg3);
}
    return TCL_OK;
}
static int _wrap_vsFlashSetBankMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint32_t * _arg2;
    char ** _arg3;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint32_t  temp1;

    clientData = clientData; objv = objv;
{
  _arg3 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsFlashSetBankMulti num lid_list address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_flash_set_bank_global(*_arg0,_arg1,*_arg2,_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg3,strlen(*_arg3));
  if (*_arg3) free(*_arg3);
}
    return TCL_OK;
}
static int _wrap_vsFlashEraseSectorMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint32_t * _arg2;
    char ** _arg3;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint32_t  temp1;

    clientData = clientData; objv = objv;
{
  _arg3 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsFlashEraseSectorMulti num lid_list address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_flash_erase_global(*_arg0,_arg1,*_arg2,_arg3);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg3,strlen(*_arg3));
  if (*_arg3) free(*_arg3);
}
    return TCL_OK;
}
static int _wrap_vsFlashReadSectorMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint8_t * _arg2;
    uint32_t * _arg3;
    char ** _arg4;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint8_t  temp1;
    uint32_t  temp2;

    clientData = clientData; objv = objv;
{
  _arg4 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsFlashReadSectorMulti num lid_list size address ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_flash_read_global(*_arg0,_arg1,*_arg2,*_arg3,_arg4);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg4,strlen(*_arg4));
  if (*_arg4) free(*_arg4);
}
    return TCL_OK;
}
static int _wrap_vsFlashWriteSectorMulti(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    uint16_vs_arr_t * _arg1;
    uint8_t * _arg2;
    uint32_t * _arg3;
    uint32_vs_data_arr_t * _arg4;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0[IBVS_MULTI_MAX];
    uint8_t  temp1;
    uint32_t  temp2;
    uint32_t  temp3[IBVS_DATA_MAX];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsFlashWriteSectorMulti num lid_list size address data ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  char *str;
  char *str_tcl;
  int i;
  char *loc_buf;
  char *str_token;

  str_tcl = Tcl_GetStringFromObj(objv[2],NULL);
  loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
  strcpy(loc_buf,str_tcl);

  str = strtok_r(loc_buf," ", &str_token);
  for (i=0;i<IBVS_MULTI_MAX;i++) {
    if (str == NULL) {
      break;
    }
    temp0[i] = atoi(str);
    str = strtok_r(NULL," ",&str_token);
  }
  _arg1 = temp0;
  free(loc_buf);
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
    char *str;
    char *str_tcl;
    int i;
    char *loc_buf;
    char *str_token;

    str_tcl = Tcl_GetStringFromObj(objv[5],NULL);
    loc_buf = (char *)malloc((strlen(str_tcl)+1)*sizeof(char));
    strcpy(loc_buf,str_tcl);
    str = strtok_r(loc_buf," ", &str_token);
    for (i=0;i<IBVS_DATA_MAX;i++) {
	if (str == NULL) {
	    break;
	}
	temp3[i] = (uint32_t)strtoll(str, (char **)NULL, 0);
	str = strtok_r(NULL," ",&str_token);
    }
    _arg4 = temp3;
    free(loc_buf);
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_multi_flash_write_global(*_arg0,_arg1,*_arg2,*_arg3,_arg4);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsMirrorRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    char ** _arg1;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;

    clientData = clientData; objv = objv;
{
  _arg1 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsMirrorRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_mirror_read_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg1,strlen(*_arg1));
  if (*_arg1) free(*_arg1);
}
    return TCL_OK;
}
static int _wrap_vsMirrorWrite(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint32_t * _arg1;
    uint32_t * _arg2;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint32_t  temp0;
    uint32_t  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsMirrorWrite lid rx_mirror tx_mirror ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_mirror_write_global(*_arg0,*_arg1,*_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_vsGetGeneralInfo(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    char ** _arg1;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;

    clientData = clientData; objv = objv;
{
  _arg1 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsGetGeneralInfo lid ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_general_info_get_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg1,strlen(*_arg1));
  if (*_arg1) free(*_arg1);
}
    return TCL_OK;
}
static int _wrap_vsGetPrivateLFTMap(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    char ** _arg2;
    char * p_c;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg2 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. vsGetPrivateLFTMap lid upper_ports ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibvs_plft_map_get_global(*_arg0,*_arg1,_arg2);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result,*_arg2,strlen(*_arg2));
  if (*_arg2) free(*_arg2);
}
    return TCL_OK;
}
static int _wrap_bbmVpdRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    uint16_t * _arg2;
    uint16_t * _arg3;
    ib_bbm_vpd_t * _arg4;
    ib_bbm_vpd_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;
    uint8_t  temp1;
    uint16_t  temp2;
    uint16_t  temp3;

    clientData = clientData; objv = objv;
{
  _arg4 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmVpdRead lid vpd_device_selector bytes_num offset ",-1);
        return TCL_ERROR;
    }
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp3;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_read_vpd_global(*_arg0,*_arg1,*_arg2,*_arg3,_arg4);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (_arg4) {
         static char buff[1624];
	 static int i;
	 sprintf(buff, "{b_key 0x%016" PRIx64 "} {bm_sequence 0x%x } {device_sel 0x%x } {bytes_num 0x%x } {offset 0x%x }",
                        cl_ntoh64(_arg4->b_key),
                        cl_ntoh16(_arg4->bm_sequence),
			(_arg4->vpd_device_selector),
			cl_ntoh16(_arg4->bytes_num),
			cl_ntoh16(_arg4->offset));
         for (i=0;i<cl_ntoh16(_arg4->bytes_num);i++) {
         	sprintf(buff,"%s {data%u 0x%x} ",buff,i,_arg4->data[i]);
         };

         Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  } else {
         Tcl_SetStringObj(tcl_result, "", 0);
  }
}
    return TCL_OK;
}
static int _wrap_bbmVpdWrite(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    uint8_t * _arg1;
    uint16_t * _arg2;
    uint16_t * _arg3;
    uint8_t * _arg4;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;
    uint16_t  temp1;
    uint16_t  temp2;
    uint8_t  temp3;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmVpdWrite lid vpd_device_selector bytes_num offset p_data ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  temp2 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp2;
}
{
  temp3 = strtoul(Tcl_GetStringFromObj(objv[5],NULL), NULL, 0);
  _arg4 = &temp3;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_write_vpd_global(*_arg0,*_arg1,*_arg2,*_arg3,_arg4);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_bbmVSDRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    ib_bbm_bsn_vpd_t * _arg1;
    ib_bbm_bsn_vpd_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg1 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmVSDRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_read_bsn_vpd_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (_arg1) {
         static char buff[512];
	 static int j;
	 sprintf(buff, "{b_key 0x%016" PRIx64 "} {bm_sequence 0x%x} {device_sel 0x%x} {bytes_num 0x%x} {offset 0x%x}",
                        cl_ntoh64(_arg1->b_key),
                        cl_ntoh16(_arg1->bm_sequence),
			(_arg1->vpd_device_selector),
		        cl_ntoh16(_arg1->bytes_num),
			cl_ntoh16(_arg1->offset));
	 for (j=0;j<IBBBM_BSN_VPD_SIZE;j++) {
		sprintf(buff,"%s {bsn%u 0x%x} ",buff,j,_arg1->bsn[j]);
	 };

         Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  } else {
         Tcl_SetStringObj(tcl_result, "", 0);
  }
}
    return TCL_OK;
}
static int _wrap_bbmBSNRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    ib_bbm_bsn_vpd_t * _arg1;
    ib_bbm_bsn_vpd_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg1 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmBSNRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_read_bsn_vpd_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (_arg1) {
         static char buff[512];
	 static int j;
	 sprintf(buff, "{b_key 0x%016" PRIx64 "} {bm_sequence 0x%x} {device_sel 0x%x} {bytes_num 0x%x} {offset 0x%x}",
                        cl_ntoh64(_arg1->b_key),
                        cl_ntoh16(_arg1->bm_sequence),
			(_arg1->vpd_device_selector),
		        cl_ntoh16(_arg1->bytes_num),
			cl_ntoh16(_arg1->offset));
	 for (j=0;j<IBBBM_BSN_VPD_SIZE;j++) {
		sprintf(buff,"%s {bsn%u 0x%x} ",buff,j,_arg1->bsn[j]);
	 };

         Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  } else {
         Tcl_SetStringObj(tcl_result, "", 0);
  }
}
    return TCL_OK;
}
static int _wrap_bbmModRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    ib_bbm_mod_vpd_t * _arg1;
    ib_bbm_mod_vpd_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg1 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmModRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_read_mod_vpd_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (_arg1) {
         static char buff[1624];
	 static int i;
	 sprintf(buff, "{b_key 0x%016" PRIx64 "} {bm_sequence 0x%x } {device_sel 0x%x } {bytes_num 0x%x } {offset 0x%x } {temp_sensor_count 0x%x }",
                        cl_ntoh64(_arg1->b_key),
                        cl_ntoh16(_arg1->bm_sequence),
			(_arg1->vpd_device_selector),
			cl_ntoh16(_arg1->bytes_num),
			cl_ntoh16(_arg1->offset),
			_arg1->temp_sensor_count);

         for (i=0;i<IBBBM_MOD_VPD_TEMP_SIZE;i++) {
         	sprintf(buff,"%s {temp%u 0x%x} ",buff,i+1,cl_ntoh16(_arg1->temp_sensor_record[i]));
         };

	 sprintf(buff,"%s {power_sup_count 0x%x} ",buff,_arg1->power_sup_count);

	 for (i=0;i<IBBBM_MOD_VPD_PWR_SIZE;i++) {
         	sprintf(buff,"%s {power%u 0x%x} ",buff,i+1,cl_ntoh32(_arg1->power_sup_record[i]));
         };

         Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  } else {
         Tcl_SetStringObj(tcl_result, "", 0);
  }
}
    return TCL_OK;
}
static int _wrap_bbmChaRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    ib_bbm_cha_vpd_t * _arg1;
    ib_bbm_cha_vpd_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg1 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmChaRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_read_cha_vpd_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (_arg1) {
         static char buff[1624];
	 static int i;
	 sprintf(buff, "{b_key 0x%016" PRIx64 "} {bm_sequence 0x%x } {device_sel 0x%x } {bytes_num 0x%x } {offset 0x%x } {temp_sensor_count 0x%x }",
                        cl_ntoh64(_arg1->b_key),
                        cl_ntoh16(_arg1->bm_sequence),
			(_arg1->vpd_device_selector),
		        cl_ntoh16(_arg1->bytes_num),
			cl_ntoh16(_arg1->offset),
			_arg1->temp_sensor_count);

	 for (i=0;i<IBBBM_CHA_VPD_TEMP_SIZE;i++) {
         	sprintf(buff,"%s {temp%u 0x%x} ",buff,i+1,cl_ntoh16(_arg1->temp_sensor_record[i]));
         };

	 sprintf(buff,"%s {power_sup_count 0x%x} ",buff,_arg1->power_sup_count);

	 for (i=0;i<IBBBM_CHA_VPD_PWR_SIZE;i++) {
         	sprintf(buff,"%s {power%u 0x%x} ",buff,i+1,cl_ntoh32(_arg1->power_sup_record[i]));
         };

	 sprintf(buff,"%s {fan_count 0x%x} ",buff,_arg1->fan_count);

   	 for (i=0;i<IBBBM_CHA_VPD_FAN_SIZE;i++) {
         	sprintf(buff,"%s {fan%u 0x%x} ",buff,i+1,cl_ntoh16(_arg1->fan_record[i]));
         };

         Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  } else {
         Tcl_SetStringObj(tcl_result, "", 0);
  }
}
    return TCL_OK;
}
static int _wrap_bbmFWVerRead(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint16_t * _arg0;
    ib_bbm_fw_ver_vpd_t * _arg1;
    ib_bbm_fw_ver_vpd_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg1 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. bbmFWVerRead lid ",-1);
        return TCL_ERROR;
    }
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp0;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibbbm_read_fw_ver_vpd_global(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (_arg1) {
         static char buff[512];
	 sprintf(buff, "{b_key 0x%016" PRIx64 "} {bm_sequence 0x%x} {device_sel 0x%x} {bytes_num 0x%x} {offset 0x%x} {maj_fw_ver 0x%x} {min_fw_ver 0x%x} {sub_min_fw_ver 0x%x}",
                        cl_ntoh64(_arg1->b_key),
                        cl_ntoh16(_arg1->bm_sequence),
			(_arg1->vpd_device_selector),
		        cl_ntoh16(_arg1->bytes_num),
			cl_ntoh16(_arg1->offset),
			_arg1->maj_fw_ver,
			_arg1->min_fw_ver,
			_arg1->sub_min_fw_ver);

         Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  } else {
         Tcl_SetStringObj(tcl_result, "", 0);
  }
}
    return TCL_OK;
}
static int _wrap_ibis_puts(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint8_t * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_puts verbosity msg ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )ibis_puts(*_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibis_init(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_init ",-1);
        return TCL_ERROR;
    }
    _result = (int )ibis_ui_init();
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibis_set_verbosity(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    int  _arg0;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_set_verbosity level ",-1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[1],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg0 = (int ) tempint;
    _result = (int )ibis_set_verbosity(_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibis_set_port(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint64_t * _arg0;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_set_port guid ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[1],NULL), NULL,16);
  _arg0 = &temp;
}
    _result = (int )ibis_set_port(*_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibis_get_port(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_get_port ",-1);
        return TCL_ERROR;
    }
    _result = (new_uint64_t *) malloc(sizeof(new_uint64_t ));
    *(_result) = ibis_get_port();
    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  free( _result );
}
    return TCL_OK;
}
static int _wrap_ibis_set_transaction_timeout(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    uint32_t * _arg0;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_set_transaction_timeout timeout_ms ",-1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[1],NULL), NULL, 0);
  _arg0 = &temp;
}
    _result = (int )ibis_set_transaction_timeout(*_arg0);
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibis_exit(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibis_exit ",-1);
        return TCL_ERROR;
    }
    _result = (int )ibis_ui_destroy();
    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define _ib_node_info_base_version_set(_swigobj,_swigval) (_swigobj->base_version = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_base_version_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_base_version_set { sacNodeInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_base_version_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_base_version_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_base_version_get(_swigobj) (&_swigobj->base_version)
static int _wrap_sacNodeInfo_base_version_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_base_version_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_base_version_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_base_version_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_class_version_set(_swigobj,_swigval) (_swigobj->class_version = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_class_version_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_class_version_set { sacNodeInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_class_version_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_class_version_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_class_version_get(_swigobj) (&_swigobj->class_version)
static int _wrap_sacNodeInfo_class_version_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_class_version_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_class_version_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_class_version_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_type_set(_swigobj,_swigval) (_swigobj->node_type = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_node_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_node_type_set { sacNodeInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_node_type_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_node_type_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_type_get(_swigobj) (&_swigobj->node_type)
static int _wrap_sacNodeInfo_node_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_node_type_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_node_type_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_node_type_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_num_ports_set(_swigobj,_swigval) (_swigobj->num_ports = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_num_ports_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_num_ports_set { sacNodeInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_num_ports_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_num_ports_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_num_ports_get(_swigobj) (&_swigobj->num_ports)
static int _wrap_sacNodeInfo_num_ports_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_num_ports_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_num_ports_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_num_ports_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_sys_guid_set(_swigobj,_swigval) (_swigobj->sys_guid = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_sys_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacNodeInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_sys_guid_set { sacNodeInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_sys_guid_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_sys_guid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_sys_guid_get(_swigobj) (&_swigobj->sys_guid)
static int _wrap_sacNodeInfo_sys_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_sys_guid_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_sys_guid_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_sys_guid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_guid_set(_swigobj,_swigval) (_swigobj->node_guid = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_node_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacNodeInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_node_guid_set { sacNodeInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_node_guid_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_node_guid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_guid_get(_swigobj) (&_swigobj->node_guid)
static int _wrap_sacNodeInfo_node_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_node_guid_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_node_guid_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_node_guid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_guid_set(_swigobj,_swigval) (_swigobj->port_guid = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_port_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacNodeInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_port_guid_set { sacNodeInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_port_guid_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_port_guid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_guid_get(_swigobj) (&_swigobj->port_guid)
static int _wrap_sacNodeInfo_port_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_port_guid_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_port_guid_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_port_guid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_partition_cap_set(_swigobj,_swigval) (_swigobj->partition_cap = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_partition_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacNodeInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_partition_cap_set { sacNodeInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_partition_cap_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_partition_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_partition_cap_get(_swigobj) (&_swigobj->partition_cap)
static int _wrap_sacNodeInfo_partition_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_partition_cap_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_partition_cap_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_partition_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_device_id_set(_swigobj,_swigval) (_swigobj->device_id = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_device_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacNodeInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_device_id_set { sacNodeInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_device_id_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_device_id_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_device_id_get(_swigobj) (&_swigobj->device_id)
static int _wrap_sacNodeInfo_device_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_device_id_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_device_id_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_device_id_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_revision_set(_swigobj,_swigval) (_swigobj->revision = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_revision_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacNodeInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_revision_set { sacNodeInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_revision_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_revision_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_revision_get(_swigobj) (&_swigobj->revision)
static int _wrap_sacNodeInfo_revision_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_revision_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_revision_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_revision_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_num_vendor_id_set(_swigobj,_swigval) (_swigobj->port_num_vendor_id = *(_swigval),_swigval)
static int _wrap_sacNodeInfo_port_num_vendor_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacNodeInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_port_num_vendor_id_set { sacNodeInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_port_num_vendor_id_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_port_num_vendor_id_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_num_vendor_id_get(_swigobj) (&_swigobj->port_num_vendor_id)
static int _wrap_sacNodeInfo_port_num_vendor_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_port_num_vendor_id_get { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_port_num_vendor_id_get. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_port_num_vendor_id_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static void  sacNodeInfo_delete(sacNodeInfo *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacNodeInfo_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacNodeInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeInfo_delete { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeInfo_delete. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacNodeInfo_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacNodeInfoMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacNodeInfo methods : { dump cget configure delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacNodeInfo_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacNodeInfo_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-base_version") == 0) {
                    cmd = _wrap_sacNodeInfo_base_version_set;
                }  else if (strcmp(_str,"-class_version") == 0) {
                    cmd = _wrap_sacNodeInfo_class_version_set;
                }  else if (strcmp(_str,"-node_type") == 0) {
                    cmd = _wrap_sacNodeInfo_node_type_set;
                }  else if (strcmp(_str,"-num_ports") == 0) {
                    cmd = _wrap_sacNodeInfo_num_ports_set;
                }  else if (strcmp(_str,"-sys_guid") == 0) {
                    cmd = _wrap_sacNodeInfo_sys_guid_set;
                }  else if (strcmp(_str,"-node_guid") == 0) {
                    cmd = _wrap_sacNodeInfo_node_guid_set;
                }  else if (strcmp(_str,"-port_guid") == 0) {
                    cmd = _wrap_sacNodeInfo_port_guid_set;
                }  else if (strcmp(_str,"-partition_cap") == 0) {
                    cmd = _wrap_sacNodeInfo_partition_cap_set;
                }  else if (strcmp(_str,"-device_id") == 0) {
                    cmd = _wrap_sacNodeInfo_device_id_set;
                }  else if (strcmp(_str,"-revision") == 0) {
                    cmd = _wrap_sacNodeInfo_revision_set;
                }  else if (strcmp(_str,"-port_num_vendor_id") == 0) {
                    cmd = _wrap_sacNodeInfo_port_num_vendor_id_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-base_version") == 0) {
                    cmd = _wrap_sacNodeInfo_base_version_get;
                }  else if (strcmp(_str,"-class_version") == 0) {
                    cmd = _wrap_sacNodeInfo_class_version_get;
                }  else if (strcmp(_str,"-node_type") == 0) {
                    cmd = _wrap_sacNodeInfo_node_type_get;
                }  else if (strcmp(_str,"-num_ports") == 0) {
                    cmd = _wrap_sacNodeInfo_num_ports_get;
                }  else if (strcmp(_str,"-sys_guid") == 0) {
                    cmd = _wrap_sacNodeInfo_sys_guid_get;
                }  else if (strcmp(_str,"-node_guid") == 0) {
                    cmd = _wrap_sacNodeInfo_node_guid_get;
                }  else if (strcmp(_str,"-port_guid") == 0) {
                    cmd = _wrap_sacNodeInfo_port_guid_get;
                }  else if (strcmp(_str,"-partition_cap") == 0) {
                    cmd = _wrap_sacNodeInfo_partition_cap_get;
                }  else if (strcmp(_str,"-device_id") == 0) {
                    cmd = _wrap_sacNodeInfo_device_id_get;
                }  else if (strcmp(_str,"-revision") == 0) {
                    cmd = _wrap_sacNodeInfo_revision_get;
                }  else if (strcmp(_str,"-port_num_vendor_id") == 0) {
                    cmd = _wrap_sacNodeInfo_port_num_vendor_id_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacNodeInfo_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacNodeInfo_base_version_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_version ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_class_version_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-class_version ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_node_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_num_ports_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-num_ports ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_sys_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-sys_guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_node_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_port_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_partition_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-partition_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_device_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-device_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_revision_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-revision ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeInfo_port_num_vendor_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_num_vendor_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacNodeInfoCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacNodeInfo * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacNodeInfo_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacNodeInfo_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacNodeInfo object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacNodeInfoMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_node_record_t_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_sacNodeRec_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacNodeRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_lid_set { sacNodeRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_lid_set. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_record_t_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_record_t_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_sacNodeRec_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacNodeRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_lid_get { sacNodeRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_lid_get. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_record_t_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_record_t_node_info_set(_swigobj,_swigval) (_swigobj->node_info = *(_swigval),_swigval)
static int _wrap_sacNodeRec_node_info_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacNodeInfo * _result;
    sacNodeRec * _arg0;
    sacNodeInfo * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_node_info_set { sacNodeRec * } { sacNodeInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_node_info_set. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_sacNodeInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of sacNodeRec_node_info_set. Expected _sacNodeInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacNodeInfo *)_ib_node_record_t_node_info_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacNodeInfo_p");
    return TCL_OK;
}
#define _ib_node_record_t_node_info_get(_swigobj) (&_swigobj->node_info)
static int _wrap_sacNodeRec_node_info_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacNodeInfo * _result;
    sacNodeRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_node_info_get { sacNodeRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_node_info_get. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacNodeInfo *)_ib_node_record_t_node_info_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacNodeInfo_p");
    return TCL_OK;
}
#define _ib_node_record_t_node_desc_set(_swigobj,_swigval) (_swigobj->node_desc = *(_swigval),_swigval)
static int _wrap_sacNodeRec_node_desc_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_node_desc_t * _result;
    sacNodeRec * _arg0;
    ib_node_desc_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_node_desc_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_node_desc_set { sacNodeRec * } { ib_node_desc_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_node_desc_set. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  strcpy((char *)temp.description, Tcl_GetStringFromObj(objv[2],NULL));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_node_desc_t *)_ib_node_record_t_node_desc_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  /* we must make sure we do not overflow the node desc length */
  char buff[IB_NODE_DESCRIPTION_SIZE];
  strncpy(buff,(char *)_result,IB_NODE_DESCRIPTION_SIZE - 1);
  buff[IB_NODE_DESCRIPTION_SIZE - 1] = '\0';
  Tcl_SetStringObj(tcl_result, buff, strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_record_t_node_desc_get(_swigobj) (&_swigobj->node_desc)
static int _wrap_sacNodeRec_node_desc_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_node_desc_t * _result;
    sacNodeRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_node_desc_get { sacNodeRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_node_desc_get. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_node_desc_t *)_ib_node_record_t_node_desc_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  /* we must make sure we do not overflow the node desc length */
  char buff[IB_NODE_DESCRIPTION_SIZE];
  strncpy(buff,(char *)_result,IB_NODE_DESCRIPTION_SIZE - 1);
  buff[IB_NODE_DESCRIPTION_SIZE - 1] = '\0';
  Tcl_SetStringObj(tcl_result, buff, strlen(buff));
}
    return TCL_OK;
}
static char * sacNodeRec_get(sacNodeRec *self,uint64_t  comp_mask) {
	 return(ibsacNodeRecordQuery(self, cl_hton64(comp_mask),
                                IB_MAD_METHOD_GET));
  }
static int _wrap_sacNodeRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacNodeRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_get { sacNodeRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_get. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacNodeRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacNodeRec_getTable(sacNodeRec *self,uint64_t  comp_mask) {
	 return(ibsacNodeRecordQuery(self, cl_hton64(comp_mask),
                                IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacNodeRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacNodeRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_getTable { sacNodeRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_getTable. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacNodeRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacNodeRec_delete(sacNodeRec *self) {
	 /* we need to de-register both the node info and node record */
	 SWIG_AltMnglUnregObj(&(self->node_info));
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacNodeRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacNodeRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacNodeRec_delete { sacNodeRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacNodeRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacNodeRec_delete. Expected _sacNodeRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacNodeRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacNodeRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacNodeRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacNodeRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacNodeRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacNodeRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacNodeRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacNodeRec_lid_set;
                }  else if (strcmp(_str,"-node_info") == 0) {
                    cmd = _wrap_sacNodeRec_node_info_set;
                }  else if (strcmp(_str,"-node_desc") == 0) {
                    cmd = _wrap_sacNodeRec_node_desc_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -node_info -node_desc  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -node_info -node_desc  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacNodeRec_lid_get;
                }  else if (strcmp(_str,"-node_info") == 0) {
                    cmd = _wrap_sacNodeRec_node_info_get;
                }  else if (strcmp(_str,"-node_desc") == 0) {
                    cmd = _wrap_sacNodeRec_node_desc_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacNodeRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -node_info -node_desc  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -node_info -node_desc  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacNodeRec_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeRec_node_info_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_info ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacNodeRec_node_desc_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_desc ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacNodeRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacNodeRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacNodeRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacNodeRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacNodeRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacNodeRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_port_info_m_key_set(_swigobj,_swigval) (_swigobj->m_key = *(_swigval),_swigval)
static int _wrap_sacPortInfo_m_key_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacPortInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_m_key_set { sacPortInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_m_key_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_m_key_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_get(_swigobj) (&_swigobj->m_key)
static int _wrap_sacPortInfo_m_key_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_m_key_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_m_key_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_m_key_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_prefix_set(_swigobj,_swigval) (_swigobj->subnet_prefix = *(_swigval),_swigval)
static int _wrap_sacPortInfo_subnet_prefix_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacPortInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_subnet_prefix_set { sacPortInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_subnet_prefix_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_subnet_prefix_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_prefix_get(_swigobj) (&_swigobj->subnet_prefix)
static int _wrap_sacPortInfo_subnet_prefix_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_subnet_prefix_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_subnet_prefix_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_subnet_prefix_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_base_lid_set(_swigobj,_swigval) (_swigobj->base_lid = *(_swigval),_swigval)
static int _wrap_sacPortInfo_base_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_base_lid_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_base_lid_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_base_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_base_lid_get(_swigobj) (&_swigobj->base_lid)
static int _wrap_sacPortInfo_base_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_base_lid_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_base_lid_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_base_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_master_sm_base_lid_set(_swigobj,_swigval) (_swigobj->master_sm_base_lid = *(_swigval),_swigval)
static int _wrap_sacPortInfo_master_sm_base_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_master_sm_base_lid_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_master_sm_base_lid_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_master_sm_base_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_master_sm_base_lid_get(_swigobj) (&_swigobj->master_sm_base_lid)
static int _wrap_sacPortInfo_master_sm_base_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_master_sm_base_lid_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_master_sm_base_lid_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_master_sm_base_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_capability_mask_set(_swigobj,_swigval) (_swigobj->capability_mask = *(_swigval),_swigval)
static int _wrap_sacPortInfo_capability_mask_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_capability_mask_set { sacPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_capability_mask_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_port_info_capability_mask_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_capability_mask_get(_swigobj) (&_swigobj->capability_mask)
static int _wrap_sacPortInfo_capability_mask_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_capability_mask_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_capability_mask_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_port_info_capability_mask_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_diag_code_set(_swigobj,_swigval) (_swigobj->diag_code = *(_swigval),_swigval)
static int _wrap_sacPortInfo_diag_code_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_diag_code_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_diag_code_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_diag_code_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_diag_code_get(_swigobj) (&_swigobj->diag_code)
static int _wrap_sacPortInfo_diag_code_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_diag_code_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_diag_code_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_diag_code_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_lease_period_set(_swigobj,_swigval) (_swigobj->m_key_lease_period = *(_swigval),_swigval)
static int _wrap_sacPortInfo_m_key_lease_period_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_m_key_lease_period_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_m_key_lease_period_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_lease_period_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_lease_period_get(_swigobj) (&_swigobj->m_key_lease_period)
static int _wrap_sacPortInfo_m_key_lease_period_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_m_key_lease_period_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_m_key_lease_period_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_lease_period_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_local_port_num_set(_swigobj,_swigval) (_swigobj->local_port_num = *(_swigval),_swigval)
static int _wrap_sacPortInfo_local_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_local_port_num_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_local_port_num_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_local_port_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_local_port_num_get(_swigobj) (&_swigobj->local_port_num)
static int _wrap_sacPortInfo_local_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_local_port_num_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_local_port_num_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_local_port_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_enabled_set(_swigobj,_swigval) (_swigobj->link_width_enabled = *(_swigval),_swigval)
static int _wrap_sacPortInfo_link_width_enabled_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_width_enabled_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_width_enabled_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_enabled_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_enabled_get(_swigobj) (&_swigobj->link_width_enabled)
static int _wrap_sacPortInfo_link_width_enabled_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_width_enabled_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_width_enabled_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_enabled_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_supported_set(_swigobj,_swigval) (_swigobj->link_width_supported = *(_swigval),_swigval)
static int _wrap_sacPortInfo_link_width_supported_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_width_supported_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_width_supported_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_supported_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_supported_get(_swigobj) (&_swigobj->link_width_supported)
static int _wrap_sacPortInfo_link_width_supported_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_width_supported_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_width_supported_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_supported_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_active_set(_swigobj,_swigval) (_swigobj->link_width_active = *(_swigval),_swigval)
static int _wrap_sacPortInfo_link_width_active_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_width_active_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_width_active_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_active_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_active_get(_swigobj) (&_swigobj->link_width_active)
static int _wrap_sacPortInfo_link_width_active_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_width_active_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_width_active_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_active_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info1_set(_swigobj,_swigval) (_swigobj->state_info1 = *(_swigval),_swigval)
static int _wrap_sacPortInfo_state_info1_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_state_info1_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_state_info1_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info1_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info1_get(_swigobj) (&_swigobj->state_info1)
static int _wrap_sacPortInfo_state_info1_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_state_info1_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_state_info1_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info1_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info2_set(_swigobj,_swigval) (_swigobj->state_info2 = *(_swigval),_swigval)
static int _wrap_sacPortInfo_state_info2_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_state_info2_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_state_info2_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info2_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info2_get(_swigobj) (&_swigobj->state_info2)
static int _wrap_sacPortInfo_state_info2_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_state_info2_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_state_info2_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info2_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mkey_lmc_set(_swigobj,_swigval) (_swigobj->mkey_lmc = *(_swigval),_swigval)
static int _wrap_sacPortInfo_mkey_lmc_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_mkey_lmc_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_mkey_lmc_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mkey_lmc_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mkey_lmc_get(_swigobj) (&_swigobj->mkey_lmc)
static int _wrap_sacPortInfo_mkey_lmc_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_mkey_lmc_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_mkey_lmc_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mkey_lmc_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_speed_set(_swigobj,_swigval) (_swigobj->link_speed = *(_swigval),_swigval)
static int _wrap_sacPortInfo_link_speed_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_speed_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_speed_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_speed_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_speed_get(_swigobj) (&_swigobj->link_speed)
static int _wrap_sacPortInfo_link_speed_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_link_speed_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_link_speed_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_speed_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_smsl_set(_swigobj,_swigval) (_swigobj->mtu_smsl = *(_swigval),_swigval)
static int _wrap_sacPortInfo_mtu_smsl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_mtu_smsl_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_mtu_smsl_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_smsl_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_smsl_get(_swigobj) (&_swigobj->mtu_smsl)
static int _wrap_sacPortInfo_mtu_smsl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_mtu_smsl_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_mtu_smsl_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_smsl_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_cap_set(_swigobj,_swigval) (_swigobj->vl_cap = *(_swigval),_swigval)
static int _wrap_sacPortInfo_vl_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_cap_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_cap_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_cap_get(_swigobj) (&_swigobj->vl_cap)
static int _wrap_sacPortInfo_vl_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_cap_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_cap_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_high_limit_set(_swigobj,_swigval) (_swigobj->vl_high_limit = *(_swigval),_swigval)
static int _wrap_sacPortInfo_vl_high_limit_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_high_limit_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_high_limit_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_high_limit_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_high_limit_get(_swigobj) (&_swigobj->vl_high_limit)
static int _wrap_sacPortInfo_vl_high_limit_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_high_limit_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_high_limit_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_high_limit_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_high_cap_set(_swigobj,_swigval) (_swigobj->vl_arb_high_cap = *(_swigval),_swigval)
static int _wrap_sacPortInfo_vl_arb_high_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_arb_high_cap_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_arb_high_cap_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_high_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_high_cap_get(_swigobj) (&_swigobj->vl_arb_high_cap)
static int _wrap_sacPortInfo_vl_arb_high_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_arb_high_cap_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_arb_high_cap_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_high_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_low_cap_set(_swigobj,_swigval) (_swigobj->vl_arb_low_cap = *(_swigval),_swigval)
static int _wrap_sacPortInfo_vl_arb_low_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_arb_low_cap_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_arb_low_cap_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_low_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_low_cap_get(_swigobj) (&_swigobj->vl_arb_low_cap)
static int _wrap_sacPortInfo_vl_arb_low_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_arb_low_cap_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_arb_low_cap_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_low_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_cap_set(_swigobj,_swigval) (_swigobj->mtu_cap = *(_swigval),_swigval)
static int _wrap_sacPortInfo_mtu_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_mtu_cap_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_mtu_cap_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_cap_get(_swigobj) (&_swigobj->mtu_cap)
static int _wrap_sacPortInfo_mtu_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_mtu_cap_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_mtu_cap_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_stall_life_set(_swigobj,_swigval) (_swigobj->vl_stall_life = *(_swigval),_swigval)
static int _wrap_sacPortInfo_vl_stall_life_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_stall_life_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_stall_life_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_stall_life_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_stall_life_get(_swigobj) (&_swigobj->vl_stall_life)
static int _wrap_sacPortInfo_vl_stall_life_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_stall_life_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_stall_life_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_stall_life_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_enforce_set(_swigobj,_swigval) (_swigobj->vl_enforce = *(_swigval),_swigval)
static int _wrap_sacPortInfo_vl_enforce_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_enforce_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_enforce_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_enforce_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_enforce_get(_swigobj) (&_swigobj->vl_enforce)
static int _wrap_sacPortInfo_vl_enforce_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_vl_enforce_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_vl_enforce_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_enforce_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_violations_set(_swigobj,_swigval) (_swigobj->m_key_violations = *(_swigval),_swigval)
static int _wrap_sacPortInfo_m_key_violations_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_m_key_violations_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_m_key_violations_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_violations_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_violations_get(_swigobj) (&_swigobj->m_key_violations)
static int _wrap_sacPortInfo_m_key_violations_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_m_key_violations_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_m_key_violations_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_violations_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_p_key_violations_set(_swigobj,_swigval) (_swigobj->p_key_violations = *(_swigval),_swigval)
static int _wrap_sacPortInfo_p_key_violations_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_p_key_violations_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_p_key_violations_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_p_key_violations_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_p_key_violations_get(_swigobj) (&_swigobj->p_key_violations)
static int _wrap_sacPortInfo_p_key_violations_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_p_key_violations_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_p_key_violations_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_p_key_violations_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_q_key_violations_set(_swigobj,_swigval) (_swigobj->q_key_violations = *(_swigval),_swigval)
static int _wrap_sacPortInfo_q_key_violations_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_q_key_violations_set { sacPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_q_key_violations_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_q_key_violations_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_q_key_violations_get(_swigobj) (&_swigobj->q_key_violations)
static int _wrap_sacPortInfo_q_key_violations_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_q_key_violations_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_q_key_violations_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_q_key_violations_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_guid_cap_set(_swigobj,_swigval) (_swigobj->guid_cap = *(_swigval),_swigval)
static int _wrap_sacPortInfo_guid_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_guid_cap_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_guid_cap_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_guid_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_guid_cap_get(_swigobj) (&_swigobj->guid_cap)
static int _wrap_sacPortInfo_guid_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_guid_cap_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_guid_cap_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_guid_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_timeout_set(_swigobj,_swigval) (_swigobj->subnet_timeout = *(_swigval),_swigval)
static int _wrap_sacPortInfo_subnet_timeout_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_subnet_timeout_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_subnet_timeout_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_subnet_timeout_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_timeout_get(_swigobj) (&_swigobj->subnet_timeout)
static int _wrap_sacPortInfo_subnet_timeout_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_subnet_timeout_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_subnet_timeout_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_subnet_timeout_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_resp_time_value_set(_swigobj,_swigval) (_swigobj->resp_time_value = *(_swigval),_swigval)
static int _wrap_sacPortInfo_resp_time_value_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_resp_time_value_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_resp_time_value_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_resp_time_value_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_resp_time_value_get(_swigobj) (&_swigobj->resp_time_value)
static int _wrap_sacPortInfo_resp_time_value_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_resp_time_value_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_resp_time_value_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_resp_time_value_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_error_threshold_set(_swigobj,_swigval) (_swigobj->error_threshold = *(_swigval),_swigval)
static int _wrap_sacPortInfo_error_threshold_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_error_threshold_set { sacPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_error_threshold_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_error_threshold_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_error_threshold_get(_swigobj) (&_swigobj->error_threshold)
static int _wrap_sacPortInfo_error_threshold_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_error_threshold_get { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_error_threshold_get. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_error_threshold_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static void  sacPortInfo_delete(sacPortInfo *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacPortInfo_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortInfo_delete { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortInfo_delete. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacPortInfo_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacPortInfoMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacPortInfo methods : { dump cget configure delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacPortInfo_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacPortInfo_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-m_key") == 0) {
                    cmd = _wrap_sacPortInfo_m_key_set;
                }  else if (strcmp(_str,"-subnet_prefix") == 0) {
                    cmd = _wrap_sacPortInfo_subnet_prefix_set;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_sacPortInfo_base_lid_set;
                }  else if (strcmp(_str,"-master_sm_base_lid") == 0) {
                    cmd = _wrap_sacPortInfo_master_sm_base_lid_set;
                }  else if (strcmp(_str,"-capability_mask") == 0) {
                    cmd = _wrap_sacPortInfo_capability_mask_set;
                }  else if (strcmp(_str,"-diag_code") == 0) {
                    cmd = _wrap_sacPortInfo_diag_code_set;
                }  else if (strcmp(_str,"-m_key_lease_period") == 0) {
                    cmd = _wrap_sacPortInfo_m_key_lease_period_set;
                }  else if (strcmp(_str,"-local_port_num") == 0) {
                    cmd = _wrap_sacPortInfo_local_port_num_set;
                }  else if (strcmp(_str,"-link_width_enabled") == 0) {
                    cmd = _wrap_sacPortInfo_link_width_enabled_set;
                }  else if (strcmp(_str,"-link_width_supported") == 0) {
                    cmd = _wrap_sacPortInfo_link_width_supported_set;
                }  else if (strcmp(_str,"-link_width_active") == 0) {
                    cmd = _wrap_sacPortInfo_link_width_active_set;
                }  else if (strcmp(_str,"-state_info1") == 0) {
                    cmd = _wrap_sacPortInfo_state_info1_set;
                }  else if (strcmp(_str,"-state_info2") == 0) {
                    cmd = _wrap_sacPortInfo_state_info2_set;
                }  else if (strcmp(_str,"-mkey_lmc") == 0) {
                    cmd = _wrap_sacPortInfo_mkey_lmc_set;
                }  else if (strcmp(_str,"-link_speed") == 0) {
                    cmd = _wrap_sacPortInfo_link_speed_set;
                }  else if (strcmp(_str,"-mtu_smsl") == 0) {
                    cmd = _wrap_sacPortInfo_mtu_smsl_set;
                }  else if (strcmp(_str,"-vl_cap") == 0) {
                    cmd = _wrap_sacPortInfo_vl_cap_set;
                }  else if (strcmp(_str,"-vl_high_limit") == 0) {
                    cmd = _wrap_sacPortInfo_vl_high_limit_set;
                }  else if (strcmp(_str,"-vl_arb_high_cap") == 0) {
                    cmd = _wrap_sacPortInfo_vl_arb_high_cap_set;
                }  else if (strcmp(_str,"-vl_arb_low_cap") == 0) {
                    cmd = _wrap_sacPortInfo_vl_arb_low_cap_set;
                }  else if (strcmp(_str,"-mtu_cap") == 0) {
                    cmd = _wrap_sacPortInfo_mtu_cap_set;
                }  else if (strcmp(_str,"-vl_stall_life") == 0) {
                    cmd = _wrap_sacPortInfo_vl_stall_life_set;
                }  else if (strcmp(_str,"-vl_enforce") == 0) {
                    cmd = _wrap_sacPortInfo_vl_enforce_set;
                }  else if (strcmp(_str,"-m_key_violations") == 0) {
                    cmd = _wrap_sacPortInfo_m_key_violations_set;
                }  else if (strcmp(_str,"-p_key_violations") == 0) {
                    cmd = _wrap_sacPortInfo_p_key_violations_set;
                }  else if (strcmp(_str,"-q_key_violations") == 0) {
                    cmd = _wrap_sacPortInfo_q_key_violations_set;
                }  else if (strcmp(_str,"-guid_cap") == 0) {
                    cmd = _wrap_sacPortInfo_guid_cap_set;
                }  else if (strcmp(_str,"-subnet_timeout") == 0) {
                    cmd = _wrap_sacPortInfo_subnet_timeout_set;
                }  else if (strcmp(_str,"-resp_time_value") == 0) {
                    cmd = _wrap_sacPortInfo_resp_time_value_set;
                }  else if (strcmp(_str,"-error_threshold") == 0) {
                    cmd = _wrap_sacPortInfo_error_threshold_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-m_key") == 0) {
                    cmd = _wrap_sacPortInfo_m_key_get;
                }  else if (strcmp(_str,"-subnet_prefix") == 0) {
                    cmd = _wrap_sacPortInfo_subnet_prefix_get;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_sacPortInfo_base_lid_get;
                }  else if (strcmp(_str,"-master_sm_base_lid") == 0) {
                    cmd = _wrap_sacPortInfo_master_sm_base_lid_get;
                }  else if (strcmp(_str,"-capability_mask") == 0) {
                    cmd = _wrap_sacPortInfo_capability_mask_get;
                }  else if (strcmp(_str,"-diag_code") == 0) {
                    cmd = _wrap_sacPortInfo_diag_code_get;
                }  else if (strcmp(_str,"-m_key_lease_period") == 0) {
                    cmd = _wrap_sacPortInfo_m_key_lease_period_get;
                }  else if (strcmp(_str,"-local_port_num") == 0) {
                    cmd = _wrap_sacPortInfo_local_port_num_get;
                }  else if (strcmp(_str,"-link_width_enabled") == 0) {
                    cmd = _wrap_sacPortInfo_link_width_enabled_get;
                }  else if (strcmp(_str,"-link_width_supported") == 0) {
                    cmd = _wrap_sacPortInfo_link_width_supported_get;
                }  else if (strcmp(_str,"-link_width_active") == 0) {
                    cmd = _wrap_sacPortInfo_link_width_active_get;
                }  else if (strcmp(_str,"-state_info1") == 0) {
                    cmd = _wrap_sacPortInfo_state_info1_get;
                }  else if (strcmp(_str,"-state_info2") == 0) {
                    cmd = _wrap_sacPortInfo_state_info2_get;
                }  else if (strcmp(_str,"-mkey_lmc") == 0) {
                    cmd = _wrap_sacPortInfo_mkey_lmc_get;
                }  else if (strcmp(_str,"-link_speed") == 0) {
                    cmd = _wrap_sacPortInfo_link_speed_get;
                }  else if (strcmp(_str,"-mtu_smsl") == 0) {
                    cmd = _wrap_sacPortInfo_mtu_smsl_get;
                }  else if (strcmp(_str,"-vl_cap") == 0) {
                    cmd = _wrap_sacPortInfo_vl_cap_get;
                }  else if (strcmp(_str,"-vl_high_limit") == 0) {
                    cmd = _wrap_sacPortInfo_vl_high_limit_get;
                }  else if (strcmp(_str,"-vl_arb_high_cap") == 0) {
                    cmd = _wrap_sacPortInfo_vl_arb_high_cap_get;
                }  else if (strcmp(_str,"-vl_arb_low_cap") == 0) {
                    cmd = _wrap_sacPortInfo_vl_arb_low_cap_get;
                }  else if (strcmp(_str,"-mtu_cap") == 0) {
                    cmd = _wrap_sacPortInfo_mtu_cap_get;
                }  else if (strcmp(_str,"-vl_stall_life") == 0) {
                    cmd = _wrap_sacPortInfo_vl_stall_life_get;
                }  else if (strcmp(_str,"-vl_enforce") == 0) {
                    cmd = _wrap_sacPortInfo_vl_enforce_get;
                }  else if (strcmp(_str,"-m_key_violations") == 0) {
                    cmd = _wrap_sacPortInfo_m_key_violations_get;
                }  else if (strcmp(_str,"-p_key_violations") == 0) {
                    cmd = _wrap_sacPortInfo_p_key_violations_get;
                }  else if (strcmp(_str,"-q_key_violations") == 0) {
                    cmd = _wrap_sacPortInfo_q_key_violations_get;
                }  else if (strcmp(_str,"-guid_cap") == 0) {
                    cmd = _wrap_sacPortInfo_guid_cap_get;
                }  else if (strcmp(_str,"-subnet_timeout") == 0) {
                    cmd = _wrap_sacPortInfo_subnet_timeout_get;
                }  else if (strcmp(_str,"-resp_time_value") == 0) {
                    cmd = _wrap_sacPortInfo_resp_time_value_get;
                }  else if (strcmp(_str,"-error_threshold") == 0) {
                    cmd = _wrap_sacPortInfo_error_threshold_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacPortInfo_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacPortInfo_m_key_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-m_key ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_subnet_prefix_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-subnet_prefix ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_base_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_master_sm_base_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-master_sm_base_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_capability_mask_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-capability_mask ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_diag_code_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-diag_code ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_m_key_lease_period_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-m_key_lease_period ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_local_port_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-local_port_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_link_width_enabled_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_width_enabled ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_link_width_supported_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_width_supported ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_link_width_active_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_width_active ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_state_info1_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-state_info1 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_state_info2_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-state_info2 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_mkey_lmc_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mkey_lmc ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_link_speed_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_speed ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_mtu_smsl_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mtu_smsl ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_vl_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_vl_high_limit_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_high_limit ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_vl_arb_high_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_arb_high_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_vl_arb_low_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_arb_low_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_mtu_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mtu_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_vl_stall_life_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_stall_life ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_vl_enforce_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_enforce ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_m_key_violations_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-m_key_violations ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_p_key_violations_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_key_violations ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_q_key_violations_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-q_key_violations ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_guid_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-guid_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_subnet_timeout_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-subnet_timeout ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_resp_time_value_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-resp_time_value ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortInfo_error_threshold_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-error_threshold ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacPortInfoCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacPortInfo * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacPortInfo_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacPortInfo_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacPortInfo object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacPortInfoMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_portinfo_record_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_sacPortRec_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_lid_set { sacPortRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_lid_set. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_portinfo_record_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_portinfo_record_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_sacPortRec_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPortRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_lid_get { sacPortRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_lid_get. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_portinfo_record_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_portinfo_record_port_num_set(_swigobj,_swigval) (_swigobj->port_num = *(_swigval),_swigval)
static int _wrap_sacPortRec_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_port_num_set { sacPortRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_port_num_set. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_portinfo_record_port_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_portinfo_record_port_num_get(_swigobj) (&_swigobj->port_num)
static int _wrap_sacPortRec_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPortRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_port_num_get { sacPortRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_port_num_get. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_portinfo_record_port_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_portinfo_record_port_info_set(_swigobj,_swigval) (_swigobj->port_info = *(_swigval),_swigval)
static int _wrap_sacPortRec_port_info_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacPortInfo * _result;
    sacPortRec * _arg0;
    sacPortInfo * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_port_info_set { sacPortRec * } { sacPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_port_info_set. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_sacPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of sacPortRec_port_info_set. Expected _sacPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacPortInfo *)_ib_portinfo_record_port_info_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacPortInfo_p");
    return TCL_OK;
}
#define _ib_portinfo_record_port_info_get(_swigobj) (&_swigobj->port_info)
static int _wrap_sacPortRec_port_info_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacPortInfo * _result;
    sacPortRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_port_info_get { sacPortRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_port_info_get. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacPortInfo *)_ib_portinfo_record_port_info_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacPortInfo_p");
    return TCL_OK;
}
static char * sacPortRec_get(sacPortRec *self,uint64_t  comp_mask) {
	 return(ibsacPortInfoRecordQuery(self, cl_hton64(comp_mask),
                                    IB_MAD_METHOD_GET));
  }
static int _wrap_sacPortRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacPortRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_get { sacPortRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_get. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacPortRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacPortRec_getTable(sacPortRec *self,uint64_t  comp_mask) {
	 return(ibsacPortInfoRecordQuery(self, cl_hton64(comp_mask),
                                    IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacPortRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacPortRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_getTable { sacPortRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_getTable. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacPortRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacPortRec_delete(sacPortRec *self) {
	 /* we need to de-register both the node info and node record */
	 SWIG_AltMnglUnregObj(&(self->port_info));
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacPortRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacPortRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPortRec_delete { sacPortRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPortRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPortRec_delete. Expected _sacPortRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacPortRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacPortRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacPortRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacPortRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacPortRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacPortRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacPortRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacPortRec_lid_set;
                }  else if (strcmp(_str,"-port_num") == 0) {
                    cmd = _wrap_sacPortRec_port_num_set;
                }  else if (strcmp(_str,"-port_info") == 0) {
                    cmd = _wrap_sacPortRec_port_info_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -port_num -port_info  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -port_num -port_info  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacPortRec_lid_get;
                }  else if (strcmp(_str,"-port_num") == 0) {
                    cmd = _wrap_sacPortRec_port_num_get;
                }  else if (strcmp(_str,"-port_info") == 0) {
                    cmd = _wrap_sacPortRec_port_info_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacPortRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -port_num -port_info  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -port_num -port_info  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacPortRec_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortRec_port_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPortRec_port_info_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_info ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacPortRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacPortRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacPortRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacPortRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacPortRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacPortRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_sm_info_guid_set(_swigobj,_swigval) (_swigobj->guid = *(_swigval),_swigval)
static int _wrap_sacSmInfo_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacSmInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_guid_set { sacSmInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_guid_set. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_sm_info_guid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_guid_get(_swigobj) (&_swigobj->guid)
static int _wrap_sacSmInfo_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacSmInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_guid_get { sacSmInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_guid_get. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_sm_info_guid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_sm_key_set(_swigobj,_swigval) (_swigobj->sm_key = *(_swigval),_swigval)
static int _wrap_sacSmInfo_sm_key_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacSmInfo * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_sm_key_set { sacSmInfo * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_sm_key_set. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_sm_info_sm_key_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_sm_key_get(_swigobj) (&_swigobj->sm_key)
static int _wrap_sacSmInfo_sm_key_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacSmInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_sm_key_get { sacSmInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_sm_key_get. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_sm_info_sm_key_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_act_count_set(_swigobj,_swigval) (_swigobj->act_count = *(_swigval),_swigval)
static int _wrap_sacSmInfo_act_count_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacSmInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_act_count_set { sacSmInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_act_count_set. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_sm_info_act_count_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_act_count_get(_swigobj) (&_swigobj->act_count)
static int _wrap_sacSmInfo_act_count_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacSmInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_act_count_get { sacSmInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_act_count_get. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_sm_info_act_count_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_pri_state_set(_swigobj,_swigval) (_swigobj->pri_state = *(_swigval),_swigval)
static int _wrap_sacSmInfo_pri_state_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSmInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_pri_state_set { sacSmInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_pri_state_set. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_sm_info_pri_state_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sm_info_pri_state_get(_swigobj) (&_swigobj->pri_state)
static int _wrap_sacSmInfo_pri_state_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSmInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_pri_state_get { sacSmInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_pri_state_get. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_sm_info_pri_state_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static void  sacSmInfo_delete(sacSmInfo *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacSmInfo_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSmInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmInfo_delete { sacSmInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmInfo_delete. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacSmInfo_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacSmInfoMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacSmInfo methods : { dump cget configure delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacSmInfo_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacSmInfo_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-guid") == 0) {
                    cmd = _wrap_sacSmInfo_guid_set;
                }  else if (strcmp(_str,"-sm_key") == 0) {
                    cmd = _wrap_sacSmInfo_sm_key_set;
                }  else if (strcmp(_str,"-act_count") == 0) {
                    cmd = _wrap_sacSmInfo_act_count_set;
                }  else if (strcmp(_str,"-pri_state") == 0) {
                    cmd = _wrap_sacSmInfo_pri_state_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -guid -sm_key -act_count -pri_state  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -guid -sm_key -act_count -pri_state  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-guid") == 0) {
                    cmd = _wrap_sacSmInfo_guid_get;
                }  else if (strcmp(_str,"-sm_key") == 0) {
                    cmd = _wrap_sacSmInfo_sm_key_get;
                }  else if (strcmp(_str,"-act_count") == 0) {
                    cmd = _wrap_sacSmInfo_act_count_get;
                }  else if (strcmp(_str,"-pri_state") == 0) {
                    cmd = _wrap_sacSmInfo_pri_state_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacSmInfo_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -guid -sm_key -act_count -pri_state  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -guid -sm_key -act_count -pri_state  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacSmInfo_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSmInfo_sm_key_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-sm_key ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSmInfo_act_count_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-act_count ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSmInfo_pri_state_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-pri_state ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacSmInfoCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacSmInfo * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacSmInfo_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacSmInfo_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacSmInfo object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacSmInfoMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_sminfo_record_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_sacSmRec_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSmRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_lid_set { sacSmRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_lid_set. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_sminfo_record_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sminfo_record_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_sacSmRec_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSmRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_lid_get { sacSmRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_lid_get. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_sminfo_record_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_sminfo_record_sm_info_set(_swigobj,_swigval) (_swigobj->sm_info = *(_swigval),_swigval)
static int _wrap_sacSmRec_sm_info_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSmInfo * _result;
    sacSmRec * _arg0;
    sacSmInfo * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_sm_info_set { sacSmRec * } { sacSmInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_sm_info_set. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_sacSmInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of sacSmRec_sm_info_set. Expected _sacSmInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacSmInfo *)_ib_sminfo_record_sm_info_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacSmInfo_p");
    return TCL_OK;
}
#define _ib_sminfo_record_sm_info_get(_swigobj) (&_swigobj->sm_info)
static int _wrap_sacSmRec_sm_info_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSmInfo * _result;
    sacSmRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_sm_info_get { sacSmRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_sm_info_get. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacSmInfo *)_ib_sminfo_record_sm_info_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacSmInfo_p");
    return TCL_OK;
}
static char * sacSmRec_get(sacSmRec *self,uint64_t  comp_mask) {
	 return(ibsacSMInfoRecordQuery(self, cl_hton64(comp_mask),
                                  IB_MAD_METHOD_GET));
  }
static int _wrap_sacSmRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacSmRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_get { sacSmRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_get. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacSmRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacSmRec_getTable(sacSmRec *self,uint64_t  comp_mask) {
	 return(ibsacSMInfoRecordQuery(self, cl_hton64(comp_mask),
                                  IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacSmRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacSmRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_getTable { sacSmRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_getTable. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacSmRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacSmRec_delete(sacSmRec *self) {
	 /* we need to de-register both the node info and node record */
	 SWIG_AltMnglUnregObj(&(self->sm_info));
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacSmRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSmRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSmRec_delete { sacSmRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSmRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSmRec_delete. Expected _sacSmRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacSmRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacSmRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacSmRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacSmRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacSmRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacSmRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacSmRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacSmRec_lid_set;
                }  else if (strcmp(_str,"-sm_info") == 0) {
                    cmd = _wrap_sacSmRec_sm_info_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -sm_info  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -sm_info  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacSmRec_lid_get;
                }  else if (strcmp(_str,"-sm_info") == 0) {
                    cmd = _wrap_sacSmRec_sm_info_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacSmRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -sm_info  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -sm_info  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacSmRec_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSmRec_sm_info_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-sm_info ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacSmRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacSmRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacSmRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacSmRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacSmRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacSmRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_switch_info_lin_cap_set(_swigobj,_swigval) (_swigobj->lin_cap = *(_swigval),_swigval)
static int _wrap_sacSwInfo_lin_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_lin_cap_set { sacSwInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_lin_cap_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lin_cap_get(_swigobj) (&_swigobj->lin_cap)
static int _wrap_sacSwInfo_lin_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_lin_cap_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_lin_cap_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_rand_cap_set(_swigobj,_swigval) (_swigobj->rand_cap = *(_swigval),_swigval)
static int _wrap_sacSwInfo_rand_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_rand_cap_set { sacSwInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_rand_cap_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_rand_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_rand_cap_get(_swigobj) (&_swigobj->rand_cap)
static int _wrap_sacSwInfo_rand_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_rand_cap_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_rand_cap_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_rand_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_mcast_cap_set(_swigobj,_swigval) (_swigobj->mcast_cap = *(_swigval),_swigval)
static int _wrap_sacSwInfo_mcast_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_mcast_cap_set { sacSwInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_mcast_cap_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_mcast_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_mcast_cap_get(_swigobj) (&_swigobj->mcast_cap)
static int _wrap_sacSwInfo_mcast_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_mcast_cap_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_mcast_cap_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_mcast_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lin_top_set(_swigobj,_swigval) (_swigobj->lin_top = *(_swigval),_swigval)
static int _wrap_sacSwInfo_lin_top_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_lin_top_set { sacSwInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_lin_top_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_top_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lin_top_get(_swigobj) (&_swigobj->lin_top)
static int _wrap_sacSwInfo_lin_top_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_lin_top_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_lin_top_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_top_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_port_set(_swigobj,_swigval) (_swigobj->def_port = *(_swigval),_swigval)
static int _wrap_sacSwInfo_def_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_def_port_set { sacSwInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_def_port_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_port_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_port_get(_swigobj) (&_swigobj->def_port)
static int _wrap_sacSwInfo_def_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_def_port_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_def_port_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_port_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_pri_port_set(_swigobj,_swigval) (_swigobj->def_mcast_pri_port = *(_swigval),_swigval)
static int _wrap_sacSwInfo_def_mcast_pri_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_def_mcast_pri_port_set { sacSwInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_def_mcast_pri_port_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_pri_port_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_pri_port_get(_swigobj) (&_swigobj->def_mcast_pri_port)
static int _wrap_sacSwInfo_def_mcast_pri_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_def_mcast_pri_port_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_def_mcast_pri_port_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_pri_port_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_not_port_set(_swigobj,_swigval) (_swigobj->def_mcast_not_port = *(_swigval),_swigval)
static int _wrap_sacSwInfo_def_mcast_not_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_def_mcast_not_port_set { sacSwInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_def_mcast_not_port_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_not_port_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_not_port_get(_swigobj) (&_swigobj->def_mcast_not_port)
static int _wrap_sacSwInfo_def_mcast_not_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_def_mcast_not_port_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_def_mcast_not_port_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_not_port_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_life_state_set(_swigobj,_swigval) (_swigobj->life_state = *(_swigval),_swigval)
static int _wrap_sacSwInfo_life_state_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_life_state_set { sacSwInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_life_state_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_life_state_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_life_state_get(_swigobj) (&_swigobj->life_state)
static int _wrap_sacSwInfo_life_state_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_life_state_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_life_state_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_life_state_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lids_per_port_set(_swigobj,_swigval) (_swigobj->lids_per_port = *(_swigval),_swigval)
static int _wrap_sacSwInfo_lids_per_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_lids_per_port_set { sacSwInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_lids_per_port_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lids_per_port_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lids_per_port_get(_swigobj) (&_swigobj->lids_per_port)
static int _wrap_sacSwInfo_lids_per_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_lids_per_port_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_lids_per_port_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lids_per_port_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_enforce_cap_set(_swigobj,_swigval) (_swigobj->enforce_cap = *(_swigval),_swigval)
static int _wrap_sacSwInfo_enforce_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_enforce_cap_set { sacSwInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_enforce_cap_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_enforce_cap_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_enforce_cap_get(_swigobj) (&_swigobj->enforce_cap)
static int _wrap_sacSwInfo_enforce_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_enforce_cap_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_enforce_cap_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_enforce_cap_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_flags_set(_swigobj,_swigval) (_swigobj->flags = *(_swigval),_swigval)
static int _wrap_sacSwInfo_flags_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_flags_set { sacSwInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_flags_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_flags_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_flags_get(_swigobj) (&_swigobj->flags)
static int _wrap_sacSwInfo_flags_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_flags_get { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_flags_get. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_flags_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static void  sacSwInfo_delete(sacSwInfo *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacSwInfo_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSwInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwInfo_delete { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwInfo_delete. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacSwInfo_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacSwInfoMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacSwInfo methods : { dump cget configure delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacSwInfo_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacSwInfo_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lin_cap") == 0) {
                    cmd = _wrap_sacSwInfo_lin_cap_set;
                }  else if (strcmp(_str,"-rand_cap") == 0) {
                    cmd = _wrap_sacSwInfo_rand_cap_set;
                }  else if (strcmp(_str,"-mcast_cap") == 0) {
                    cmd = _wrap_sacSwInfo_mcast_cap_set;
                }  else if (strcmp(_str,"-lin_top") == 0) {
                    cmd = _wrap_sacSwInfo_lin_top_set;
                }  else if (strcmp(_str,"-def_port") == 0) {
                    cmd = _wrap_sacSwInfo_def_port_set;
                }  else if (strcmp(_str,"-def_mcast_pri_port") == 0) {
                    cmd = _wrap_sacSwInfo_def_mcast_pri_port_set;
                }  else if (strcmp(_str,"-def_mcast_not_port") == 0) {
                    cmd = _wrap_sacSwInfo_def_mcast_not_port_set;
                }  else if (strcmp(_str,"-life_state") == 0) {
                    cmd = _wrap_sacSwInfo_life_state_set;
                }  else if (strcmp(_str,"-lids_per_port") == 0) {
                    cmd = _wrap_sacSwInfo_lids_per_port_set;
                }  else if (strcmp(_str,"-enforce_cap") == 0) {
                    cmd = _wrap_sacSwInfo_enforce_cap_set;
                }  else if (strcmp(_str,"-flags") == 0) {
                    cmd = _wrap_sacSwInfo_flags_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lin_cap") == 0) {
                    cmd = _wrap_sacSwInfo_lin_cap_get;
                }  else if (strcmp(_str,"-rand_cap") == 0) {
                    cmd = _wrap_sacSwInfo_rand_cap_get;
                }  else if (strcmp(_str,"-mcast_cap") == 0) {
                    cmd = _wrap_sacSwInfo_mcast_cap_get;
                }  else if (strcmp(_str,"-lin_top") == 0) {
                    cmd = _wrap_sacSwInfo_lin_top_get;
                }  else if (strcmp(_str,"-def_port") == 0) {
                    cmd = _wrap_sacSwInfo_def_port_get;
                }  else if (strcmp(_str,"-def_mcast_pri_port") == 0) {
                    cmd = _wrap_sacSwInfo_def_mcast_pri_port_get;
                }  else if (strcmp(_str,"-def_mcast_not_port") == 0) {
                    cmd = _wrap_sacSwInfo_def_mcast_not_port_get;
                }  else if (strcmp(_str,"-life_state") == 0) {
                    cmd = _wrap_sacSwInfo_life_state_get;
                }  else if (strcmp(_str,"-lids_per_port") == 0) {
                    cmd = _wrap_sacSwInfo_lids_per_port_get;
                }  else if (strcmp(_str,"-enforce_cap") == 0) {
                    cmd = _wrap_sacSwInfo_enforce_cap_get;
                }  else if (strcmp(_str,"-flags") == 0) {
                    cmd = _wrap_sacSwInfo_flags_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacSwInfo_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacSwInfo_lin_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lin_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_rand_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-rand_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_mcast_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mcast_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_lin_top_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lin_top ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_def_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-def_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_def_mcast_pri_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-def_mcast_pri_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_def_mcast_not_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-def_mcast_not_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_life_state_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-life_state ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_lids_per_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lids_per_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_enforce_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-enforce_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwInfo_flags_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-flags ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacSwInfoCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacSwInfo * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacSwInfo_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacSwInfo_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacSwInfo object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacSwInfoMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_switch_info_record_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_sacSwRec_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_lid_set { sacSwRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_lid_set. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_record_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_record_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_sacSwRec_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSwRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_lid_get { sacSwRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_lid_get. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_record_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_record_switch_info_set(_swigobj,_swigval) (_swigobj->switch_info = *(_swigval),_swigval)
static int _wrap_sacSwRec_switch_info_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSwInfo * _result;
    sacSwRec * _arg0;
    sacSwInfo * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_switch_info_set { sacSwRec * } { sacSwInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_switch_info_set. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_sacSwInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of sacSwRec_switch_info_set. Expected _sacSwInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacSwInfo *)_ib_switch_info_record_switch_info_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacSwInfo_p");
    return TCL_OK;
}
#define _ib_switch_info_record_switch_info_get(_swigobj) (&_swigobj->switch_info)
static int _wrap_sacSwRec_switch_info_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSwInfo * _result;
    sacSwRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_switch_info_get { sacSwRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_switch_info_get. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacSwInfo *)_ib_switch_info_record_switch_info_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacSwInfo_p");
    return TCL_OK;
}
static char * sacSwRec_get(sacSwRec *self,uint64_t  comp_mask) {
	 return(ibsacSwitchInfoRecordQuery(self, cl_hton64(comp_mask),
                                      IB_MAD_METHOD_GET));
  }
static int _wrap_sacSwRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacSwRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_get { sacSwRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_get. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacSwRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacSwRec_getTable(sacSwRec *self,uint64_t  comp_mask) {
	 return(ibsacSwitchInfoRecordQuery(self, cl_hton64(comp_mask),
                                      IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacSwRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacSwRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_getTable { sacSwRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_getTable. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacSwRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacSwRec_delete(sacSwRec *self) {
	 /* we need to de-register both the node info and node record */
	 SWIG_AltMnglUnregObj(&(self->switch_info));
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacSwRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSwRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSwRec_delete { sacSwRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSwRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSwRec_delete. Expected _sacSwRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacSwRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacSwRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacSwRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacSwRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacSwRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacSwRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacSwRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacSwRec_lid_set;
                }  else if (strcmp(_str,"-switch_info") == 0) {
                    cmd = _wrap_sacSwRec_switch_info_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -switch_info  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -switch_info  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacSwRec_lid_get;
                }  else if (strcmp(_str,"-switch_info") == 0) {
                    cmd = _wrap_sacSwRec_switch_info_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacSwRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -switch_info  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -switch_info  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacSwRec_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacSwRec_switch_info_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-switch_info ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacSwRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacSwRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacSwRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacSwRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacSwRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacSwRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_link_record_from_lid_set(_swigobj,_swigval) (_swigobj->from_lid = *(_swigval),_swigval)
static int _wrap_sacLinkRec_from_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLinkRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_from_lid_set { sacLinkRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_from_lid_set. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_link_record_from_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_from_lid_get(_swigobj) (&_swigobj->from_lid)
static int _wrap_sacLinkRec_from_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLinkRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_from_lid_get { sacLinkRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_from_lid_get. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_link_record_from_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_from_port_num_set(_swigobj,_swigval) (_swigobj->from_port_num = *(_swigval),_swigval)
static int _wrap_sacLinkRec_from_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacLinkRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_from_port_num_set { sacLinkRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_from_port_num_set. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_link_record_from_port_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_from_port_num_get(_swigobj) (&_swigobj->from_port_num)
static int _wrap_sacLinkRec_from_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacLinkRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_from_port_num_get { sacLinkRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_from_port_num_get. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_link_record_from_port_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_to_port_num_set(_swigobj,_swigval) (_swigobj->to_port_num = *(_swigval),_swigval)
static int _wrap_sacLinkRec_to_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacLinkRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_to_port_num_set { sacLinkRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_to_port_num_set. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_link_record_to_port_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_to_port_num_get(_swigobj) (&_swigobj->to_port_num)
static int _wrap_sacLinkRec_to_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacLinkRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_to_port_num_get { sacLinkRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_to_port_num_get. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_link_record_to_port_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_to_lid_set(_swigobj,_swigval) (_swigobj->to_lid = *(_swigval),_swigval)
static int _wrap_sacLinkRec_to_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLinkRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_to_lid_set { sacLinkRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_to_lid_set. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_link_record_to_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_link_record_to_lid_get(_swigobj) (&_swigobj->to_lid)
static int _wrap_sacLinkRec_to_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLinkRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_to_lid_get { sacLinkRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_to_lid_get. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_link_record_to_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static char * sacLinkRec_get(sacLinkRec *self,uint64_t  comp_mask) {
	 return(ibsacLinkRecordQuery(self, cl_hton64(comp_mask),
                                IB_MAD_METHOD_GET));
  }
static int _wrap_sacLinkRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacLinkRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_get { sacLinkRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_get. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacLinkRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacLinkRec_getTable(sacLinkRec *self,uint64_t  comp_mask) {
	 return(ibsacLinkRecordQuery(self, cl_hton64(comp_mask),
                                IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacLinkRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacLinkRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_getTable { sacLinkRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_getTable. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacLinkRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacLinkRec_delete(sacLinkRec *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacLinkRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacLinkRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLinkRec_delete { sacLinkRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLinkRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLinkRec_delete. Expected _sacLinkRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacLinkRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacLinkRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacLinkRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacLinkRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacLinkRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacLinkRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacLinkRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-from_lid") == 0) {
                    cmd = _wrap_sacLinkRec_from_lid_set;
                }  else if (strcmp(_str,"-from_port_num") == 0) {
                    cmd = _wrap_sacLinkRec_from_port_num_set;
                }  else if (strcmp(_str,"-to_port_num") == 0) {
                    cmd = _wrap_sacLinkRec_to_port_num_set;
                }  else if (strcmp(_str,"-to_lid") == 0) {
                    cmd = _wrap_sacLinkRec_to_lid_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -from_lid -from_port_num -to_port_num -to_lid  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -from_lid -from_port_num -to_port_num -to_lid  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-from_lid") == 0) {
                    cmd = _wrap_sacLinkRec_from_lid_get;
                }  else if (strcmp(_str,"-from_port_num") == 0) {
                    cmd = _wrap_sacLinkRec_from_port_num_get;
                }  else if (strcmp(_str,"-to_port_num") == 0) {
                    cmd = _wrap_sacLinkRec_to_port_num_get;
                }  else if (strcmp(_str,"-to_lid") == 0) {
                    cmd = _wrap_sacLinkRec_to_lid_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacLinkRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -from_lid -from_port_num -to_port_num -to_lid  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -from_lid -from_port_num -to_port_num -to_lid  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacLinkRec_from_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-from_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacLinkRec_from_port_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-from_port_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacLinkRec_to_port_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-to_port_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacLinkRec_to_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-to_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacLinkRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacLinkRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacLinkRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacLinkRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacLinkRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacLinkRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_path_rec_service_id_set(_swigobj,_swigval) (_swigobj->service_id = *(_swigval),_swigval)
static int _wrap_sacPathRec_service_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacPathRec * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_service_id_set { sacPathRec * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_service_id_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_path_rec_service_id_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_service_id_get(_swigobj) (&_swigobj->service_id)
static int _wrap_sacPathRec_service_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_service_id_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_service_id_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_path_rec_service_id_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_dgid_set(_swigobj,_swigval) (_swigobj->dgid = *(_swigval),_swigval)
static int _wrap_sacPathRec_dgid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacPathRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_dgid_set { sacPathRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_dgid_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_path_rec_dgid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_dgid_get(_swigobj) (&_swigobj->dgid)
static int _wrap_sacPathRec_dgid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_dgid_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_dgid_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_path_rec_dgid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_sgid_set(_swigobj,_swigval) (_swigobj->sgid = *(_swigval),_swigval)
static int _wrap_sacPathRec_sgid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacPathRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_sgid_set { sacPathRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_sgid_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_path_rec_sgid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_sgid_get(_swigobj) (&_swigobj->sgid)
static int _wrap_sacPathRec_sgid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_sgid_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_sgid_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_path_rec_sgid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_dlid_set(_swigobj,_swigval) (_swigobj->dlid = *(_swigval),_swigval)
static int _wrap_sacPathRec_dlid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_dlid_set { sacPathRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_dlid_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_dlid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_dlid_get(_swigobj) (&_swigobj->dlid)
static int _wrap_sacPathRec_dlid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_dlid_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_dlid_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_dlid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_slid_set(_swigobj,_swigval) (_swigobj->slid = *(_swigval),_swigval)
static int _wrap_sacPathRec_slid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_slid_set { sacPathRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_slid_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_slid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_slid_get(_swigobj) (&_swigobj->slid)
static int _wrap_sacPathRec_slid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_slid_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_slid_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_slid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_hop_flow_raw_set(_swigobj,_swigval) (_swigobj->hop_flow_raw = *(_swigval),_swigval)
static int _wrap_sacPathRec_hop_flow_raw_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacPathRec * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_hop_flow_raw_set { sacPathRec * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_hop_flow_raw_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_path_rec_hop_flow_raw_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_hop_flow_raw_get(_swigobj) (&_swigobj->hop_flow_raw)
static int _wrap_sacPathRec_hop_flow_raw_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_hop_flow_raw_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_hop_flow_raw_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_path_rec_hop_flow_raw_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_tclass_set(_swigobj,_swigval) (_swigobj->tclass = *(_swigval),_swigval)
static int _wrap_sacPathRec_tclass_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_tclass_set { sacPathRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_tclass_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_tclass_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_tclass_get(_swigobj) (&_swigobj->tclass)
static int _wrap_sacPathRec_tclass_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_tclass_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_tclass_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_tclass_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_num_path_set(_swigobj,_swigval) (_swigobj->num_path = *(_swigval),_swigval)
static int _wrap_sacPathRec_num_path_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_num_path_set { sacPathRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_num_path_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_num_path_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_num_path_get(_swigobj) (&_swigobj->num_path)
static int _wrap_sacPathRec_num_path_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_num_path_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_num_path_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_num_path_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_pkey_set(_swigobj,_swigval) (_swigobj->pkey = *(_swigval),_swigval)
static int _wrap_sacPathRec_pkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_pkey_set { sacPathRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_pkey_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_pkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_pkey_get(_swigobj) (&_swigobj->pkey)
static int _wrap_sacPathRec_pkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_pkey_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_pkey_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_pkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_qos_class_sl_set(_swigobj,_swigval) (_swigobj->qos_class_sl = *(_swigval),_swigval)
static int _wrap_sacPathRec_qos_class_sl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_qos_class_sl_set { sacPathRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_qos_class_sl_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_qos_class_sl_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_qos_class_sl_get(_swigobj) (&_swigobj->qos_class_sl)
static int _wrap_sacPathRec_qos_class_sl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_qos_class_sl_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_qos_class_sl_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_path_rec_qos_class_sl_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_mtu_set(_swigobj,_swigval) (_swigobj->mtu = *(_swigval),_swigval)
static int _wrap_sacPathRec_mtu_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_mtu_set { sacPathRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_mtu_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_mtu_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_mtu_get(_swigobj) (&_swigobj->mtu)
static int _wrap_sacPathRec_mtu_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_mtu_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_mtu_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_mtu_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_rate_set(_swigobj,_swigval) (_swigobj->rate = *(_swigval),_swigval)
static int _wrap_sacPathRec_rate_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_rate_set { sacPathRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_rate_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_rate_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_rate_get(_swigobj) (&_swigobj->rate)
static int _wrap_sacPathRec_rate_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_rate_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_rate_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_rate_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_pkt_life_set(_swigobj,_swigval) (_swigobj->pkt_life = *(_swigval),_swigval)
static int _wrap_sacPathRec_pkt_life_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_pkt_life_set { sacPathRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_pkt_life_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_pkt_life_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_pkt_life_get(_swigobj) (&_swigobj->pkt_life)
static int _wrap_sacPathRec_pkt_life_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_pkt_life_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_pkt_life_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_pkt_life_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_preference_set(_swigobj,_swigval) (_swigobj->preference = *(_swigval),_swigval)
static int _wrap_sacPathRec_preference_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_preference_set { sacPathRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_preference_set. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_preference_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_path_rec_preference_get(_swigobj) (&_swigobj->preference)
static int _wrap_sacPathRec_preference_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_preference_get { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_preference_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_path_rec_preference_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static char * sacPathRec_get(sacPathRec *self,uint64_t  comp_mask) {
	 return(ibsacPathRecordQuery(self, cl_hton64(comp_mask),
                                IB_MAD_METHOD_GET));
  }
static int _wrap_sacPathRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacPathRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_get { sacPathRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_get. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacPathRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacPathRec_getTable(sacPathRec *self,uint64_t  comp_mask) {
	 return(ibsacPathRecordQuery(self, cl_hton64(comp_mask),
                                IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacPathRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacPathRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_getTable { sacPathRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_getTable. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacPathRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacPathRec_delete(sacPathRec *self) {
    free(self);
	 SWIG_AltMnglUnregObj(self);
  }
static int _wrap_sacPathRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacPathRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacPathRec_delete { sacPathRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacPathRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacPathRec_delete. Expected _sacPathRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacPathRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacPathRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacPathRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacPathRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacPathRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacPathRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacPathRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-service_id") == 0) {
                    cmd = _wrap_sacPathRec_service_id_set;
                }  else if (strcmp(_str,"-dgid") == 0) {
                    cmd = _wrap_sacPathRec_dgid_set;
                }  else if (strcmp(_str,"-sgid") == 0) {
                    cmd = _wrap_sacPathRec_sgid_set;
                }  else if (strcmp(_str,"-dlid") == 0) {
                    cmd = _wrap_sacPathRec_dlid_set;
                }  else if (strcmp(_str,"-slid") == 0) {
                    cmd = _wrap_sacPathRec_slid_set;
                }  else if (strcmp(_str,"-hop_flow_raw") == 0) {
                    cmd = _wrap_sacPathRec_hop_flow_raw_set;
                }  else if (strcmp(_str,"-tclass") == 0) {
                    cmd = _wrap_sacPathRec_tclass_set;
                }  else if (strcmp(_str,"-num_path") == 0) {
                    cmd = _wrap_sacPathRec_num_path_set;
                }  else if (strcmp(_str,"-pkey") == 0) {
                    cmd = _wrap_sacPathRec_pkey_set;
                }  else if (strcmp(_str,"-qos_class_sl") == 0) {
                    cmd = _wrap_sacPathRec_qos_class_sl_set;
                }  else if (strcmp(_str,"-mtu") == 0) {
                    cmd = _wrap_sacPathRec_mtu_set;
                }  else if (strcmp(_str,"-rate") == 0) {
                    cmd = _wrap_sacPathRec_rate_set;
                }  else if (strcmp(_str,"-pkt_life") == 0) {
                    cmd = _wrap_sacPathRec_pkt_life_set;
                }  else if (strcmp(_str,"-preference") == 0) {
                    cmd = _wrap_sacPathRec_preference_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -service_id -dgid -sgid -dlid -slid -hop_flow_raw -tclass -num_path -pkey -qos_class_sl -mtu -rate -pkt_life -preference  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -service_id -dgid -sgid -dlid -slid -hop_flow_raw -tclass -num_path -pkey -qos_class_sl -mtu -rate -pkt_life -preference  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-service_id") == 0) {
                    cmd = _wrap_sacPathRec_service_id_get;
                }  else if (strcmp(_str,"-dgid") == 0) {
                    cmd = _wrap_sacPathRec_dgid_get;
                }  else if (strcmp(_str,"-sgid") == 0) {
                    cmd = _wrap_sacPathRec_sgid_get;
                }  else if (strcmp(_str,"-dlid") == 0) {
                    cmd = _wrap_sacPathRec_dlid_get;
                }  else if (strcmp(_str,"-slid") == 0) {
                    cmd = _wrap_sacPathRec_slid_get;
                }  else if (strcmp(_str,"-hop_flow_raw") == 0) {
                    cmd = _wrap_sacPathRec_hop_flow_raw_get;
                }  else if (strcmp(_str,"-tclass") == 0) {
                    cmd = _wrap_sacPathRec_tclass_get;
                }  else if (strcmp(_str,"-num_path") == 0) {
                    cmd = _wrap_sacPathRec_num_path_get;
                }  else if (strcmp(_str,"-pkey") == 0) {
                    cmd = _wrap_sacPathRec_pkey_get;
                }  else if (strcmp(_str,"-qos_class_sl") == 0) {
                    cmd = _wrap_sacPathRec_qos_class_sl_get;
                }  else if (strcmp(_str,"-mtu") == 0) {
                    cmd = _wrap_sacPathRec_mtu_get;
                }  else if (strcmp(_str,"-rate") == 0) {
                    cmd = _wrap_sacPathRec_rate_get;
                }  else if (strcmp(_str,"-pkt_life") == 0) {
                    cmd = _wrap_sacPathRec_pkt_life_get;
                }  else if (strcmp(_str,"-preference") == 0) {
                    cmd = _wrap_sacPathRec_preference_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacPathRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -service_id -dgid -sgid -dlid -slid -hop_flow_raw -tclass -num_path -pkey -qos_class_sl -mtu -rate -pkt_life -preference  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -service_id -dgid -sgid -dlid -slid -hop_flow_raw -tclass -num_path -pkey -qos_class_sl -mtu -rate -pkt_life -preference  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacPathRec_service_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_dgid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-dgid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_sgid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-sgid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_dlid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-dlid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_slid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-slid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_hop_flow_raw_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-hop_flow_raw ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_tclass_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-tclass ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_num_path_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-num_path ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_pkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-pkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_qos_class_sl_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-qos_class_sl ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_mtu_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mtu ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_rate_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-rate ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_pkt_life_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-pkt_life ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacPathRec_preference_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-preference ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacPathRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacPathRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacPathRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacPathRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacPathRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacPathRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_lft_record_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_sacLFTRec_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLFTRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_lid_set { sacLFTRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_lid_set. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_sacLFTRec_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLFTRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_lid_get { sacLFTRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_lid_get. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_block_num_set(_swigobj,_swigval) (_swigobj->block_num = *(_swigval),_swigval)
static int _wrap_sacLFTRec_block_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLFTRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_block_num_set { sacLFTRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_block_num_set. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_block_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_block_num_get(_swigobj) (&_swigobj->block_num)
static int _wrap_sacLFTRec_block_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacLFTRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_block_num_get { sacLFTRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_block_num_get. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_block_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static ib_lft_t * _ib_lft_record_lft_set(sacLFTRec *obj, ib_lft_t val[64]) {
{
  int i;
  int m = 64;
  if (m > 64) m = 64;
  for (i=0; i <64 ; i++) {
    obj->lft[i] = *(val+i);
  }
}
    return (ib_lft_t *) val;
}
static int _wrap_sacLFTRec_lft_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_lft_t * _result;
    sacLFTRec * _arg0;
    ib_lft_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_lft_set { sacLFTRec * } { ib_lft_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_lft_set. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_ib_lft_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of sacLFTRec_lft_set. Expected _ib_lft_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_lft_t *)_ib_lft_record_lft_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buf[12];
  int i;
  for (i = 0; i < 64; i++) {
	 sprintf(buf, "{%u %u} ", i, _result[i]);
	 Tcl_AppendToObj(tcl_result, buf, -1);
  }
}
    return TCL_OK;
}
#define _ib_lft_record_lft_get(_swigobj) ((ib_lft_t *) _swigobj->lft)
static int _wrap_sacLFTRec_lft_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_lft_t * _result;
    sacLFTRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_lft_get { sacLFTRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_lft_get. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_lft_t *)_ib_lft_record_lft_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buf[12];
  int i;
  for (i = 0; i < 64; i++) {
	 sprintf(buf, "{%u %u} ", i, _result[i]);
	 Tcl_AppendToObj(tcl_result, buf, -1);
  }
}
    return TCL_OK;
}
static char * sacLFTRec_get(sacLFTRec *self,uint64_t  comp_mask) {
	 return(ibsacLFTRecordQuery(self, cl_hton64(comp_mask),
                               IB_MAD_METHOD_GET));
  }
static int _wrap_sacLFTRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacLFTRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_get { sacLFTRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_get. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacLFTRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacLFTRec_getTable(sacLFTRec *self,uint64_t  comp_mask) {
	 return(ibsacLFTRecordQuery(self, cl_hton64(comp_mask),
                               IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacLFTRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacLFTRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_getTable { sacLFTRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_getTable. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacLFTRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacLFTRec_delete(sacLFTRec *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacLFTRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacLFTRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacLFTRec_delete { sacLFTRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacLFTRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacLFTRec_delete. Expected _sacLFTRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacLFTRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacLFTRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacLFTRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacLFTRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacLFTRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacLFTRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacLFTRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacLFTRec_lid_set;
                }  else if (strcmp(_str,"-block_num") == 0) {
                    cmd = _wrap_sacLFTRec_block_num_set;
                }  else if (strcmp(_str,"-lft") == 0) {
                    cmd = _wrap_sacLFTRec_lft_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -block_num -lft  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -block_num -lft  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacLFTRec_lid_get;
                }  else if (strcmp(_str,"-block_num") == 0) {
                    cmd = _wrap_sacLFTRec_block_num_get;
                }  else if (strcmp(_str,"-lft") == 0) {
                    cmd = _wrap_sacLFTRec_lft_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacLFTRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -block_num -lft  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -block_num -lft  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacLFTRec_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacLFTRec_block_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-block_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacLFTRec_lft_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lft ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacLFTRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacLFTRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacLFTRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacLFTRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacLFTRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacLFTRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_member_rec_mgid_set(_swigobj,_swigval) (_swigobj->mgid = *(_swigval),_swigval)
static int _wrap_sacMCMRec_mgid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacMCMRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_mgid_set { sacMCMRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_mgid_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_member_rec_mgid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_mgid_get(_swigobj) (&_swigobj->mgid)
static int _wrap_sacMCMRec_mgid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_mgid_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_mgid_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_member_rec_mgid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_port_gid_set(_swigobj,_swigval) (_swigobj->port_gid = *(_swigval),_swigval)
static int _wrap_sacMCMRec_port_gid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacMCMRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_port_gid_set { sacMCMRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_port_gid_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_member_rec_port_gid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_port_gid_get(_swigobj) (&_swigobj->port_gid)
static int _wrap_sacMCMRec_port_gid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_port_gid_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_port_gid_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_member_rec_port_gid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_qkey_set(_swigobj,_swigval) (_swigobj->qkey = *(_swigval),_swigval)
static int _wrap_sacMCMRec_qkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacMCMRec * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_qkey_set { sacMCMRec * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_qkey_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_member_rec_qkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_qkey_get(_swigobj) (&_swigobj->qkey)
static int _wrap_sacMCMRec_qkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_qkey_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_qkey_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_member_rec_qkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_mlid_set(_swigobj,_swigval) (_swigobj->mlid = *(_swigval),_swigval)
static int _wrap_sacMCMRec_mlid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacMCMRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_mlid_set { sacMCMRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_mlid_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_member_rec_mlid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_mlid_get(_swigobj) (&_swigobj->mlid)
static int _wrap_sacMCMRec_mlid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_mlid_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_mlid_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_member_rec_mlid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_mtu_set(_swigobj,_swigval) (_swigobj->mtu = *(_swigval),_swigval)
static int _wrap_sacMCMRec_mtu_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_mtu_set { sacMCMRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_mtu_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_mtu_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_mtu_get(_swigobj) (&_swigobj->mtu)
static int _wrap_sacMCMRec_mtu_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_mtu_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_mtu_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_mtu_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_tclass_set(_swigobj,_swigval) (_swigobj->tclass = *(_swigval),_swigval)
static int _wrap_sacMCMRec_tclass_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_tclass_set { sacMCMRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_tclass_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_tclass_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_tclass_get(_swigobj) (&_swigobj->tclass)
static int _wrap_sacMCMRec_tclass_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_tclass_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_tclass_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_tclass_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_pkey_set(_swigobj,_swigval) (_swigobj->pkey = *(_swigval),_swigval)
static int _wrap_sacMCMRec_pkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacMCMRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_pkey_set { sacMCMRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_pkey_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_member_rec_pkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_pkey_get(_swigobj) (&_swigobj->pkey)
static int _wrap_sacMCMRec_pkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_pkey_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_pkey_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_member_rec_pkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_rate_set(_swigobj,_swigval) (_swigobj->rate = *(_swigval),_swigval)
static int _wrap_sacMCMRec_rate_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_rate_set { sacMCMRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_rate_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_rate_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_rate_get(_swigobj) (&_swigobj->rate)
static int _wrap_sacMCMRec_rate_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_rate_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_rate_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_rate_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_pkt_life_set(_swigobj,_swigval) (_swigobj->pkt_life = *(_swigval),_swigval)
static int _wrap_sacMCMRec_pkt_life_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_pkt_life_set { sacMCMRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_pkt_life_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_pkt_life_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_pkt_life_get(_swigobj) (&_swigobj->pkt_life)
static int _wrap_sacMCMRec_pkt_life_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_pkt_life_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_pkt_life_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_pkt_life_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_sl_flow_hop_set(_swigobj,_swigval) (_swigobj->sl_flow_hop = *(_swigval),_swigval)
static int _wrap_sacMCMRec_sl_flow_hop_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacMCMRec * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_sl_flow_hop_set { sacMCMRec * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_sl_flow_hop_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_member_rec_sl_flow_hop_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_sl_flow_hop_get(_swigobj) (&_swigobj->sl_flow_hop)
static int _wrap_sacMCMRec_sl_flow_hop_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_sl_flow_hop_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_sl_flow_hop_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_member_rec_sl_flow_hop_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_scope_state_set(_swigobj,_swigval) (_swigobj->scope_state = *(_swigval),_swigval)
static int _wrap_sacMCMRec_scope_state_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_scope_state_set { sacMCMRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_scope_state_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_scope_state_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_member_rec_scope_state_get(_swigobj) (&_swigobj->scope_state)
static int _wrap_sacMCMRec_scope_state_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_scope_state_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_scope_state_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_member_rec_scope_state_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static char * sacMCMRec_get(sacMCMRec *self,uint64_t  comp_mask) {
	 return(ibsacMCMemberRecordQuery(self, cl_hton64(comp_mask),
                                    IB_MAD_METHOD_GET));
  }
static int _wrap_sacMCMRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacMCMRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_get { sacMCMRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacMCMRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacMCMRec_getTable(sacMCMRec *self,uint64_t  comp_mask) {
	 return(ibsacMCMemberRecordQuery(self, cl_hton64(comp_mask),
                                    IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacMCMRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacMCMRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_getTable { sacMCMRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_getTable. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacMCMRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacMCMRec_set(sacMCMRec *self,uint64_t  comp_mask) {
   return(ibsacMCMemberRecordQuery(self, cl_hton64(comp_mask),
                                   IB_MAD_METHOD_SET));
 }
static int _wrap_sacMCMRec_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacMCMRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_set { sacMCMRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacMCMRec_set(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacMCMRec_del(sacMCMRec *self,uint64_t  comp_mask) {
   return(ibsacMCMemberRecordQuery(self, cl_hton64(comp_mask),
                                   IB_MAD_METHOD_DELETE));
 }
static int _wrap_sacMCMRec_del(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacMCMRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_del { sacMCMRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_del. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacMCMRec_del(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static int  sacMCMRec_proxy_join_get(sacMCMRec *self) {
   return(self->proxy_join);
 }
static int _wrap_sacMCMRec_proxy_join_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_proxy_join_get { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_proxy_join_get. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (int )sacMCMRec_proxy_join_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static void  sacMCMRec_proxy_join_set(sacMCMRec *self,uint8_t  proxy_join) {
    self->proxy_join = proxy_join;
  }
static int _wrap_sacMCMRec_proxy_join_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacMCMRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_proxy_join_set { sacMCMRec * } proxy_join ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_proxy_join_set. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacMCMRec_proxy_join_set(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static void  sacMCMRec_obj_delete(sacMCMRec *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacMCMRec_obj_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacMCMRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacMCMRec_obj_delete { sacMCMRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacMCMRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacMCMRec_obj_delete. Expected _sacMCMRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacMCMRec_obj_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacMCMRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacMCMRec methods : { dump cget configure get getTable set del proxy_join_get proxy_join_set obj_delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacMCMRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacMCMRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacMCMRec_getTable;
    }    else if (strcmp(_str,"set") == 0) {
        cmd = _wrap_sacMCMRec_set;
    }    else if (strcmp(_str,"del") == 0) {
        cmd = _wrap_sacMCMRec_del;
    }    else if (strcmp(_str,"proxy_join_get") == 0) {
        cmd = _wrap_sacMCMRec_proxy_join_get;
    }    else if (strcmp(_str,"proxy_join_set") == 0) {
        cmd = _wrap_sacMCMRec_proxy_join_set;
    }    else if (strcmp(_str,"obj_delete") == 0) {
        cmd = _wrap_sacMCMRec_obj_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-mgid") == 0) {
                    cmd = _wrap_sacMCMRec_mgid_set;
                }  else if (strcmp(_str,"-port_gid") == 0) {
                    cmd = _wrap_sacMCMRec_port_gid_set;
                }  else if (strcmp(_str,"-qkey") == 0) {
                    cmd = _wrap_sacMCMRec_qkey_set;
                }  else if (strcmp(_str,"-mlid") == 0) {
                    cmd = _wrap_sacMCMRec_mlid_set;
                }  else if (strcmp(_str,"-mtu") == 0) {
                    cmd = _wrap_sacMCMRec_mtu_set;
                }  else if (strcmp(_str,"-tclass") == 0) {
                    cmd = _wrap_sacMCMRec_tclass_set;
                }  else if (strcmp(_str,"-pkey") == 0) {
                    cmd = _wrap_sacMCMRec_pkey_set;
                }  else if (strcmp(_str,"-rate") == 0) {
                    cmd = _wrap_sacMCMRec_rate_set;
                }  else if (strcmp(_str,"-pkt_life") == 0) {
                    cmd = _wrap_sacMCMRec_pkt_life_set;
                }  else if (strcmp(_str,"-sl_flow_hop") == 0) {
                    cmd = _wrap_sacMCMRec_sl_flow_hop_set;
                }  else if (strcmp(_str,"-scope_state") == 0) {
                    cmd = _wrap_sacMCMRec_scope_state_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -mgid -port_gid -qkey -mlid -mtu -tclass -pkey -rate -pkt_life -sl_flow_hop -scope_state  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -mgid -port_gid -qkey -mlid -mtu -tclass -pkey -rate -pkt_life -sl_flow_hop -scope_state  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-mgid") == 0) {
                    cmd = _wrap_sacMCMRec_mgid_get;
                }  else if (strcmp(_str,"-port_gid") == 0) {
                    cmd = _wrap_sacMCMRec_port_gid_get;
                }  else if (strcmp(_str,"-qkey") == 0) {
                    cmd = _wrap_sacMCMRec_qkey_get;
                }  else if (strcmp(_str,"-mlid") == 0) {
                    cmd = _wrap_sacMCMRec_mlid_get;
                }  else if (strcmp(_str,"-mtu") == 0) {
                    cmd = _wrap_sacMCMRec_mtu_get;
                }  else if (strcmp(_str,"-tclass") == 0) {
                    cmd = _wrap_sacMCMRec_tclass_get;
                }  else if (strcmp(_str,"-pkey") == 0) {
                    cmd = _wrap_sacMCMRec_pkey_get;
                }  else if (strcmp(_str,"-rate") == 0) {
                    cmd = _wrap_sacMCMRec_rate_get;
                }  else if (strcmp(_str,"-pkt_life") == 0) {
                    cmd = _wrap_sacMCMRec_pkt_life_get;
                }  else if (strcmp(_str,"-sl_flow_hop") == 0) {
                    cmd = _wrap_sacMCMRec_sl_flow_hop_get;
                }  else if (strcmp(_str,"-scope_state") == 0) {
                    cmd = _wrap_sacMCMRec_scope_state_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacMCMRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -mgid -port_gid -qkey -mlid -mtu -tclass -pkey -rate -pkt_life -sl_flow_hop -scope_state  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -mgid -port_gid -qkey -mlid -mtu -tclass -pkey -rate -pkt_life -sl_flow_hop -scope_state  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacMCMRec_mgid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mgid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_port_gid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_gid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_qkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-qkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_mlid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mlid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_mtu_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mtu ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_tclass_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-tclass ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_pkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-pkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_rate_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-rate ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_pkt_life_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-pkt_life ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_sl_flow_hop_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-sl_flow_hop ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacMCMRec_scope_state_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-scope_state ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get getTable set del proxy_join_get proxy_join_set obj_delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacMCMRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacMCMRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacMCMRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacMCMRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacMCMRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacMCMRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ibsac_class_port_info_base_ver_set(_swigobj,_swigval) (_swigobj->base_ver = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_base_ver_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacClassPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_base_ver_set { sacClassPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_base_ver_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_class_port_info_base_ver_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_base_ver_get(_swigobj) (&_swigobj->base_ver)
static int _wrap_sacClassPortInfo_base_ver_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_base_ver_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_base_ver_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_class_port_info_base_ver_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_class_ver_set(_swigobj,_swigval) (_swigobj->class_ver = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_class_ver_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacClassPortInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_class_ver_set { sacClassPortInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_class_ver_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_class_port_info_class_ver_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_class_ver_get(_swigobj) (&_swigobj->class_ver)
static int _wrap_sacClassPortInfo_class_ver_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_class_ver_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_class_ver_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_class_port_info_class_ver_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_cap_mask_set(_swigobj,_swigval) (_swigobj->cap_mask = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_cap_mask_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_cap_mask_set { sacClassPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_cap_mask_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_cap_mask_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_cap_mask_get(_swigobj) (&_swigobj->cap_mask)
static int _wrap_sacClassPortInfo_cap_mask_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_cap_mask_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_cap_mask_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_cap_mask_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_cap_mask2_resp_time_set(_swigobj,_swigval) (_swigobj->cap_mask2_resp_time = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_cap_mask2_resp_time_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_cap_mask2_resp_time_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_cap_mask2_resp_time_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_cap_mask2_resp_time_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_cap_mask2_resp_time_get(_swigobj) (&_swigobj->cap_mask2_resp_time)
static int _wrap_sacClassPortInfo_cap_mask2_resp_time_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_cap_mask2_resp_time_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_cap_mask2_resp_time_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_cap_mask2_resp_time_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_gid_set(_swigobj,_swigval) (_swigobj->redir_gid = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_redir_gid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacClassPortInfo * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_gid_set { sacClassPortInfo * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_gid_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ibsac_class_port_info_redir_gid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_gid_get(_swigobj) (&_swigobj->redir_gid)
static int _wrap_sacClassPortInfo_redir_gid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_gid_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_gid_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ibsac_class_port_info_redir_gid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_tc_sl_fl_set(_swigobj,_swigval) (_swigobj->redir_tc_sl_fl = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_redir_tc_sl_fl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_tc_sl_fl_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_tc_sl_fl_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_redir_tc_sl_fl_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_tc_sl_fl_get(_swigobj) (&_swigobj->redir_tc_sl_fl)
static int _wrap_sacClassPortInfo_redir_tc_sl_fl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_tc_sl_fl_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_tc_sl_fl_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_redir_tc_sl_fl_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_lid_set(_swigobj,_swigval) (_swigobj->redir_lid = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_redir_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_lid_set { sacClassPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_lid_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_redir_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_lid_get(_swigobj) (&_swigobj->redir_lid)
static int _wrap_sacClassPortInfo_redir_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_lid_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_lid_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_redir_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_pkey_set(_swigobj,_swigval) (_swigobj->redir_pkey = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_redir_pkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_pkey_set { sacClassPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_pkey_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_redir_pkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_pkey_get(_swigobj) (&_swigobj->redir_pkey)
static int _wrap_sacClassPortInfo_redir_pkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_pkey_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_pkey_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_redir_pkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_qp_set(_swigobj,_swigval) (_swigobj->redir_qp = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_redir_qp_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_qp_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_qp_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_redir_qp_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_qp_get(_swigobj) (&_swigobj->redir_qp)
static int _wrap_sacClassPortInfo_redir_qp_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_qp_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_qp_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_redir_qp_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_qkey_set(_swigobj,_swigval) (_swigobj->redir_qkey = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_redir_qkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_qkey_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_qkey_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_redir_qkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_redir_qkey_get(_swigobj) (&_swigobj->redir_qkey)
static int _wrap_sacClassPortInfo_redir_qkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_redir_qkey_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_redir_qkey_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_redir_qkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_gid_set(_swigobj,_swigval) (_swigobj->trap_gid = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_trap_gid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacClassPortInfo * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_gid_set { sacClassPortInfo * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_gid_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ibsac_class_port_info_trap_gid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_gid_get(_swigobj) (&_swigobj->trap_gid)
static int _wrap_sacClassPortInfo_trap_gid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_gid_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_gid_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ibsac_class_port_info_trap_gid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_tc_sl_fl_set(_swigobj,_swigval) (_swigobj->trap_tc_sl_fl = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_trap_tc_sl_fl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_tc_sl_fl_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_tc_sl_fl_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_trap_tc_sl_fl_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_tc_sl_fl_get(_swigobj) (&_swigobj->trap_tc_sl_fl)
static int _wrap_sacClassPortInfo_trap_tc_sl_fl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_tc_sl_fl_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_tc_sl_fl_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_trap_tc_sl_fl_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_lid_set(_swigobj,_swigval) (_swigobj->trap_lid = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_trap_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_lid_set { sacClassPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_lid_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_trap_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_lid_get(_swigobj) (&_swigobj->trap_lid)
static int _wrap_sacClassPortInfo_trap_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_lid_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_lid_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_trap_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_pkey_set(_swigobj,_swigval) (_swigobj->trap_pkey = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_trap_pkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_pkey_set { sacClassPortInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_pkey_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_trap_pkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_pkey_get(_swigobj) (&_swigobj->trap_pkey)
static int _wrap_sacClassPortInfo_trap_pkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_pkey_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_pkey_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_class_port_info_trap_pkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_hop_qp_set(_swigobj,_swigval) (_swigobj->trap_hop_qp = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_trap_hop_qp_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_hop_qp_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_hop_qp_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_trap_hop_qp_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_hop_qp_get(_swigobj) (&_swigobj->trap_hop_qp)
static int _wrap_sacClassPortInfo_trap_hop_qp_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_hop_qp_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_hop_qp_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_trap_hop_qp_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_qkey_set(_swigobj,_swigval) (_swigobj->trap_qkey = *(_swigval),_swigval)
static int _wrap_sacClassPortInfo_trap_qkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_qkey_set { sacClassPortInfo * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_qkey_set. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_trap_qkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_class_port_info_trap_qkey_get(_swigobj) (&_swigobj->trap_qkey)
static int _wrap_sacClassPortInfo_trap_qkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_trap_qkey_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_trap_qkey_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ibsac_class_port_info_trap_qkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static char * sacClassPortInfo_get(sacClassPortInfo *self) {
    return(ibsacClassPortInfoQuery(self, 0, IB_MAD_METHOD_GET));
  }
static int _wrap_sacClassPortInfo_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_get { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_get. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacClassPortInfo_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacClassPortInfo_delete(sacClassPortInfo *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacClassPortInfo_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacClassPortInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacClassPortInfo_delete { sacClassPortInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacClassPortInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacClassPortInfo_delete. Expected _sacClassPortInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacClassPortInfo_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacClassPortInfoMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacClassPortInfo methods : { dump cget configure get delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacClassPortInfo_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacClassPortInfo_get;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacClassPortInfo_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-base_ver") == 0) {
                    cmd = _wrap_sacClassPortInfo_base_ver_set;
                }  else if (strcmp(_str,"-class_ver") == 0) {
                    cmd = _wrap_sacClassPortInfo_class_ver_set;
                }  else if (strcmp(_str,"-cap_mask") == 0) {
                    cmd = _wrap_sacClassPortInfo_cap_mask_set;
                }  else if (strcmp(_str,"-cap_mask2_resp_time") == 0) {
                    cmd = _wrap_sacClassPortInfo_cap_mask2_resp_time_set;
                }  else if (strcmp(_str,"-redir_gid") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_gid_set;
                }  else if (strcmp(_str,"-redir_tc_sl_fl") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_tc_sl_fl_set;
                }  else if (strcmp(_str,"-redir_lid") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_lid_set;
                }  else if (strcmp(_str,"-redir_pkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_pkey_set;
                }  else if (strcmp(_str,"-redir_qp") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_qp_set;
                }  else if (strcmp(_str,"-redir_qkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_qkey_set;
                }  else if (strcmp(_str,"-trap_gid") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_gid_set;
                }  else if (strcmp(_str,"-trap_tc_sl_fl") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_tc_sl_fl_set;
                }  else if (strcmp(_str,"-trap_lid") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_lid_set;
                }  else if (strcmp(_str,"-trap_pkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_pkey_set;
                }  else if (strcmp(_str,"-trap_hop_qp") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_hop_qp_set;
                }  else if (strcmp(_str,"-trap_qkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_qkey_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -base_ver -class_ver -cap_mask -cap_mask2_resp_time -redir_gid -redir_tc_sl_fl -redir_lid -redir_pkey -redir_qp -redir_qkey -trap_gid -trap_tc_sl_fl -trap_lid -trap_pkey -trap_hop_qp -trap_qkey  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -base_ver -class_ver -cap_mask -cap_mask2_resp_time -redir_gid -redir_tc_sl_fl -redir_lid -redir_pkey -redir_qp -redir_qkey -trap_gid -trap_tc_sl_fl -trap_lid -trap_pkey -trap_hop_qp -trap_qkey  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-base_ver") == 0) {
                    cmd = _wrap_sacClassPortInfo_base_ver_get;
                }  else if (strcmp(_str,"-class_ver") == 0) {
                    cmd = _wrap_sacClassPortInfo_class_ver_get;
                }  else if (strcmp(_str,"-cap_mask") == 0) {
                    cmd = _wrap_sacClassPortInfo_cap_mask_get;
                }  else if (strcmp(_str,"-cap_mask2_resp_time") == 0) {
                    cmd = _wrap_sacClassPortInfo_cap_mask2_resp_time_get;
                }  else if (strcmp(_str,"-redir_gid") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_gid_get;
                }  else if (strcmp(_str,"-redir_tc_sl_fl") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_tc_sl_fl_get;
                }  else if (strcmp(_str,"-redir_lid") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_lid_get;
                }  else if (strcmp(_str,"-redir_pkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_pkey_get;
                }  else if (strcmp(_str,"-redir_qp") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_qp_get;
                }  else if (strcmp(_str,"-redir_qkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_redir_qkey_get;
                }  else if (strcmp(_str,"-trap_gid") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_gid_get;
                }  else if (strcmp(_str,"-trap_tc_sl_fl") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_tc_sl_fl_get;
                }  else if (strcmp(_str,"-trap_lid") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_lid_get;
                }  else if (strcmp(_str,"-trap_pkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_pkey_get;
                }  else if (strcmp(_str,"-trap_hop_qp") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_hop_qp_get;
                }  else if (strcmp(_str,"-trap_qkey") == 0) {
                    cmd = _wrap_sacClassPortInfo_trap_qkey_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacClassPortInfo_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -base_ver -class_ver -cap_mask -cap_mask2_resp_time -redir_gid -redir_tc_sl_fl -redir_lid -redir_pkey -redir_qp -redir_qkey -trap_gid -trap_tc_sl_fl -trap_lid -trap_pkey -trap_hop_qp -trap_qkey  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -base_ver -class_ver -cap_mask -cap_mask2_resp_time -redir_gid -redir_tc_sl_fl -redir_lid -redir_pkey -redir_qp -redir_qkey -trap_gid -trap_tc_sl_fl -trap_lid -trap_pkey -trap_hop_qp -trap_qkey  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacClassPortInfo_base_ver_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_ver ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_class_ver_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-class_ver ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_cap_mask_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-cap_mask ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_cap_mask2_resp_time_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-cap_mask2_resp_time ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_redir_gid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-redir_gid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_redir_tc_sl_fl_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-redir_tc_sl_fl ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_redir_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-redir_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_redir_pkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-redir_pkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_redir_qp_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-redir_qp ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_redir_qkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-redir_qkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_trap_gid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_gid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_trap_tc_sl_fl_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_tc_sl_fl ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_trap_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_trap_pkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_pkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_trap_hop_qp_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_hop_qp ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacClassPortInfo_trap_qkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_qkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacClassPortInfoCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacClassPortInfo * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacClassPortInfo_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacClassPortInfo_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacClassPortInfo object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacClassPortInfoMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ibsac_inform_info_gid_set(_swigobj,_swigval) (_swigobj->gid = *(_swigval),_swigval)
static int _wrap_sacInformInfo_gid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacInformInfo * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_gid_set { sacInformInfo * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_gid_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ibsac_inform_info_gid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_gid_get(_swigobj) (&_swigobj->gid)
static int _wrap_sacInformInfo_gid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_gid_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_gid_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ibsac_inform_info_gid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_lid_range_begin_set(_swigobj,_swigval) (_swigobj->lid_range_begin = *(_swigval),_swigval)
static int _wrap_sacInformInfo_lid_range_begin_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_lid_range_begin_set { sacInformInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_lid_range_begin_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_lid_range_begin_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_lid_range_begin_get(_swigobj) (&_swigobj->lid_range_begin)
static int _wrap_sacInformInfo_lid_range_begin_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_lid_range_begin_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_lid_range_begin_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_lid_range_begin_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_lid_range_end_set(_swigobj,_swigval) (_swigobj->lid_range_end = *(_swigval),_swigval)
static int _wrap_sacInformInfo_lid_range_end_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_lid_range_end_set { sacInformInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_lid_range_end_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_lid_range_end_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_lid_range_end_get(_swigobj) (&_swigobj->lid_range_end)
static int _wrap_sacInformInfo_lid_range_end_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_lid_range_end_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_lid_range_end_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_lid_range_end_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_reserved1_set(_swigobj,_swigval) (_swigobj->reserved1 = *(_swigval),_swigval)
static int _wrap_sacInformInfo_reserved1_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_reserved1_set { sacInformInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_reserved1_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_reserved1_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_reserved1_get(_swigobj) (&_swigobj->reserved1)
static int _wrap_sacInformInfo_reserved1_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_reserved1_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_reserved1_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_reserved1_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_is_generic_set(_swigobj,_swigval) (_swigobj->is_generic = *(_swigval),_swigval)
static int _wrap_sacInformInfo_is_generic_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_is_generic_set { sacInformInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_is_generic_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_inform_info_is_generic_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_is_generic_get(_swigobj) (&_swigobj->is_generic)
static int _wrap_sacInformInfo_is_generic_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_is_generic_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_is_generic_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_inform_info_is_generic_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_subscribe_set(_swigobj,_swigval) (_swigobj->subscribe = *(_swigval),_swigval)
static int _wrap_sacInformInfo_subscribe_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_subscribe_set { sacInformInfo * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_subscribe_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_inform_info_subscribe_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_subscribe_get(_swigobj) (&_swigobj->subscribe)
static int _wrap_sacInformInfo_subscribe_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_subscribe_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_subscribe_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ibsac_inform_info_subscribe_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_trap_type_set(_swigobj,_swigval) (_swigobj->trap_type = *(_swigval),_swigval)
static int _wrap_sacInformInfo_trap_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_trap_type_set { sacInformInfo * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_trap_type_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_trap_type_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_trap_type_get(_swigobj) (&_swigobj->trap_type)
static int _wrap_sacInformInfo_trap_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_trap_type_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_trap_type_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ibsac_inform_info_trap_type_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ibsac_inform_info_g_or_v_get(_swigobj) (&_swigobj->g_or_v)
static int _wrap_sacInformInfo_g_or_v_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacInformInfo_g_or_v * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_get { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_get. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacInformInfo_g_or_v *)_ibsac_inform_info_g_or_v_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacInformInfo_g_or_v_p");
    return TCL_OK;
}
static char * sacInformInfo_set(sacInformInfo *self) {
    return(ibsacInformInfoQuery(self, 0, IB_MAD_METHOD_SET));
  }
static int _wrap_sacInformInfo_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_set { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_set. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacInformInfo_set(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacInformInfo_delete(sacInformInfo *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacInformInfo_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacInformInfo * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_delete { sacInformInfo * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_delete. Expected _sacInformInfo_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacInformInfo_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacInformInfoMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacInformInfo methods : { dump cget configure set delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacInformInfo_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"set") == 0) {
        cmd = _wrap_sacInformInfo_set;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacInformInfo_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-gid") == 0) {
                    cmd = _wrap_sacInformInfo_gid_set;
                }  else if (strcmp(_str,"-lid_range_begin") == 0) {
                    cmd = _wrap_sacInformInfo_lid_range_begin_set;
                }  else if (strcmp(_str,"-lid_range_end") == 0) {
                    cmd = _wrap_sacInformInfo_lid_range_end_set;
                }  else if (strcmp(_str,"-reserved1") == 0) {
                    cmd = _wrap_sacInformInfo_reserved1_set;
                }  else if (strcmp(_str,"-is_generic") == 0) {
                    cmd = _wrap_sacInformInfo_is_generic_set;
                }  else if (strcmp(_str,"-subscribe") == 0) {
                    cmd = _wrap_sacInformInfo_subscribe_set;
                }  else if (strcmp(_str,"-trap_type") == 0) {
                    cmd = _wrap_sacInformInfo_trap_type_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -gid -lid_range_begin -lid_range_end -reserved1 -is_generic -subscribe -trap_type  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -gid -lid_range_begin -lid_range_end -reserved1 -is_generic -subscribe -trap_type  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-gid") == 0) {
                    cmd = _wrap_sacInformInfo_gid_get;
                }  else if (strcmp(_str,"-lid_range_begin") == 0) {
                    cmd = _wrap_sacInformInfo_lid_range_begin_get;
                }  else if (strcmp(_str,"-lid_range_end") == 0) {
                    cmd = _wrap_sacInformInfo_lid_range_end_get;
                }  else if (strcmp(_str,"-reserved1") == 0) {
                    cmd = _wrap_sacInformInfo_reserved1_get;
                }  else if (strcmp(_str,"-is_generic") == 0) {
                    cmd = _wrap_sacInformInfo_is_generic_get;
                }  else if (strcmp(_str,"-subscribe") == 0) {
                    cmd = _wrap_sacInformInfo_subscribe_get;
                }  else if (strcmp(_str,"-trap_type") == 0) {
                    cmd = _wrap_sacInformInfo_trap_type_get;
                }  else if (strcmp(_str,"-g_or_v") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacInformInfo_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -gid -lid_range_begin -lid_range_end -reserved1 -is_generic -subscribe -trap_type -g_or_v  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -gid -lid_range_begin -lid_range_end -reserved1 -is_generic -subscribe -trap_type -g_or_v  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacInformInfo_gid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-gid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_lid_range_begin_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid_range_begin ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_lid_range_end_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid_range_end ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_reserved1_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved1 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_is_generic_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-is_generic ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_subscribe_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-subscribe ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_trap_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-g_or_v ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure set delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacInformInfoCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacInformInfo * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacInformInfo_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacInformInfo_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacInformInfo object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacInformInfoMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define sacInformInfo_g_or_v_generic_get(_swigobj) (&_swigobj->generic)
static int _wrap_sacInformInfo_g_or_v_generic_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacInformInfo_g_or_v_generic * _result;
    sacInformInfo_g_or_v * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_get { sacInformInfo_g_or_v * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_get. Expected _sacInformInfo_g_or_v_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacInformInfo_g_or_v_generic *)sacInformInfo_g_or_v_generic_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacInformInfo_g_or_v_generic_p");
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_get(_swigobj) (&_swigobj->vend)
static int _wrap_sacInformInfo_g_or_v_vend_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacInformInfo_g_or_v_vend * _result;
    sacInformInfo_g_or_v * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_get { sacInformInfo_g_or_v * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_get. Expected _sacInformInfo_g_or_v_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacInformInfo_g_or_v_vend *)sacInformInfo_g_or_v_vend_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacInformInfo_g_or_v_vend_p");
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacInformInfo_g_or_vMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacInformInfo_g_or_v methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacInformInfo_g_or_v_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);

          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be {  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-generic") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_get;
                }  else if (strcmp(_str,"-vend") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacInformInfo_g_or_v_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -generic -vend  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -generic -vend  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacInformInfo_g_or_v_generic_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-generic ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_vend_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vend ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacInformInfo_g_or_vCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacInformInfo_g_or_v * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacInformInfo_g_or_v_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacInformInfo_g_or_v_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacInformInfo_g_or_v object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacInformInfo_g_or_vMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define sacInformInfo_g_or_v_generic_trap_num_set(_swigobj,_swigval) (_swigobj->trap_num = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_generic_trap_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_trap_num_set { sacInformInfo_g_or_v_generic * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_trap_num_set. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_generic_trap_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_trap_num_get(_swigobj) (&_swigobj->trap_num)
static int _wrap_sacInformInfo_g_or_v_generic_trap_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_trap_num_get { sacInformInfo_g_or_v_generic * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_trap_num_get. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_generic_trap_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_qpn_resp_time_val_set(_swigobj,_swigval) (_swigobj->qpn_resp_time_val = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_generic_qpn_resp_time_val_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_qpn_resp_time_val_set { sacInformInfo_g_or_v_generic * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_qpn_resp_time_val_set. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)sacInformInfo_g_or_v_generic_qpn_resp_time_val_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_qpn_resp_time_val_get(_swigobj) (&_swigobj->qpn_resp_time_val)
static int _wrap_sacInformInfo_g_or_v_generic_qpn_resp_time_val_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_qpn_resp_time_val_get { sacInformInfo_g_or_v_generic * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_qpn_resp_time_val_get. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)sacInformInfo_g_or_v_generic_qpn_resp_time_val_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_reserved2_set(_swigobj,_swigval) (_swigobj->reserved2 = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_generic_reserved2_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_reserved2_set { sacInformInfo_g_or_v_generic * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_reserved2_set. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_generic_reserved2_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_reserved2_get(_swigobj) (&_swigobj->reserved2)
static int _wrap_sacInformInfo_g_or_v_generic_reserved2_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_reserved2_get { sacInformInfo_g_or_v_generic * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_reserved2_get. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_generic_reserved2_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_node_type_msb_set(_swigobj,_swigval) (_swigobj->node_type_msb = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_generic_node_type_msb_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_node_type_msb_set { sacInformInfo_g_or_v_generic * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_node_type_msb_set. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_generic_node_type_msb_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_node_type_msb_get(_swigobj) (&_swigobj->node_type_msb)
static int _wrap_sacInformInfo_g_or_v_generic_node_type_msb_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_node_type_msb_get { sacInformInfo_g_or_v_generic * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_node_type_msb_get. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_generic_node_type_msb_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_node_type_lsb_set(_swigobj,_swigval) (_swigobj->node_type_lsb = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_generic_node_type_lsb_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_node_type_lsb_set { sacInformInfo_g_or_v_generic * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_node_type_lsb_set. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_generic_node_type_lsb_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_generic_node_type_lsb_get(_swigobj) (&_swigobj->node_type_lsb)
static int _wrap_sacInformInfo_g_or_v_generic_node_type_lsb_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_generic * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_generic_node_type_lsb_get { sacInformInfo_g_or_v_generic * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_generic_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_generic_node_type_lsb_get. Expected _sacInformInfo_g_or_v_generic_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_generic_node_type_lsb_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacInformInfo_g_or_v_genericMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacInformInfo_g_or_v_generic methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacInformInfo_g_or_v_generic_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-trap_num") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_trap_num_set;
                }  else if (strcmp(_str,"-qpn_resp_time_val") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_qpn_resp_time_val_set;
                }  else if (strcmp(_str,"-reserved2") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_reserved2_set;
                }  else if (strcmp(_str,"-node_type_msb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_node_type_msb_set;
                }  else if (strcmp(_str,"-node_type_lsb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_node_type_lsb_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -trap_num -qpn_resp_time_val -reserved2 -node_type_msb -node_type_lsb  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -trap_num -qpn_resp_time_val -reserved2 -node_type_msb -node_type_lsb  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-trap_num") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_trap_num_get;
                }  else if (strcmp(_str,"-qpn_resp_time_val") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_qpn_resp_time_val_get;
                }  else if (strcmp(_str,"-reserved2") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_reserved2_get;
                }  else if (strcmp(_str,"-node_type_msb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_node_type_msb_get;
                }  else if (strcmp(_str,"-node_type_lsb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_generic_node_type_lsb_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacInformInfo_g_or_v_generic_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -trap_num -qpn_resp_time_val -reserved2 -node_type_msb -node_type_lsb  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -trap_num -qpn_resp_time_val -reserved2 -node_type_msb -node_type_lsb  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacInformInfo_g_or_v_generic_trap_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-trap_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_generic_qpn_resp_time_val_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-qpn_resp_time_val ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_generic_reserved2_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved2 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_generic_node_type_msb_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_type_msb ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_generic_node_type_lsb_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_type_lsb ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacInformInfo_g_or_v_genericCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacInformInfo_g_or_v_generic * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacInformInfo_g_or_v_generic_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacInformInfo_g_or_v_generic_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacInformInfo_g_or_v_generic object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacInformInfo_g_or_v_genericMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define sacInformInfo_g_or_v_vend_dev_id_set(_swigobj,_swigval) (_swigobj->dev_id = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_vend_dev_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_dev_id_set { sacInformInfo_g_or_v_vend * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_dev_id_set. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_vend_dev_id_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_dev_id_get(_swigobj) (&_swigobj->dev_id)
static int _wrap_sacInformInfo_g_or_v_vend_dev_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_dev_id_get { sacInformInfo_g_or_v_vend * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_dev_id_get. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_vend_dev_id_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_qpn_resp_time_val_set(_swigobj,_swigval) (_swigobj->qpn_resp_time_val = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_vend_qpn_resp_time_val_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_qpn_resp_time_val_set { sacInformInfo_g_or_v_vend * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_qpn_resp_time_val_set. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)sacInformInfo_g_or_v_vend_qpn_resp_time_val_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_qpn_resp_time_val_get(_swigobj) (&_swigobj->qpn_resp_time_val)
static int _wrap_sacInformInfo_g_or_v_vend_qpn_resp_time_val_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_qpn_resp_time_val_get { sacInformInfo_g_or_v_vend * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_qpn_resp_time_val_get. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)sacInformInfo_g_or_v_vend_qpn_resp_time_val_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_reserved2_set(_swigobj,_swigval) (_swigobj->reserved2 = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_vend_reserved2_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_reserved2_set { sacInformInfo_g_or_v_vend * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_reserved2_set. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_vend_reserved2_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_reserved2_get(_swigobj) (&_swigobj->reserved2)
static int _wrap_sacInformInfo_g_or_v_vend_reserved2_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_reserved2_get { sacInformInfo_g_or_v_vend * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_reserved2_get. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_vend_reserved2_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_vendor_id_msb_set(_swigobj,_swigval) (_swigobj->vendor_id_msb = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_vend_vendor_id_msb_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_vendor_id_msb_set { sacInformInfo_g_or_v_vend * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_vendor_id_msb_set. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_vend_vendor_id_msb_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_vendor_id_msb_get(_swigobj) (&_swigobj->vendor_id_msb)
static int _wrap_sacInformInfo_g_or_v_vend_vendor_id_msb_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_vendor_id_msb_get { sacInformInfo_g_or_v_vend * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_vendor_id_msb_get. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)sacInformInfo_g_or_v_vend_vendor_id_msb_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_vendor_id_lsb_set(_swigobj,_swigval) (_swigobj->vendor_id_lsb = *(_swigval),_swigval)
static int _wrap_sacInformInfo_g_or_v_vend_vendor_id_lsb_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_vendor_id_lsb_set { sacInformInfo_g_or_v_vend * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_vendor_id_lsb_set. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_vend_vendor_id_lsb_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define sacInformInfo_g_or_v_vend_vendor_id_lsb_get(_swigobj) (&_swigobj->vendor_id_lsb)
static int _wrap_sacInformInfo_g_or_v_vend_vendor_id_lsb_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacInformInfo_g_or_v_vend * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacInformInfo_g_or_v_vend_vendor_id_lsb_get { sacInformInfo_g_or_v_vend * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacInformInfo_g_or_v_vend_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacInformInfo_g_or_v_vend_vendor_id_lsb_get. Expected _sacInformInfo_g_or_v_vend_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)sacInformInfo_g_or_v_vend_vendor_id_lsb_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacInformInfo_g_or_v_vendMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacInformInfo_g_or_v_vend methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacInformInfo_g_or_v_vend_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-dev_id") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_dev_id_set;
                }  else if (strcmp(_str,"-qpn_resp_time_val") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_qpn_resp_time_val_set;
                }  else if (strcmp(_str,"-reserved2") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_reserved2_set;
                }  else if (strcmp(_str,"-vendor_id_msb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_vendor_id_msb_set;
                }  else if (strcmp(_str,"-vendor_id_lsb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_vendor_id_lsb_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -dev_id -qpn_resp_time_val -reserved2 -vendor_id_msb -vendor_id_lsb  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -dev_id -qpn_resp_time_val -reserved2 -vendor_id_msb -vendor_id_lsb  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-dev_id") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_dev_id_get;
                }  else if (strcmp(_str,"-qpn_resp_time_val") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_qpn_resp_time_val_get;
                }  else if (strcmp(_str,"-reserved2") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_reserved2_get;
                }  else if (strcmp(_str,"-vendor_id_msb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_vendor_id_msb_get;
                }  else if (strcmp(_str,"-vendor_id_lsb") == 0) {
                    cmd = _wrap_sacInformInfo_g_or_v_vend_vendor_id_lsb_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacInformInfo_g_or_v_vend_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -dev_id -qpn_resp_time_val -reserved2 -vendor_id_msb -vendor_id_lsb  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -dev_id -qpn_resp_time_val -reserved2 -vendor_id_msb -vendor_id_lsb  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacInformInfo_g_or_v_vend_dev_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-dev_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_vend_qpn_resp_time_val_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-qpn_resp_time_val ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_vend_reserved2_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved2 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_vend_vendor_id_msb_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vendor_id_msb ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacInformInfo_g_or_v_vend_vendor_id_lsb_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vendor_id_lsb ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacInformInfo_g_or_v_vendCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacInformInfo_g_or_v_vend * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacInformInfo_g_or_v_vend_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacInformInfo_g_or_v_vend_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacInformInfo_g_or_v_vend object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacInformInfo_g_or_v_vendMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_service_record_service_id_set(_swigobj,_swigval) (_swigobj->service_id = *(_swigval),_swigval)
static int _wrap_sacServiceRec_service_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacServiceRec * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_id_set { sacServiceRec * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_id_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_service_record_service_id_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_id_get(_swigobj) (&_swigobj->service_id)
static int _wrap_sacServiceRec_service_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_id_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_id_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_t *)_ib_service_record_service_id_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_gid_set(_swigobj,_swigval) (_swigobj->service_gid = *(_swigval),_swigval)
static int _wrap_sacServiceRec_service_gid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacServiceRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_gid_set { sacServiceRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_gid_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[40];
  char *p_prefix, *p_guid;
  char *str_token;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  if (! p_prefix)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }
  p_guid = strtok_r(NULL, " ", &str_token);
  if (! p_guid)
  {
    printf("Wrong format for gid prefix:%s\n", Tcl_GetStringFromObj(objv[2],NULL));
    return TCL_ERROR;
  }

  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_service_record_service_gid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_gid_get(_swigobj) (&_swigobj->service_gid)
static int _wrap_sacServiceRec_service_gid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_gid_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_gid_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_gid_t *)_ib_service_record_service_gid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[38];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_pkey_set(_swigobj,_swigval) (_swigobj->service_pkey = *(_swigval),_swigval)
static int _wrap_sacServiceRec_service_pkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacServiceRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_pkey_set { sacServiceRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_pkey_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_service_record_service_pkey_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_pkey_get(_swigobj) (&_swigobj->service_pkey)
static int _wrap_sacServiceRec_service_pkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_pkey_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_pkey_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_service_record_service_pkey_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_resv_set(_swigobj,_swigval) (_swigobj->resv = *(_swigval),_swigval)
static int _wrap_sacServiceRec_resv_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacServiceRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_resv_set { sacServiceRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_resv_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_service_record_resv_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_resv_get(_swigobj) (&_swigobj->resv)
static int _wrap_sacServiceRec_resv_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_resv_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_resv_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_service_record_resv_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_lease_set(_swigobj,_swigval) (_swigobj->service_lease = *(_swigval),_swigval)
static int _wrap_sacServiceRec_service_lease_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacServiceRec * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_lease_set { sacServiceRec * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_lease_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_service_record_service_lease_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_lease_get(_swigobj) (&_swigobj->service_lease)
static int _wrap_sacServiceRec_service_lease_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_lease_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_lease_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_t *)_ib_service_record_service_lease_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static uint8_array_t * _ib_service_record_service_key_set(sacServiceRec *obj, uint8_array_t val[16]) {
{
	int i;
	for (i=0; i <16 ; i++) {
		obj->service_key[i] = *(val+i);
	}
}
    return (uint8_array_t *) val;
}
static int _wrap_sacServiceRec_service_key_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    sacServiceRec * _arg0;
    uint8_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  entrys[16];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_key_set { sacServiceRec * } { uint8_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_key_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 16))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 0xff)
    {
      printf("Error: wrong format or out of range value for expected uint8_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 16; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_array_t *)_ib_service_record_service_key_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <16 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_service_record_service_key_get(_swigobj) ((uint8_array_t *) _swigobj->service_key)
static int _wrap_sacServiceRec_service_key_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_key_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_key_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_array_t *)_ib_service_record_service_key_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <16 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
static ib_svc_name_t * _ib_service_record_service_name_set(sacServiceRec *obj, ib_svc_name_t *val) {
{
  memcpy(&(obj->service_name), val, sizeof(ib_svc_name_t));
}
    return (ib_svc_name_t *) val;
}
static int _wrap_sacServiceRec_service_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_svc_name_t * _result;
    sacServiceRec * _arg0;
    ib_svc_name_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_svc_name_t  n;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_name_set { sacServiceRec * } { ib_svc_name_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_name_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *p_name;
  int l;
  p_name = Tcl_GetStringFromObj(objv[2], &l);
  if (l > 63) l = 63;
  memcpy(n, p_name, l);
  _arg1 = &n;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_svc_name_t *)_ib_service_record_service_name_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[64];
  strncpy(buff, (char *)(*_result), 63);
  buff[63] = '\0';
  Tcl_SetStringObj(tcl_result,buff, strlen(buff));
}
    return TCL_OK;
}
#define _ib_service_record_service_name_get(_swigobj) (&_swigobj->service_name)
static int _wrap_sacServiceRec_service_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_svc_name_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_name_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_name_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_svc_name_t *)_ib_service_record_service_name_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[64];
  strncpy(buff, (char *)(*_result), 63);
  buff[63] = '\0';
  Tcl_SetStringObj(tcl_result,buff, strlen(buff));
}
    return TCL_OK;
}
static uint8_array_t * _ib_service_record_service_data8_set(sacServiceRec *obj, uint8_array_t val[16]) {
{
	int i;
	for (i=0; i <16 ; i++) {
		obj->service_data8[i] = *(val+i);
	}
}
    return (uint8_array_t *) val;
}
static int _wrap_sacServiceRec_service_data8_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    sacServiceRec * _arg0;
    uint8_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  entrys[16];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data8_set { sacServiceRec * } { uint8_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data8_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 16))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 0xff)
    {
      printf("Error: wrong format or out of range value for expected uint8_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 16; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_array_t *)_ib_service_record_service_data8_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <16 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_service_record_service_data8_get(_swigobj) ((uint8_array_t *) _swigobj->service_data8)
static int _wrap_sacServiceRec_service_data8_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data8_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data8_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_array_t *)_ib_service_record_service_data8_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <16 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
static ib_net16_array_t * _ib_service_record_service_data16_set(sacServiceRec *obj, ib_net16_array_t val[8]) {
{
	int i;
	for (i=0; i <8 ; i++) {
     obj->service_data16[i] = *(val+i);
	}
}
    return (ib_net16_array_t *) val;
}
static int _wrap_sacServiceRec_service_data16_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_array_t * _result;
    sacServiceRec * _arg0;
    ib_net16_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  entrys[8];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data16_set { sacServiceRec * } { ib_net16_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data16_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 8))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 65535)
    {
      printf("Error: wrong format or out of range value for expected ib_net16_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = cl_hton16(entry);
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 8; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_array_t *)_ib_service_record_service_data16_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <8 ; i++) {
    sprintf(buff, "0x%04x ", cl_ntoh16(*(_result+i)));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_service_record_service_data16_get(_swigobj) ((ib_net16_array_t *) _swigobj->service_data16)
static int _wrap_sacServiceRec_service_data16_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_array_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data16_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data16_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_array_t *)_ib_service_record_service_data16_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <8 ; i++) {
    sprintf(buff, "0x%04x ", cl_ntoh16(*(_result+i)));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
static ib_net32_array_t * _ib_service_record_service_data32_set(sacServiceRec *obj, ib_net32_array_t val[4]) {
{
	int i;
	for (i=0; i <4 ; i++) {
     obj->service_data32[i] = *(val+i);
	}
}
    return (ib_net32_array_t *) val;
}
static int _wrap_sacServiceRec_service_data32_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_array_t * _result;
    sacServiceRec * _arg0;
    ib_net32_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  entrys[4];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data32_set { sacServiceRec * } { ib_net32_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data32_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  uint32_t entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 4))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 0xffffffff)
    {
      printf("Error: wrong format or out of range value for expected ib_net32_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = cl_hton32(entry);
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 4; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_array_t *)_ib_service_record_service_data32_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[12];
  for (i=0; i <4 ; i++) {
    sprintf(buff, "0x%08x ", cl_ntoh32(*(_result+i)));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_service_record_service_data32_get(_swigobj) ((ib_net32_array_t *) _swigobj->service_data32)
static int _wrap_sacServiceRec_service_data32_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_array_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data32_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data32_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net32_array_t *)_ib_service_record_service_data32_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[12];
  for (i=0; i <4 ; i++) {
    sprintf(buff, "0x%08x ", cl_ntoh32(*(_result+i)));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
static ib_net64_array_t * _ib_service_record_service_data64_set(sacServiceRec *obj, ib_net64_array_t val[2]) {
{
	int i;
	for (i=0; i <2 ; i++) {
     obj->service_data64[i] = *(val+i);
	}
}
    return (ib_net64_array_t *) val;
}
static int _wrap_sacServiceRec_service_data64_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_array_t * _result;
    sacServiceRec * _arg0;
    ib_net64_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net64_t  entrys[2];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data64_set { sacServiceRec * } { ib_net64_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data64_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  uint64_t entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 2))
  {
    entry = strtoll(p_ch, NULL, 0);
    if (entry > 0xffffffffffffffffULL )
    {
      printf("Error: wrong format or out of range value for expected ib_net64_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = cl_hton64(entry);
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 2; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_array_t *)_ib_service_record_service_data64_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[20];
  for (i=0; i <2 ; i++) {
    sprintf(buff, "0x%016" PRIx64 " ", cl_ntoh64(*(_result+i)));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_service_record_service_data64_get(_swigobj) ((ib_net64_array_t *) _swigobj->service_data64)
static int _wrap_sacServiceRec_service_data64_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_array_t * _result;
    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_service_data64_get { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_service_data64_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net64_array_t *)_ib_service_record_service_data64_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[20];
  for (i=0; i <2 ; i++) {
    sprintf(buff, "0x%016" PRIx64 " ", cl_ntoh64(*(_result+i)));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
static char * sacServiceRec_get(sacServiceRec *self,uint64_t  comp_mask) {
    return(ibsacServiceRecordQuery(self, cl_hton64(comp_mask),
                                   IB_MAD_METHOD_GET));
  }
static int _wrap_sacServiceRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacServiceRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_get { sacServiceRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_get. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacServiceRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacServiceRec_set(sacServiceRec *self,uint64_t  comp_mask) {
    return(ibsacServiceRecordQuery(self, cl_hton64(comp_mask),
                                   IB_MAD_METHOD_SET));
  }
static int _wrap_sacServiceRec_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacServiceRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_set { sacServiceRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_set. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacServiceRec_set(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacServiceRec_getTable(sacServiceRec *self,uint64_t  comp_mask) {
    return(ibsacServiceRecordQuery(self, cl_hton64(comp_mask),
                                   IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacServiceRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacServiceRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_getTable { sacServiceRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_getTable. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacServiceRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacServiceRec_delete(sacServiceRec *self,uint64_t  comp_mask) {
    return(ibsacServiceRecordQuery(self, cl_hton64(comp_mask),
                                   IB_MAD_METHOD_DELETE));
  }
static int _wrap_sacServiceRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacServiceRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_delete { sacServiceRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_delete. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacServiceRec_delete(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacServiceRec_obj_delete(sacServiceRec *self) {
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacServiceRec_obj_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacServiceRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacServiceRec_obj_delete { sacServiceRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacServiceRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacServiceRec_obj_delete. Expected _sacServiceRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacServiceRec_obj_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacServiceRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacServiceRec methods : { dump cget configure get set getTable delete obj_delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacServiceRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacServiceRec_get;
    }    else if (strcmp(_str,"set") == 0) {
        cmd = _wrap_sacServiceRec_set;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacServiceRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacServiceRec_delete;
    }    else if (strcmp(_str,"obj_delete") == 0) {
        cmd = _wrap_sacServiceRec_obj_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-service_id") == 0) {
                    cmd = _wrap_sacServiceRec_service_id_set;
                }  else if (strcmp(_str,"-service_gid") == 0) {
                    cmd = _wrap_sacServiceRec_service_gid_set;
                }  else if (strcmp(_str,"-service_pkey") == 0) {
                    cmd = _wrap_sacServiceRec_service_pkey_set;
                }  else if (strcmp(_str,"-resv") == 0) {
                    cmd = _wrap_sacServiceRec_resv_set;
                }  else if (strcmp(_str,"-service_lease") == 0) {
                    cmd = _wrap_sacServiceRec_service_lease_set;
                }  else if (strcmp(_str,"-service_key") == 0) {
                    cmd = _wrap_sacServiceRec_service_key_set;
                }  else if (strcmp(_str,"-service_name") == 0) {
                    cmd = _wrap_sacServiceRec_service_name_set;
                }  else if (strcmp(_str,"-service_data8") == 0) {
                    cmd = _wrap_sacServiceRec_service_data8_set;
                }  else if (strcmp(_str,"-service_data16") == 0) {
                    cmd = _wrap_sacServiceRec_service_data16_set;
                }  else if (strcmp(_str,"-service_data32") == 0) {
                    cmd = _wrap_sacServiceRec_service_data32_set;
                }  else if (strcmp(_str,"-service_data64") == 0) {
                    cmd = _wrap_sacServiceRec_service_data64_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -service_id -service_gid -service_pkey -resv -service_lease -service_key -service_name -service_data8 -service_data16 -service_data32 -service_data64  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -service_id -service_gid -service_pkey -resv -service_lease -service_key -service_name -service_data8 -service_data16 -service_data32 -service_data64  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-service_id") == 0) {
                    cmd = _wrap_sacServiceRec_service_id_get;
                }  else if (strcmp(_str,"-service_gid") == 0) {
                    cmd = _wrap_sacServiceRec_service_gid_get;
                }  else if (strcmp(_str,"-service_pkey") == 0) {
                    cmd = _wrap_sacServiceRec_service_pkey_get;
                }  else if (strcmp(_str,"-resv") == 0) {
                    cmd = _wrap_sacServiceRec_resv_get;
                }  else if (strcmp(_str,"-service_lease") == 0) {
                    cmd = _wrap_sacServiceRec_service_lease_get;
                }  else if (strcmp(_str,"-service_key") == 0) {
                    cmd = _wrap_sacServiceRec_service_key_get;
                }  else if (strcmp(_str,"-service_name") == 0) {
                    cmd = _wrap_sacServiceRec_service_name_get;
                }  else if (strcmp(_str,"-service_data8") == 0) {
                    cmd = _wrap_sacServiceRec_service_data8_get;
                }  else if (strcmp(_str,"-service_data16") == 0) {
                    cmd = _wrap_sacServiceRec_service_data16_get;
                }  else if (strcmp(_str,"-service_data32") == 0) {
                    cmd = _wrap_sacServiceRec_service_data32_get;
                }  else if (strcmp(_str,"-service_data64") == 0) {
                    cmd = _wrap_sacServiceRec_service_data64_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacServiceRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -service_id -service_gid -service_pkey -resv -service_lease -service_key -service_name -service_data8 -service_data16 -service_data32 -service_data64  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -service_id -service_gid -service_pkey -resv -service_lease -service_key -service_name -service_data8 -service_data16 -service_data32 -service_data64  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacServiceRec_service_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_gid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_gid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_pkey_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_pkey ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_resv_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-resv ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_lease_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_lease ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_key_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_key ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_data8_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_data8 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_data16_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_data16 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_data32_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_data32 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_sacServiceRec_service_data64_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-service_data64 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure get set getTable delete obj_delete }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacServiceRecCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacServiceRec * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacServiceRec_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacServiceRec_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacServiceRec object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacServiceRecMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


static uint8_array_t * _ib_slvl_table_raw_vl_by_sl_set(sacSlVlTbl *obj, uint8_array_t val[IB_MAX_NUM_VLS/2]) {
{
	int i;
	for (i=0; i <IB_MAX_NUM_VLS/2 ; i++) {
		obj->raw_vl_by_sl[i] = *(val+i);
	}
}
    return (uint8_array_t *) val;
}
static int _wrap_sacSlVlTbl_raw_vl_by_sl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    sacSlVlTbl * _arg0;
    uint8_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  entrys[IB_MAX_NUM_VLS/2];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlTbl_raw_vl_by_sl_set { sacSlVlTbl * } { uint8_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlTbl_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlTbl_raw_vl_by_sl_set. Expected _sacSlVlTbl_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < IB_MAX_NUM_VLS/2))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 0xff)
    {
      printf("Error: wrong format or out of range value for expected uint8_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < IB_MAX_NUM_VLS/2; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_array_t *)_ib_slvl_table_raw_vl_by_sl_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <IB_MAX_NUM_VLS/2 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_slvl_table_raw_vl_by_sl_get(_swigobj) ((uint8_array_t *) _swigobj->raw_vl_by_sl)
static int _wrap_sacSlVlTbl_raw_vl_by_sl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    sacSlVlTbl * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlTbl_raw_vl_by_sl_get { sacSlVlTbl * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlTbl_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlTbl_raw_vl_by_sl_get. Expected _sacSlVlTbl_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_array_t *)_ib_slvl_table_raw_vl_by_sl_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <IB_MAX_NUM_VLS/2 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacSlVlTblMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacSlVlTbl methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacSlVlTbl_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-raw_vl_by_sl") == 0) {
                    cmd = _wrap_sacSlVlTbl_raw_vl_by_sl_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -raw_vl_by_sl  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -raw_vl_by_sl  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-raw_vl_by_sl") == 0) {
                    cmd = _wrap_sacSlVlTbl_raw_vl_by_sl_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacSlVlTbl_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -raw_vl_by_sl  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -raw_vl_by_sl  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_sacSlVlTbl_raw_vl_by_sl_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-raw_vl_by_sl ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclsacSlVlTblCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    sacSlVlTbl * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_sacSlVlTbl_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_sacSlVlTbl_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a sacSlVlTbl object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclsacSlVlTblMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_slvl_table_record_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_sacSlVlRec_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSlVlRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_lid_set { sacSlVlRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_lid_set. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_slvl_table_record_lid_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_sacSlVlRec_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    sacSlVlRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_lid_get { sacSlVlRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_lid_get. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (ib_net16_t *)_ib_slvl_table_record_lid_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_in_port_num_set(_swigobj,_swigval) (_swigobj->in_port_num = *(_swigval),_swigval)
static int _wrap_sacSlVlRec_in_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSlVlRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_in_port_num_set { sacSlVlRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_in_port_num_set. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_slvl_table_record_in_port_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_in_port_num_get(_swigobj) (&_swigobj->in_port_num)
static int _wrap_sacSlVlRec_in_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSlVlRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_in_port_num_get { sacSlVlRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_in_port_num_get. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_slvl_table_record_in_port_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_out_port_num_set(_swigobj,_swigval) (_swigobj->out_port_num = *(_swigval),_swigval)
static int _wrap_sacSlVlRec_out_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSlVlRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_out_port_num_set { sacSlVlRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_out_port_num_set. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_slvl_table_record_out_port_num_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_out_port_num_get(_swigobj) (&_swigobj->out_port_num)
static int _wrap_sacSlVlRec_out_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    sacSlVlRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_out_port_num_get { sacSlVlRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_out_port_num_get. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint8_t *)_ib_slvl_table_record_out_port_num_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_resv_set(_swigobj,_swigval) (_swigobj->resv = *(_swigval),_swigval)
static int _wrap_sacSlVlRec_resv_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    sacSlVlRec * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_resv_set { sacSlVlRec * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_resv_set. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint32_t *)_ib_slvl_table_record_resv_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_resv_get(_swigobj) (&_swigobj->resv)
static int _wrap_sacSlVlRec_resv_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    sacSlVlRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_resv_get { sacSlVlRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_resv_get. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (uint32_t *)_ib_slvl_table_record_resv_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_slvl_table_record_slvl_tbl_set(_swigobj,_swigval) (_swigobj->slvl_tbl = *(_swigval),_swigval)
static int _wrap_sacSlVlRec_slvl_tbl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSlVlTbl * _result;
    sacSlVlRec * _arg0;
    sacSlVlTbl * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_slvl_tbl_set { sacSlVlRec * } { sacSlVlTbl * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_slvl_tbl_set. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_sacSlVlTbl_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of sacSlVlRec_slvl_tbl_set. Expected _sacSlVlTbl_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacSlVlTbl *)_ib_slvl_table_record_slvl_tbl_set(_arg0,_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacSlVlTbl_p");
    return TCL_OK;
}
#define _ib_slvl_table_record_slvl_tbl_get(_swigobj) (&_swigobj->slvl_tbl)
static int _wrap_sacSlVlRec_slvl_tbl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSlVlTbl * _result;
    sacSlVlRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_slvl_tbl_get { sacSlVlRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_slvl_tbl_get. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (sacSlVlTbl *)_ib_slvl_table_record_slvl_tbl_get(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_sacSlVlTbl_p");
    return TCL_OK;
}
static char * sacSlVlRec_get(sacSlVlRec *self,uint64_t  comp_mask) {
    return(ibsacSl2VlRecordQuery(self, cl_hton64(comp_mask),
                                 IB_MAD_METHOD_GET));
  }
static int _wrap_sacSlVlRec_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacSlVlRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_get { sacSlVlRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_get. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacSlVlRec_get(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static char * sacSlVlRec_getTable(sacSlVlRec *self,uint64_t  comp_mask) {
    return(ibsacSl2VlRecordQuery(self, cl_hton64(comp_mask),
                                 IB_MAD_METHOD_GETTABLE));
  }
static int _wrap_sacSlVlRec_getTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    sacSlVlRec * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_getTable { sacSlVlRec * } comp_mask ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_getTable. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      _result = (char *)sacSlVlRec_getTable(_arg0,*_arg1);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
free(_result);

    return TCL_OK;
}
static void  sacSlVlRec_delete(sacSlVlRec *self) {
	 SWIG_AltMnglUnregObj(&(self->slvl_tbl));
	 SWIG_AltMnglUnregObj(self);
    free(self);
  }
static int _wrap_sacSlVlRec_delete(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    sacSlVlRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. sacSlVlRec_delete { sacSlVlRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_sacSlVlRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of sacSlVlRec_delete. Expected _sacSlVlRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  /* we can check if IBIS was initialized here */
  if (!IbisObj.initialized)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      "ibis was not yet initialized. please use ibis_init and then ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  if (! IbisObj.port_guid)
  {
    Tcl_SetStringObj(
      Tcl_GetObjResult(interp),
      " ibis was not yet initialized. please use ibis_set_port before.", -1);
    return TCL_ERROR;
  }

  ibis_tcl_error = 0;
      sacSlVlRec_delete(_arg0);
;
  if (ibis_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibis_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclsacSlVlRecMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"sacSlVlRec methods : { dump cget configure get getTable delete  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_sacSlVlRec_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"get") == 0) {
        cmd = _wrap_sacSlVlRec_get;
    }    else if (strcmp(_str,"getTable") == 0) {
        cmd = _wrap_sacSlVlRec_getTable;
    }    else if (strcmp(_str,"delete") == 0) {
        cmd = _wrap_sacSlVlRec_delete;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacSlVlRec_lid_set;
                }  else if (strcmp(_str,"-in_port_num") == 0) {
                    cmd = _wrap_sacSlVlRec_in_port_num_set;
                }  else if (strcmp(_str,"-out_port_num") == 0) {
                    cmd = _wrap_sacSlVlRec_out_port_num_set;
                }  else if (strcmp(_str,"-resv") == 0) {
                    cmd = _wrap_sacSlVlRec_resv_set;
                }  else if (strcmp(_str,"-slvl_tbl") == 0) {
                    cmd = _wrap_sacSlVlRec_slvl_tbl_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -in_port_num -out_port_num -resv -slvl_tbl  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -in_port_num -out_port_num -resv -slvl_tbl  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_sacSlVlRec_lid_get;
                }  else if (strcmp(_str,"-in_port_num") == 0) {
                    cmd = _wrap_sacSlVlRec_in_port_num_get;
                }  else if (strcmp(_str,"-out_port_num") == 0) {
                    cmd = _wrap_sacSlVlRec_out_port_num_get;
                }  else if (strcmp(_str,"-resv") == 0) {
                    cmd = _wrap_sacSlVlRec_resv_get;
                }  else if (strcmp(_str,"-slvl_tbl") == 0) {
                    cmd = _wrap_sacSlVlRec_slvl_tbl_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_sacSlVlRec_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -in_port_num -out_port_num -resv -slvl_tbl  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -in_port_num -out_port_num -resv -slvl_tbl  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
   