/*
 *  linux/ibcs/stream.c
 *
 *  Copyright 1994, 1995  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: stream.c,v 1.11 1998/06/24 20:34:17 jaggy Exp $
 * $Source: /u/CVS/ibcs/iBCSemul/stream.c,v $
 */

#include <linux/config.h>

#include <linux/module.h>
#include <linux/version.h>

#include <asm/uaccess.h>

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/ptrace.h>
#include <linux/net.h>
#include <linux/mm.h>
#include <linux/socket.h>
#include <linux/file.h>

#include <ibcs/ibcs.h>
#include <ibcs/stream.h>
#include <ibcs/tli.h>

#ifdef IBCS_TRACE
#include <ibcs/trace.h>
#endif


int
ibcs_getmsg(struct pt_regs *regs)
{
	int fd;
	struct file *filep;
	struct inode *ino;
	int error;

	fd = (int)get_syscall_parameter (regs, 0);
	filep = fget(fd);
	if (!filep)
		return -EBADF;

	error = -EBADF;
	ino = filep->f_dentry->d_inode;
	if (ino->i_sock) {
#if defined(EMU_XTI) || defined(SPX)
		error = timod_getmsg(fd, ino, 0, regs);
#else
		error = 0;
#endif /* EMU_XTI */
	}
	fput(filep);
	return error;
}


int
ibcs_putmsg(struct pt_regs *regs)
{
	int fd;
	struct file *filep;
	struct inode *ino;
	int error;

	fd = (int)get_syscall_parameter (regs, 0);
	filep = fget(fd);
	if (!filep)
		return -EBADF;

	error = -EBADF;
	ino = filep->f_dentry->d_inode;
	if (ino->i_sock
	|| (MAJOR(ino->i_rdev) == 30 && MINOR(ino->i_rdev) == 1)) {
#if defined(EMU_XTI) || defined(EMU_SPX)
		error = timod_putmsg(fd, ino, 0, regs);
#else
		error = 0;
#endif
	}
	fput(filep);
	return error;
}


#ifdef EMU_XTI
int
ibcs_getpmsg(struct pt_regs *regs)
{
	int fd;
	struct file *filep;
	struct inode *ino;
	int error;

	fd = (int)get_syscall_parameter (regs, 0);

	filep = fget(fd);
	if (!filep)
		return -EBADF;

	error = -EBADF;
	ino = filep->f_dentry->d_inode;
	if (ino->i_sock)
		error = timod_getmsg(fd, ino, 1, regs);
	fput(filep);
	return error;
}


int
ibcs_putpmsg(struct pt_regs *regs)
{
	int fd;
	struct file *filep;
	struct inode *ino;
	int error;

	fd = (int)get_syscall_parameter (regs, 0);

	filep = fget(fd);
	if (!filep)
		return -EBADF;

	error = -EBADF;
	ino = filep->f_dentry->d_inode;
	if (ino->i_sock
	|| (MAJOR(ino->i_rdev) == 30 && MINOR(ino->i_rdev) == 1))
		error = timod_putmsg(fd, ino, 1, regs);
	fput(filep);
	return error;
}
#endif /* EMU_XTI */
