                   
/*
 * File:        sidl_cxx.hxx
 * Copyright:   (c) 2001-2002 The Regents of the University of California
 * Revision:    @(#) $Revision: 1.1 $
 * Date:        $Date: 2006/08/29 23:35:00 $
 * Description: Babel/C++ base classes 
 * AUTOMATICALLY GENERATED BY genSIDLcxx.py
 *
 */

#ifndef included_sidl_cxx_hxx
#define included_sidl_cxx_hxx

#ifndef __cplusplus
#error C++ headerfile: not meant for C compilers
#endif


// get babel configuration information
#include "babel_config.h"
#include <stdlib.h>

// need free()
#include <stddef.h>

// need exception
#include <exception>

// need iterator
#include <iterator>

// need vector
#include <vector>

// include complex<T>
#ifndef HAVE_COMPLEX
#  error C++ bindings assume complex<T> is available
#else
#  ifdef HAVE_COMPLEX_MATH_IN_NAMESPACE_STD
#    include <complex>
#  else
#    include <complex.h>
#  endif
#endif

// include C++ strings
#include <string>

#ifdef sidl
/* AIX /usr/include/sys/proc.h has #define sidl 4 (groan) */
#undef sidl 
#endif

#ifndef included_sidl_interface_IOR_h
#include "sidl_interface_IOR.h"
#endif

#ifndef included_sidl_BaseInterface_h
#include "sidl_BaseInterface.h"
#endif

#ifndef included_sidl_String_h
#include "sidl_String.h"
#endif

#ifndef included_sidlArray_h
#include "sidlArray.h"
#endif

#ifndef included_sidl_BaseInterface_IOR_h
#include "sidl_BaseInterface_IOR.h"
#endif


     //This function is used for downcasting Babel Stubs.
    template<typename Target, typename Source>
    Target babel_cast(const Source& arg)
    {
      // _cast increments the reference count, so don't increment it
      // in the constructor
      return Target(reinterpret_cast<typename Target::ior_t*>(Target::_cast(arg._get_ior())), false);

    }



namespace sidl { 


  // redefine types inside sidl namespace
  // typedef bool bool;
  // typedef char char;
  // typedef ::int32_t int;
  // typedef ::int64_t long;
  // typedef float float;
  // typedef double double;
  typedef ::std::complex<float> fcomplex;
  typedef ::std::complex<double> dcomplex;
  typedef ::std::string string;
  typedef void * opaque;
  
  // rescope enum
  enum array_ordering { 
    general_order = sidl_general_order,
    column_major_order = sidl_column_major_order, 
    row_major_order = sidl_row_major_order
  };

  struct dcomplex_less { 
    bool operator() ( const sidl::dcomplex& a, const sidl::dcomplex& b) const {
      if ( a.real() == b.real() ) { 
        return a.imag() < b.imag();
      } else { 
        return a.real() < b.real();
      }
    }
  };

  struct fcomplex_less { 
    bool operator() ( const sidl::fcomplex& a, const sidl::fcomplex& b) const {
      if ( a.real() == b.real() ) { 
        return a.imag() < b.imag();
      } else { 
        return a.real() < b.real();
      }
    }
  };

  // This class is particular to C++ Stub Bindings.
  class NullIORException : public ::std::exception {
  private:
    ::std::string msg;

  public:
    NullIORException( const char * c ): msg(c) { }
    NullIORException( const ::std::string &s ): msg(s) { }
    virtual const char *what() const throw() { 
      return msg.c_str();
    }
#if defined(__GNUG__) && (__GNUG__ < 3)
    virtual ~NullIORException() { }
#else
    virtual ~NullIORException() throw() { }
#endif
  };

  // This is throw when a particular method is not supported
  class UnsupportedException : public ::std::exception {
  private:
    ::std::string msg;

  public:
    UnsupportedException( const ::std::string &s ): msg(s) { }
    virtual const char *what() const throw() { 
      return msg.c_str();
    }
#if defined(__GNUG__) && (__GNUG__ < 3)
    virtual ~UnsupportedException() { }
#else
    virtual ~UnsupportedException() throw() { }
#endif
  };

    // introduce StubBase into the sidl namespace
    // StubBase is the abstract base class for all C++ stubs.
    class StubBase {
    public:

      StubBase() : d_self(0), d_weak_reference(false) { };

      StubBase(void * ior, bool isWeak) : d_self(ior), d_weak_reference(isWeak) {};

      virtual ~StubBase() { 
        if(!d_weak_reference && d_self != 0) {
          d_weak_reference = true;
          struct sidl_BaseInterface__object* loc_self =
          reinterpret_cast<struct sidl_BaseInterface__object*>(d_self);
          struct sidl_BaseInterface__object* throwaway_exception;
          sidl_BaseInterface_deleteRef(loc_self, &throwaway_exception);
          d_self = 0;
        }
      }

      /* virtual void* _cast(const char* type) const = 0; */

      // copy constructor
      StubBase ( const StubBase& base ) {
        d_self = const_cast< void*>(base.d_self);
        d_weak_reference = base.d_weak_reference;
        if (d_self != 0 ) {
          struct sidl_BaseInterface__object* loc_self =
            reinterpret_cast<struct sidl_BaseInterface__object*>(d_self);
          struct sidl_BaseInterface__object *throwaway_exception;
          sidl_BaseInterface_addRef(loc_self, &throwaway_exception);
        }
      }
    
      // assignment operator
      //BaseInterface& operator= ( const StubBase& rhs );
    
      // conversion from ior to C++ class
      StubBase( void* ior ): d_self(ior), d_weak_reference(false) {
        if ( d_self != 0 ) {
          struct sidl_BaseInterface__object* loc_self =
            reinterpret_cast<struct sidl_BaseInterface__object*>(d_self);
          struct sidl_BaseInterface__object *throwaway_exception;
          sidl_BaseInterface_addRef(loc_self, &throwaway_exception);
        }
      }

    protected:
      // Pointer to sidl's IOR type (one per instance)
      void * d_self;

      // Weak references (used by Impl's only) don't add/deleteRef()
      bool d_weak_reference;

    };



     //This function is used for downcasting Babel Stubs.
    template<typename Target, typename Source>
    Target babel_cast(const Source& arg)
    {
      // _cast increments the reference count, so don't increment it
      // in the constructor
      return Target(reinterpret_cast<typename Target::ior_t*>(Target::_cast(arg._get_ior())), false);

    }


  /////////////////////////////////////////////////////////////////
  // 
  // array iterators:
  // 
  //   array_iter_base  : common base class
  //   array_iter       : standard iterator for sidl::array
  //   const_array_iter : standard const_iterator for sidl::array
  template <typename array_traits>
  class array_iter_base
  { 
  public:
    typedef array_iter_base< array_traits >    iterator;
    typedef typename array_traits::pointer     pointer;
    typedef typename array_traits::cxx_array_t cxx_array_t;
    typedef typename array_traits::cxx_item_t  cxx_item_t;

  protected:
    cxx_array_t d_array;
    int32_t d_index;
    
  public:
    array_iter_base( cxx_array_t a, int32_t i) : d_array(a), d_index(i) {}
    array_iter_base( const iterator& x ) : d_array(x.d_array), d_index(x.d_index) {}
    
    cxx_item_t operator*() const { return d_array.get(d_index); }
    pointer operator->() const { return &(d_array.get(d_index)); }
    
    bool operator==( const array_iter_base& x ) const { return (d_array==x.d_array)&&(d_index==x.d_index); }
    bool operator!=( const array_iter_base& x ) const { return (d_array!=x.d_array)||(d_index!=x.d_index); }
  };
 

  template < typename array_traits > 
  class  array_iter : public array_iter_base< array_traits > 
  { 
  public:
    typedef array_iter_base< array_traits >    Base;
    typedef std::input_iterator_tag            iterator_category;
    typedef typename array_traits::value_type  value_type;
    typedef typename array_traits::pointer     pointer;
    typedef size_t                             size_type;
    typedef int32_t                            difference_type;
    typedef typename array_traits::cxx_array_t cxx_array_t;

    array_iter( cxx_array_t a, int32_t i) : Base(a,i) {}
    array_iter( const array_iter<array_traits>& x) : Base(x) {}

    array_iter& operator++() { ++(this->d_index); return *this; } 
    array_iter operator++(int) { return array_iter(this->d_array, (this->d_index)++); }
  };

  template <typename array_traits > 
  class  const_array_iter : public array_iter_base<array_traits>
  { 
  public:
    typedef array_iter_base<array_traits>       Base;
    typedef std::input_iterator_tag              iterator_category;
    typedef typename array_traits::value_type    value_type;
    typedef typename array_traits::const_pointer const_pointer;
    typedef size_t                              size_type;
    typedef int32_t                             difference_type;
    typedef typename array_traits::cxx_array_t   cxx_array_t;

    const_array_iter( const cxx_array_t a, int32_t i) : Base(a,i) {}
    const_array_iter( const array_iter<cxx_array_t>& x) : Base(x) {}

    const_array_iter& operator++() { ++(this->d_index); return *this; } 
    const_array_iter operator++(int) { return const_array_iter( this->d_array, (this->d_index)++); }
  };

  ////////////////////////////////////////////////////////////
  //
  // basearray is a concrete, non-template base
  //                   class for a SIDL C++ arrays.
  //
  ////////////////////////////////////////////////////////////
  class basearray {
  protected:
    struct sidl__array *d_array;

  public:
    // default destructor
    virtual ~basearray() { sidl__array_deleteRef(d_array); }

    // Wrap up the C struct as a C++ class
    basearray(struct sidl__array *src=0) : d_array(src) {}

    basearray(const basearray &src) : d_array(src.d_array) {
      addRef();
    }

    void addRef() { sidl__array_addRef(this->d_array);  }

    void deleteRef() {
      sidl__array_deleteRef(this->d_array);
      this->d_array = 0; }

    void smartCopy() {
      struct sidl__array *p = sidl__array_smartCopy(this->d_array);
      deleteRef();
      this->d_array = p;
    }

    int32_t dimen() const throw() {
      return sidlArrayDim(this->d_array);
    }

    int32_t lower(int32_t d) const throw() {
      return sidlLower(this->d_array, d);
    }

    int32_t upper(int32_t d) const throw() {
      return sidlUpper(this->d_array, d);
    }

    int32_t length(int32_t d=0) const throw() {
      return sidlLength(this->d_array, d);
    }

    int32_t stride(int32_t d) const throw() {
      return sidlStride(this->d_array, d);
    }

    bool isColumnOrder() const throw() {
      return sidl__array_isColumnOrder(this->d_array);
    }

    bool isRowOrder() const throw() {
      return sidl__array_isRowOrder(this->d_array);
    }

    int32_t arrayType() const throw() {
      return sidl__array_type(this->d_array);
    }

    const struct sidl__array *_get_baseior() const throw() {
      return this->d_array;
    }

    struct sidl__array *_get_baseior() throw() {
      return this->d_array;
    }

    // check if no pointer to array
    bool _is_nil() const throw() {
      return (this->d_array==0);
    }

    // check if no pointer to array
    bool _not_nil() const throw (){
      return (this->d_array!=0);
    }

    // check if no pointer to array
    bool operator !() const throw (){
      return (this->d_array==0);
    }

    // check if the array is allocated
    operator void *() const throw () {
      return (void *)this->d_array;
    }

    void _set_ior(struct sidl__array * s) throw() {
      deleteRef();
      this->d_array = s;
    }

    basearray& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    // the following methods are C++ extensions to the base sidl::array api
    bool operator==(const basearray& x) const throw() {
      return this->d_array == x.d_array;
    }

    bool operator!=(const basearray& x) const throw() {
      return this->d_array != x.d_array;
    }
  };

  // All arrays of objects/interfaces inherit from this
  // template.
  template <typename array_traits>
  class interface_array :
     public basearray
  {
  public:
    typedef basearray                              Base;
    typedef typename array_traits::cxx_array_t     cxx_array_t;
    typedef typename array_traits::cxx_item_t      cxx_item_t;
    typedef typename array_traits::ior_array_t     ior_array_t;
    typedef struct sidl_interface__array           ior_internal_array;
    typedef typename array_traits::ior_item_t      ior_item_t;
    typedef array_iter< array_traits >             iterator;
    typedef const_array_iter< array_traits >       const_iterator;
    typedef typename array_traits::pointer         pointer;
    typedef typename array_traits::value_type      value_type;

    interface_array(ior_array_t *src=0)
      : Base(reinterpret_cast<struct sidl__array*> (src )) { }

    interface_array(const interface_array &src) : Base(src) { }
  
    // static constructor
    static cxx_array_t
    createRow(int32_t dimen, 
              const int32_t lower[],
              const int32_t upper[]) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (sidl_interface__array_createRow(dimen, lower, upper)));
    }

    /**
     * static constructor: createCol
     */
    static cxx_array_t
    createCol(int32_t dimen,
            const int32_t lower[],
            const int32_t upper[]) {
    return cxx_array_t(reinterpret_cast< ior_array_t * >
      (sidl_interface__array_createCol( dimen, lower, upper )));
    }

    /**
     * static constructor: create1d
     */
    static cxx_array_t
    create1d(int32_t len) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (sidl_interface__array_create1d(len)));
    }

    /**
     * static constructor: create1d[Init]
     */
    static cxx_array_t
    create1d(int32_t len, const ior_item_t* data) {
      return create1dInit( len, data );
    }

    /**
     * static constructor: create1dInit
     */
    static cxx_array_t
    create1dInit(int32_t len, const sidl_BaseInterface* data) {
      std::vector<ior_item_t> ior_data(len);
      for( int i=0; i<len; ++i) { 
         ior_data[i]=reinterpret_cast<ior_item_t>(data[i]);
      }
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (sidl_interface__array_create1dInit(len,ior_data.begin())));
    }

    /**
     * static constructor: create2dCol
     */
    static cxx_array_t
    create2dCol(int32_t m, int32_t n) {
      return cxx_array_t(reinterpret_cast< ior_array_t * >
        (sidl_interface__array_create2dCol(m,n)));
    }

    /**
     * static constructor: create2dRow
     */
    static cxx_array_t
    create2dRow(int32_t m, int32_t n) {
      return cxx_array_t (reinterpret_cast< ior_array_t * >
        (sidl_interface__array_create2dRow(m,n)));
    }


    // borrow
    void borrow(struct sidl_BaseInterface__object* * first_element,
                int32_t dimen,
                const int32_t lower[],
                const int32_t upper[],
                const int32_t stride[])
      throw ()
    {
      if (this->d_array) deleteRef();
      this->d_array = 
        sidl_interface__array_borrow(first_element, dimen, lower,
                                     upper, stride);
    }

    // copy from one array to another
    void copy( const cxx_array_t& src ) throw (){
      sidl_interface__array_copy
        (reinterpret_cast<const ior_internal_array*>(src._get_ior()),
         reinterpret_cast<ior_internal_array*>(this->d_array));
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) throw() {
      if (this->d_array) {
        struct sidl_interface__array *p = 
          sidl_interface__array_ensure
           (reinterpret_cast<ior_internal_array*>(this->d_array),
            dimen, (sidl_array_ordering) ordering);
        deleteRef();
        this->d_array = reinterpret_cast<sidl__array*>(p);
      }
    }
    
    cxx_array_t
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw () 
    {
      return cxx_array_t ( reinterpret_cast< ior_array_t * >
        (sidl_interface__array_slice
          (reinterpret_cast<ior_internal_array*>(this->d_array),
           dimen, numElem,
           srcStart, srcStride, newStart)));
    }

    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    // get
    cxx_item_t get(int32_t i) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get1
          (reinterpret_cast<ior_internal_array *>(this->d_array), i);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get2
          (reinterpret_cast<ior_internal_array *>(this->d_array), i, j);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const throw ()  {
      sidl_BaseInterface sbi =
        sidl_interface__array_get3
          (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get4
          (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get5
         (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get6
          (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m, n);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get7(
          reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m, n, o);
      cxx_item_t icwt(reinterpret_cast<ior_item_t *>(sbi), false);
      return icwt;
    }


    // get
    cxx_item_t get(const int32_t ind[]) const throw () {
      sidl_BaseInterface sbi =
        sidl_interface__array_get
          (reinterpret_cast<ior_internal_array *>(this->d_array), ind);
      cxx_item_t icwt(reinterpret_cast<ior_item_t * >(sbi), false);
      return icwt;
    }

    // set
    void set(int32_t i, cxx_item_t element) throw () {
      sidl_interface__array_set1
        (reinterpret_cast<ior_internal_array *>(this->d_array), i,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, cxx_item_t element) throw () {
      sidl_interface__array_set2
        (reinterpret_cast<ior_internal_array *>(this->d_array), i, j,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, cxx_item_t element) throw () {
      sidl_interface__array_set3
        (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, cxx_item_t element) throw () {
      sidl_interface__array_set4
        (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, cxx_item_t element) throw () {
      sidl_interface__array_set5
        (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, cxx_item_t element) throw () {
      sidl_interface__array_set6
        (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m, n,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, cxx_item_t element) throw () {
      sidl_interface__array_set7
        (reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m, n, o,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }
    
    // set
    void set(const int32_t ind[], cxx_item_t element) throw (){
      sidl_interface__array_set
        (reinterpret_cast<ior_internal_array *>(this->d_array), ind,
         reinterpret_cast<struct sidl_BaseInterface__object *>
         (element._get_ior()));
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return get(i); 
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };


  // All arrays of enumerated types inherit from this
  // template.
  template<typename array_traits> 
  class enum_array : public basearray
  { 
  public:
    typedef basearray                             Base;
    typedef typename array_traits::cxx_array_t    cxx_array_t;
    typedef typename array_traits::cxx_item_t     cxx_item_t;
    typedef typename array_traits::ior_array_t    ior_array_t;
    typedef struct sidl_int__array                ior_internal_array;
    typedef typename array_traits::ior_item_t     ior_item_t;
    typedef array_iter< array_traits >            iterator;
    typedef const_array_iter< array_traits >      const_iterator;
    typedef typename array_traits::pointer         pointer;
    typedef typename array_traits::value_type      value_type;

  public:
    enum_array(ior_array_t *src=0)
      : Base(reinterpret_cast<struct sidl__array *>(src)) {} 

    // static constructor
    static cxx_array_t
    createRow(int32_t dimen, 
              const int32_t lower[],
              const int32_t upper[]) {
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (sidl_int__array_createRow(dimen, lower, upper)));
    }

    /**
     * static constructor: createCol
     */
    static cxx_array_t
    createCol(int32_t dimen,
            const int32_t lower[],
            const int32_t upper[]) {
    return cxx_array_t(reinterpret_cast<ior_array_t *>
      (sidl_int__array_createCol( dimen, lower, upper ) ));
    }

    /**
     * static constructor: create1d
     */
    static cxx_array_t
    create1d(int32_t len) {
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (sidl_int__array_create1d(len)));
    }

    /**
     * static constructor: create1d[Init]
     */
    static cxx_array_t
    create1d(int32_t len, const ior_item_t* data) {
      return create1dInit(len, data);
    }

    /**
     * static constructor: create1dInit
     */
    static cxx_array_t
    create1dInit(int32_t len, const ior_item_t* data) {
      std::vector<ior_item_t> ior_data(len);
      for( int i=0; i<len; ++i) { 
         ior_data[i]=reinterpret_cast<ior_item_t>(data[i]);
      }
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (sidl_int__array_create1d(len,ior_data.begin())));
    }

    /**
     * static constructor: create2dCol
     */
    static cxx_array_t
    create2dCol(int32_t m, int32_t n) {
      return cxx_array_t(reinterpret_cast<ior_array_t *>
        (sidl_int__array_create2dCol(m,n)));
    }

    /**
     * static constructor: create2dRow
     */
    static cxx_array_t
    create2dRow(int32_t m, int32_t n) {
      return cxx_array_t (reinterpret_cast<ior_array_t *>
        (sidl_int__array_create2dRow(m,n)));
    }

    // borrow is not implementable for arrays of enum given that
    // C++ is not explicit about the sizeof(ior_item_t).
    void borrow( ior_item_t * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[])
        throw (UnsupportedException)
    {
      throw UnsupportedException("borrow is not implementable in C++ for enum_array<>");
    }

    // copy from one array to another
    void copy( const cxx_array_t& src ) throw (){
      sidl_int__array_copy(reinterpret_cast<const ior_internal_array *>(src._get_ior()),
                           reinterpret_cast<ior_internal_array *>(this->d_array));
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) throw() {
      if (this->d_array) {
        struct sidl_int__array *p = 
          sidl_int__array_ensure
            (reinterpret_cast<ior_internal_array *>(this->d_array),
             dimen, (sidl_array_ordering) ordering);
        deleteRef();
        this->d_array = reinterpret_cast<sidl__array *>(p);
      }
    }

    cxx_array_t
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw () 
    {
      return cxx_array_t ( reinterpret_cast<ior_array_t *>
        (sidl_int__array_slice
          (reinterpret_cast<ior_internal_array *> (this->d_array),
           dimen, numElem, srcStart, srcStride, newStart)) );
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    // get
    cxx_item_t get(int32_t i) const throw() {
      return cxx_item_t(sidlArrayElem1(
        reinterpret_cast<ior_internal_array *>(this->d_array), i));
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const throw() {
      return cxx_item_t(sidlArrayElem2(
        reinterpret_cast<ior_internal_array *>(this->d_array), i, j));
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const throw() {
      return cxx_item_t(sidlArrayElem3(
        reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k));
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const throw() {
      return cxx_item_t(sidlArrayElem4(
        reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l));
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const throw() {
      return cxx_item_t(sidlArrayElem5(
        reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m));
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const throw() {
      return cxx_item_t(sidlArrayElem6(
        reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m, n));
    }


    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const throw() {
      return cxx_item_t(sidlArrayElem7(
        reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k, l, m, n, o));
    }


    // get
    cxx_item_t get(const int32_t ind[]) const throw() {
      return cxx_item_t(sidl_int__array_get(
        reinterpret_cast<ior_internal_array *>(this->d_array), ind));
    }

    // set
    void set(int32_t i, cxx_item_t element) throw() {
      sidlArrayElem1(reinterpret_cast<ior_internal_array *>(this->d_array), i) =
        (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, cxx_item_t element) throw(){
      sidlArrayElem2(reinterpret_cast<ior_internal_array *>(this->d_array), i, j) =
        (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, cxx_item_t element) throw() {
      sidlArrayElem3(reinterpret_cast<ior_internal_array *>(this->d_array), i, j, k)
        = (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, cxx_item_t element) throw() {
      sidlArrayElem4(reinterpret_cast<ior_internal_array *>(this->d_array),
        i, j, k, l) =  (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, cxx_item_t element) throw() {
      sidlArrayElem5(reinterpret_cast<ior_internal_array *>(this->d_array),
        i, j, k, l, m) = (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, cxx_item_t element) throw() {
      sidlArrayElem6(reinterpret_cast<ior_internal_array *>(this->d_array),
        i, j, k, l, m, n) =  (ior_item_t)element;
    }
    
    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, cxx_item_t element) throw() {
      sidlArrayElem7(reinterpret_cast<ior_internal_array *>(this->d_array),
        i, j, k, l, m, n, o) = (ior_item_t)element;
    }
    
    // set
    void set(const int32_t ind[], cxx_item_t element) throw() {
      sidl_int__array_set(reinterpret_cast<ior_internal_array *>(this->d_array),
        ind, (ior_item_t)element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return get(i); 
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };


  // These are bogus templates that don't do anything.
  // But we specialize off of these to the more complicated
  // forms below.
  template < typename T >
  struct array_traits {};

  template< typename T > 
  class array : public basearray {  };
 
  // template specialization for array_traits<string>
  template<>
  struct array_traits<string> { 
    typedef array<string>                            cxx_array_t;
    typedef string                                   cxx_item_t;
    typedef struct sidl_string__array                ior_array_t;
    typedef char*                                    ior_item_t;
    typedef const char **                            ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<string>
  template<> 
  class array< string > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<string>::cxx_array_t          cxx_array_t;
    typedef array_traits<string>::cxx_item_t           cxx_item_t;
    typedef array_traits<string>::ior_array_t          ior_array_t;
    typedef array_traits<string>::ior_item_t           ior_item_t;
    typedef array_traits<string>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<string> >         iterator;
    typedef const_array_iter< array_traits<string> >   const_iterator;
    typedef array_traits< string > ::pointer         pointer;
    typedef array_traits< string > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< string >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< string >(sidl_string__array_createRow(dimen, lower, upper) );
    }
    
    static array< string >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< string >( sidl_string__array_createCol(dimen, lower, upper) );
    }
    
    static array< string >
    create1d(int32_t len) throw() {
      return array< string >(sidl_string__array_create1d( len ) );
    }

    static array< string >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< string >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< string >(sidl_string__array_create1dInit( len, data ) );
    }

    static array< string >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< string > ( sidl_string__array_create2dCol(m,n) );
    }

    static array< string >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< string > ( sidl_string__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( char * * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array =
        reinterpret_cast<sidl__array *>(
          sidl_string__array_borrow(first_element, dimen, lower,
                                    upper, stride));
    }

    void copy( const array< string >& src )  throw() {
      sidl_string__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_string__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< string >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_string__array_slice( _get_ior(), dimen, numElem,
                                 srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
     basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() && (sidl_string_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
       string s;
      char *tmp =  sidl_string__array_get1(_get_ior(),i);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      string s;
      char *tmp =  sidl_string__array_get2(_get_ior(),i,j);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      string s;
      char *tmp =  sidl_string__array_get3(_get_ior(),i,j,k);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      string s;
      char *tmp =  sidl_string__array_get4(_get_ior(),i,j,k,l);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      string s;
      char *tmp =  sidl_string__array_get5(_get_ior(),i,j,k,l,m);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      string s;
      char *tmp =  sidl_string__array_get6(_get_ior(),i,j,k,l,m,n);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      string s;
      char *tmp =  sidl_string__array_get7(_get_ior(),i,j,k,l,m,n,o);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      string s;
      char *tmp =  sidl_string__array_get(_get_ior(), ind);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    // set
    void set(int32_t i, string element) {
      sidl_string__array_set1(_get_ior(),i,element.c_str());
    } 

    // set
    void set(int32_t i, int32_t j, string element) {
      sidl_string__array_set2(_get_ior(),i,j,element.c_str());
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, string element) {
      sidl_string__array_set3(_get_ior(),i,j,k,element.c_str());
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, string element) {
      sidl_string__array_set4(_get_ior(),i,j,k,l,element.c_str());
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, string element) {
      sidl_string__array_set5(_get_ior(),i,j,k,l,m,element.c_str());
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, string element) {
      sidl_string__array_set6(_get_ior(),i,j,k,l,m,n,element.c_str());
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, string element) {
      sidl_string__array_set7(_get_ior(),i,j,k,l,m,n,o,element.c_str());
    }

    void set(int32_t ind[], string element ) {
      sidl_string__array_set(_get_ior(),ind,element.c_str());           
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      string s;
      char *tmp =  sidl_string__array_get1(_get_ior(),i);
      if (tmp) {
        s = tmp;
        free(tmp);
      }
      return s;
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<bool>
  template<>
  struct array_traits<bool> { 
    typedef array<bool>                            cxx_array_t;
    typedef bool                               cxx_item_t;
    typedef struct sidl_bool__array                       ior_array_t;
    typedef sidl_bool                               ior_item_t;
    typedef const sidl_bool*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<bool>
  template<> 
  class array< bool > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<bool>::cxx_array_t          cxx_array_t;
    typedef array_traits<bool>::cxx_item_t           cxx_item_t;
    typedef array_traits<bool>::ior_array_t          ior_array_t;
    typedef array_traits<bool>::ior_item_t           ior_item_t;
    typedef array_traits<bool>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<bool> >         iterator;
    typedef const_array_iter< array_traits<bool> >   const_iterator;
    typedef array_traits< bool > ::pointer         pointer;
    typedef array_traits< bool > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< bool >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< bool >(sidl_bool__array_createRow(dimen, lower, upper) );
    }
    
    static array< bool >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< bool >( sidl_bool__array_createCol(dimen, lower, upper) );
    }
    
    static array< bool >
    create1d(int32_t len) throw() {
      return array< bool >(sidl_bool__array_create1d( len ) );
    }

    static array< bool >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< bool >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< bool >(sidl_bool__array_create1dInit( len, data ) );
    }

    static array< bool >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< bool > ( sidl_bool__array_create2dCol(m,n) );
    }

    static array< bool >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< bool > ( sidl_bool__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( sidl_bool * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_bool__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const sidl_bool* first() const throw() {
      return const_cast<const sidl_bool*>(sidl_bool__array_first( _get_ior() ) );
    }

    sidl_bool* first() throw() {
      return sidl_bool__array_first( _get_ior() );
    }

    void copy( const array< bool >& src )  throw() {
      sidl_bool__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_bool__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< bool >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_bool__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_bool_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) == TRUE;
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o) == TRUE;
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_bool__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind) == TRUE;
    }

    // set
    void set(int32_t i, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, bool element) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = _local_element;
    }

    void set(int32_t ind[], bool element ) {
      sidl_bool _local_element = (( element ) ? TRUE : FALSE);
      sidl_bool__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,_local_element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) == TRUE;
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<char>
  template<>
  struct array_traits<char> { 
    typedef array<char>                            cxx_array_t;
    typedef char                               cxx_item_t;
    typedef struct sidl_char__array                       ior_array_t;
    typedef char                               ior_item_t;
    typedef const char*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<char>
  template<> 
  class array< char > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<char>::cxx_array_t          cxx_array_t;
    typedef array_traits<char>::cxx_item_t           cxx_item_t;
    typedef array_traits<char>::ior_array_t          ior_array_t;
    typedef array_traits<char>::ior_item_t           ior_item_t;
    typedef array_traits<char>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<char> >         iterator;
    typedef const_array_iter< array_traits<char> >   const_iterator;
    typedef array_traits< char > ::pointer         pointer;
    typedef array_traits< char > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< char >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< char >(sidl_char__array_createRow(dimen, lower, upper) );
    }
    
    static array< char >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< char >( sidl_char__array_createCol(dimen, lower, upper) );
    }
    
    static array< char >
    create1d(int32_t len) throw() {
      return array< char >(sidl_char__array_create1d( len ) );
    }

    static array< char >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< char >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< char >(sidl_char__array_create1dInit( len, data ) );
    }

    static array< char >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< char > ( sidl_char__array_create2dCol(m,n) );
    }

    static array< char >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< char > ( sidl_char__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( char * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_char__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const char* first() const throw() {
      return const_cast<const char*>(sidl_char__array_first( _get_ior() ) );
    }

    char* first() throw() {
      return sidl_char__array_first( _get_ior() );
    }

    void copy( const array< char >& src )  throw() {
      sidl_char__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_char__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< char >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_char__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_char_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_char__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
    }

    // set
    void set(int32_t i, char element) {
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, char element) {
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, char element) {
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, char element) {
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, char element) {
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, char element) {
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, char element) {
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], char element ) {
      sidl_char__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<int32_t>
  template<>
  struct array_traits<int32_t> { 
    typedef array<int32_t>                            cxx_array_t;
    typedef int32_t                               cxx_item_t;
    typedef struct sidl_int__array                       ior_array_t;
    typedef int32_t                               ior_item_t;
    typedef const int32_t*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<int32_t>
  template<> 
  class array< int32_t > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<int32_t>::cxx_array_t          cxx_array_t;
    typedef array_traits<int32_t>::cxx_item_t           cxx_item_t;
    typedef array_traits<int32_t>::ior_array_t          ior_array_t;
    typedef array_traits<int32_t>::ior_item_t           ior_item_t;
    typedef array_traits<int32_t>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<int32_t> >         iterator;
    typedef const_array_iter< array_traits<int32_t> >   const_iterator;
    typedef array_traits< int32_t > ::pointer         pointer;
    typedef array_traits< int32_t > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< int32_t >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< int32_t >(sidl_int__array_createRow(dimen, lower, upper) );
    }
    
    static array< int32_t >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< int32_t >( sidl_int__array_createCol(dimen, lower, upper) );
    }
    
    static array< int32_t >
    create1d(int32_t len) throw() {
      return array< int32_t >(sidl_int__array_create1d( len ) );
    }

    static array< int32_t >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< int32_t >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< int32_t >(sidl_int__array_create1dInit( len, data ) );
    }

    static array< int32_t >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< int32_t > ( sidl_int__array_create2dCol(m,n) );
    }

    static array< int32_t >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< int32_t > ( sidl_int__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( int32_t * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_int__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const int32_t* first() const throw() {
      return const_cast<const int32_t*>(sidl_int__array_first( _get_ior() ) );
    }

    int32_t* first() throw() {
      return sidl_int__array_first( _get_ior() );
    }

    void copy( const array< int32_t >& src )  throw() {
      sidl_int__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_int__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< int32_t >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_int__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_int_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_int__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
    }

    // set
    void set(int32_t i, int32_t element) {
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t element) {
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t element) {
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t element) {
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t element) {
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t element) {
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, int32_t element) {
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], int32_t element ) {
      sidl_int__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<int64_t>
  template<>
  struct array_traits<int64_t> { 
    typedef array<int64_t>                            cxx_array_t;
    typedef int64_t                               cxx_item_t;
    typedef struct sidl_long__array                       ior_array_t;
    typedef int64_t                               ior_item_t;
    typedef const int64_t*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<int64_t>
  template<> 
  class array< int64_t > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<int64_t>::cxx_array_t          cxx_array_t;
    typedef array_traits<int64_t>::cxx_item_t           cxx_item_t;
    typedef array_traits<int64_t>::ior_array_t          ior_array_t;
    typedef array_traits<int64_t>::ior_item_t           ior_item_t;
    typedef array_traits<int64_t>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<int64_t> >         iterator;
    typedef const_array_iter< array_traits<int64_t> >   const_iterator;
    typedef array_traits< int64_t > ::pointer         pointer;
    typedef array_traits< int64_t > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< int64_t >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< int64_t >(sidl_long__array_createRow(dimen, lower, upper) );
    }
    
    static array< int64_t >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< int64_t >( sidl_long__array_createCol(dimen, lower, upper) );
    }
    
    static array< int64_t >
    create1d(int32_t len) throw() {
      return array< int64_t >(sidl_long__array_create1d( len ) );
    }

    static array< int64_t >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< int64_t >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< int64_t >(sidl_long__array_create1dInit( len, data ) );
    }

    static array< int64_t >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< int64_t > ( sidl_long__array_create2dCol(m,n) );
    }

    static array< int64_t >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< int64_t > ( sidl_long__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( int64_t * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_long__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const int64_t* first() const throw() {
      return const_cast<const int64_t*>(sidl_long__array_first( _get_ior() ) );
    }

    int64_t* first() throw() {
      return sidl_long__array_first( _get_ior() );
    }

    void copy( const array< int64_t >& src )  throw() {
      sidl_long__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_long__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< int64_t >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_long__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_long_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_long__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
    }

    // set
    void set(int32_t i, int64_t element) {
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int64_t element) {
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int64_t element) {
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int64_t element) {
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int64_t element) {
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int64_t element) {
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, int64_t element) {
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], int64_t element ) {
      sidl_long__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<float>
  template<>
  struct array_traits<float> { 
    typedef array<float>                            cxx_array_t;
    typedef float                               cxx_item_t;
    typedef struct sidl_float__array                       ior_array_t;
    typedef float                               ior_item_t;
    typedef const float*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<float>
  template<> 
  class array< float > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<float>::cxx_array_t          cxx_array_t;
    typedef array_traits<float>::cxx_item_t           cxx_item_t;
    typedef array_traits<float>::ior_array_t          ior_array_t;
    typedef array_traits<float>::ior_item_t           ior_item_t;
    typedef array_traits<float>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<float> >         iterator;
    typedef const_array_iter< array_traits<float> >   const_iterator;
    typedef array_traits< float > ::pointer         pointer;
    typedef array_traits< float > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< float >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< float >(sidl_float__array_createRow(dimen, lower, upper) );
    }
    
    static array< float >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< float >( sidl_float__array_createCol(dimen, lower, upper) );
    }
    
    static array< float >
    create1d(int32_t len) throw() {
      return array< float >(sidl_float__array_create1d( len ) );
    }

    static array< float >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< float >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< float >(sidl_float__array_create1dInit( len, data ) );
    }

    static array< float >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< float > ( sidl_float__array_create2dCol(m,n) );
    }

    static array< float >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< float > ( sidl_float__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( float * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_float__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const float* first() const throw() {
      return const_cast<const float*>(sidl_float__array_first( _get_ior() ) );
    }

    float* first() throw() {
      return sidl_float__array_first( _get_ior() );
    }

    void copy( const array< float >& src )  throw() {
      sidl_float__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_float__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< float >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_float__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_float_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_float__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
    }

    // set
    void set(int32_t i, float element) {
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, float element) {
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, float element) {
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, float element) {
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, float element) {
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, float element) {
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, float element) {
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], float element ) {
      sidl_float__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<double>
  template<>
  struct array_traits<double> { 
    typedef array<double>                            cxx_array_t;
    typedef double                               cxx_item_t;
    typedef struct sidl_double__array                       ior_array_t;
    typedef double                               ior_item_t;
    typedef const double*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<double>
  template<> 
  class array< double > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<double>::cxx_array_t          cxx_array_t;
    typedef array_traits<double>::cxx_item_t           cxx_item_t;
    typedef array_traits<double>::ior_array_t          ior_array_t;
    typedef array_traits<double>::ior_item_t           ior_item_t;
    typedef array_traits<double>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<double> >         iterator;
    typedef const_array_iter< array_traits<double> >   const_iterator;
    typedef array_traits< double > ::pointer         pointer;
    typedef array_traits< double > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< double >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< double >(sidl_double__array_createRow(dimen, lower, upper) );
    }
    
    static array< double >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< double >( sidl_double__array_createCol(dimen, lower, upper) );
    }
    
    static array< double >
    create1d(int32_t len) throw() {
      return array< double >(sidl_double__array_create1d( len ) );
    }

    static array< double >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< double >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< double >(sidl_double__array_create1dInit( len, data ) );
    }

    static array< double >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< double > ( sidl_double__array_create2dCol(m,n) );
    }

    static array< double >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< double > ( sidl_double__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( double * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_double__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const double* first() const throw() {
      return const_cast<const double*>(sidl_double__array_first( _get_ior() ) );
    }

    double* first() throw() {
      return sidl_double__array_first( _get_ior() );
    }

    void copy( const array< double >& src )  throw() {
      sidl_double__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_double__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< double >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_double__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_double_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_double__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
    }

    // set
    void set(int32_t i, double element) {
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, double element) {
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, double element) {
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, double element) {
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, double element) {
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, double element) {
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, double element) {
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], double element ) {
      sidl_double__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<fcomplex>
  template<>
  struct array_traits<fcomplex> { 
    typedef array<fcomplex>                            cxx_array_t;
    typedef fcomplex                               cxx_item_t;
    typedef struct sidl_fcomplex__array                       ior_array_t;
    typedef struct sidl_fcomplex                               ior_item_t;
    typedef const struct sidl_fcomplex*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<fcomplex>
  template<> 
  class array< fcomplex > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<fcomplex>::cxx_array_t          cxx_array_t;
    typedef array_traits<fcomplex>::cxx_item_t           cxx_item_t;
    typedef array_traits<fcomplex>::ior_array_t          ior_array_t;
    typedef array_traits<fcomplex>::ior_item_t           ior_item_t;
    typedef array_traits<fcomplex>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<fcomplex> >         iterator;
    typedef const_array_iter< array_traits<fcomplex> >   const_iterator;
    typedef array_traits< fcomplex > ::pointer         pointer;
    typedef array_traits< fcomplex > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< fcomplex >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< fcomplex >(sidl_fcomplex__array_createRow(dimen, lower, upper) );
    }
    
    static array< fcomplex >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< fcomplex >( sidl_fcomplex__array_createCol(dimen, lower, upper) );
    }
    
    static array< fcomplex >
    create1d(int32_t len) throw() {
      return array< fcomplex >(sidl_fcomplex__array_create1d( len ) );
    }

    static array< fcomplex >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< fcomplex >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< fcomplex >(sidl_fcomplex__array_create1dInit( len, data ) );
    }

    static array< fcomplex >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< fcomplex > ( sidl_fcomplex__array_create2dCol(m,n) );
    }

    static array< fcomplex >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< fcomplex > ( sidl_fcomplex__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( struct sidl_fcomplex * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_fcomplex__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const struct sidl_fcomplex* first() const throw() {
      return const_cast<const struct sidl_fcomplex*>(sidl_fcomplex__array_first( _get_ior() ) );
    }

    struct sidl_fcomplex* first() throw() {
      return sidl_fcomplex__array_first( _get_ior() );
    }

    void copy( const array< fcomplex >& src )  throw() {
      sidl_fcomplex__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_fcomplex__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< fcomplex >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_fcomplex__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_fcomplex_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      sidl_fcomplex _local_result =
         sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      sidl_fcomplex _local_result =
         sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      sidl_fcomplex _local_result =
         sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      sidl_fcomplex _local_result =
         sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      sidl_fcomplex _local_result =
         sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      sidl_fcomplex _local_result =
         sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      sidl_fcomplex _local_result =
         sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      sidl_fcomplex _local_result =
         sidl_fcomplex__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    // set
    void set(int32_t i, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, fcomplex element) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = _local_element;
    }

    void set(int32_t ind[], fcomplex element ) {
      sidl_fcomplex _local_element = { element.real(), element.imag() };
      sidl_fcomplex__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,_local_element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      sidl_fcomplex _local_result =
         sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
      return fcomplex(_local_result.real, _local_result.imaginary);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<dcomplex>
  template<>
  struct array_traits<dcomplex> { 
    typedef array<dcomplex>                            cxx_array_t;
    typedef dcomplex                               cxx_item_t;
    typedef struct sidl_dcomplex__array                       ior_array_t;
    typedef struct sidl_dcomplex                               ior_item_t;
    typedef const struct sidl_dcomplex*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<dcomplex>
  template<> 
  class array< dcomplex > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<dcomplex>::cxx_array_t          cxx_array_t;
    typedef array_traits<dcomplex>::cxx_item_t           cxx_item_t;
    typedef array_traits<dcomplex>::ior_array_t          ior_array_t;
    typedef array_traits<dcomplex>::ior_item_t           ior_item_t;
    typedef array_traits<dcomplex>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<dcomplex> >         iterator;
    typedef const_array_iter< array_traits<dcomplex> >   const_iterator;
    typedef array_traits< dcomplex > ::pointer         pointer;
    typedef array_traits< dcomplex > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< dcomplex >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< dcomplex >(sidl_dcomplex__array_createRow(dimen, lower, upper) );
    }
    
    static array< dcomplex >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< dcomplex >( sidl_dcomplex__array_createCol(dimen, lower, upper) );
    }
    
    static array< dcomplex >
    create1d(int32_t len) throw() {
      return array< dcomplex >(sidl_dcomplex__array_create1d( len ) );
    }

    static array< dcomplex >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< dcomplex >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< dcomplex >(sidl_dcomplex__array_create1dInit( len, data ) );
    }

    static array< dcomplex >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< dcomplex > ( sidl_dcomplex__array_create2dCol(m,n) );
    }

    static array< dcomplex >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< dcomplex > ( sidl_dcomplex__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( struct sidl_dcomplex * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_dcomplex__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const struct sidl_dcomplex* first() const throw() {
      return const_cast<const struct sidl_dcomplex*>(sidl_dcomplex__array_first( _get_ior() ) );
    }

    struct sidl_dcomplex* first() throw() {
      return sidl_dcomplex__array_first( _get_ior() );
    }

    void copy( const array< dcomplex >& src )  throw() {
      sidl_dcomplex__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_dcomplex__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< dcomplex >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_dcomplex__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_dcomplex_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      sidl_dcomplex _local_result =
         sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      sidl_dcomplex _local_result =
         sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      sidl_dcomplex _local_result =
         sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      sidl_dcomplex _local_result =
         sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      sidl_dcomplex _local_result =
         sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      sidl_dcomplex _local_result =
         sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      sidl_dcomplex _local_result =
         sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      sidl_dcomplex _local_result =
         sidl_dcomplex__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    // set
    void set(int32_t i, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = _local_element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = _local_element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, dcomplex element) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = _local_element;
    }

    void set(int32_t ind[], dcomplex element ) {
      sidl_dcomplex _local_element = { element.real(), element.imag() };
      sidl_dcomplex__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,_local_element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      sidl_dcomplex _local_result =
         sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
      return dcomplex(_local_result.real, _local_result.imaginary);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

  // template specialization for array_traits<opaque>
  template<>
  struct array_traits<opaque> { 
    typedef array<opaque>                            cxx_array_t;
    typedef void*                               cxx_item_t;
    typedef struct sidl_opaque__array                       ior_array_t;
    typedef void*                               ior_item_t;
    typedef void*const*      ior_item_internal_t;
    typedef cxx_item_t                               value_type;
    typedef value_type*                              pointer;
    typedef const value_type*                        const_pointer;
  };

  // template specialization for array<opaque>
  template<> 
  class array< opaque > 
    : public basearray
  { 
  public:
    typedef basearray                                  Base;
    typedef array_traits<opaque>::cxx_array_t          cxx_array_t;
    typedef array_traits<opaque>::cxx_item_t           cxx_item_t;
    typedef array_traits<opaque>::ior_array_t          ior_array_t;
    typedef array_traits<opaque>::ior_item_t           ior_item_t;
    typedef array_traits<opaque>::ior_item_internal_t  ior_item_internal_t;
    typedef array_iter< array_traits<opaque> >         iterator;
    typedef const_array_iter< array_traits<opaque> >   const_iterator;
    typedef array_traits< opaque > ::pointer         pointer;
    typedef array_traits< opaque > ::value_type      value_type;

    array(ior_array_t* src=0)
      : Base(reinterpret_cast<struct sidl__array*>(src)) {}

    array(const array &src) : Base(src) {}

    // static constructor: createRow
    static array< opaque >
    createRow(int32_t dimen,
              const int32_t lower[],
              const int32_t upper[]) throw() {
      return array< opaque >(sidl_opaque__array_createRow(dimen, lower, upper) );
    }
    
    static array< opaque >
    createCol(int32_t dimen,
              const int32_t lower[], 
              const int32_t upper[]) throw() {
      return array< opaque >( sidl_opaque__array_createCol(dimen, lower, upper) );
    }
    
    static array< opaque >
    create1d(int32_t len) throw() {
      return array< opaque >(sidl_opaque__array_create1d( len ) );
    }

    static array< opaque >
    create1d(int32_t len, ior_item_internal_t data) throw() {
      return create1dInit( len, data );
    }

    static array< opaque >
    create1dInit(int32_t len, ior_item_internal_t data) throw() {
      return array< opaque >(sidl_opaque__array_create1dInit( len, data ) );
    }

    static array< opaque >
    create2dCol(int32_t m, int32_t n) throw() {
      return array< opaque > ( sidl_opaque__array_create2dCol(m,n) );
    }

    static array< opaque >
    create2dRow(int32_t m, int32_t n ) throw() {
      return array< opaque > ( sidl_opaque__array_create2dRow(m,n) );
    }

    // borrow
    void borrow( void* * first_element, int32_t dimen,
      const int32_t lower[], const int32_t upper[], const int32_t stride[]) {
      if (this->d_array) deleteRef();
      this->d_array = reinterpret_cast<sidl__array*>
        (sidl_opaque__array_borrow(first_element, dimen, lower,
                            upper, stride));
    }

    const void** first() const throw() {
      return const_cast<const void**>(sidl_opaque__array_first( _get_ior() ) );
    }

    void** first() throw() {
      return sidl_opaque__array_first( _get_ior() );
    }

    void copy( const array< opaque >& src )  throw() {
      sidl_opaque__array_copy( src._get_ior(), _get_ior() );
    }

    // ensure
    void ensure( int32_t dimen, array_ordering ordering ) {
      ior_array_t* p = sidl_opaque__array_ensure( _get_ior(), dimen, (sidl_array_ordering) ordering );
      _set_ior( p );
    }

    array< opaque >
    slice( int32_t dimen,
           const int32_t numElem[],
           const int32_t *srcStart = 0,
           const int32_t *srcStride = 0,
           const int32_t *newStart = 0) throw() {
      return  sidl_opaque__array_slice(
        reinterpret_cast<ior_array_t*>(this->d_array), dimen, numElem,
                                srcStart, srcStride, newStart);
    }
    
    // is packed 1-d 
    bool is1dPacked() const throw () {
        return (dimen()==1) && ( isColumnOrder()||isRowOrder() );
    }

    // get a const pointer to the actual array ior 
    const ior_array_t* _get_ior() const throw () {
      return reinterpret_cast<const ior_array_t *>(d_array);
    }

    // get a non-const pointer to the actual array ior
    ior_array_t* _get_ior() throw () {
      return reinterpret_cast<ior_array_t *>(d_array);
    }

    // set the actual array ior
    void _set_ior( ior_array_t * s) throw () {
      basearray::_set_ior(reinterpret_cast<struct sidl__array *>(s));
    }

    array& operator =(const array &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array = const_cast<sidl__array *>(rhs._get_baseior());
        addRef();
      }
      return *this;
    }

    array& operator =(const basearray &rhs) throw() {
      if (this->d_array != rhs._get_baseior()) {
        deleteRef();
        this->d_array =
          (rhs._get_baseior() &&
           (sidl_opaque_array == rhs.arrayType()))
          ? const_cast<sidl__array *>(rhs._get_baseior()) : NULL;
        addRef();
      }
      return *this;
    }

    // get
    cxx_item_t get(int32_t i) const {
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j) const {
      return sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k) const {
      return sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l) const {
      return sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m) const {
      return sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n) const {
      return sidlArrayElem6(
       reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n);
    }

    // get
    cxx_item_t get(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o) const {
      return sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),
        i,j,k,l,m,n,o);
    }

    // get
    cxx_item_t get(const int32_t ind[]) const {
      return sidl_opaque__array_get(reinterpret_cast<ior_array_t*>(this->d_array),
        ind);
    }

    // set
    void set(int32_t i, void* element) {
      sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i) = element;
    } 

    // set
    void set(int32_t i, int32_t j, void* element) {
      sidlArrayElem2(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, void* element) {
      sidlArrayElem3(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k) = element;
    } 

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, void* element) {
      sidlArrayElem4(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, void* element) {
      sidlArrayElem5(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, void* element) {
      sidlArrayElem6(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n) = element;
    }

    // set
    void set(int32_t i, int32_t j, int32_t k, int32_t l, int32_t m, int32_t n, int32_t o, void* element) {
      sidlArrayElem7(
        reinterpret_cast<ior_array_t*>(this->d_array),i,j,k,l,m,n,o) = element;
    }

    void set(int32_t ind[], void* element ) {
      sidl_opaque__array_set(
        reinterpret_cast<ior_array_t*>(this->d_array),ind,element);
    }

    // [] overloaded to be same as get1()
    cxx_item_t operator[](int32_t i) const throw() { 
      return sidlArrayElem1(
        reinterpret_cast<ior_array_t*>(this->d_array),i);
    }

    iterator begin() { 
      return iterator(*this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    const_iterator begin() const {
      return const_iterator( *this, ((dimen()==1) ? lower(0) : 0 ) );
    }

    iterator end() { 
       return iterator(*this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  
    const_iterator end() const { 
       return const_iterator( *this, ((dimen()==1) ? (upper(0)-lower(0)+1) : 0 ) );
    }
  };

} //end sidl namespace

#endif // defined included_sidl_cxx_hxx
