/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_PLANARTREE_H
#define _HYANTES_PLANARTREE_H

#include <stddef.h>
#include "quadtree.h"

/** 
* @brief representation of a quadtree designed to be stored in an array to limit cache miss 
*/
typedef struct ptree
{
    double value;               /**< cumulated value of all leaves */
    size_t size;                /**< tree size */
    hs_coord_t coo;             /**< zone coordinate */
} planartree;

/* allocates a new planartree from Quadtree QTREE */
/*@null@*/ planartree *create_planartree(const QuadT qtree);

#endif
