<?php

//    qryurls.php
//    Shows a List of URLs previously set with a form
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: qryurls.php,v 1.19 2004/01/12 08:55:55 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</A>";
   die;
}

$strSection=$strListofUrls;
$pagetitle = "Database: $dbname - " . $strSection;
eval("\$strhome = \"$strDBHome \";");
$linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";

// A database has been selected

include ("./include/header.inc.php");

if (isset ($cmd))
{

   if (!isset($initpage))
      $initpage=0;

   if (!isset($pagesize))
      $pagesize=30;

   $strwhere = "WHERE 1 ";
   $otherinfo = '&cmd=' . urlencode($cmd);
   
   if (isset($ctype) && $ctype!="AllCTypes")
   {
      $strwhere = $strwhere . "AND Url.ContentType $whatctype '$ctype' ";
      $otherinfo = $otherinfo . '&whatctype=' . urlencode($whatctype)
         . '&ctype=' . urlencode($ctype);
   }

   if (isset($charset) && $charset!="AllCharsets")
   {
      if ($charset == 'NULL')
      {
         if ($whatcharset == '!=')
            $whatcharsettmp = 'not';
         $strwhere = $strwhere . "AND Url.Charset is $whatcharsettmp $charset ";
      }
      else
      {
         $strwheretmp = "Url.Charset $whatcharset '$charset'";
         if ($whatcharset == '!=')
            $strwhere .= "AND ($strwheretmp OR Url.Charset is NULL)";
         else
            $strwhere .= "AND $strwheretmp ";
      }

      $otherinfo = $otherinfo . '&whatcharset=' . urlencode($whatcharset)
         . '&charset=' . urlencode($charset);
   }

   if (isset($doctype) && $doctype!="AllDocTypes")
   {
      if ($doctype == 'NULL')
      {
         if ($whatdoctype == '!=')
            $whatdoctypetmp = 'not';
         $strwhere = $strwhere . "AND Url.DocType is $whatdoctypetmp $doctype ";
      }
      else
      {
         $strwheretmp = "Url.DocType $whatdoctype '$doctype'";
         if ($whatcharset == '!=')
            $strwhere .= "AND ($strwheretmp OR Url.DocType is NULL)";
         else
            $strwhere .= "AND $strwheretmp ";
      }

      $otherinfo = $otherinfo . '&whatdoctype=' . urlencode($whatdoctype)
         . '&doctype=' . urlencode($doctype);
   }

   if (isset($scode) && $scode!="AllSCodes")
   {
      $strwhere = $strwhere . "AND Url.StatusCode $whatscode '$scode' ";
      $otherinfo = $otherinfo . '&whatscode=' . urlencode($whatscode)
         . '&scode=' . urlencode($scode);
   }

   if (isset($size) && strlen($size) && settype($size, "integer"))
   {
      $size *= 1024;
      $strwhere = $strwhere . "AND Url.Size $whatsize $size AND Url.Size >= 0 ";
      $otherinfo = $otherinfo . '&whatsize=' . urlencode($whatsize)
         . '&size=' . urlencode ($size);
   }

   if (isset($sizeadd) && strlen($sizeadd) && settype($sizeadd, "integer"))
   {
      $sizeadd *= 1024;
      $strwhere = $strwhere . "AND (Url.SizeAdd + Url.Size) $whatsizeadd $sizeadd "
         . "AND Url.Size >= 0 ";
      $otherinfo = $otherinfo . '&whatsizeadd=' . urlencode($whatsizeadd)
         . '&sizeadd=' . urlencode ($sizeadd);
   }


   $num=count($url); // Count the elements

   // Set the URL filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($url[$i]) && $url[$i] && strlen($url[$i]) > 0)
      {
         if(isset($whaturl[$i]))
         {
            $strwhere = $strwhere . "AND Url.Url " . $whaturl[$i]
               . " '" . $url[$i] . "' ";
            $otherinfo = $otherinfo . "&whaturl[$i]=" . urlencode($whaturl[$i])
               . "&url[$i]=" . urlencode ($url[$i]);
          }
      }
   }


   $num=count($title); // Count the elements

   // Set the title filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($title[$i]) && $title[$i] && strlen($title[$i]) > 0)
      {
         if(isset($whattitle[$i]))
         {
            $strwhere = $strwhere . "AND Url.Title " . $whattitle[$i]
               . " '" . $title[$i] . "' ";
            $otherinfo = $otherinfo . "&whattitle[$i]="
               . urlencode($whattitle[$i])
               ."&title[$i]=" . urlencode($title[$i]);
          }
      }
   }
   
   $num=count($description); // Count the elements

   // Set the description filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($description[$i]) && $description[$i] && strlen($description[$i]) > 0)
      {
         if(isset($whatdescription[$i]))
         {
            $strwhere = $strwhere . "AND Url.Description " . $whatdescription[$i]
               . " '" . $description[$i] . "' ";
            $otherinfo = $otherinfo . "&whatdescription[$i]="
               . urlencode($whatdescription[$i])
               ."&description[$i]=" . urlencode($description[$i]);
          }
      }
   }
   
   $num=count($keywords); // Count the elements

   // Set the keywords filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($keywords[$i]) && $keywords[$i] && strlen($keywords[$i]) > 0)
      {
         if(isset($whatkeywords[$i]))
         {
            $strwhere = $strwhere . "AND Url.Keywords " . $whatkeywords[$i]
               . " '" . $keywords[$i] . "' ";
            $otherinfo = $otherinfo . "&whatkeywords[$i]="
               . urlencode($whatkeywords[$i])
               ."&keywords[$i]=" . urlencode($keywords[$i]);
          }
      }
   }

   // Show all the URLs, retrieved ones as well as not
   $strGenSQL = "SELECT * "
      . "FROM Url "
      . $strwhere
      . " LIMIT " . $initpage . ", " . $pagesize;

   if (!isset($count))
   {
      $strCountSQL="select count(*) from Url "
         . $strwhere;

      $count = $MyDB->CountEntries($strCountSQL,$dbname,true);
      if ($count<0)
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }
      $MyDB->Free();
   }

?>

<?php

// HTTP results
   
?>

<!--
SQL: <?php echo $strGenSQL; ?>
-->

<h4><?php echo $strSection; ?></h4>
<p>
<?
if ($count) printf ($strListPageInfo, number_format($initpage+1), number_format(($initpage+$pagesize)>$count?$count:$initpage+$pagesize), number_format($count));
?>  
<br>
<?php WritePageLink($initpage, $pagesize, $count, $dbname, $otherinfo); ?>
</p>

<?php

   $result=$MyDB->Query($dbname, $strGenSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
      // At least one occurrence found

?>

<table>
<tr>
<th> N. </th>
<th> ID </th>
<th> Url </th>
<th> <?php echo $strStatusCode; ?> & <br> <?php echo $strReasonPhrase; ?></th>
<th> <?php echo $strConnectionStatus; ?></th>
</tr>
      
<?php
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
         // Get next row
         $i++;
         ($i % 2)? $trclass='odd':$trclass='even';
?>
 <tr class="<?php echo $trclass; ?>">
   <td align="right"> <?php echo number_format($initpage+$i); ?> </td>
   <td align="right"> <?php echo number_format($row["IDUrl"]); ?> </td>
   <td class="url" align="left"><a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrl"]; ?>"><?php echo GetURL($row["Url"]); ?></A></td><?php
   if ($row["StatusCode"])
   {
?>
   <td align="center"> <?php echo $row["StatusCode"]; ?> - <?php echo $row["ReasonPhrase"]; ?></td>
   <td align="center"> <?php echo $row["ConnStatus"]; ?></td>
<?php
   }
   else
   {
?>
   <td align="center" colspan="2"><em><?php echo $strNotRetrieved; ?></em></td>
<?php   
   }
?>
 </tr>
<?php         
      }

?>
</table>
<?php      
      // Page management

      WritePageLink($initpage, $pagesize, $count, $dbname,$otherinfo);
   }
   else
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>

<?php
   }

   $MyDB->Free();

}
else
{
?>
<p><?php echo $strFilterUrls; ?>:</p>

<form action="<?php echo $PHP_SELF; ?>" method="GET">
<input type="hidden" name="dbname" value="<?php echo $dbname; ?>">
<table>

<tr>
<th>
<?php echo $strUrl; ?> : 
</th>
</tr>

<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<tr>
<td>
<select name="whaturl[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="url[<?php echo $i; ?>]" type="text" value="<?php echo $url[$i]; ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }
?>


<?php

   // Retrieving all the Status Codes found
   $strSQL="SELECT count(*) as Count, StatusCode "
      . "FROM Url GROUP BY StatusCode "
      . "ORDER BY StatusCode ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td>
<strong><?php echo $strStatusCode; ?> : </strong>
<select name="whatscode">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="scode">
 <option value="AllSCodes"><?php echo $strAllSCodes; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <option value="<?php echo $row["StatusCode"]; ?>">
   <?php echo $row["StatusCode"]; ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
<?php
   }

   $MyDB->Free();

?>

<?php

   // Retrieving all the ContentTypes found
   $strSQL="SELECT count(*) as Count, ContentType "
      . "FROM Url GROUP BY ContentType "
      . "ORDER BY ContentType ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td>
<strong><?php echo $strContentType; ?> : </strong>
<select name="whatctype">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="ctype">
 <option value="AllCTypes"><?php echo $strAllCTypes; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <option value="<?php echo $row["ContentType"]; ?>">
   <?php echo $row["ContentType"]; ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
<?php
   }

   $MyDB->Free();

   // Retrieving all the Charsets found
   $strSQL="SELECT count(*) as Count, Charset "
      . "FROM Url GROUP BY Charset "
      . "ORDER BY Charset ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td>
<strong><?php echo $strCharset; ?> : </strong>
<select name="whatcharset">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="charset">
 <option value="AllCharsets"><?php echo $strAllCharsets; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
          if (empty($row["Charset"]))
          {
             $cs = 'NULL';
             $strcs = &$strNull;
          }
          else
          {
             $cs = &$row["Charset"];
             if ($cs == 'unknown')
                $strcs = &$strOther;
             else
                $strcs = &$cs;
          }
?>
 <option value="<?php echo $cs; ?>">
   <?php echo $strcs; ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
<?php
   }

   $MyDB->Free();

   // Retrieving all the DocTypes found
   $strSQL="SELECT count(*) as Count, DocType "
      . "FROM Url GROUP BY DocType "
      . "ORDER BY DocType ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td>
<strong><?php echo $strDocType; ?> : </strong>
<select name="whatdoctype">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="doctype">
 <option value="AllDocTypes"><?php echo $strAllDocTypes; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
          if (empty($row['DocType']))
          {
             $dt = 'NULL';
             $strdt = &$strNull;
          }
          else
          {
             $dt = &$row["DocType"];
             if ($dt == 'unknown')
                $strdt = &$strOther;
             else
                $strdt = &$dt;
          }
?>
 <option value="<?php echo $dt; ?>">
   <?php echo $strdt; ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
<?php
   }

   $MyDB->Free();

?>

<tr>
<td>
<strong><?php echo $strSize; ?> : </strong>
<select name="whatsize">
 <option value=">"><?php echo $strGt; ?></option>
 <option value="<"><?php echo $strLt; ?></option>
 <option value="="><?php echo $strLike; ?></option>
</select>
<input name="size" type="text" value="<?php echo $size; ?>"
   size="10" maxlength="9"> KBytes
</td>
</tr>


<tr>
<td>
<strong><?php echo $strPageWeight; ?> : </strong>
<select name="whatsizeadd">
 <option value=">"><?php echo $strGt; ?></option>
 <option value="<"><?php echo $strLt; ?></option>
 <option value="="><?php echo $strLike; ?></option>
</select>
<input name="sizeadd" type="text" value="<?php echo $sizeadd; ?>"
   size="10" maxlength="9"> KBytes
</td>
</tr>


<tr>
<th>
<?php echo $strTitle; ?> : 
</th>
</tr>

<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<tr>
<td>
<select name="whattitle[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="title[<?php echo $i; ?>]" type="text" value="<?php echo $title[$i]; ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }
?>


<tr>
<th>
<?php echo $strDescription; ?> : 
</th>
</tr>

<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<tr>
<td>
<select name="whatdescription[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="description[<?php echo $i; ?>]" type="text" value="<?php echo $description[$i]; ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }
?>


<tr>
<th>
<?php echo $strKeywords; ?> : 
</th>
</tr>

<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<tr>
<td>
<select name="whatkeywords[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="keywords[<?php echo $i; ?>]" type="text" value="<?php echo $keywords[$i]; ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }
?>



<tr>
<td colspan="2" align="right">
<input type="submit" name="cmd" value="<?php echo $strLinkSubmit; ?>">
</td>
</tr>
</form>
</table>

<p align="justify">
<?php echo $strHelpOnString; ?>
</p>
<p align="justify">
<?php echo $strHelpOnRegExp; ?>
</p>

<?php
}

?>

<br>

<?php include ("./include/footer.inc.php"); ?>
