///////
   //    HtmlAttribute.h
   //    HtmlAttribute Class declaration
   //
   //    Class for HtmlAttribute storage
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlAttribute.h,v 1.9 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifndef _HTMLATTRIBUTE_H
#define _HTMLATTRIBUTE_H

#include <Object.h>
#include <htString.h>


class HtmlAttribute : public Object
{

   // Write the object to the output
   friend ostream& operator<<( ostream&, const HtmlAttribute& );
   
   public:
   
      // Construction / Destruction
      HtmlAttribute();
      virtual ~HtmlAttribute();

///////
   //    Public Interface
///////

      void Reset();

      void SetIDUrl        (unsigned int id) { IDUrl = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetAttrPosition (unsigned int ap) { AttrPosition = ap; }
      void SetAttribute    (const String &a) { Attribute = a; }
      void SetContent      (const String &c) { Content = c; }

      unsigned int GetIDUrl() const          { return IDUrl; }
      unsigned int GetTagPosition() const    { return TagPosition; }
      unsigned int GetAttrPosition() const   { return AttrPosition; }
      const String &GetAttribute() const     { return Attribute; }
      const String &GetContent() const       { return Content; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int   IDUrl;
      unsigned int   TagPosition;
      unsigned int   AttrPosition;
      String         Attribute;
      String         Content;
      
///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

};

#endif
