<?php
/*
 * $Horde: horde/phplib/local.inc,v 1.3.2.7 2000/09/21 13:48:43 bjn Exp $
 *
 * This is the Horde local.inc file for PHPLIB. You can either include
 * this file in your local.inc, replace your local.inc with it, or
 * copy the necessary contents over. There's no need for these to be
 * the only classes in local.inc.
 *
 * Please read through this file's comments to make sure the settings
 * reflect your desired configuration.
 */


/*
 * Session storage definition
 *
 * This section defines what medium to use for session storage.  The current
 * choices are:
 *      - SQL database (MySQL, by default)
 *      - Shared memory
 *      - LDAP
 *      - DBM database
 *
 * Note that only one storage type can be used at one time, so uncommenting
 * multiple types below will result in errors.
 */

/* To use an SQL database, uncomment and edit the following: */
#class HordeDB extends DB_Sql {
#  var $Host = 'localhost';
#  var $Database = 'horde';
#  var $User = 'hordemgr';
#  var $Password = 'hordemgr';
#  var $Port = '';
#
#  function halt($msg) {
#    // Printing here causes race condition trouble, so don't.
#    //printf("<b>Database error (HordeDB):</b> %s<br>\n", $msg);
#  }
#}
#
#class HordeCT extends CT_Sql {
#  var $database_class = 'HordeDB';         // Which database class to use...
#  var $database_table = 'active_sessions'; // and find our data in this table.
#}

/* To use shared memory, uncomment and edit the following: */
/* NOTE: If you do this, you must edit prepend.php3 to include ct_shm.inc
   instead of ct_sql.inc */
#class HordeCT extends CT_Shm {
#  var $max_sessions   = 500;               // number of maximum sessions
#  var $shm_key        = 0x123754;          // unique shm identifier
#  var $shm_size       = 64000;             // size of segment
#}

/* To use LDAP, uncomment and edit the following: */
/* NOTE: If you do this, you must edit prepend.php3 to include ct_ldap.inc
   instead of ct_sql.inc */
#class HordeCT extends CT_Ldap {
#  var $ldap_host = "localhost";
#  var $ldap_port = 389;
#  var $basedn    = "dc=your-domain, dc=com";
#  var $rootdn    = "cn=root, dc=your-domain, dc=com";
#  var $rootpw    = "secret";
#  var $objclass  = "phplibdata";
#}

/* To use a DBM database, uncomment and edit the following: */
/* NOTE: If you do this, you must edit prepend.php3 to include ct_dbm.inc
   instead of ct_sql.inc */
#class HordeCT extends CT_DBM {
#  var $dbm_file  = '/users/chuck/horde/lib/session.dbm';
#}


/*
 * The following classes define our session, authentication, and user
 * properties.  You probably don't need to make any changes to them.
 */
class HordeSession extends Session { var $classname = 'HordeSession'; 
  var $cookiename     = '';           // defaults to classname
  var $magic          = 'chuckmIMP';  // ID seed
  var $mode           = 'cookie';     // We propagate session IDs with cookies
  var $fallback_mode  = 'get';
  var $lifetime       = 0;            // 0 = do session cookies, else minutes
  var $that_class     = 'HordeCT';    // name of data storage container
  var $gc_probability = 5;
  var $allowcache     = 'no';         // don't allow any caching of pages
}

class HordeSessionCached extends HordeSession {
  var $allowcache     = 'private';    // allow private caching of pages
}

?>
