################################################################
# jikenbo+ theme
#  version 1.9.3 for hns-2.19.1 or later

# 2000/12/24  HyperNikkiSystem Project
# 2001/2/10   "UEYAMA Rui" <rui@t-code.org> 
# 2001/2/14   Masato Kawakami <masato@orange.co.jp> 
# 2001/11/15   Kenji <kenji@club.h14m.org>

# This code's lisence is GPL.

################################################################
# User variable
#  parameter %value is expanded to value of the user variable.
#  you can use other value of user variable by noting as "%user{BASHO}".
package HNS::Hnf::UserVar;
$Templates{'TENKI'}  = "[ŷ:%value]";
$Templates{'BASHO'}  = "(%value)";
$Templates{'TAION'}  = " β:%value";
$Templates{'TAIJU'}  = " ν:%value" . "Kg";
$Templates{'SUIMIN'} = " ̲:%value";
$Templates{'BGM'}    = " BGM:%value";
$Templates{'HOSU'}   = " %value";
$Templates{'HON'}    = " ɽ:%value";
$Templates{'KITAKU'} = " :%value";
$Templates{'WALK'}   = " :%value";
$Templates{'RUN'}    = " 祮:%value";
$Templates{'SAKE'}    = " 륳:%value";

################################################################
# Mark
package HNS::Hnf::Command::MARK;
# image size is automatically set
$List{"(^^)"}    = "icons/usaniko.png";
$List{"(-_-)"}   = "icons/usamesen.png";
$List{"(^^;"}    = "icons/usaase.png";
$List{"(;_;)"}   = "icons/usauru.png";
$List{"(T_T)"}   = "icons/usauru2.png";
$List{"v(^^)"}   = "icons/usav.png";
$List{"m(__)m"}  = "icons/usapeko.png";
$List{"!!"}      = "icons/usadoki.png";
$List{"??"}      = "icons/usahatena.png";
$List{"!?"}      = "icons/usanaze.png";
$List{"()"}    = "icons/usasho.png";
$List{":-)"}     = "icons/usasmile2.png";
$List{":-("}     = "icons/usaheno2.png";
$List{":-P"}     = "icons/usabe2.png";
$List{"(._.)"} = "icons/usamemo.png";

################################################################
# Language
package HNS::System;
$Lang = "ja";

################################################################
# CategoryList
package HNS::CategoryList;
$CatDir = "cat";

$TitleLabel = "ȥ";
$SubmitLabel = "ɽ!";
$Template = qq(<img src="%src" width="%width" height="%height" alt="">%value<br>\n);
$Categorize = "ƥʬ";

################################################################
# Extend HTML
package HNS::ExtHTML;
$DOCTYPE = qq(<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
	"http://www.w3.org/TR/REC-html40/loose.dtd">\n);
#$Head = undef;
$Head = qq(<meta http-equiv="Content-Style-Type" content="text/css">
<style type="text/css"><!--
 body { background: white }
 h3.new { margin-left: 1em }
 div.uservar { font-weight: bold; }
 div.section { margin-left: 2em; margin-top: 0 }
 div.sub { margin-left: 1em; margin-top: 0 }
 div.list { margin-left: 1em }
 div.fn { margin-left: 1em; margin-top: 0 }
 div.url { margin-bottom: 0 }
 pre { 
  white-space:  pre;
  padding:      0.5em;
  border-color: #ffeeb0;
  border-style: outset;
  border-width: 4px
 }
 a.hide:link { color: black; text-decoration: none }

 a.hide:visited { border-style: solid;
	color: #990000;
	background: #E0E0FF;
	border-width: 0px 0px 0px 0px;
	margin: 0em;
	font-weight: bold;
 }

 a.black:link { color: black; font-weight: bold }
 span.bold-red { color: red; font-weight: bold }
 div.bold-red { color: red; font-weight: bold }
--></style>
);

#$BodyVal = undef;
##$BodyVal = "bgcolor=#ffffcc";
#$DynamicPrintFunc = undef;
##$DynamicPrintFunc = \&PrintTime;
##sub PrintTime
##{
##    print qq(<div align="center">time is);
##    print join(':', reverse ((localtime)[0..2]));
##    print qq(</div>);
##}
################################################################
package HNS::Collection;
# %num : number of showing diarys
$FootMessages{'Common'} = "</td></tr></table>\n";
$FootMessages{'HasContent'} = "ʾ塢%num ʬǤ\n";
$FootMessages{'NoContent'} = "ΤϤޤ\n";

use HNS::Tools::HeadLine;
sub sidebar () {
    my $headline = new HNS::Tools::HeadLine;

    $headline->getFileList($HNS::System::DefaultMax * 3);

    my @files = reverse sort keys(%{$headline->files});
    foreach my $i (1 .. ($#files < $HNS::System::DefaultMax * 3 ? $#files : $HNS::System::DefaultMax * 3)) {
	$headline->readHnf($files[$i-1], 'side');
    }
    $headline->html_body();
}

sub Print($)
{
    my $self = shift;

    my @ymds = sort keys %{$self->diarys};
    @ymds = reverse @ymds if $HNS::System::AlwaysReverse eq "ON" || 
                                $self->mode eq 'RECENT';

    my $num;
    for (@ymds){
        my ($md, $diary) = ($_, $self->diarys->{$_});
        next unless $diary->read_done;
        my $reverse_sec;
        if (($self->mode eq 'RECENT') && ($HNS::System::NewReverse)) {
            $reverse_sec = 1;
        }
        $diary->Print($reverse_sec);
        $num++;
    }

    print qq(</td><td width="9"></td><td width="150" valign="top">
<br><a href="$HNS::System::MyDiaryURI" style="text-decoration: none"><font color="#990000"><strong>Ƕ</strong></font></a><br>\n<font size="-1">);
    sidebar;
    print '</font></td></tr><tr><td>';

    # Footer
    my $msg = $FootMessages{'Common'} if $FootMessages{'Common'};
    $msg .= ($num) ? $FootMessages{'HasContent'} :
        $FootMessages{'NoContent'};
    $msg =~ s/%num/$num/g;
    print $msg;
    $self->end_time(time);
}

################################################################
# PIM
# Schedule
package HNS::PIM::Schedule;
@WeekString = ('<font color="red"></font>', '', '', '', '', '', '<font color="blue"></font>');
@ABCString = ('', '', '');
$Unfixed = '??';
$ContentTemplate = qq(<li><strong>%month/%day%week</strong> %content</li>\n);
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

# TODO
package HNS::PIM::Todo;
$ContentTemplate = "<li><strong>%priority</strong> %content</li>\n";
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

################################################################
# Calendar
package HNS::Calendar::Table;
@WeekString = ('<font color="red"></font>', '', '', '', '', '', '<font color="blue"></font>');
$TableBorder = 0;
$NextTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month"></a>);
$PrevTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month"></a>);
$ThisTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">%yearǯ%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month%abc#%{ymd}0">%day</a>);

package HNS::Calendar::NoTable;
$NextTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">&gt;&gt;</a>);
$PrevTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">&lt;&lt;</a>);
$ThisTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month%abc#%{ymd}0">%day</a>);

################################################################
# DateSelect
package HNS::DateSelect;
$YearTemplate = "%yearǯ";
$MonthTemplate = "%month";
$DayTemplate = "%start_day%end_day";
$AllLabel = "";

################################################################
# Direct Ctalendar
package HNS::Calendar::Direct;
$SubmitLabel = "Go!";

################################################################
# Style
package HNS::Style;
$Templates{Table}->{pim} = qq(
<hr>
<table summary="pim" width="100%">
<tr><th align="left">ͽ</th><th align="left">TODO</th></tr>
<tr><td valign="top">
%schedule
</td>
<td valign="top">
%todo
</td></tr>
</table>
);

$Templates{Table}->{head_style} = qq( 
%pim
<hr>
<table summary="calendar">
<tr>
<td rowspan="2" valign="top">
%calendar
</td>
<td valign="top">
%unagi
</td>
</tr>
<tr>
<td valign="bottom">
%direct_calendar
</td>
</tr>
</table>
<hr>
<table summary="diary" width="100%"><tr><td width="4"></td><td valign="top">
);

$Templates{Table}->{foot_style} = "\n<hr>\n%category_list";

$Templates{Table}->{head_recent_style} = $Templates{Table}->{head_style};
$Templates{Table}->{foot_recent_style} = $Templates{Table}->{foot_style};

# template for no table browser
$Templates{NoTable} = {
    pim => qq(<hr>\n%schedule %todo),
    head_style => qq(%direct_calendar\n<hr>\n),
    foot_style=> qq(%pim\n<hr>\n%unagi\n<hr>\n%calendar\n<hr>\n
    		%category_list)
    };

$Templates{NoTable}->{head_recent_style} = $Templates{NoTable}->{head_style};
$Templates{NoTable}->{foot_recent_style} = $Templates{NoTable}->{foot_style};

# unagi template
$UnagiTemplate = qq( 
<a href="%namazu_url">Namazu</a> for hns ˤʰʸ<br>
ܤ <a href="%unagi_url">ܺٻ/إ</a>򻲾ȤƲ
<form method="GET" action="%unagi_url">
<strong>:</strong>
<input type="TEXT" name="key" size="30" value="">
<input type="SUBMIT" name="submit" value="Search!">
<input type="HIDDEN" name="whence" value="0">
</form>
);

$NoUnagiTemplate = qq(
<a href="http://www.h14m.org/"><img src="./icons/hns-logo.png" width="200" height="40" align="right" alt="HNS logo"></a>
);



################################################################
# Warning
package HNS::Hnf::Warning;
$Head = "<br><font color=\"red\">\[- ƥٹ";
$Foot = "-\]</font><br>\n";

# parameters:
#  %c : the command name
#  %p : command name of inserted position
#
$Messages{'IllegalHeader'} = "إåǤ";
$Messages{'UndefinedUserVar'} = "Ƥʤ桼ѿȤƤޤ";
$Messages{'Reserved'} = "ޥ %c ͽ󤵤Ƥޤ";
$Messages{'NoMatch'} = "ޥ %p ˥ޥ %c ޤ뤳ȤϤǤޤ󡣥ޥ /%c ȴƤǽޤ";
$Messages{'NotDefined'} = "ޥ %c ΰȤ %t Ƥޤ";

################################################################
# Version Message
# paramter:
#  %homepage
#  %public_version
#  %current_version

package HNS;
$VersionMessages{'Public'} = q(<hr>
<div>hns - ưƥ - Version %public</div>);

$VersionMessages{'NonPublic'} = qq(<hr>
<div>
<font color="red">ա</font> 
߻ѤƤ뤳ưƥ 
Version %current Ǥ<br>
Ƥưƥ 
Version %public Ǥ
</div>
);

################################################################
# Template
# usable parameter (%[A-Za-z0-9_]) is:
#  date:
#   %year, %month, %day	: year, month, day
#   %high		: int(day/10)
#   %abc		: day 1-10 -> a, 11-20 -> b, 21-31 -> c
#  counter:
#   %new, %sub, %fn	: counter of NEW, SUB, FN
#   %mark		: for GRP mark, if not in GRP the same as %new

package HNS::Diary;
################
# diary limited parameter:
#   %week		: week string
#
#  user-variable
#   %user{VARNAME}	: string as which user-var-format is expanded using
#			  value of user-variable VARNAME.
@WeekString = ('<font color="red"></font>', '', '', '', '', '', '<font color="blue"></font>');

$Head = qq(
<h2><a class="hide" href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%{day}0#%year%month%{day}0"
name="%year%month%{day}0">%yearǯ%month%day(%week)</a>
[<a href="$HNS::System::MyDiaryURI?%month%day">nǯ</a>]
<a title="%month/%day" href="http://nnh.to/%month/%day.html">ϲ</a></h2>
);

$UserVar = qq(<div class="uservar">
 %user{TENKI}%user{BASHO}%user{TAIJU}%user{TAION}%user{SUIMIN}%user{BGM}
 %user{HOSU}%user{HON}%user{KITAKU}%user{SAKE}
</div>);

$Foot = qq(<hr>\n);

package HNS::Hnf::Command::ConvUrl;
$HrefTemplate = "%base#%name";
$Template{mydiary} = "%href";
$Template{ISBN} = "http://www.bk1.co.jp/cgi-bin/srch/srch_result_book.cgi?idx=3&amp;isbn=%param";
$Template{CD} = "http://www.hmv.co.jp/search/title.asp?category=CATALOGUENO&amp;keyword=%param";
$Template{"hns-dev"} = sub { sprintf("http://www.h14m.org/ml/hns-dev/msg%05d.html", $_[0] - 1) };
$Template{"hns-users"} = sub { sprintf("http://www.h14m.org/ml/hns-users/msg%05d.html", $_[0] - 1) };

package HNS::Hnf::Command::CAT;
$Template = qq([<a href="./title.cgi?CAT=%enc_var">%var</a>]);
$ImgTemplate = qq(<a href="./title.cgi?CAT=%enc_var">%img</a>);

package HNS::Hnf::Command::NEW;
$Template = qq(
<h3 class="new"><a class="hide" name="%year%month%day%new" title="%year%month%day%new" 
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%new#%year%month%day%new">#%mark</a>
%cat %content</h3>
<div class="section">\n);
$EndTemplate = "</div><!-- end of NEW -->\n";

package HNS::Hnf::Command::LNEW;
$Template = qq(
<h3 class="new"><a class="hide" name="%year%month%day%new" title="%year%month%day%new" 
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%new#%year%month%day%new">#%mark</a>
%cat <a href="%1">%content</a></h3>
<div class="section">\n);
$EndTemplate = "</div><!-- end of LNEW -->\n";

package HNS::Hnf::Command::RLNEW;
$Template = qq(
<h3 class="new"><a class="hide" name="%year%month%day%new" title="%year%month%day%new" 
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%new#%year%month%day%new">#%mark</a>
%cat <a href="%url%2">%content</a></h3>
<div class="section">\n);
$EndTemplate = "</div><!-- end of RLNEW -->\n";

package HNS::Hnf::Command::SUB;
$Template = qq(
<h4><a class="hide" name="%year%month%day%{new}S%sub" title="%year%month%day%{new}S%sub"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub"></a>
%content:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of SUB -->\n";

package HNS::Hnf::Command::LSUB;
$Template = qq(
<h4><a class="hide" name="%year%month%day%{new}S%sub" title="%year%month%day%{new}S%sub"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub"></a>
<a href="%1">%content</a>:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of LSUB -->\n";
$NumAttr = 1;

package HNS::Hnf::Command::RLSUB;
$Template = qq(
<h4><a class="hide" name="%year%month%day%{new}S%sub" title="%year%month%day%{new}S%sub"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub"></a>
<a href="%url%2">%content</a>:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of RLSUB -->\n";
$NumAttr = 2;

################################################################
# Inline Elements
# these element has no content commands,
# so $EndTemplate, $AllowCommands has no means.

package HNS::Hnf::Command::LINK;
$Template = qq(<a href="%1">%content</a>\n);
$NumAttr = 1;

package HNS::Hnf::Command::RLINK;
$Template = qq(<a href="%url%2">%content</a>\n);
$NumAttr = 2;
# overriden AsHTML

package HNS::Hnf::Command::URL;
$Template = qq(<div class="url">
<img alt="*" src="./icons/mark01.png" width="16" height="16">
<a href="%1">%content (%1)</a>
</div>\n);
$NumAttr = 1;

package HNS::Hnf::Command::STRIKE;
$Template = qq(<strike>%content</strike>\n);

package HNS::Hnf::Command::LSTRIKE;
$Template = qq(<strike><a href="%1">%content</a></strike>\n);
$NumAttr = 1;

package HNS::Hnf::Command::STRONG;
$Template = qq(<strong>%content</strong>\n);

package HNS::Hnf::Command::FONT;
$Template = qq(<font %1="%2">%content</font>\n);
$NumAttr = 2;

package HNS::Hnf::Command::IMG;
$Template = 
    qq(<img %align src="%2" alt="%content" width="%width" height="%height">\n);
$NumAttr = 2;
# overriden AsHTML

package HNS::Hnf::Command::MARK;
$Template = qq(<img src="%src" alt="%1" width="%width" height="%height">\n);
$NumAttr = 1;
# overriden AsHTML

package HNS::Hnf::Command::ALIAS;
$Template = "%term";
# overriden AsHTML

################################################################
# Block Commands
package HNS::Hnf::Command::PRE;
$Template = "<pre>\n";
$EndTemplate = "</pre>\n";

package HNS::Hnf::Command::CITE;
$Template = "<blockquote>\n";
$EndTemplate = "</blockquote>\n";

package HNS::Hnf::Command::UL;
$Template = "<ul>\n";
$EndTemplate = qq(</ul>\n);

package HNS::Hnf::Command::OL;
$Template = "<ol>\n";
$EndTemplate = qq(</ol>\n);

package HNS::Hnf::Command::LI;
$Template = q(<li>%content );
$EndTemplate = "</li>\n";

package HNS::Hnf::Command::HR;
$Template = q(<hr>\n);

package HNS::Hnf::Command::FN;
$Template = 
    qq(<a href="$ENV{'REQUEST_URI'}#%year%month%day%{new}F%fn"><small>*%fn</small></a>\n);

$HeaderTemplate = qq(<hr class="section" width="40%" align="left">
<div class="fn">\n);
$FooterTemplate = qq(</div>\n);

$ContentTemplate = qq(
<a class="hide" name="%year%month%day%{new}F%fn"
href="$HNS::System::MyDiaryURI?%year%month%abc&amp;to=%year%month%day%{new}F%fn#%year%month%day%{new}F%fn"><small>*%fn</small></a>: %content<br>
);
package HNS::Tools::Title;
$CatTemplate{dynamic} =
  qq(<h3>%img<a href="title.cgi?%{arg}CAT=%enc_var">%var</a></h3>\n);
$CatLinkTemplate{dynamic} =
  qq([<a href="title.cgi?%{arg}CAT=%enc_var">%var</a>]);
$CatTemplate{static} =
  qq(<h3>%img<a href="#%enc_var" name="%enc_var">%var</a></h3>\n);
$CatLinkTemplate{static} =
  qq(<a href="tc%year%month.html#%enc_var">%var</a>);
$HeadTitle = qq(<title>$HNS::System::Title Title List</title>\n);
$Header = qq(<h1><a href="$HNS::System::MyDiaryURI">$HNS::System::Title</a> Title List</h1>\n);
$BacktoDiary = qq(<div align="right"><a href="$HNS::System::MyDiaryURI">Back to Diary</a></div>\n);

package HNS::Tools::Title::Hnf;
$BaseTemplate{dynamic} = "$HNS::System::MyDiaryURI?%year%month%abc";
$BaseTemplate{static} = "./%year%month.html";

package HNS::Tools::HeadLine;
$Max = $HNS::System::DefaultMax * 3;
$HeadTitle = qq(<title>$HNS::System::Title HeadLine</title>\n);
$Header = "";
$BacktoDiary = "";
$BaseTemplate{dynamic} = "$HNS::System::MyDiaryURI?%year%month%abc";
$BaseTemplate{static} = "./%year%month.html";
$RecentBaseTemplate{dynamic} = "$HNS::System::MyDiaryURI";
$RecentBaseTemplate{static} = "./recent.html";
$DayTemplate = qq(<a href="%href" class="black">%yearǯ%month%day</a>);

package HNS::Tools::HeadLine::New;
$Template = qq(<a href="%href" title="%para">%content</a>);

################################################################
1;
