module SCC (Node, Component, scc) where

type Node a      = (a,[a])
type Component a = [Node a]

name :: Node a -> a
name = fst

names, deps :: Eq a => Component a -> [a]
names = map fst
deps  = nub . concatMap snd

-- | Partition the input into connected components
cc :: Eq a => [Node a] -> [Component a]
cc = foldr connected [] . map (:[])

connected :: Eq a => Component a -> [Component a] -> [Component a]
connected candidate [] = [candidate]
connected candidate (c:components) =
    if any (`elem` names c) (deps candidate)
    || any (`elem` names candidate) (deps c)
    then connected (candidate++c) components
    else c : connected candidate components

-- | Partition a connected component into strongly-connected components
scc :: Eq a => Component a -> [Component a]
scc = foldr stronglyConnected []

stronglyConnected :: Eq a => Node a -> [Component a] -> [Component a]
stronglyConnected cand []    = [cand]
stronglyConnected cand comps =
    map (\cs-> if name cand `elem`  concatMap deps cs
               && any (`elem` map names cs) (snd cand)
               then
        (powerset comps)

powerset :: [a] -> [[a]]
powerset = foldr (\x s-> s ++ map (x:) s) [[]]

combinations :: [[a]] -> [[a]]
combinations []      = []
combinations (x:xss) = [ x++xs | xs <- combinations xss ]


generate all possible groupings
  where a grouping uses all nodes from the original set
test that, forall groups in a grouping,
  all members of a group satisfy the condition that there is a path from
  the member back to itself via dependencies

topological sort:
build a tree, starting with an arbitrary node
  forall non-tree nodes, attach the node to the tree.
  if node depends on the root of the tree, node becomes new root.
  otherwise, recursively look at all children as if they were roots.

  Then, after adding a node, continue through the tree.
  if


-- | Topological sort within a component.
--   List of elements is partially ordered by dependency:
--       lowest elements come first, dependent elements later.
--   Cyclic dependencies cause the ordering to be:
--       smallest set of dependencies first, larger later.
toposort :: Eq a => Component a -> Component a
toposort [] = []
toposort cs | cyclic cs = order (map (length.snd) cs)
            | otherwise =

lowest :: Eq a => Component a -> Node a
lowest = foldr1 lower 
    where lower (a
