#ifndef __varsh__
#define __varsh__

#include <map>
#include <string>

using namespace std;

class HTML;

class Vars{
public:
  enum Scope{Local,Parent,Global};
  Vars(Vars* parent):m_parent(parent){}
  bool IsDefName(string name)const;
  bool Get(const HTML& curHTML,string name,string& value)const;
  bool Set(string name,const string& value,Scope scope);
  bool Unset(string name,Scope scope);
  void Prefix(map<string,string>& results,string prefix)const;
private:
  static bool IsValidVarName(const string& name);
  bool IsDefEngine(const string& name)const;
  bool GetEngine(const string& name,string& value)const;
  bool SetEngine(const string& name,const string& value, Scope scope);
  bool UnsetEngine(const string& name, Scope scope);
  void PrefixEngine(map<string,string>& results,const string& prefix,unsigned int len)const;
  Vars* m_parent;
  map<string,string> m_map;
};

#endif
