{- This module was generated from data in the Kate syntax
   highlighting file bibtex.xml, version 1.17, by Jeroen Wijnhout (Jeroen.Wijnhout@kdemail.net)+Thomas Braun (thomas.braun@virtuell-zuhause.de) -}

module Text.Highlighting.Kate.Syntax.Bibtex
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "BibTeX"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.bib"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("BibTeX","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("BibTeX","Normal") -> return ()
      ("BibTeX","PreambleCommand") -> return ()
      ("BibTeX","StringCommand") -> return ()
      ("BibTeX","Entry") -> return ()
      ("BibTeX","Field") -> return ()
      ("BibTeX","CurlyBracket") -> return ()
      ("BibTeX","QuotedText") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_kw'5fentry = Set.fromList $ words $ "@article @book @booklet @conference @collection @electronic @inbook @incollection @inproceedings @manual @mastersthesis @misc @online @patent @periodical @proceedings @report @phdthesis @set @thesis @techreport @unpublished @www @person @company @place"

regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b = compileRegex True "[a-zA-Z0-9\\-]+"
regex_'5ba'2dzA'2dZ0'2d9'5f'40'5c'5c'2d'5c'5c'3a'5d'2b = compileRegex True "[a-zA-Z0-9_@\\\\-\\\\:]+"
regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5c'2e'5d'2b = compileRegex True "[a-zA-Z0-9\\-_\\.]+"
regex_'5b0'2d9'5d'2b = compileRegex True "[0-9]+"
regex_'2e = compileRegex True "."
regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 = compileRegex True "\\\\([a-zA-Z@]+|[^ ])"
regex_'7d'24 = compileRegex True "}$"

parseRules ("BibTeX","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~" list_kw'5fentry >>= withAttribute KeywordTok) >>~ pushContext ("BibTeX","Entry"))
   <|>
   ((pString False "@string" >>= withAttribute FunctionTok) >>~ pushContext ("BibTeX","StringCommand"))
   <|>
   ((pString False "@preamble" >>= withAttribute FunctionTok) >>~ pushContext ("BibTeX","PreambleCommand"))
   <|>
   ((pString False "@comment" >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("BibTeX","Normal")) >> pDefault >>= withAttribute CommentTok))

parseRules ("BibTeX","PreambleCommand") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("BibTeX","CurlyBracket"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("BibTeX","StringCommand") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("BibTeX","CurlyBracket"))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b >>= withAttribute StringTok) >>~ pushContext ("BibTeX","CurlyBracket"))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("BibTeX","Entry") =
  (((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5f'40'5c'5c'2d'5c'5c'3a'5d'2b >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok) >>~ pushContext ("BibTeX","Field"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("BibTeX","Entry")) >> pDefault >>= withAttribute NormalTok))

parseRules ("BibTeX","Field") =
  (((pFirstNonSpace >> pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5c'2e'5d'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '=' >>= withAttribute NormalTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("BibTeX","CurlyBracket"))
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '"' >>= withAttribute NormalTok) >>~ pushContext ("BibTeX","QuotedText"))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b >>= withAttribute StringTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("BibTeX","Field")) >> pDefault >>= withAttribute NormalTok))

parseRules ("BibTeX","CurlyBracket") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("BibTeX","CurlyBracket"))
   <|>
   ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'7d'24 >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("BibTeX","CurlyBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("BibTeX","QuotedText") =
  (((pDetectChar False '"' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("BibTeX","QuotedText")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("BibTeX","Normal") <|> fail ("Unknown context" ++ show x)
