{- This module was generated from data in the Kate syntax
   highlighting file yaml.xml, version 1.2, by Dr Orlovsky MA (dr.orlovsky@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Yaml
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Modelines
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "YAML"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.yaml;*.yml"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("YAML","normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("YAML","normal") -> return ()
      ("YAML","dash") -> (popContext) >> pEndLine
      ("YAML","header") -> (popContext) >> pEndLine
      ("YAML","EOD") -> return ()
      ("YAML","directive") -> (popContext) >> pEndLine
      ("YAML","attribute") -> (popContext >> popContext) >> pEndLine
      ("YAML","attribute-inline") -> return ()
      ("YAML","attribute-pre") -> (popContext) >> pEndLine
      ("YAML","attribute-pre-inline") -> (popContext) >> pEndLine
      ("YAML","list") -> return ()
      ("YAML","hash") -> return ()
      ("YAML","attribute-string") -> return ()
      ("YAML","attribute-stringx") -> return ()
      ("YAML","attribute-string-inline") -> return ()
      ("YAML","attribute-stringx-inline") -> return ()
      ("YAML","attribute-end") -> (popContext >> popContext >> popContext) >> pEndLine
      ("YAML","attribute-end-inline") -> (popContext >> popContext >> popContext) >> pEndLine
      ("YAML","string") -> return ()
      ("YAML","stringx") -> return ()
      ("YAML","comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'2d'2d'2d = compileRegex True "---"
regex_'5c'2e'5c'2e'5c'2e'24 = compileRegex True "\\.\\.\\.$"
regex_'25 = compileRegex True "%"
regex_'21'21'5cS'2b = compileRegex True "!!\\S+"
regex_'26'5cS'2b = compileRegex True "&\\S+"
regex_'5c'2a'5cS'2b = compileRegex True "\\*\\S+"
regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a = compileRegex True "\\??\\s*[^\"'#-][^:#]*:"
regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a = compileRegex True "\\??\\s*\"[^\"#]+\"\\s*:"
regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a = compileRegex True "\\??\\s*'[^'#]+'\\s*:"
regex_null'24 = compileRegex True "null$"
regex_'2e = compileRegex True "."
regex_'5cs'2a = compileRegex True "\\s*"
regex_'2c'5cs = compileRegex True ",\\s"

parseRules ("YAML","normal") =
  (((pColumn 0 >> pRegExpr regex_'2d'2d'2d >>= withAttribute OtherTok) >>~ pushContext ("YAML","header"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2e'5c'2e'5c'2e'24 >>= withAttribute CommentTok) >>~ pushContext ("YAML","EOD"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'25 >>= withAttribute OtherTok) >>~ pushContext ("YAML","directive"))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   ((pFirstNonSpace >> pDetectChar False '-' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","dash"))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","list"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","hash"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'21'21'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'26'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("YAML","string"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("YAML","stringx"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","dash") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   ((pRegExpr regex_null'24 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'26'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((lookAhead (pRegExpr regex_'2e) >> (popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","dash")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","header") =
  (((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","header")) >> pDefault >>= withAttribute OtherTok))

parseRules ("YAML","EOD") =
  (currentContext >>= \x -> guard (x == ("YAML","EOD")) >> pDefault >>= withAttribute CommentTok)

parseRules ("YAML","directive") =
  (currentContext >>= \x -> guard (x == ("YAML","directive")) >> pDefault >>= withAttribute OtherTok)

parseRules ("YAML","attribute") =
  (((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","attribute-inline") =
  (((pDetectChar False ',' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-inline")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","attribute-pre") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   ((pRegExpr regex_null'24 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","list"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","hash"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-string"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-stringx"))
   <|>
   ((pRegExpr regex_'26'5cS'2b >>= withAttribute DataTypeTok) >>~ pushContext ("YAML","attribute"))
   <|>
   ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute DataTypeTok) >>~ pushContext ("YAML","attribute"))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute NormalTok) >>~ pushContext ("YAML","attribute"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-pre")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","attribute-pre-inline") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   ((pString False "null" >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","list"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","hash"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-string-inline"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-stringx-inline"))
   <|>
   ((pRegExpr regex_'26'5cS'2b >>= withAttribute DataTypeTok) >>~ pushContext ("YAML","attribute-inline"))
   <|>
   ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute DataTypeTok) >>~ pushContext ("YAML","attribute-inline"))
   <|>
   ((pDetectChar False ',' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute NormalTok) >>~ pushContext ("YAML","attribute-inline"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-pre-inline")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","list") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   ((pDetectChar False ']' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre"))
   <|>
   ((pString False "null" >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","list"))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("YAML","hash"))
   <|>
   ((pRegExpr regex_'26'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("YAML","string"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("YAML","stringx"))
   <|>
   ((pDetectChar False ',' >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","list")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","hash") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("YAML","comment"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre-inline"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre-inline"))
   <|>
   ((pRegExpr regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a >>= withAttribute FunctionTok) >>~ pushContext ("YAML","attribute-pre-inline"))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","hash")) >> pDefault >>= withAttribute NormalTok))

parseRules ("YAML","attribute-string") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-end"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-string")) >> pDefault >>= withAttribute StringTok))

parseRules ("YAML","attribute-stringx") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-end"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-stringx")) >> pDefault >>= withAttribute StringTok))

parseRules ("YAML","attribute-string-inline") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-end-inline"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-string-inline")) >> pDefault >>= withAttribute StringTok))

parseRules ("YAML","attribute-stringx-inline") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("YAML","attribute-end-inline"))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-stringx-inline")) >> pDefault >>= withAttribute StringTok))

parseRules ("YAML","attribute-end") =
  (currentContext >>= \x -> guard (x == ("YAML","attribute-end")) >> pDefault >>= withAttribute ErrorTok)

parseRules ("YAML","attribute-end-inline") =
  (((pRegExpr regex_'5cs'2a >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext >> popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'2c'5cs >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","attribute-end-inline")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("YAML","string") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("YAML","stringx") =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","stringx")) >> pDefault >>= withAttribute StringTok))

parseRules ("YAML","comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((Text.Highlighting.Kate.Syntax.Modelines.parseExpression (Just ("Modelines","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("YAML","comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing
parseRules ("Modelines", _) = Text.Highlighting.Kate.Syntax.Modelines.parseExpression Nothing

parseRules x = parseRules ("YAML","normal") <|> fail ("Unknown context" ++ show x)
