{- This module was generated from data in the Kate syntax
   highlighting file sql-mysql.xml, version 1.13, by Shane Wright (me@shanewright.co.uk) -}

module Text.Highlighting.Kate.Syntax.SqlMysql
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "SQL (MySQL)"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.sql;*.SQL"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "SQL (MySQL)" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("SQL (MySQL)",["Normal"])], synStLanguage = "SQL (MySQL)", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = False, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> return ()
    "String2" -> return ()
    "Name" -> return ()
    "SingleLineComment" -> (popContext) >> pEndLine
    "MultiLineComment" -> return ()
    "Preprocessor" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "access add all alter analyze and as asc auto_increment bdb berkeleydb between both by cascade case change charset column columns constraint create cross current_date current_time current_timestamp database databases day_hour day_minute day_second dec default delayed delete desc describe distinct distinctrow drop else enclosed escaped exists explain fields for foreign from fulltext function grant group having high_priority if ignore in index infile inner innodb insert interval into is join key keys kill leading left like limit lines load lock low_priority master_server_id match mrg_myisam natural national not null numeric on optimize option optionally or order outer outfile partial precision primary privileges procedure purge read references regexp rename replace require restrict returns revoke right rlike select set show soname sql_big_result sql_calc_found_rows sql_small_result ssl starting straight_join striped table tables terminated then to trailing truncate type union unique unlock unsigned update usage use user_resources using values varying when where with write xor year_month zerofill"
list_operators = Set.fromList $ words $ "+ - * / || = != <> < <= > >= ~= ^= := => ** .."
list_functions = Set.fromList $ words $ "ascii ord conv bin oct hex char concat concat_ws length octet_length char_length character_length bit_length locate position instr lpad rpad left right substring substring_index mid ltrim rtrim trim soundex space replace repeat reverse insert elt field find_in_set make_set export_set lcase lower ucase upper load_file quote abs sign mod floor ceiling round exp ln log log2 log10 pow power sqrt pi cos sin tan acos asin atan atan2 cot rand least greatest degrees radians dayofweek weekday dayofmonth dayofyear month dayname monthname quarter week year yearweek hour minute second period_add period_diff date_add date_sub adddate subdate extract to_days from_days date_format time_format curdate current_date curtime current_time now sysdate current_timestamp unix_timestamp from_unixtime sec_to_time time_to_sec cast convert bit_count database user system_user session_user password encrypt encode decode md5 sha1 sha aes_encrypt aes_decrypt des_encrypt des_decrypt last_insert_id format version connection_id get_lock release_lock is_free_lock benchmark inet_ntoa inet_aton master_pos_wait found_rows count avg min max sum std stddev bit_or bit_and"
list_types = Set.fromList $ words $ "char character varchar binary varbinary tinyblob mediumblob blob longblob tinytext mediumtext text longtext enum bit bool boolean tinyint smallint mediumint middleint int integer bigint float double real decimal dec fixed numeric long serial date datetime time timestamp year"

regex_SET'28'3f'3d'5cs'2a'5c'28'29 = compileRegex "SET(?=\\s*\\()"
regex_'5cbCHARACTER_SET'5cb = compileRegex "\\bCHARACTER SET\\b"
regex_'25'28'3f'3abulk'5f'28'3f'3aexceptions'7crowcount'29'7cfound'7cisopen'7cnotfound'7crowcount'7crowtype'7ctype'29'5cb = compileRegex "%(?:bulk_(?:exceptions|rowcount)|found|isopen|notfound|rowcount|rowtype|type)\\b"
regex_rem'5cb = compileRegex "rem\\b"
regex_'2f'24 = compileRegex "/$"
regex_'40'40'3f'5b'5e'40_'5ct'5cr'5cn'5d = compileRegex "@@?[^@ \\t\\r\\n]"

defaultAttributes = [("Normal",NormalTok),("String",StringTok),("String2",StringTok),("Name",StringTok),("SingleLineComment",CommentTok),("MultiLineComment",CommentTok),("Preprocessor",OtherTok)]

parseRules "Normal" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_SET'28'3f'3d'5cs'2a'5c'28'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5cbCHARACTER_SET'5cb >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_operators >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_functions >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t(),%&;?[]{}\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'28'3f'3abulk'5f'28'3f'3aexceptions'7crowcount'29'7cfound'7cisopen'7cnotfound'7crowcount'7crowtype'7ctype'29'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String2")
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext "Name")
   <|>
   ((pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext "SingleLineComment")
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext "SingleLineComment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "MultiLineComment")
   <|>
   ((pColumn 0 >> pRegExpr regex_rem'5cb >>= withAttribute CommentTok) >>~ pushContext "SingleLineComment")
   <|>
   ((pAnyChar ":&" >>= withAttribute CharTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'2f'24 >>= withAttribute CharTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'40'40'3f'5b'5e'40_'5ct'5cr'5cn'5d >>= withAttribute OtherTok) >>~ pushContext "Preprocessor")
   <|>
   ((pDetectChar False '.' >>= withAttribute CharTok)))

parseRules "String" =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '&' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "String2" =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '&' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Name" =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "SingleLineComment" =
  pzero

parseRules "MultiLineComment" =
  (((pLineContinue >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Preprocessor" =
  pzero

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
