/***************************************************************************
                          stylecolour.cpp  -  description
                             -------------------
    begin                : Die Nov 5 2002
    copyright            : (C) 2002 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stylecolour.h"
#include "stringtools.h"


#include <iostream>
#include <sstream>
#include <cmath>

using std::string;

namespace highlight {

StyleColour::StyleColour(const string & red, const string & green, const string & blue)
{
  ostringstream rgbStream;
  rgbStream << red << " " << green << " " << blue;
  setRGB(rgbStream.str());
}

StyleColour::StyleColour()
{
  rgb.red = rgb.green = rgb.blue = "00";
  rgb.iRed = rgb.iGreen = rgb.iBlue = 0;
}

StyleColour::StyleColour(const string & styleColourString)
{
  setRGB(styleColourString);
}

void StyleColour::setRGB(const string & styleColourString){

  istringstream valueStream(styleColourString.c_str());
  valueStream >> rgb.red;
  valueStream >> rgb.green;
  valueStream >> rgb.blue;

  StringTools::str2num<int>(rgb.iRed, rgb.red, std::hex);
  StringTools::str2num<int>(rgb.iGreen, rgb.green, std::hex);
  StringTools::str2num<int>(rgb.iBlue, rgb.blue, std::hex);
}

void StyleColour::setRed(const string & red)
{
  rgb.red = red;
  StringTools::str2num<int>(rgb.iRed, rgb.red, std::hex);
}

void StyleColour::setGreen(const string & green)
{
  rgb.green = green;
  StringTools::str2num<int>(rgb.iGreen, rgb.green, std::hex);
}

void StyleColour::setBlue(const string & blue)
{
  rgb.blue = blue;
  StringTools::str2num<int>(rgb.iBlue, rgb.blue, std::hex);
}

string StyleColour::getRed(OutputType type){
   switch (type) {
     case RTF:   return int2str(rgb.iRed);
     case LATEX: return float2str( (float) rgb.iRed / 255);
     case TEX:   return float2str( 1 - (float) rgb.iRed / 255);
     default:    return rgb.red;
   }
}

string StyleColour::getGreen(OutputType type){
   switch (type) {
     case RTF:   return int2str(rgb.iGreen);
     case LATEX: return float2str( (float) rgb.iGreen / 255);
     case TEX:   return float2str( 1 - (float) rgb.iGreen / 255);
     default:    return rgb.green;
   }
}

string StyleColour::getBlue(OutputType type){
   switch (type) {
     case RTF:   return int2str(rgb.iBlue);
     case LATEX: return float2str( (float) rgb.iBlue / 255);
     case TEX:   return float2str( 1 - (float) rgb.iBlue / 255);
     default:    return rgb.blue;
   }
}


string StyleColour::int2str(const int num)
{
  std::ostringstream outStream;
  outStream << num;

  return outStream.str();
}

string StyleColour::float2str(const double num)
{
  std::ostringstream outStream;
  outStream << ( floor ( num * 100 + .5 ) / 100);

  return outStream.str();
}

}

