/***************************************************************************
                        PreFormatter.cpp  -  description
                             -------------------
    begin                : Mo Jan 03 2005
    copyright            : (C) 2005 by Andr Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PreFormatter_H
#define PreFormatter_H

#define LB_CHARS " \t[](){}-+<>.:,;"
#define WS_CHARS " \n\r\t"
#define INDENT_MARKERS "{(="

#include <string>
#include <iostream>

#include "stringtools.h"

namespace highlight {

/** \brief Class which provides intelligent line wrapping.
* @author Andre Simon
*/

class PreFormatter{
public:
    /** Constructor
    */
    PreFormatter(bool wrap, bool replTabs);

    PreFormatter();

    ~PreFormatter();

    /**
     \return True if current line can be wrapped again
    */
    bool hasMoreLines();

    /**
     Sets new line to be wrapped
     \param newline New line
    */
    void setLine(const std::string  newline);

    /**
     The method will indent function calls and statements
     \return Next line
    */
    std::string  getNextLine();

    /**
     \return True if lines following open braces should be indented
    */
    bool indentCode();

    /**
      \param maxlength max. length of output lines
      \param indentAfterOpenBraces set true if lines should be indented after braces
    */
    void setWrappingProperties(unsigned int maxlength=80, bool indentAfterOpenBraces=true);

    /**
      \param num number of spaces which replace a tab
    */

    void setNumberSpaces(unsigned int num);

    /**
      \return true if preformatting is enabled
    */
    bool isEnabled(){
      return wrapLines || replaceTabs;
    }

private:

    unsigned int maxLineLength;

    std::string line, wsPrefix;
    unsigned int index;
    unsigned int numberSpaces;
    size_t wsPrefixLength;
    bool hasMore, indentAfterOpenBraces;
    bool redefineWsPrefix;
    bool wrapLines, replaceTabs;
};

}

#endif
