/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sitetext.h,v 1.3.20.1 2004/07/09 01:59:28 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SITETEXT_H_
#define _SITETEXT_H_


#if !defined(_WINDOWS)
class CHXSiteStatusText : public IHXSiteUser
#else
class CHXSiteStatusText
#endif
{
public:

#if !defined(_WINDOWS)
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     * IHXSiteUser methods usually called by the "context" to 
     * associate users with the site.
     */
    STDMETHOD(AttachSite)	(THIS_
				IHXSite*	/*IN*/ pSite);

    STDMETHOD(DetachSite)	(THIS);

    /*
     * IHXSiteUser methods called to inform user of an event.
     */
    STDMETHOD(HandleEvent)	(THIS_
				HXxEvent*	/*IN*/ pEvent);

    STDMETHOD_(BOOL,NeedsWindowedSites)	(THIS);

    HX_RESULT	Create(IHXSite* pSite);
#endif

    CHXSiteStatusText();
    ~CHXSiteStatusText();
    
#if defined(_WINDOWS)
    void	RegisterClass();
    void	UnRegisterClass();
    HINSTANCE	GetInstance();
    HX_RESULT	Create(void* ParentWindow);
    LRESULT	HandleEvent(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam);
#endif

#if defined(_UNIX) && !defined(_MAC_UNIX)
    BOOL ConvertRGBToXColor(HXxColor& hxxColor, XColor& xcolor);
#endif

    HX_RESULT	Destroy();
    HX_RESULT	Show();
    HX_RESULT	Hide();
    HX_RESULT	ParentChangedSize();
    void	SetStatusText(const char* pText);

#if defined(_WINDOWS)
    static CHXMapPtrToPtr zm_StatusWindowMap;
#endif

    private:
#if defined(_WINDOWS)
    HWND	m_hWnd;
    HWND	m_parentWindow;
    RECT	m_rect;
    HBITMAP	m_hBitMap;
    COLORREF	m_backgroundBrush;
    COLORREF	m_textColor;
#endif

#if defined(_UNIX) && !defined(_MAC_UNIX)
    Display*     m_display;
    Window       m_window;
    Colormap     m_colormap;
    XFontStruct* m_statusfont;    
#endif

#if defined(_MACINTOSH) || defined(_MAC_UNIX)
    BYTE* m_pStatusImage;
#endif

    LONG32	m_lRefCount;
    HXxColor	m_rgbBkgndColor;
    HXxColor	m_rgbTextColor;
    IHXSite*	m_pSite;
    IHXSite*	m_pParentSite;
    HXxPoint	m_statusPos;
    HXxSize	m_statusSize;
    CHXString	m_StatusText;

    HX_RESULT	GetIHXSite2(REF(IHXSite2*) pSite2);
    HX_RESULT	BringToTop();
    HX_RESULT	UpdatePosition();

    HX_RESULT	_DrawStatusText(HXxEvent* pEvent);
    HX_RESULT	_AdjustPosition(HXxPoint* pParentPos, HXxSize* pParentSize);

#if defined(_WINDOWS)
    static UINT32 zm_nInstanceCount; 
#endif
};

#endif /* _SITETEXT_H_ */
