/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: winsite.h,v 1.1.1.1.42.1 2004/07/09 01:58:48 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/****************************************************************************
 *  $Id: winsite.h,v 1.1.1.1.42.1 2004/07/09 01:58:48 hubbe Exp $
 */

#ifndef _WINSITE_H_
#define _WINSITE_H_

#include "hxslist.h"
#include "hxmap.h"
#include "chxpckts.h"
#include "hxwin.h"
#include "hxsite2.h"
#include "hxcomm.h"
#include "hxengin.h"
#include "winroot.h"

#include "basesite.h"
#include "winsurf.h"

class  CHXWinSite;
class  CHXWinFullScreenWindow;
class  ColorFuncAccess;

LRESULT HXEXPORT HXxWinHookSiteProc(HWND hWnd, UINT message, WPARAM uParam, LPARAM lParam);
LRESULT HXEXPORT HXxWinHookChar(int nCode,WPARAM wParam,LPARAM lParam);
LRESULT HXEXPORT HXxWinHookAllMessages(int nCode,WPARAM wParam,LPARAM lParam);


/*
*  reasons to schedule call backs.
*/

#define REPAINT 0
#define CLIP    1
#define MOUSE   2

struct CParentWindowThreadData
{
    HHOOK	    m_hHook;
    HHOOK	    m_hHookAllMessage;
    CHXSimpleList   m_ListOfTopLevelSites;
};

/****************************************************************************
* 
*  Class:
*
*       CHXWinSite
*
*  Purpose:
*
*       Implementation for IHXSite objects which are associated with
*       platform specific window objects on Microsoft Windows and X-Windows.
*
*/


class CHXWinSite : public CHXBaseSite
{
        friend class    CWinRootSurface;
        
public:
    CHXWinSite(IUnknown* pContext, IUnknown* pUnkOuter = NULL, INT32 lZorder = 0);
        
    static CHXMapPtrToPtr   zm_ParentWnds;
    static CHXMapPtrToPtr   zm_ParentsThreadList;
    static CHXMapPtrToPtr   zm_SubclassedWnds;
    static CHXMapPtrToPtr   zm_ScrollBarWnds;
    static CHXMapPtrToPtr   zm_ListOfHiddenWindows;
    static char*	    zm_pszWindowClassName;
    static char*	    zm_pszWindowName;
    static INT32	    zm_nInstanceCount;
	
    WNDPROC		    m_oldWndProc;

    void    ReHookParents();
    void    HookParents();
        
    void    HandleParentMessages(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam);
    BOOL    HandleWndProc(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam, LRESULT& lResult);
        
private:
                
    UINT32                  m_ulSiteThreadID;
        
protected:
    virtual     ~CHXWinSite();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    void        UnHookParents();
    void        RegisterClass();
    void        UnRegisterClass(); 
        
    void        _SizeSliders();
        
        virtual void        _NeedWindowedSite();
        virtual void        _AttachWindow();
        virtual void        _DetachWindow();
        virtual void*       _Create(void* ParentWindow, UINT32 style);
        virtual void        _Destroy(HXxWindow* pWindow);
        virtual void        _SetSize(HXxSize size);
        virtual void        _SetPosition(HXxPoint position);
        virtual void        _DamageRect(HXxRect rect);
        virtual void        _DamageRegion(HXxRegion rect);
        virtual BOOL        _ShouldEnterForceRedraw();
        virtual void        _ExitForceRedraw();
        virtual void        _SendOSUpdateMessage();
        virtual void        _ShowSite(BOOL bShow);
        virtual BOOL        _AtSystemTime();
        virtual HX_RESULT   _EventOccurred(HXxEvent* /*IN*/ pEvent);
        virtual void        _GetDeviceCaps( void* hdc,
                                                                                UINT16& uBitesPerPixel,
                                                                                UINT16& uHorzRes,
                                                                                UINT16& uVertRes);
        virtual void        _GetWindowRect(HXxRect* destRect);
        virtual void        _DestroySliders();
        virtual BOOL        _HandleOSEvents(HXxEvent* /*IN*/ pEvent);
        virtual BOOL        _ConvertToHXEvent( HXxEvent* pEvent );
        virtual void        _GenerateOSEvent(HXxEvent* pEvent, HXxEvent* pEvent2);
        virtual void        _GenerateSetCursorEvent();
        virtual HX_RESULT   _EnterFullScreen();
        virtual HX_RESULT   _ExitFullScreen();
        virtual HX_RESULT   _TestFullScreen(void* hTestBitmap,
                                                                                const char* pszStatusText);
        virtual void _TryCreateXSlider();
        virtual void _SetXSliderValues(INT32 range, INT32 pageSize);
        virtual void _TryCreateYSlider();
        virtual void _SetYSliderValues(INT32 range, INT32 pageSize);
        virtual void _GetSystemSizeOfSliders(INT32* pWidth, INT32* pHeight);
        virtual BOOL _IsWindowVisible();
        virtual void _ShowXSlider(BOOL bShow);
        virtual void _MoveXSlider(INT32 left, INT32 top,
                                                                INT32 right, INT32 bottom,
                                                                BOOL bRedraw);
        virtual void _ShowYSlider(BOOL bShow);
        virtual void _MoveYSlider(INT32 left, INT32 top,
                                                                INT32 right, INT32 bottom,
                                                                BOOL bRedraw);
        virtual BOOL _DoesXSliderExist();
        virtual void*_GetContainingWindow(); // XXXAH void*? Not HXxWindow??
        virtual void _GetCursorPos(HXxPoint* pPoint);
        virtual void _MapPointToOSWindow(HXxPoint* pPt, void** pWindowHandle);
        
        //This returns the OS specific window handle, as void*, that the
        //pointer is currently in.
        virtual void* _GetWindowWithCursor();
        virtual void  _ReInitPrimarySurface(); // XXXAH may want to move this to root.
        
        virtual BOOL  _MoveWindow( void* ,
                                                                INT32 X, INT32 Y,
                                                                INT32 nWidth, INT32 nHeight,
                                                                BOOL bRepaint);
        virtual BOOL  _UpdateWindow(void* hWnd);
        virtual BOOL  _ShowWindow(void* hWnd, INT32 nCmdShow);
        virtual BOOL  _SetWindowPos(void* hWnd,
                                                                void* hWndInsertAfter,
                                                                INT32 X, INT32 Y,
                                                                INT32 cx, INT32 cy,
                                                                INT32 uFlags);

        int _CreateXSlider(int range);
        int _CreateYSlider(int range);
        
        // this is going to be a nice one.
        virtual BOOL _SetWindowRgn(void* hWnd, HXREGION* hRgn, BOOL bRedraw);
        // XXXAH it would be nice to get the return value here
        virtual void _SetFocus(void* pWindow);

        virtual void _DrawFocusRect(UCHAR* pImage,
                                    HXBitmapInfoHeader* pImageInfo,
                                    HXxRect* pImageSize,
                                    void* pOsSpecificData=NULL);

    /*
     * crap from windowless
     */
public:

        /*
     *  SetCapture Support
     */

    void SetCaptureMessage(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
    void CheckCapture();

    /*
     *  Supporting windowed renderers
     */

    HXxWindow* GetTopLevelWindow() {return &(m_pTopLevelSite->m_TopLevelWindow);}
//    void DrawAllSites();

        HX_RESULT InternalTestFullScreen(LPVOID hTestBitmap,const char* pszStatusText);
        HX_RESULT TestMode(const char* pszModeDescription, void* hTestBitmap, const char* pszText);
        int TestFullScreenPerformance(void* hTestBitmap, const char* pszText);

        // Windowless stuff
    CRITICAL_SECTION            m_CriticalSection;

protected:

    /*
     *  Slider Support
     */

    HWND                    m_hXSlider;
    HWND                    m_hYSlider;
private:

    HWND                        m_windowParent;
    CHXWinFullScreenWindow*     m_pContainingWindow;
};

class CHXWinFullScreenWindow
{
public:
    void        RegisterClass();
    void        UnRegisterClass();
    HX_RESULT   Create();
    HX_RESULT   Destroy();
    HX_RESULT   Show();
    HX_RESULT   Hide();
    BOOL        IsVisible() {return m_bIsVisible;}
    static LRESULT HXEXPORT WindowProc(HWND hWnd,UINT message,WPARAM uParam,LPARAM lParam);
        
    CHXWinFullScreenWindow(CHXWinSite* pSite);
    ~CHXWinFullScreenWindow();
    HWND GetWindow() {return m_hWnd;}
    void ForceExitFullScreen(UINT message, WPARAM  wParam, LPARAM  lParam);
        
private:
    HWND                m_hWnd;
    HWND                m_hOldFocus;
    HWND                m_hOldForegroudWindow;
    CHXWinSite*         m_pWindowless;
    static UINT32       zm_nInstanceCount; 
    static char*        zm_pszWindowClassName;
    static char*        zm_pszWindowName;
    static BOOL         zm_bHideFullScreenWindow;
    BOOL                m_bIsVisible;
};

#endif /* _WINSITE_H_ */









