/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxgerror.cpp,v 1.3.6.4.4.1 2005/09/09 01:32:19 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxgerror.h"
#include "hx-i18n.h"
#include "hxerrorstrings.h"

#include "HXErrorCodeStrings.h"

GQuark
hx_error_quark(void)
{
    static GQuark err_q = 0;
 
    if (err_q == 0)
        err_q = g_quark_from_static_string ("hx_error-quark");
    
    return err_q;
}

G_CONST_RETURN gchar*
hx_error_get_message_from_hxresult(guint hxCode)
{
    guint i;
    
    for(i = 0; i < sizeof(g_hxerror_to_message_map) / sizeof(*g_hxerror_to_message_map); i++)
    {
        if(g_hxerror_to_message_map[i].code == hxCode)
        {
            return dgettext(PACKAGE, g_hxerror_to_message_map[i].message);
        }
    }

    return NULL;
}


GError*
hx_error_new(guint        hxCode,
             guint        userCode,
             const gchar* pErrorString,
             const gchar* pUserString,
             const gchar* pMoreInfoURL)
{
    GError* err;
    GString* message;    
    HXError code;

    /* Don't display the user code */
    (void)userCode;
    
    if(pMoreInfoURL != NULL)
    {
        /* This shouldn't happen. The url would be wrong anyway. */
        g_warning("Core passed us a pMoreInfoURL");
    }
    
    code = HX_ERROR_GENERAL;
    message = g_string_new("");

    if(pErrorString)
    {
        /* Some SMIL errors get passed in this way  */
        g_string_append(message, pErrorString);
    }
    else    
    {
        const gchar* error_str = hx_error_get_message_from_hxresult(hxCode);
        if(error_str)
        {
            g_string_append(message, error_str);
        }
        else
        {
            error_str = HXErrorCodeToString(hxCode);
            if(!error_str)
            {
                error_str = "";
            }
            g_string_append_printf(message, _("General error: %s (0x%08x)"),
                                             error_str,
                                             hxCode);
        }
    }

    if(pUserString != NULL)
    {
        /* Again, I hear that only smil will do this */
        g_string_append_printf(message, " (%s)", pUserString);
    }
   
    err = g_error_new (HX_ERROR, code, "%s", message->str);

    g_string_free(message, TRUE);
    
    return err;
}
