/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: shadvsrc.cpp,v 1.2.24.1 2004/07/09 01:52:03 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "rpffdll.ver"

#include "hxtypes.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "ihxpckts.h"
#include "hxformt.h"
#include "hxvsrc.h"  /*IHXFileViewSource*/
#include "chxfgbuf.h" /*CHXFragmentedBuffer */
#include "baseobj.h"
#include "shadvsrc.h"
#include "escrp.h" /* CEscapeSMIL */

// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

// As defined in smlffpln.cpp
static const UINT32 FileChunkSize = 10000;	//XXXBAB adjust

CRPViewSource::CRPViewSource(IUnknown* pContext, IUnknown* pContainer)
    :	m_lRefCount(0)
    ,	m_pContext(NULL)
    ,	m_pCommonClassFactory(NULL)
    ,	m_pFileObject(NULL)
    ,	m_pViewSourceResponse(NULL)
    ,	m_type(HTML_SOURCE)
    ,	m_pBuffer(NULL)
    ,	m_pContainer(NULL)
    ,	m_pOptions(NULL)
{
    m_pContext = pContext;
    HX_ASSERT(m_pContext != NULL);
    m_pContext->AddRef();

    m_pContainer = pContainer;
    HX_ASSERT(m_pContainer != NULL);
    m_pContainer->AddRef();
};
CRPViewSource::~CRPViewSource()
{
    Close();
}

/* *** IUnknown methods *** */

/************************************************************************
 *  Method:
 *	IUnknown::QueryInterface
 *  Purpose:
 *	Implement this to export the interfaces supported by your 
 *	object.
 */
STDMETHODIMP CRPViewSource::QueryInterface(REFIID riid, void** ppvObj)
{
    if (IsEqualIID(riid, IID_IHXFileViewSource))
    {
	AddRef();
	*ppvObj = (IHXFileViewSource*)this;
	return HXR_OK;
    }
    else if (m_pContainer != NULL)
    {
        // deligate to our container
        return m_pContainer->QueryInterface(riid, ppvObj);
    }
    else if (IsEqualIID(riid, IID_IUnknown))
    {
        AddRef();
        *ppvObj = m_pContainer;
        return HXR_OK;
    }
    *ppvObj = NULL;
    // deligate to our container
    return HXR_NOINTERFACE;
}

/************************************************************************
 *  Method:
 *	IUnknown::AddRef
 *  Purpose:
 *	Everyone usually implements this the same... feel free to use
 *	this implementation.
 */
STDMETHODIMP_(ULONG32) CRPViewSource::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

/************************************************************************
 *  Method:
 *	IUnknown::Release
 *  Purpose:
 *	Everyone usually implements this the same... feel free to use
 *	this implementation.
 */
STDMETHODIMP_(ULONG32) CRPViewSource::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;
    return 0;
}

/************************************************************************
 *  Method:
 *	IHXFileViewSource::Close()
 *  Purpose:
 *	Close down...
 */
STDMETHODIMP 
CRPViewSource::Close()
{
    HX_RELEASE(m_pOptions);
    HX_RELEASE(m_pContext);
    HX_RELEASE(m_pCommonClassFactory);
    if (m_pFileObject)
    {
	m_pFileObject->Close();
	HX_RELEASE(m_pFileObject);
    }
    HX_RELEASE(m_pBuffer);
    HX_RELEASE(m_pContainer);
    if ( m_pViewSourceResponse != NULL )
    {
	m_pViewSourceResponse->CloseDone(HXR_OK);
	HX_RELEASE(m_pViewSourceResponse);
    }
    return HXR_OK;
}

/************************************************************************
 *  Method:
 *	IHXFileViewSource::InitViewSource
 *  Purpose:
 *	Called by the user to init before a viewsource.
 */

STDMETHODIMP
CRPViewSource::InitViewSource(IHXFileObject* pFileObject,
	IHXFileViewSourceResponse* pResp, SOURCE_TYPE sourceType,
	IHXValues* pOptions)
{
    if ( sourceType == HTML_SOURCE )
    {
	m_type = HTML_SOURCE;
    }
    else if ( sourceType == RAW_SOURCE )
    {
	m_type = RAW_SOURCE;
    }
    else
    {
	HX_ASSERT(FALSE);
	return HXR_UNEXPECTED;
    }
    HX_RELEASE(m_pCommonClassFactory);
    HX_RESULT ret = m_pContext->QueryInterface(IID_IHXCommonClassFactory, 
	(void**)&m_pCommonClassFactory);
    if ( !SUCCEEDED(ret) )
    {
	return ret;
    }

    HX_ASSERT(pResp != NULL);
    
    HX_RELEASE(m_pOptions);
    m_pOptions = pOptions;
    m_pOptions->AddRef();

    HX_RELEASE(m_pViewSourceResponse);
    m_pViewSourceResponse = pResp;
    m_pViewSourceResponse->AddRef();
    if ( m_pFileObject != NULL )
    {
	m_pFileObject->Close();
        HX_RELEASE(m_pFileObject);
    }
    m_pFileObject = pFileObject;
    HX_ASSERT(m_pFileObject != NULL);
    m_pFileObject->AddRef();

    IHXFileStat* pStat = NULL;
    if ( SUCCEEDED(m_pFileObject->QueryInterface(IID_IHXFileStat, 
	(void**)&pStat)) )
    {
	pStat->Stat(this);
    }
    HX_RELEASE(pStat);
    return HXR_OK;
}


STDMETHODIMP
CRPViewSource::StatDone(HX_RESULT status, UINT32 ulSize, UINT32 ulCreationTime,
			    UINT32 ulAccessTime, UINT32 ulModificationTime, 
			    UINT32 ulMode)
{
    m_pOptions->SetPropertyULONG32("FileSize", ulSize);
    m_pOptions->SetPropertyULONG32("ModificationTime", ulModificationTime);
    IHXBuffer* pName = NULL;
    const char* p = NULL;
    m_pFileObject->GetFilename(p);
    if ( SUCCEEDED(m_pCommonClassFactory->CreateInstance(CLSID_IHXBuffer, 
	(void**)&pName)) )
    {
	pName->Set((const BYTE*)p, strlen(p) + 1);
    }
    m_pOptions->SetPropertyCString("FileName", pName);
    HX_RELEASE(pName);
    return m_pFileObject->Init(HX_FILE_READ, this);
}

/************************************************************************
 *	Method:
 *	    IHXFileViewSource::GetSource
 *	Purpose:
 *	    Called to get source html source.  Return the source
 *	through m_pViewSourceResoponse
 */
STDMETHODIMP
CRPViewSource::GetSource()
{
    HX_ASSERT(m_pViewSourceResponse != NULL);
    HX_ASSERT(m_pFileObject != NULL);
    return m_pFileObject->Read(FileChunkSize);
}

/************************************************************************
 *  Method:
 *    IHXFileResponse::InitDone
 *  Purpose:
 *    Notification interface provided by users of the IHXFileObject
 *    interface. This method is called by the IHXFileObject when the
 *    initialization of the file is complete.
 */
STDMETHODIMP CRPViewSource::InitDone( HX_RESULT status )
{
    HX_ASSERT(m_pViewSourceResponse != NULL);
    return m_pViewSourceResponse->InitDone(status);
}

/************************************************************************
 *  Method:
 *	IHXFileResponse::ReadDone
 *  Purpose:
 *	Notification interface provided by users of the IHXFileObject
 *	interface. This method is called by the IHXFileObject when the
 *	last read from the file is complete and a buffer is available.
 */
STDMETHODIMP CRPViewSource::ReadDone(HX_RESULT status, 
				       IHXBuffer* pBuffer)
{
    HX_RESULT result = HXR_OK;

    if ( m_pBuffer == NULL )
    {
	m_pBuffer = new CHXFragmentedBuffer();
	if ( m_pBuffer == NULL )
	{
	    return HXR_OUTOFMEMORY;
	}
	m_pBuffer->AddRef();
	m_pBuffer->Set(pBuffer->GetBuffer(), pBuffer->GetSize());
    }
    else // we are in a recursion...
    {
	// guard against a unneeded recursion in the case that our file size was
	// an exact multiple of FileChunkSize
	if ( pBuffer != NULL )
	{
	    m_pBuffer->Append(pBuffer, 0, pBuffer->GetSize());
	}
    }

    if ( pBuffer->GetSize() == FileChunkSize )
    {
	m_pFileObject->Read(FileChunkSize);	//XXXBAB recursive!!!
    }
    else
    {
	HX_ASSERT(m_pViewSourceResponse != NULL);
	if ( SUCCEEDED(result) )
	{
	    if ( m_type == HTML_SOURCE )
	    {
		CEscapeRP rpParser(m_pOptions);
		IHXBuffer* pTheStuff = NULL;
		if ( SUCCEEDED(rpParser.Convert(m_pBuffer, pTheStuff)) )
		{
    		    result = m_pViewSourceResponse->SourceReady(HXR_OK,
			pTheStuff);
		}
		else
		{
		    result = m_pViewSourceResponse->SourceReady(HXR_FAIL, NULL);
		}
		HX_RELEASE(pTheStuff);
	    }
	    else
	    {
		result = m_pViewSourceResponse->SourceReady(HXR_OK, m_pBuffer);
	    }

	}
	else
	{
	    result = m_pViewSourceResponse->SourceReady(HXR_OK, m_pBuffer);
	}
    }
    return result;
}

/************************************************************************
 *  Method:
 *	IHXFileResponse::WriteDone
 *  Purpose:
 *	Notification interface provided by users of the IHXFileObject
 *	interface. This method is called by the IHXFileObject when the
 *	last write to the file is complete.
 */
STDMETHODIMP CRPViewSource::WriteDone(HX_RESULT status)
{
    // We don't ever write, so we don't expect to get this...
    return HXR_UNEXPECTED;
}

/************************************************************************
 *  Method:
 *	IHXFileResponse::SeekDone
 *  Purpose:
 *	Notification interface provided by users of the IHXFileObject
 *	interface. This method is called by the IHXFileObject when the
 *	last seek in the file is complete.
 */
STDMETHODIMP CRPViewSource::SeekDone(HX_RESULT status)
{
    return HXR_OK;
}

/************************************************************************
 *  Method:
 *	IHXFileResponse::CloseDone
 *  Purpose:
 *	Notification interface provided by users of the IHXFileObject
 *	interface. This method is called by the IHXFileObject when the
 *	close of the file is complete.
 */
STDMETHODIMP CRPViewSource::CloseDone(HX_RESULT status)
{
    return HXR_OK;
}
