/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: atotime.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  ATOTIME.H
//
//
//  This file contains the functions that are used in RealText rendering to
//	convert a string of characters into a time value, in milliseconds.
//
//  (1)	BOOL convertTimeStringToULONG32(
//		_CHAR* pTimeBuf,
//		ULONG32 timeBufLen, 
//		ULONG32& timeValInMillisec);
//  Converts a string, like "0:00:02.341", into a ULONG32 "time" value,
//  in milliseconds, and returns FALSE, with timeValInMillisec
//  undefined if pTimeBuf is not in the correct time format which is:
//  "[[[[[[d:]h]h:]m]m:]s]s[.a[b[c]]]" where d is any number of days
//  up to 49 days (which is the max that 32 bits can hold, in msec),
//  hh is the number of hours (a two-digit # if following a ':'),
//  mm is the number of minutes (a two-digit # if following a ':'),
//  ss is the number of seconds (a two-digit # if following a ':'),
//    (noting that the lowest digit of seconds must exist in the string
//    and can stand alone as a time value),
//  and a, b, and c are tenths of seconds, hundredths of seconds, and
//  thousandths of seconds, respectively.
//  timeBufLen is equivalent of strlen(pColorNm), i.e.,
//  it does not take into account the terminating '\0' char.
//
//  (2) BOOL IsTimeAMoreRecentThanTimeB(
//		ULONG32 ulTimeA, ULONG32 ulTimeB,
//		BOOL bIsLiveSource=TRUE,
//		ULONG32* pULTimeDiff=NULL /* OUT */,
//		ULONG32 ulAcceptableMaxTimeDiff=
//			    MAX_ALLOWED_TIME_DIFFERENCE_IN_MSEC)
//	If bIsLiveSource is FALSE (defaultable to TRUE), this simply
//	returns (A>B), else it's live & ULONG32 wrap-around can occur so...
//	this function tells whether or not time A is later (more recent)
//	than time B even with ULONG32 wrap-around, e.g., if A is 1234
//	and B is 4000001234, then we can guess that A is actually more
//	recent than B because A<B and B-A>ulAcceptableMaxTimeDiff,
//	so it looks like the clock wrapped around after B and before A.
//	Conversely, if A>B and A-B>ulAcceptableMaxTimeDiff, then it looks
//	like the clock wrapped around after A and before B, so A is NOT
//	more recent.  Returned is a BOOL that contains the answer.
//	NOTE: there is a concept of "infinity", defined as
//	TIME_INFINITY (which is 0xfffffffe), and there is a concept
//	of invalid time, defined as TIME_INVALID (0xffffffff).  The following
//	chart shows how these values are handled:
//	    A is:		B is:		return value will be:
//	    -----		-----		---------------------
//	    Infinity		Infinity	FALSE
//	    Infinity		Invalid		FALSE
//	    Infinity		< 0xfffffffe	TRUE
//	    Invalid		Infinity	TRUE
//	    Invalid		Invalid		FALSE
//	    Invalid		< 0xfffffffe	TRUE
//	    < 0xfffffffe	Infinity	FALSE
//	    < 0xfffffffe	Invalid		FALSE
//	    < 0xfffffffe	< 0xfffffffe	depends; see above algorithm
//
//	If pULTimeDiff is sent in as NULL, it remains NULL, otherwise it will
//	exit this function containing A minus B, regardless of which is
//	greater or more recent, noting that A & B are ULONG32s so the result
//	is always the equivalent of adding 0x100000000 to A and then
//	subtracting B and then truncating it by removing that 33rd bit, if
//	still 1:
//
//
//  (3) BOOL IsTimeASameOrMoreRecentThanTimeB(
//		ULONG32 ulTimeA, ULONG32 ulTimeB,
//		BOOL bIsLiveSource=TRUE,
//		ULONG32* pULTimeDiff=NULL /* OUT */,
//		ULONG32 ulAcceptableMaxTimeDiff=
//			    MAX_ALLOWED_TIME_DIFFERENCE_IN_MSEC)
//	This function first checks if time A is == to time B, and, if not
//	returns the return value from a call to (2), above.
//
//

#if !defined(_ATOTIME_H_)
#define _ATOTIME_H_

#if !defined(TIME_INVALID)
#define TIME_INVALID			((ULONG32)0xFFFFFFFF)
#endif

//We want two different values for "invalid" and "infinity"; using the same
// value causes problems with the new live "wallclock"-enabled code:
#if !defined(TIME_INFINITY)
#define TIME_INFINITY			((ULONG32)0xFFFFFFFE)
#else
#error TIME_INFINITY already defined elsewhere
#endif

#define MIN_TIMEBUFFERLENGTH	1  //Min time-format string is "s" (0-9 secs)

//33.33+ days can pass without changing a time variable before
// a call with it to IsTimeAMoreRecentThanTimeB() may be wrong:
#define MAX_ALLOWED_TIME_DIFFERENCE_IN_MSEC	0xABADC0DE


//(See description of this function above)
BOOL convertTimeStringToULONG32(_CHAR* pTimeBuf, ULONG32 timeBufLen, 
		ULONG32& timeValInMillisec);

//(See description of this function above)
BOOL IsTimeAMoreRecentThanTimeB(ULONG32 ulTimeA, ULONG32 ulTimeB,
	BOOL bIsLiveSource=TRUE,
	ULONG32* pULTimeDiff=NULL /* OUT */,
	//XXXEH- get rid of this parameter when debugging is "done":
	ULONG32 ulAcceptableMaxTimeDiff=
		    MAX_ALLOWED_TIME_DIFFERENCE_IN_MSEC);

//(See description of this function above)
BOOL IsTimeASameOrMoreRecentThanTimeB(ULONG32 ulTimeA, ULONG32 ulTimeB,
	BOOL bIsLiveSource=TRUE,
	ULONG32* pULTimeDiff=NULL /* OUT */,
	ULONG32 ulAcceptableMaxTimeDiff=
		    MAX_ALLOWED_TIME_DIFFERENCE_IN_MSEC);


#endif

