#	$Id: Specfile,v 1.95.2.11 2001/10/28 19:40:46 alan Exp $
Summary: heartbeat - heartbeat subsystem for High-Availability Linux
Name:	heartbeat
Version:	0.4.9.0l
Release:	1
Copyright: GPL
URL: http://linux-ha.org/
Group: Utilities
Packager: Alan Robertson <alanr@henge.com>
Source: http://linux-ha.org/download/heartbeat-0.4.9.0l.tar.gz
Buildroot: /var/tmp/heartbeat-root
BuildPreReq: lynx
Requires: sysklogd

%package ldirectord
Summary: Monitor daemon for maintaining high availability resources
Group: Utilities
Requires: perl, perl-libwww-perl perl-Net-SSLeay, ipvsadm
# perl-libwww-perl, perl-net-ssleay available from
# ultramonkey.sourceforge.net and others

%package stonith
Summary: Provides an interface to Shoot The Other Node In The Head 
Group: Utilities
#
#	These are the Red Hat names for the UCD SNMP package
#
#BuildPreReq: ucd-snmp-devel
#	This dependency will automatically be verified by the RPM
#	system, so it isn't needed as an explicit dependency.
#Requires: ucd-snmp
#
#	The SuSE names for the UCD SNMP package is ucdsnmp
#	Note that the header files we need are installed as part of
#	the ucdsnmp package with SuSE...
#
#BuildPreReq: ucdsnmp
#	This dependency will automatically be verified by the RPM
#	system, so it isn't needed as an explicit dependency.
#Requires: ucdsnmp

%description
heartbeat is a basic heartbeat subsystem for Linux-HA.
It will run scripts at initialization, and when machines go up or down.
This version will also perform IP address takeover using gratuitous ARPs.
It works correctly for a 2-node configuration, and is extensible to larger
configurations.

It implements the following kinds of heartbeats:
	- Bidirectional Serial Rings ("raw" serial ports)
	- UDP/IP broadcast (ethernet, etc)
	- Bidirectional Serial PPP/UDP Rings (using PPP)
	- "ping" heartbeats (for routers, switches, etc.)
	   (to be used for breaking ties in 2-node systems)

%description ldirectord
ldirectord is a stand-alone daemon to monitor services of real 
for virtual services provided by The Linux Virtual Server
(http://www.linuxvirtualserver.org/). It is simple to install 
and works with the heartbeat code (http://www.linux-ha.org/).

%description stonith
The STONITH module (a.k.a. STOMITH) provides an extensible interface
for remotely powering down a node in the cluster.  The idea is quite simple:
When the software running on one machine wants to make sure another
machine in the cluster is not using a resource, pull the plug on the other 
machine. It's simple and reliable, albeit admittedly brutal.

%changelog
* Tue Oct 2 2001 Alan Robertson <alanr@unix.sh>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>, Jacob Rief <jacob.rief@tis.at>
     Guenther Thomsen <thomsen@cs.tu-berlin.de>,
     Luis Claudio R. Gonalves <lclaudio@conectiva.com.br>,
     Marcelo Tosatti <marcelo@conectiva.com.br>,
     Horms <horms@vergenet.net>, Eric Ayers <eric.ayers@compgen.com>,
     Mike Tilstra <conrad@sistina.com> 
     Juan Pedro Paredes Caballero <juampe@retemail.es>
     Andreas Piesk <a.piesk@gmx.net>, Chris Wright <chris@wirex.com>

+ Version 0.4.9.1 beta series

  + Fixes to the restart after shutdown for cluster partitioning  (really!)
  + The Famous CLK_TCK compile time fixes (really!)
  + Changed the code which makes FIFOs to not try and make the FIFOs for
	named clients, and several other minor API client changes.
  + Fixed a fairly rare client API bug where it would shut down the
	client for no apparent reason.
  + Added stonith plugins for: apcmaster, apcmastersnmp switches, and ssh
	module (for test environments only)
  + Added support for the Baytech RPC-3 switch into baytech module
  + Fixes to APC UPS plugin
  + Got rid of "control_process: NULL message" message
  + Got rid of the "controlfifo2msg: cannot create message" message
  + Added -h option to give usage message for stonith command...
  + Changed where usage messages go depending on exit status from usage().
  + Made some more functions static.
  + Real-time performance improvement changes
  + Updated the faqntips document
  + Added a feature to heartbeat.h so that log messages get checked as
	printf-style messages on GNU C compilers
  + Changed several log messages to have the right parameters (discovered
	as a result of the change above)
  + Changed send_arp code to send out both ARP requests and responses

* Fri Mar 16 2001 Alan Robertson <alanr@unix.sh>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>, Jacob Rief <jacob.rief@tis.at>
     Guenther Thomsen <thomsen@cs.tu-berlin.de>,
     Luis Claudio R. Gonalves <lclaudio@conectiva.com.br>,
     Marcelo Tosatti <marcelo@conectiva.com.br>,
     Horms <horms@vergenet.net>, Eric Ayers <eric.ayers@compgen.com>,
     Mike Tilstra <conrad@sistina.com> 
     Juan Pedro Paredes Caballero <juampe@retemail.es>
     Andreas Piesk <a.piesk@gmx.net>, Chris Wright <chris@wirex.com>

+ Version 0.4.9

  + Split into 3 rpms - heartbeat, heartbeat-stonith heartbeat-ldirectord

  + Made media modules and authentication modules and stonith modules
	dynamically loadable.

  + Added Multicast media support
  + Added ping node/membership/link type for tiebreaking.  This will
	be useful when implementing quorum on 2-node systems.
	(not yet compatible with nice_failback(?))
  + Removed ppp support

  + Heartbeat client API support

  + Added STONITH API library
    +   support for the Baytech RPC-3A power switch
    +   support for the APCsmart UPS
    +   support for the VACM cluster management tool
    +	support for WTI RPS10
    +	support for Night/Ware RPC100S
    +	support for "Meatware" (human intervention) module
    +	support for "null" (testing only) module

  + Fixed startup timing bugs
  + Fixed shutdown sequence bugs: takeover occured before
	resources were released by other system
  + Fixed various logging bugs
  + Closed holes in protection against replay attacks

  + Added checks that complain if all resources aren't idle on startup.
  + IP address takeover fixes
      + Endian fixes
      + Removed the 8-alias limitation
      + Takeovers now occur faster (ARPs occur asynchronously)

  + Port number changes
    + Use our IANA port number (694) by default
    + Recognize our IANA port number ("ha-cluster") if it's in /etc/services

  + Moved several files, etc. from /var/run to /var/lib/heartbeat
  + Incorporated new ldirectord version
  + Added late heartbeat warning for late-arriving heartbeats
  + Added detection of and partial recovery from cluster partitions
  + Accept multiple arguments for resource scripts
  + Added Raid1 and Filesystem resource scripts
  + Added man pages
  + Added debian package support

* Fri Jun 30 2000 Alan Robertson <alanr@unix.sh>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>, Jacob Rief <jacob.rief@tis.at>
     Guenther Thomsen <thomsen@cs.tu-berlin.de>,
     Luis Claudio R. Gonalves <lclaudio@conectiva.com.br>,
     Marcelo Tosatti <marcelo@conectiva.com.br>
     and Horms <horms@vergenet.net>

+ Version 0.4.8
  + Incorporated ldirectord version 1.9 (fixes memory leak)
  + Made the order of resource takeover more rational:  Takeover is now
    left-to-right, and giveup is right-to-left
  + Changed the default port number to our official IANA port number (694)
  + Regularized more messages, eliminated some redundant ones.
  + Print the version of heartbeat when starting.
  + Print exhaustive version info when starting with debug on.
  + Hosts now have 3 statuses {down, up, active} active means that it knows
	that all its links are operational, and it's safe to send cluster
	messages
  + Significant revisions to nice_failback (mainly due to lclaudio)
  + More SuSE-compatibility. Thanks to Friedrich Lobenstock <fl@fl.priv.at>
  + Tidied up logging so it can be to files, to syslog or both (Horms)
  + Tidied up build process (Horms)
  + Updated ldirectord to produce and install a man page and be
    compatible with the fwmark options to The Linux Virtual Server (Horms)
  + Added log rotation for ldirectord and heartbeat using logrotate
    if it is installed
  + Added Audible Alarm resource by Kirk Lawson <lklawson@heapy.com> 
    and myself (Horms)
  + Added init script for ldirectord so it can be run independently
    of heartbeat (Horms)
  + Added sample config file for ldirectord (Horms)
  + An empty /etc/ha.d/conf/ is now part of the rpm distribution
    as this is where ldirectord's configuration belongs (Horms)
  + Minor startup script tweaks.  Hopefully, we should be able to make core
    files should we crash in the future.  Thanks to Holger Kiehl for diagnosing
    the problem!
  + Fixed a bug which kept the "logfile" option from ever working.
  + Added a TestCluster test utility.  Pretty primitive so far...
  + Fixed the serial locking code so that it unlocks when it shuts down.
  + Lock heartbeat into memory, and raise our priority
  + Minor, but important fix from lclaudio to init uninited variable.

* Sat Dec 25 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>, Jacob Rief <jacob.rief@tis.at>
     and Guenther Thomsen <thomsen@cs.tu-berlin.de>

+ Version 0.4.7
  + Added the nice_failback feature. If the cluster is running when
	the primary starts it acts as a secondary. (Luis Claudio Goncalves)
  + Put in lots of code to make lost packet retransmission happen
  + Stopped trying to use the /proc/ha interface
  + Finished the error recovery in the heartbeat protocol (and got it to work)
  + Added test code for the heartbeat protocol
  + Raised the maximum length of a node name
  + Added Jacob Rief's ldirectord resource type
  + Added Stefan Salzer's <salt@cin.de> fix for a 'grep' in IPaddr which
	wasn't specific enough and would sometimes get IPaddr confused on
	IP addresses that prefix-matched.
  + Added Lars Marowsky-Bree's suggestion to make the code almost completely
	robust with respect to jumping the clock backwards and forwards
  + Added code from Michael Moerz <mike@cubit.at> to keep findif from
	core dumping if /proc/route can't be read.

* Mon Nov 22 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>,
     and Guenther Thomsen <thomsen@cs.tu-berlin.de>

* Tue Nov 22 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>,
     and Guenther Thomsen <thomsen@cs.tu-berlin.de>,

+ Version 0.4.6
  + Fixed timing problem in "heartbeat restart" so it's reliable now
  + Made start/stop status compatible with SuSE expectations
  + Made resource status detection compatible with SuSE start/stop expectations
  + Fixed a bug relating to serial and ppp-udp authentication (it never worked)
  + added a little more substance to the error recovery for the HB protocol.
  + Fixed a bug for logging from shell scripts
  + Added a little logging for initial resource acquisition
  + Added #!/bin/sh to the front of shell scripts
  + Fixed Makefile, so that the build root wasn't compiled into pathnames
  + Turned on CTSRTS, enabling for flow control for serial ports.
  + Fixed a bug which kept it from working in non-English environments

* Wed Oct 13 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, Rudy Pawul <rpawul@iso-ne.com>,
     Mitja Sarp <mitja@lysator.liu.se>,
     and Guenther Thomsen <thomsen@cs.tu-berlin.de>

+ Version 0.4.5
  + Mijta Sarp added a new feature to authenticate heartbeat packets
	using a variety of strong authentication techniques
  + Changed resource acquisition and relinquishment to occur in heartbeat,
       instead of in the start/stop script.  This means you don't *really*
       have to use the start/stop script if you don't want to.
  + Added -k option to gracefully shut down current heartbeat instance
  + Added -r option to cause currently running heartbeat to reread config files
  + Added -s option to report on operational status of "heartbeat"
  + Sped up resource acquisition on master restart.
  + Added validation of ipresources file at startup time.
  + Added code to allow the IPaddr takeover script to be given the
        interface to take over, instead of inferring it.  This was requested
        by Lars Marowsky-Bree
  + Incorporated patch from Guenther Thomsen to implement locking for
        serial ports used for heartbeats
  + Incorporated patch from Guenther Thomsen to clean up logging.
        (you can now use syslog and/or file logs)
  + Improved FreeBSD compatibility.
  + Fixed a bug where the FIFO doesn't get created correctly.
  + Fixed a couple of uninitialized variables in heartbeat and /proc/ha code
  + Fixed longstanding crash bug related to getting a SIGALRM while in malloc
	or free.
  + Implemented new memory management scheme, including memory stats

* Thu Sep 16 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, and Rudy Pawul <rpawul@iso-ne.com>
+ Version 0.4.4
  + Fixed a stupid error in handling CIDR addresses in IPaddr.
  + Updated the documentation with the latest from Rudy.

* Wed Sep 15 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, and Rudy Pawul <rpawul@iso-ne.com>
+ Version 0.4.3
  + Changed startup scripts to create /dev/watchdog if needed
  + Turned off loading of /proc/ha module by default.
  + Incorporated bug fix from Thomas Hepper <th@ant.han.de> to IPaddr for
	PPP configurations
  + Put in a fix from Gregor Howey <ghowey@bremer-nachrichten.de>
	where Gregor found that I had stripped off the ::resourceid part
	of the string in ResourceManager resulting in some bad calls later on.
  +  Made it compliant with the FHS (filesystem hierarchy standard)
  +  Fixed IP address takeover so we can take over on non-eth0 interface
  +  Fixed IP takeover code so we can specify netmasks and broadcast addrs,
	or default them at the user's option.
  +  Added code to report on message buffer usage on SIGUSR[12]
  +  Made SIGUSR1 increment debug level, and SIGUSR2 decrement it.
  +  Incorporated Rudy's latest "Getting Started" document
  +  Made it largely Debian-compliant.  Thanks to Guenther Thomsen, Thomas
	Hepper, Iaki Fernndez Villanueva and others.
  +  Made changes to work better with Red Hat 6.1, and SMP code.
  +  Sometimes it seems that the Master Control Process dies :-(

* Sat Aug 14 1999  Alan Robertson <alanr@henge.com>,
     Volker Wiegand <wiegand@suse.de>, and Rudy Pawul <rpawul@iso-ne.com>
+ Version 0.4.2
  + Implemented simple resource groups
  + Implemented application notification for groups starting/stopping
  + Eliminated restriction on floating IPs only being associated with eth0
  + Added a uniform resource model, with IP resources being only one kind.
	(Thanks to Lars Marowsky-Bree for a good suggestion)
  + Largely rewrote the IP address takeover code, making it clearer, fit
	into the uniform resource model, and removing some restrictions.
  + Preliminary "Getting Started" document by Rudy Pawul
  + Improved the /proc/ha code
  + Fixed memory leak associated with serial ports, and problem with return
	of control to the "master" node.
	(Thanks to Holger Kiehl for reporting them, and testing fixes!)

* Tue Jul 6 1999  Alan Robertson <alanr@henge.com> and
     Volker Wiegand <Volker.Wiegand@SuSE.de>
+ Version 0.4.1
  + Fixed major memory leak in 0.4.0 (oops!)
  + Added code to eliminate duplicate packets and log lost ones
  + Tightened up PPP/UDP startup/shutdown code
  + Made PPP/UDP peacefully coexist with "normal" udp
  + Made logs more uniform and neater
  + Fixed several other minor bugs
  + Added very preliminary kernel code for monitoring and controlling
	heartbeat via /proc/ha.  Very cool, but not really done yet.

* Wed Jun 30 1999 Alan Robertson <alanr@henge.com>
+ Version 0.4.0
  + Changed packet format from single line positional parameter style
	to a collection of {name,value} pairs.  A vital change for the future.
  + Fixed some bugs with regard to forwarding data around rings
  + We now modify /etc/ppp/ip-up.local, so PPP-udp works out of the box
	(at least for Red Hat)
  + Includes the first version of Volker Wiegand's Hardware Installation Guide
	(it's pretty good for a first version!)

* Wed Jun 09 1999 Alan Robertson <alanr@henge.com>
+ Version 0.3.2
  + Added UDP/PPP bidirectional serial ring heartbeat
	(PPP ensures data integrity on the serial links)
  + fixed a stupid bug which caused shutdown to give unpredictable
	results
  + added timestamps to /var/log/ha-log messages
  + fixed a couple of other minor oversights.

* Sun May 10 1999 Alan Robertson <alanr@henge.com>
+ Version 0.3.1
  + Make ChangeLog file from RPM specfile
  + Made ipresources only install in the DOC directory as a sample

* Sun May 09 1999 Alan Robertson <alanr@henge.com>
+ Version 0.3.0
  + Added UDP broadcast heartbeat (courtesy of Tom Vogt)
  + Significantly restructured code making it easier to add heartbeat media
  + added new directives to config file:
    + udp interface-name
    + udpport port-number
    + baud    serial-baud-rate
  + made manual daemon shutdown easier (only need to kill one)
  + moved the sample ha.cf file to the Doc directory

* Sat Mar 27 1999 Alan Robertson <alanr@henge.com>
+ Version 0.2.0
  + Make an RPM out of it
  + Integrated IP address takeover gotten from Horms
  + Added support to tickle a watchdog timer whenever our heart beats
  + Integrated enough basic code to allow a 2-node demo to occur
  + Integrated patches from Andrew Hildebrand <andrew@pdi.com> to allow it
    to run under IRIX.
  - Known Bugs
    - Only supports 2-node clusters
    - Only supports a single IP interface per node in the cluster
    - Doesn't yet include Tom Vogt's ethernet heartbeat code
    - No documentation
    - Not very useful yet :-)
%prep
%setup
%build
make
###########################################################
%install
###########################################################
if
  [ -z "${RPM_BUILD_ROOT}"  -a "${RPM_BUILD_ROOT}" != "/" ]
then
  rm -rf $RPM_BUILD_ROOT
fi
RPM_BUILD=yes BUILD_ROOT=$RPM_BUILD_ROOT make install
(
  cd $RPM_BUILD_ROOT/etc/ha.d/resource.d
  ln -s /usr/sbin/ldirectord ldirectord
)

TEMPL=$RPM_BUILD_ROOT/var/adm/fillup-templates
if
  [ ! -d $TEMPL ]
then
  mkdir -p $TEMPL
fi
install -m 644 rc.config.heartbeat $TEMPL

###########################################################
%files
###########################################################
%defattr(-,root,root)
%dir /etc/ha.d
/etc/ha.d/harc
/etc/ha.d/shellfuncs
/etc/ha.d/rc.d
/etc/ha.d/README.config
/etc/ha.d/conf
/usr/lib/heartbeat
/usr/lib/libhbclient.so
/usr/lib/libhbclient.a
/etc/ha.d/resource.d/
/etc/init.d/heartbeat
/etc/logrotate.d/heartbeat
/var/adm/fillup-templates/rc.config.heartbeat
%dir /var/lib/heartbeat
%attr (600, root, root)       /var/lib/heartbeat/fifo
%attr (750, root, haclient) /var/lib/heartbeat/api
%attr (620, root, haclient) /var/lib/heartbeat/register
%attr (1770, root, haclient) /var/lib/heartbeat/casual
/usr/man/man8/heartbeat.8*
%doc doc/*

###########################################################
# Files for ldirectord
%files ldirectord
###########################################################
%defattr(-,root,root)
/usr/sbin/ldirectord
/etc/logrotate.d/ldirectord
/etc/init.d/ldirectord
/etc/ha.d/resource.d/ldirectord
/usr/man/man8/ldirectord.8*
%doc ldirectord/ldirectord.cf

###########################################################
# Files for the stonith library
%files stonith
###########################################################
%defattr(-,root,root)
/usr/lib/libstonith.a
/usr/lib/libstonith.so
%dir /usr/lib/stonith/*.so
/usr/sbin/stonith
/usr/sbin/meatclient
/usr/include/stonith.h


###########################################################
%clean
###########################################################
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/heartbeat-0.4.9.0l

###########################################################
%pre
###########################################################
#
#	This isn't perfect.  But getting every distribution
#	to agree on group id's seems hard to me :-(
#
if
  grep '^haclient:' etc/group >/dev/null
then
  : OK group haclient already present
else
  GROUPOPT="-g 90"
  if
    usr/sbin/groupadd $GROUPOPT haclient 2>/dev/null
  then
    : OK we were able to add group haclient
  else
    usr/sbin/groupadd haclient
  fi
fi
#
#  Multi-distribution kludge for init scripts...
#
if
  [ ! -d etc/init.d ]
then
  if
    [ -d sbin/init.d  -a ! -L sbin/init.d ]
  then
    ln -s ../sbin/init.d etc/init.d
  elif
    [ -d etc/rc.d/init.d ]
  then
    ln -s rc.d/init.d etc/init.d
  else
    # I give up!
    echo "Warning: making directory /etc/init.d"
    mkdir -p etc/init.d
  fi
fi
###########################################################
%pre ldirectord
###########################################################
#
#  Multi-distribution kludge for init scripts...
#
if
  [ ! -d etc/init.d ]
then
  if
    [ -d sbin/init.d  -a ! -L sbin/init.d ]
  then
    ln -s ../sbin/init.d etc/init.d
  elif
    [ -d etc/rc.d/init.d ]
  then
    ln -s rc.d/init.d etc/init.d
  else
    # I give up!
    echo "Warning: making directory /etc/init.d"
    mkdir -p etc/init.d
  fi
fi
###########################################################
%post
###########################################################

# Run heartbeat on startup
if
  [ -f etc/SuSE-release ]
then
  for d in etc/init.d/rc[235].d
  do
    rm -f $d/S10heartbeat
    rm -f $d/S99heartbeat; ln -s ../heartbeat $d/S99heartbeat 
    rm -f $d/K35heartbeat; ln -s ../heartbeat $d/K35heartbeat
  done
  FILLUP=/bin/fillup
  if 
    $FILLUP -q -d = etc/rc.config var/adm/fillup-templates/rc.config.heartbeat
  then
    : fillup returned OK
  else
    echo "ERROR: $FILLUP failed. This should not happen. Please compare"
    echo "/etc/rc.config and /var/adm/fillup-templates/rc.config.heartbeat"
    echo "and update by hand."
  fi
elif
  [ -x sbin/chkconfig ]
then
  sbin/chkconfig --add heartbeat
fi
true

###########################################################
%preun
###########################################################

Uninstall_PPP_hack() {
  file2hack=etc/ppp/ip-up.local
  echo "NOTE: Restoring /$file2hack"
  MARKER="Heartbeat"
  ed -s $file2hack <<-!EOF  2>/dev/null
H
g/ $MARKER\$/d
w
!EOF
}

if
  [ $1 = 0 ]
then
  [ -x sbin/chkconfig ] && sbin/chkconfig --del heartbeat
  if
    [ ! -x etc/ppp/ip-up.heart ]
  then
    Uninstall_PPP_hack
  fi
fi
if
   [ -r etc/SuSE-release ]
then
  rm -f sbin/init.d/rc[23]/*heartbeat
fi
true
